% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper-compress.R
\name{makeInfReps}
\alias{makeInfReps}
\title{Make pseudo-inferential replicates from mean and variance}
\usage{
makeInfReps(y, numReps, minDisp = 0.001)
}
\arguments{
\item{y}{a SummarizedExperiment}

\item{numReps}{how many inferential replicates}

\item{minDisp}{the minimal dispersion value,
set after method of moments estimation from
inferential mean and variance}
}
\value{
a SummarizedExperiment
}
\description{
Makes pseudo-inferential replicate counts from
\code{mean} and \code{variance} assays. The simulated
counts are drawn from a negative binomial distribution,
with \code{mu=mean} and \code{size} set using a method
of moments estimator for dispersion.
}
\details{
Note that these simulated counts only reflect marginal
variance (one transcript or gene at a time),
and do not capture the covariance of counts across
transcripts or genes, unlike imported inferential
replicate data. Therefore, \code{makeInfReps} should
not be used with \code{summarizeToGene} to create
gene-level inferential replicates if inferential
replicates were originally created on the transcript
level. Instead, import the original inferential
replicates.
}
\examples{

library(SummarizedExperiment)
mean <- matrix(1:4,ncol=2)
variance <- mean
se <- SummarizedExperiment(list(mean=mean, variance=variance))
se <- makeInfReps(se, numReps=50)

}
\references{
Van Buren, S., Sarkar, H., Srivastava, A., Rashid, N.U.,
Patro, R., Love, M.I. (2020)
Compression of quantification uncertainty for scRNA-seq counts.
bioRxiv.
\url{https://doi.org/10.1101/2020.07.06.189639}
}
