#include "chrome/browser/ui/webui/custom_newtab/customize_newtab_ui.h"

#include "base/values.h"
#include "chrome/browser/profiles/profile.h"
#include "chrome/browser/ui/webui/custom_newtab/customize_newtab_handler.h"
#include "chrome/common/url_constants.h"
#include "chrome/grit/browser_resources.h"
#include "chrome/grit/generated_resources.h"
#include "content/public/browser/web_ui.h"
#include "content/public/browser/web_ui_data_source.h"

CustomizeNewTabUI::CustomizeNewTabUI(content::WebUI* web_ui1)
    : content::WebUIController(web_ui1) {
    LOG(INFO) << "CustomizeNewTabUI::CustomizeNewTabUI1";
    Profile *profile = Profile::FromWebUI(web_ui1);
    web_ui()->AddMessageHandler(
        std::make_unique<CustomizeNewTabHandler>(profile));

    // Set up the chrome://hello-world source.
    content::WebUIDataSource *html_source =
        content::WebUIDataSource::Create(chrome::kChromeUINewTabHost);

    // Localized strings.
    // html_source->AddLocalizedString("newtabTitle", IDS_NEWTAB_TITLE);
    html_source->AddLocalizedString("newtabTitle", IDS_NEWTAB_TITLE);
    html_source->AddLocalizedString("testtext", IDS_ABOUT_BROWSER);
    html_source->AddLocalizedString("webpage", IDS_NEWTAB_WEBPAGE);
    html_source->AddLocalizedString("images", IDS_NEWTAB_IMAGES);
    html_source->AddLocalizedString("news", IDS_NEWTAB_NEWS);
    html_source->AddLocalizedString("videos", IDS_NEWTAB_VIDEOS);
    html_source->AddLocalizedString("maps", IDS_NEWTAB_MAPS);
    html_source->AddLocalizedString("search", IDS_NEWTAB_SEARCH);

    // html_source->AddLocalizedString("welcomeMessage",
    // IDS_HELLO_WORLD_WELCOME_TEXT);

    // As a demonstration of passing a variable for JS to use we pass in the name
    // "Bob".
    html_source->AddString("userName", "Bob");
    // html_source->SetJsonPath("strings.js");
    html_source->UseStringsJs();

    // Add required resources.
    html_source->AddResourcePath("normal.css", IDR_NORMAL_CSS);
    html_source->AddResourcePath("jquery.js", IDR_JQUERY_JS);
    html_source->AddResourcePath("customize_newtab.css",
                                 IDR_CUSTOMIZE_NEWTAB_CSS);
    html_source->AddResourcePath("customize_newtab.js", IDR_CUSTOMIZE_NEWTAB_JS);
    html_source->SetDefaultResource(IDR_CUSTOMIZE_NEWTAB_HTML);

    content::WebUIDataSource::Add(profile, html_source);

    LOG(INFO) << "CustomizeNewTabUI::CustomizeNewTabUI2";
}

CustomizeNewTabUI::~CustomizeNewTabUI() {}