/* Copyright (c) 2010-2018. The SimGrid Team.
 * All rights reserved.                                                     */

/* This program is free software; you can redistribute it and/or modify it
 * under the terms of the license (GNU LGPL) which comes with this package. */

#include "xbt/asserts.h"
#include "simgrid/jedule/jedule.hpp"

#if SIMGRID_HAVE_JEDULE

namespace simgrid{
namespace jedule {

Jedule::~Jedule() {
  delete this->root_container_;
  for (auto const& evt : this->event_set_)
    delete evt;
  this->event_set_.clear();
}

void Jedule::add_meta_info(char* key, char* value)
{
  xbt_assert(key != nullptr);
  xbt_assert(value != nullptr);

  this->meta_info_.insert({key, value});
}

void Jedule::write_output(FILE* file)
{
  if (not this->event_set_.empty()) {
    fprintf(file, "<jedule>\n");

    if (not this->meta_info_.empty()) {
      fprintf(file, "  <jedule_meta>\n");
      for (auto const& elm : this->meta_info_)
        fprintf(file, "        <prop key=\"%s\" value=\"%s\" />\n",elm.first,elm.second);
      fprintf(file, "  </jedule_meta>\n");
    }

    fprintf(file, "  <platform>\n");
    this->root_container_->print(file);
    fprintf(file, "  </platform>\n");

    fprintf(file, "  <events>\n");
    for (auto const& event : this->event_set_)
      event->print(file);
    fprintf(file, "  </events>\n");

    fprintf(file, "</jedule>\n");
  }
}

}
}
#endif
