description("Test the parsing of the -webkit-animation-trigger property.");

// These have to be global for the test helpers to see them.
var stylesheet, cssRule, declaration, triggerRule, subRule;
var styleElement = document.createElement("style");
document.head.appendChild(styleElement);
stylesheet = styleElement.sheet;

function testTriggerRule(description, rule, expectedLength, expectedValue, expectedTexts)
{
    debug("");
    debug(description + " : " + rule);

    stylesheet.insertRule("body { -webkit-animation-trigger: " + rule + "; }", 0);
    cssRule = stylesheet.cssRules.item(0);

    shouldBe("cssRule.type", "1");

    declaration = cssRule.style;
    if (!expectedLength || !expectedValue) {
        shouldBe("declaration.length", "0");
        shouldBeEqualToString("declaration.getPropertyValue('-webkit-animation-trigger')", "");
        return;
    }
    shouldBe("declaration.length", "1");
    shouldBe("declaration.getPropertyValue('-webkit-animation-trigger')", "'" + expectedValue + "'");

    triggerRule = declaration.getPropertyCSSValue("-webkit-animation-trigger");
    if (expectedLength > 1) {
        shouldBe("triggerRule.length", "" + expectedLength);
        for (var i = 0; i < expectedLength; i++) {
            subRule = triggerRule[i];
            shouldBe("subRule.cssText", "'" + expectedTexts[i] + "'");
        }
    } else {
        shouldBe("triggerRule.cssText", "'" + expectedValue + "'");
    }

    stylesheet.deleteRule(0);
}

debug("")
debug("Valid property tests");
debug("")

testTriggerRule("Auto",
                "auto", 1, "auto");

testTriggerRule("Container Scroll",
                "container-scroll(200px)", 1, "container-scroll(200px)");

testTriggerRule("Container Scroll",
                "container-scroll(2em)", 1, "container-scroll(2em)");

testTriggerRule("Container Scroll",
                "container-scroll(30vw)", 1, "container-scroll(30vw)");

testTriggerRule("Container Scroll with end value",
                "container-scroll(200px, 300px)", 1, "container-scroll(200px, 300px)");

testTriggerRule("Two scroll values",
                "container-scroll(1px), container-scroll(2px)", 2, "container-scroll(1px), container-scroll(2px)", ["container-scroll(1px)", "container-scroll(2px)"]);

testTriggerRule("Many scroll values",
                "container-scroll(1px), container-scroll(2px), container-scroll(3px), container-scroll(4px), container-scroll(5px), container-scroll(3000px)",
                6,
                "container-scroll(1px), container-scroll(2px), container-scroll(3px), container-scroll(4px), container-scroll(5px), container-scroll(3000px)",
                ["container-scroll(1px)", "container-scroll(2px)", "container-scroll(3px)", "container-scroll(4px)", "container-scroll(5px)", "container-scroll(3000px)"]);

debug("")
debug("Invalid property tests");
debug("")

testTriggerRule("No value", "", 0, null);
testTriggerRule("Bad value", "banana", 0, null);
testTriggerRule("Bad list", "container-scroll(1px), orange", 0, null);
testTriggerRule("Missing comma", "container-scroll(1px) container-scroll(2px)", 0, null);
testTriggerRule("Too many values", "container-scroll(1px, 2px, 3px)", 0, null);

successfullyParsed = true;
