# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ConsistencyPolicy(Model):
    """The consistency policy for the Cosmos DB database account.

    All required parameters must be populated in order to send to Azure.

    :param default_consistency_level: Required. The default consistency level
     and configuration settings of the Cosmos DB account. Possible values
     include: 'Eventual', 'Session', 'BoundedStaleness', 'Strong',
     'ConsistentPrefix'
    :type default_consistency_level: str or
     ~azure.mgmt.cosmosdb.models.DefaultConsistencyLevel
    :param max_staleness_prefix: When used with the Bounded Staleness
     consistency level, this value represents the number of stale requests
     tolerated. Accepted range for this value is 1 – 2,147,483,647. Required
     when defaultConsistencyPolicy is set to 'BoundedStaleness'.
    :type max_staleness_prefix: long
    :param max_interval_in_seconds: When used with the Bounded Staleness
     consistency level, this value represents the time amount of staleness (in
     seconds) tolerated. Accepted range for this value is 5 - 86400. Required
     when defaultConsistencyPolicy is set to 'BoundedStaleness'.
    :type max_interval_in_seconds: int
    """

    _validation = {
        'default_consistency_level': {'required': True},
        'max_staleness_prefix': {'maximum': 2147483647, 'minimum': 1},
        'max_interval_in_seconds': {'maximum': 86400, 'minimum': 5},
    }

    _attribute_map = {
        'default_consistency_level': {'key': 'defaultConsistencyLevel', 'type': 'DefaultConsistencyLevel'},
        'max_staleness_prefix': {'key': 'maxStalenessPrefix', 'type': 'long'},
        'max_interval_in_seconds': {'key': 'maxIntervalInSeconds', 'type': 'int'},
    }

    def __init__(self, *, default_consistency_level, max_staleness_prefix: int=None, max_interval_in_seconds: int=None, **kwargs) -> None:
        super(ConsistencyPolicy, self).__init__(**kwargs)
        self.default_consistency_level = default_consistency_level
        self.max_staleness_prefix = max_staleness_prefix
        self.max_interval_in_seconds = max_interval_in_seconds
