/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/DocXml/DiagTypesXml/DiagSetValueXml.h"

#include "Doc/DiagTypesDoc/CDiagSetValueCollectionDoc.h"
#include "Doc/DiagTypesDoc/CDiagSetValueDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/DiagTypesXml/DiagSetValueCollectionXml.h"

using namespace Caf;

void DiagSetValueCollectionXml::add(
	const SmartPtrCDiagSetValueCollectionDoc diagSetValueCollectionDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("DiagSetValueCollectionXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(diagSetValueCollectionDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::deque<SmartPtrCDiagSetValueDoc> setValueVal =
			diagSetValueCollectionDoc->getSetValueCollection();
		CAF_CM_VALIDATE_STL(setValueVal);

		if (! setValueVal.empty()) {
			for (TConstIterator<std::deque<SmartPtrCDiagSetValueDoc> > setValueIter(setValueVal);
				setValueIter; setValueIter++) {
				const SmartPtrCXmlElement setValueXml =
					thisXml->createAndAddElement("setValue");
				DiagSetValueXml::add(*setValueIter, setValueXml);
			}
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCDiagSetValueCollectionDoc DiagSetValueCollectionXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("DiagSetValueCollectionXml", "parse");

	SmartPtrCDiagSetValueCollectionDoc diagSetValueCollectionDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const CXmlElement::SmartPtrCElementCollection setValueChildrenXml =
			thisXml->findRequiredChildren("setValue");

		std::deque<SmartPtrCDiagSetValueDoc> setValueVal;
		if (! setValueChildrenXml.IsNull() && ! setValueChildrenXml->empty()) {
			for (TConstIterator<CXmlElement::CElementCollection> setValueXmlIter(*setValueChildrenXml);
				setValueXmlIter; setValueXmlIter++) {
				const SmartPtrCXmlElement setValueXml = setValueXmlIter->second;
				const SmartPtrCDiagSetValueDoc setValueDoc =
					DiagSetValueXml::parse(setValueXml);
				setValueVal.push_back(setValueDoc);
			}
		}

		diagSetValueCollectionDoc.CreateInstance();
		diagSetValueCollectionDoc->initialize(
			setValueVal);
	}
	CAF_CM_EXIT;

	return diagSetValueCollectionDoc;
}

