# Copyright (c) 2014 Andrew Kelley
# This file is MIT licensed.
# See http://opensource.org/licenses/MIT

# LIBAV_FOUND
# LIBAV_INCLUDE_DIRS
# LIBAV_LIBRARIES

# AVFILTER_FOUND
# AVFILTER_INCLUDE_DIRS
# AVFILTER_LIBRARIES

# AVFORMAT_FOUND
# AVFORMAT_INCLUDE_DIRS
# AVFORMAT_LIBRARIES

# AVCODEC_FOUND
# AVCODEC_INCLUDE_DIRS
# AVCODEC_LIBRARIES

# AVUTIL_FOUND
# AVUTIL_INCLUDE_DIRS
# AVUTIL_LIBRARIES

find_path(AVFILTER_INCLUDE_DIRS NAMES libavfilter/avfilter.h)
find_library(AVFILTER_LIBRARIES NAMES avfilter)
if(AVFILTER_LIBRARIES AND AVFILTER_INCLUDE_DIRS)
  set(AVFILTER_FOUND TRUE)
else()
  set(AVFILTER_FOUND FALSE)
endif()

find_path(AVFORMAT_INCLUDE_DIRS NAMES libavformat/avformat.h)
find_library(AVFORMAT_LIBRARIES NAMES avformat)
if(AVFORMAT_LIBRARIES AND AVFORMAT_INCLUDE_DIRS)
  set(AVFORMAT_FOUND TRUE)
else()
  set(AVFORMAT_FOUND FALSE)
endif()

find_path(AVCODEC_INCLUDE_DIRS NAMES libavcodec/avcodec.h)
find_library(AVCODEC_LIBRARIES NAMES avcodec)
if(AVCODEC_LIBRARIES AND AVCODEC_INCLUDE_DIRS)
  set(AVCODEC_FOUND TRUE)
else()
  set(AVCODEC_FOUND FALSE)
endif()

find_path(AVUTIL_INCLUDE_DIRS NAMES libavutil/avutil.h)
find_library(AVUTIL_LIBRARIES NAMES avutil)
if(AVUTIL_LIBRARIES AND AVUTIL_INCLUDE_DIRS)
  set(AVUTIL_FOUND TRUE)
else()
  set(AVUTIL_FOUND FALSE)
endif()

if(AVFILTER_FOUND AND AVFORMAT_FOUND AND AVCODEC_FOUND AND AVUTIL_FOUND)
  set(LIBAV_FOUND TRUE)
  set(LIBAV_INCLUDE_DIRS
    ${AVFILTER_INCLUDE_DIRS}
    ${AVFORMAT_INCLUDE_DIRS}
    ${AVCODEC_INCLUDE_DIRS}
    ${AVUTIL_INCLUDE_DIRS})
  set(LIBAV_LIBRARIES
    ${AVFILTER_LIBRARIES}
    ${AVFORMAT_LIBRARIES}
    ${AVCODEC_LIBRARIES}
    ${AVUTIL_LIBRARIES})
else()
  set(LIBAV_FOUND FALSE)
endif()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(LIBAV DEFAULT_MSG
  AVFILTER_LIBRARIES AVFILTER_INCLUDE_DIRS
  AVFORMAT_LIBRARIES AVFORMAT_INCLUDE_DIRS
  AVCODEC_LIBRARIES AVCODEC_INCLUDE_DIRS
  AVUTIL_LIBRARIES AVUTIL_INCLUDE_DIRS)

mark_as_advanced(
  AVFILTER_INCLUDE_DIRS AVFILTER_LIBRARIES
  AVFORMAT_INCLUDE_DIRS AVFORMAT_LIBRARIES
  AVCODEC_INCLUDE_DIRS AVCODEC_LIBRARIES
  AVUTIL_INCLUDE_DIRS AVUTIL_LIBRARIES)
