// RUN: llvm-mc -triple x86_64-unknown-unknown -mcpu=knl -mattr=+avx512vbmi2 --show-encoding < %s | FileCheck %s

// CHECK: vpexpandb %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x62,0xcb]
          vpexpandb %zmm3, %zmm1

// CHECK: vpexpandw %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x62,0xcb]
          vpexpandw %zmm3, %zmm1

// CHECK: vpexpandb %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa2,0x7d,0x48,0x62,0xef]
          vpexpandb %zmm23, %zmm21

// CHECK: vpexpandw %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa2,0xfd,0x48,0x62,0xef]
          vpexpandw %zmm23, %zmm21

// CHECK: vpexpandb %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x62,0xcb]
          vpexpandb %zmm3, %zmm1 {%k2}

// CHECK: vpexpandw %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x62,0xcb]
          vpexpandw %zmm3, %zmm1 {%k2}

// CHECK: vpexpandb %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x7d,0x4a,0x62,0xef]
          vpexpandb %zmm23, %zmm21 {%k2}

// CHECK: vpexpandw %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xfd,0x4a,0x62,0xef]
          vpexpandw %zmm23, %zmm21 {%k2}

// CHECK: vpexpandb  (%rcx), %zmm1
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x62,0x09]
          vpexpandb  (%rcx), %zmm1

// CHECK: vpexpandb  -4(%rsp), %zmm1
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x62,0x4c,0x24,0xfc]
          vpexpandb  -4(%rsp), %zmm1

// CHECK: vpexpandb  4(%rsp), %zmm1
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x62,0x4c,0x24,0x04]
          vpexpandb  4(%rsp), %zmm1

// CHECK: vpexpandb  268435456(%rcx,%r14,8), %zmm1
// CHECK: encoding: [0x62,0xb2,0x7d,0x48,0x62,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpexpandb  268435456(%rcx,%r14,8), %zmm1

// CHECK: vpexpandb  -536870912(%rcx,%r14,8), %zmm1
// CHECK: encoding: [0x62,0xb2,0x7d,0x48,0x62,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpexpandb  -536870912(%rcx,%r14,8), %zmm1

// CHECK: vpexpandb  -536870910(%rcx,%r14,8), %zmm1
// CHECK: encoding: [0x62,0xb2,0x7d,0x48,0x62,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpexpandb  -536870910(%rcx,%r14,8), %zmm1

// CHECK: vpexpandw  (%rcx), %zmm1
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x62,0x09]
          vpexpandw  (%rcx), %zmm1

// CHECK: vpexpandw  -8(%rsp), %zmm1
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x62,0x4c,0x24,0xfc]
          vpexpandw  -8(%rsp), %zmm1

// CHECK: vpexpandw  8(%rsp), %zmm1
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x62,0x4c,0x24,0x04]
          vpexpandw  8(%rsp), %zmm1

// CHECK: vpexpandw  268435456(%rcx,%r14,8), %zmm1
// CHECK: encoding: [0x62,0xb2,0xfd,0x48,0x62,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpexpandw  268435456(%rcx,%r14,8), %zmm1

// CHECK: vpexpandw  -536870912(%rcx,%r14,8), %zmm1
// CHECK: encoding: [0x62,0xb2,0xfd,0x48,0x62,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpexpandw  -536870912(%rcx,%r14,8), %zmm1

// CHECK: vpexpandw  -536870910(%rcx,%r14,8), %zmm1
// CHECK: encoding: [0x62,0xb2,0xfd,0x48,0x62,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpexpandw  -536870910(%rcx,%r14,8), %zmm1

// CHECK: vpexpandb  (%rcx), %zmm21
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x62,0x29]
          vpexpandb  (%rcx), %zmm21

// CHECK: vpexpandb  -4(%rsp), %zmm21
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x62,0x6c,0x24,0xfc]
          vpexpandb  -4(%rsp), %zmm21

// CHECK: vpexpandb  4(%rsp), %zmm21
// CHECK: encoding: [0x62,0xe2,0x7d,0x48,0x62,0x6c,0x24,0x04]
          vpexpandb  4(%rsp), %zmm21

// CHECK: vpexpandb  268435456(%rcx,%r14,8), %zmm21
// CHECK: encoding: [0x62,0xa2,0x7d,0x48,0x62,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpexpandb  268435456(%rcx,%r14,8), %zmm21

// CHECK: vpexpandb  -536870912(%rcx,%r14,8), %zmm21
// CHECK: encoding: [0x62,0xa2,0x7d,0x48,0x62,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpexpandb  -536870912(%rcx,%r14,8), %zmm21

// CHECK: vpexpandb  -536870910(%rcx,%r14,8), %zmm21
// CHECK: encoding: [0x62,0xa2,0x7d,0x48,0x62,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpexpandb  -536870910(%rcx,%r14,8), %zmm21

// CHECK: vpexpandw  (%rcx), %zmm21
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x62,0x29]
          vpexpandw  (%rcx), %zmm21

// CHECK: vpexpandw  -8(%rsp), %zmm21
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x62,0x6c,0x24,0xfc]
          vpexpandw  -8(%rsp), %zmm21

// CHECK: vpexpandw  8(%rsp), %zmm21
// CHECK: encoding: [0x62,0xe2,0xfd,0x48,0x62,0x6c,0x24,0x04]
          vpexpandw  8(%rsp), %zmm21

// CHECK: vpexpandw  268435456(%rcx,%r14,8), %zmm21
// CHECK: encoding: [0x62,0xa2,0xfd,0x48,0x62,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpexpandw  268435456(%rcx,%r14,8), %zmm21

// CHECK: vpexpandw  -536870912(%rcx,%r14,8), %zmm21
// CHECK: encoding: [0x62,0xa2,0xfd,0x48,0x62,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpexpandw  -536870912(%rcx,%r14,8), %zmm21

// CHECK: vpexpandw  -536870910(%rcx,%r14,8), %zmm21
// CHECK: encoding: [0x62,0xa2,0xfd,0x48,0x62,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpexpandw  -536870910(%rcx,%r14,8), %zmm21

// CHECK: vpexpandb  (%rcx), %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x62,0x09]
          vpexpandb  (%rcx), %zmm1 {%k2}

// CHECK: vpexpandb  -4(%rsp), %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x62,0x4c,0x24,0xfc]
          vpexpandb  -4(%rsp), %zmm1 {%k2}

// CHECK: vpexpandb  4(%rsp), %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x62,0x4c,0x24,0x04]
          vpexpandb  4(%rsp), %zmm1 {%k2}

// CHECK: vpexpandb  268435456(%rcx,%r14,8), %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0x7d,0x4a,0x62,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpexpandb  268435456(%rcx,%r14,8), %zmm1 {%k2}

// CHECK: vpexpandb  -536870912(%rcx,%r14,8), %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0x7d,0x4a,0x62,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpexpandb  -536870912(%rcx,%r14,8), %zmm1 {%k2}

// CHECK: vpexpandb  -536870910(%rcx,%r14,8), %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0x7d,0x4a,0x62,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpexpandb  -536870910(%rcx,%r14,8), %zmm1 {%k2}

// CHECK: vpexpandw  (%rcx), %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x62,0x09]
          vpexpandw  (%rcx), %zmm1 {%k2}

// CHECK: vpexpandw  -8(%rsp), %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x62,0x4c,0x24,0xfc]
          vpexpandw  -8(%rsp), %zmm1 {%k2}

// CHECK: vpexpandw  8(%rsp), %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x62,0x4c,0x24,0x04]
          vpexpandw  8(%rsp), %zmm1 {%k2}

// CHECK: vpexpandw  268435456(%rcx,%r14,8), %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xfd,0x4a,0x62,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpexpandw  268435456(%rcx,%r14,8), %zmm1 {%k2}

// CHECK: vpexpandw  -536870912(%rcx,%r14,8), %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xfd,0x4a,0x62,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpexpandw  -536870912(%rcx,%r14,8), %zmm1 {%k2}

// CHECK: vpexpandw  -536870910(%rcx,%r14,8), %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xfd,0x4a,0x62,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpexpandw  -536870910(%rcx,%r14,8), %zmm1 {%k2}

// CHECK: vpexpandb  (%rcx), %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x62,0x29]
          vpexpandb  (%rcx), %zmm21 {%k2}

// CHECK: vpexpandb  -4(%rsp), %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x62,0x6c,0x24,0xfc]
          vpexpandb  -4(%rsp), %zmm21 {%k2}

// CHECK: vpexpandb  4(%rsp), %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x62,0x6c,0x24,0x04]
          vpexpandb  4(%rsp), %zmm21 {%k2}

// CHECK: vpexpandb  268435456(%rcx,%r14,8), %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x7d,0x4a,0x62,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpexpandb  268435456(%rcx,%r14,8), %zmm21 {%k2}

// CHECK: vpexpandb  -536870912(%rcx,%r14,8), %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x7d,0x4a,0x62,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpexpandb  -536870912(%rcx,%r14,8), %zmm21 {%k2}

// CHECK: vpexpandb  -536870910(%rcx,%r14,8), %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x7d,0x4a,0x62,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpexpandb  -536870910(%rcx,%r14,8), %zmm21 {%k2}

// CHECK: vpexpandw  (%rcx), %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x62,0x29]
          vpexpandw  (%rcx), %zmm21 {%k2}

// CHECK: vpexpandw  -8(%rsp), %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x62,0x6c,0x24,0xfc]
          vpexpandw  -8(%rsp), %zmm21 {%k2}

// CHECK: vpexpandw  8(%rsp), %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x62,0x6c,0x24,0x04]
          vpexpandw  8(%rsp), %zmm21 {%k2}

// CHECK: vpexpandw  268435456(%rcx,%r14,8), %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xfd,0x4a,0x62,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpexpandw  268435456(%rcx,%r14,8), %zmm21 {%k2}

// CHECK: vpexpandw  -536870912(%rcx,%r14,8), %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xfd,0x4a,0x62,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpexpandw  -536870912(%rcx,%r14,8), %zmm21 {%k2}

// CHECK: vpexpandw  -536870910(%rcx,%r14,8), %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xfd,0x4a,0x62,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpexpandw  -536870910(%rcx,%r14,8), %zmm21 {%k2}

// CHECK: vpcompressb %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x63,0xd9]
          vpcompressb %zmm3, %zmm1

// CHECK: vpcompressw %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x63,0xd9]
          vpcompressw %zmm3, %zmm1

// CHECK: vpcompressb %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa2,0x7d,0x48,0x63,0xfd]
          vpcompressb %zmm23, %zmm21

// CHECK: vpcompressw %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa2,0xfd,0x48,0x63,0xfd]
          vpcompressw %zmm23, %zmm21

// CHECK: vpcompressb %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x7d,0x4a,0x63,0xd9]
          vpcompressb %zmm3, %zmm1 {%k2}

// CHECK: vpcompressw %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xfd,0x4a,0x63,0xd9]
          vpcompressw %zmm3, %zmm1 {%k2}

// CHECK: vpcompressb %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x7d,0x4a,0x63,0xfd]
          vpcompressb %zmm23, %zmm21 {%k2}

// CHECK: vpcompressw %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xfd,0x4a,0x63,0xfd]
          vpcompressw %zmm23, %zmm21 {%k2}

// CHECK: vpcompressb  %zmm1, (%rcx)
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x63,0x09]
          vpcompressb  %zmm1, (%rcx)

// CHECK: vpcompressb  %zmm1, -4(%rsp)
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x63,0x4c,0x24,0xfc]
          vpcompressb  %zmm1, -4(%rsp)

// CHECK: vpcompressb  %zmm1, 4(%rsp)
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x63,0x4c,0x24,0x04]
          vpcompressb  %zmm1, 4(%rsp)

// CHECK: vpcompressb  %zmm1, 268435456(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0x7d,0x48,0x63,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpcompressb  %zmm1, 268435456(%rcx,%r14,8)

// CHECK: vpcompressb  %zmm1, -536870912(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0x7d,0x48,0x63,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpcompressb  %zmm1, -536870912(%rcx,%r14,8)

// CHECK: vpcompressb  %zmm1, -536870910(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0x7d,0x48,0x63,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpcompressb  %zmm1, -536870910(%rcx,%r14,8)

// CHECK: vpcompressw  %zmm1, (%rcx)
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x63,0x09]
          vpcompressw  %zmm1, (%rcx)

// CHECK: vpcompressw  %zmm1, -8(%rsp)
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x63,0x4c,0x24,0xfc]
          vpcompressw  %zmm1, -8(%rsp)

// CHECK: vpcompressw  %zmm1, 8(%rsp)
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x63,0x4c,0x24,0x04]
          vpcompressw  %zmm1, 8(%rsp)

// CHECK: vpcompressw  %zmm1, 268435456(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0xfd,0x48,0x63,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpcompressw  %zmm1, 268435456(%rcx,%r14,8)

// CHECK: vpcompressw  %zmm1, -536870912(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0xfd,0x48,0x63,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpcompressw  %zmm1, -536870912(%rcx,%r14,8)

// CHECK: vpcompressw  %zmm1, -536870910(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0xfd,0x48,0x63,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpcompressw  %zmm1, -536870910(%rcx,%r14,8)

// CHECK: vpcompressb  %zmm21, (%rcx) {%k2}
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x63,0x29]
          vpcompressb  %zmm21, (%rcx) {%k2}

// CHECK: vpcompressb  %zmm21, -4(%rsp) {%k2}
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x63,0x6c,0x24,0xfc]
          vpcompressb  %zmm21, -4(%rsp) {%k2}

// CHECK: vpcompressb  %zmm21, 4(%rsp) {%k2}
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x63,0x6c,0x24,0x04]
          vpcompressb  %zmm21, 4(%rsp) {%k2}

// CHECK: vpcompressb  %zmm21, 268435456(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0x7d,0x4a,0x63,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpcompressb  %zmm21, 268435456(%rcx,%r14,8) {%k2}

// CHECK: vpcompressb  %zmm21, -536870912(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0x7d,0x4a,0x63,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpcompressb  %zmm21, -536870912(%rcx,%r14,8) {%k2}

// CHECK: vpcompressb  %zmm21, -536870910(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0x7d,0x4a,0x63,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpcompressb  %zmm21, -536870910(%rcx,%r14,8) {%k2}

// CHECK: vpcompressw  %zmm21, (%rcx) {%k2}
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x63,0x29]
          vpcompressw  %zmm21, (%rcx) {%k2}

// CHECK: vpcompressw  %zmm21, -8(%rsp) {%k2}
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x63,0x6c,0x24,0xfc]
          vpcompressw  %zmm21, -8(%rsp) {%k2}

// CHECK: vpcompressw  %zmm21, 8(%rsp) {%k2}
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x63,0x6c,0x24,0x04]
          vpcompressw  %zmm21, 8(%rsp) {%k2}

// CHECK: vpcompressw  %zmm21, 268435456(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0xfd,0x4a,0x63,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpcompressw  %zmm21, 268435456(%rcx,%r14,8) {%k2}

// CHECK: vpcompressw  %zmm21, -536870912(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0xfd,0x4a,0x63,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpcompressw  %zmm21, -536870912(%rcx,%r14,8) {%k2}

// CHECK: vpcompressw  %zmm21, -536870910(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0xfd,0x4a,0x63,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpcompressw  %zmm21, -536870910(%rcx,%r14,8) {%k2}

// CHECK: vpcompressb  %zmm1, (%rcx)
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x63,0x09]
          vpcompressb  %zmm1, (%rcx)

// CHECK: vpcompressb  %zmm1, -4(%rsp)
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x63,0x4c,0x24,0xfc]
          vpcompressb  %zmm1, -4(%rsp)

// CHECK: vpcompressb  %zmm1, 4(%rsp)
// CHECK: encoding: [0x62,0xf2,0x7d,0x48,0x63,0x4c,0x24,0x04]
          vpcompressb  %zmm1, 4(%rsp)

// CHECK: vpcompressb  %zmm1, 268435456(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0x7d,0x48,0x63,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpcompressb  %zmm1, 268435456(%rcx,%r14,8)

// CHECK: vpcompressb  %zmm1, -536870912(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0x7d,0x48,0x63,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpcompressb  %zmm1, -536870912(%rcx,%r14,8)

// CHECK: vpcompressb  %zmm1, -536870910(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0x7d,0x48,0x63,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpcompressb  %zmm1, -536870910(%rcx,%r14,8)

// CHECK: vpcompressw  %zmm1, (%rcx)
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x63,0x09]
          vpcompressw  %zmm1, (%rcx)

// CHECK: vpcompressw  %zmm1, -8(%rsp)
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x63,0x4c,0x24,0xfc]
          vpcompressw  %zmm1, -8(%rsp)

// CHECK: vpcompressw  %zmm1, 8(%rsp)
// CHECK: encoding: [0x62,0xf2,0xfd,0x48,0x63,0x4c,0x24,0x04]
          vpcompressw  %zmm1, 8(%rsp)

// CHECK: vpcompressw  %zmm1, 268435456(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0xfd,0x48,0x63,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpcompressw  %zmm1, 268435456(%rcx,%r14,8)

// CHECK: vpcompressw  %zmm1, -536870912(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0xfd,0x48,0x63,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpcompressw  %zmm1, -536870912(%rcx,%r14,8)

// CHECK: vpcompressw  %zmm1, -536870910(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0xfd,0x48,0x63,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpcompressw  %zmm1, -536870910(%rcx,%r14,8)

// CHECK: vpcompressb  %zmm21, (%rcx) {%k2}
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x63,0x29]
          vpcompressb  %zmm21, (%rcx) {%k2}

// CHECK: vpcompressb  %zmm21, -4(%rsp) {%k2}
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x63,0x6c,0x24,0xfc]
          vpcompressb  %zmm21, -4(%rsp) {%k2}

// CHECK: vpcompressb  %zmm21, 4(%rsp) {%k2}
// CHECK: encoding: [0x62,0xe2,0x7d,0x4a,0x63,0x6c,0x24,0x04]
          vpcompressb  %zmm21, 4(%rsp) {%k2}

// CHECK: vpcompressb  %zmm21, 268435456(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0x7d,0x4a,0x63,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpcompressb  %zmm21, 268435456(%rcx,%r14,8) {%k2}

// CHECK: vpcompressb  %zmm21, -536870912(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0x7d,0x4a,0x63,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpcompressb  %zmm21, -536870912(%rcx,%r14,8) {%k2}

// CHECK: vpcompressb  %zmm21, -536870910(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0x7d,0x4a,0x63,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpcompressb  %zmm21, -536870910(%rcx,%r14,8) {%k2}

// CHECK: vpcompressw  %zmm21, (%rcx) {%k2}
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x63,0x29]
          vpcompressw  %zmm21, (%rcx) {%k2}

// CHECK: vpcompressw  %zmm21, -8(%rsp) {%k2}
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x63,0x6c,0x24,0xfc]
          vpcompressw  %zmm21, -8(%rsp) {%k2}

// CHECK: vpcompressw  %zmm21, 8(%rsp) {%k2}
// CHECK: encoding: [0x62,0xe2,0xfd,0x4a,0x63,0x6c,0x24,0x04]
          vpcompressw  %zmm21, 8(%rsp) {%k2}

// CHECK: vpcompressw  %zmm21, 268435456(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0xfd,0x4a,0x63,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpcompressw  %zmm21, 268435456(%rcx,%r14,8) {%k2}

// CHECK: vpcompressw  %zmm21, -536870912(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0xfd,0x4a,0x63,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpcompressw  %zmm21, -536870912(%rcx,%r14,8) {%k2}

// CHECK: vpcompressw  %zmm21, -536870910(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0xfd,0x4a,0x63,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpcompressw  %zmm21, -536870910(%rcx,%r14,8) {%k2}

// CHECK: vpshldw $7, %zmm3, %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x48,0x70,0xcb,0x07]
          vpshldw $7, %zmm3, %zmm3, %zmm1

// CHECK: vpshldd $7, %zmm3, %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf3,0x65,0x48,0x71,0xcb,0x07]
          vpshldd $7, %zmm3, %zmm3, %zmm1

// CHECK: vpshldq $7, %zmm3, %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x48,0x71,0xcb,0x07]
          vpshldq $7, %zmm3, %zmm3, %zmm1

// CHECK: vpshrdw $7, %zmm3, %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x48,0x72,0xcb,0x07]
          vpshrdw $7, %zmm3, %zmm3, %zmm1

// CHECK: vpshrdd $7, %zmm3, %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf3,0x65,0x48,0x73,0xcb,0x07]
          vpshrdd $7, %zmm3, %zmm3, %zmm1

// CHECK: vpshrdq $7, %zmm3, %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x48,0x73,0xcb,0x07]
          vpshrdq $7, %zmm3, %zmm3, %zmm1

// CHECK: vpshldw $7, %zmm23, %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x40,0x70,0xef,0x07]
          vpshldw $7, %zmm23, %zmm23, %zmm21

// CHECK: vpshldd $7, %zmm23, %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa3,0x45,0x40,0x71,0xef,0x07]
          vpshldd $7, %zmm23, %zmm23, %zmm21

// CHECK: vpshldq $7, %zmm23, %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x40,0x71,0xef,0x07]
          vpshldq $7, %zmm23, %zmm23, %zmm21

// CHECK: vpshrdw $7, %zmm23, %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x40,0x72,0xef,0x07]
          vpshrdw $7, %zmm23, %zmm23, %zmm21

// CHECK: vpshrdd $7, %zmm23, %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa3,0x45,0x40,0x73,0xef,0x07]
          vpshrdd $7, %zmm23, %zmm23, %zmm21

// CHECK: vpshrdq $7, %zmm23, %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x40,0x73,0xef,0x07]
          vpshrdq $7, %zmm23, %zmm23, %zmm21

// CHECK: vpshldw $7, %zmm3, %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x4a,0x70,0xcb,0x07]
          vpshldw $7, %zmm3, %zmm3, %zmm1 {%k2}

// CHECK: vpshldd $7, %zmm3, %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0x65,0x4a,0x71,0xcb,0x07]
          vpshldd $7, %zmm3, %zmm3, %zmm1 {%k2}

// CHECK: vpshldq $7, %zmm3, %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x4a,0x71,0xcb,0x07]
          vpshldq $7, %zmm3, %zmm3, %zmm1 {%k2}

// CHECK: vpshrdw $7, %zmm3, %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x4a,0x72,0xcb,0x07]
          vpshrdw $7, %zmm3, %zmm3, %zmm1 {%k2}

// CHECK: vpshrdd $7, %zmm3, %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0x65,0x4a,0x73,0xcb,0x07]
          vpshrdd $7, %zmm3, %zmm3, %zmm1 {%k2}

// CHECK: vpshrdq $7, %zmm3, %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x4a,0x73,0xcb,0x07]
          vpshrdq $7, %zmm3, %zmm3, %zmm1 {%k2}

// CHECK: vpshldw $7, %zmm23, %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x42,0x70,0xef,0x07]
          vpshldw $7, %zmm23, %zmm23, %zmm21 {%k2}

// CHECK: vpshldd $7, %zmm23, %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0x45,0x42,0x71,0xef,0x07]
          vpshldd $7, %zmm23, %zmm23, %zmm21 {%k2}

// CHECK: vpshldq $7, %zmm23, %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x42,0x71,0xef,0x07]
          vpshldq $7, %zmm23, %zmm23, %zmm21 {%k2}

// CHECK: vpshrdw $7, %zmm23, %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x42,0x72,0xef,0x07]
          vpshrdw $7, %zmm23, %zmm23, %zmm21 {%k2}

// CHECK: vpshrdd $7, %zmm23, %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0x45,0x42,0x73,0xef,0x07]
          vpshrdd $7, %zmm23, %zmm23, %zmm21 {%k2}

// CHECK: vpshrdq $7, %zmm23, %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x42,0x73,0xef,0x07]
          vpshrdq $7, %zmm23, %zmm23, %zmm21 {%k2}

// CHECK: vpshldw  $7, (%rcx), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x48,0x70,0x09,0x07]
          vpshldw  $7, (%rcx), %zmm3, %zmm1

// CHECK: vpshldw  $7, -256(%rsp), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x48,0x70,0x4c,0x24,0xfc,0x07]
          vpshldw  $7, -256(%rsp), %zmm3, %zmm1

// CHECK: vpshldw  $7, 256(%rsp), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x48,0x70,0x4c,0x24,0x04,0x07]
          vpshldw  $7, 256(%rsp), %zmm3, %zmm1

// CHECK: vpshldw  $7, 268435456(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x48,0x70,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldw  $7, 268435456(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshldw  $7, -536870912(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x48,0x70,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldw  $7, -536870912(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshldw  $7, -536870910(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x48,0x70,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldw  $7, -536870910(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshldd  $7, (%rcx), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf3,0x65,0x48,0x71,0x09,0x07]
          vpshldd  $7, (%rcx), %zmm3, %zmm1

// CHECK: vpshldd  $7, -256(%rsp), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf3,0x65,0x48,0x71,0x4c,0x24,0xfc,0x07]
          vpshldd  $7, -256(%rsp), %zmm3, %zmm1

// CHECK: vpshldd  $7, 256(%rsp), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf3,0x65,0x48,0x71,0x4c,0x24,0x04,0x07]
          vpshldd  $7, 256(%rsp), %zmm3, %zmm1

// CHECK: vpshldd  $7, 268435456(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb3,0x65,0x48,0x71,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldd  $7, 268435456(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshldd  $7, -536870912(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb3,0x65,0x48,0x71,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldd  $7, -536870912(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshldd  $7, -536870910(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb3,0x65,0x48,0x71,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldd  $7, -536870910(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshldq  $7, (%rcx), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x48,0x71,0x09,0x07]
          vpshldq  $7, (%rcx), %zmm3, %zmm1

// CHECK: vpshldq  $7, -256(%rsp), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x48,0x71,0x4c,0x24,0xfc,0x07]
          vpshldq  $7, -256(%rsp), %zmm3, %zmm1

// CHECK: vpshldq  $7, 256(%rsp), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x48,0x71,0x4c,0x24,0x04,0x07]
          vpshldq  $7, 256(%rsp), %zmm3, %zmm1

// CHECK: vpshldq  $7, 268435456(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x48,0x71,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldq  $7, 268435456(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshldq  $7, -536870912(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x48,0x71,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldq  $7, -536870912(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshldq  $7, -536870910(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x48,0x71,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldq  $7, -536870910(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshrdw  $7, (%rcx), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x48,0x72,0x09,0x07]
          vpshrdw  $7, (%rcx), %zmm3, %zmm1

// CHECK: vpshrdw  $7, -256(%rsp), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x48,0x72,0x4c,0x24,0xfc,0x07]
          vpshrdw  $7, -256(%rsp), %zmm3, %zmm1

// CHECK: vpshrdw  $7, 256(%rsp), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x48,0x72,0x4c,0x24,0x04,0x07]
          vpshrdw  $7, 256(%rsp), %zmm3, %zmm1

// CHECK: vpshrdw  $7, 268435456(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x48,0x72,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdw  $7, 268435456(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshrdw  $7, -536870912(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x48,0x72,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdw  $7, -536870912(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshrdw  $7, -536870910(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x48,0x72,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdw  $7, -536870910(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshrdd  $7, (%rcx), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf3,0x65,0x48,0x73,0x09,0x07]
          vpshrdd  $7, (%rcx), %zmm3, %zmm1

// CHECK: vpshrdd  $7, -256(%rsp), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf3,0x65,0x48,0x73,0x4c,0x24,0xfc,0x07]
          vpshrdd  $7, -256(%rsp), %zmm3, %zmm1

// CHECK: vpshrdd  $7, 256(%rsp), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf3,0x65,0x48,0x73,0x4c,0x24,0x04,0x07]
          vpshrdd  $7, 256(%rsp), %zmm3, %zmm1

// CHECK: vpshrdd  $7, 268435456(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb3,0x65,0x48,0x73,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdd  $7, 268435456(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshrdd  $7, -536870912(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb3,0x65,0x48,0x73,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdd  $7, -536870912(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshrdd  $7, -536870910(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb3,0x65,0x48,0x73,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdd  $7, -536870910(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshrdq  $7, (%rcx), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x48,0x73,0x09,0x07]
          vpshrdq  $7, (%rcx), %zmm3, %zmm1

// CHECK: vpshrdq  $7, -256(%rsp), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x48,0x73,0x4c,0x24,0xfc,0x07]
          vpshrdq  $7, -256(%rsp), %zmm3, %zmm1

// CHECK: vpshrdq  $7, 256(%rsp), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x48,0x73,0x4c,0x24,0x04,0x07]
          vpshrdq  $7, 256(%rsp), %zmm3, %zmm1

// CHECK: vpshrdq  $7, 268435456(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x48,0x73,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdq  $7, 268435456(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshrdq  $7, -536870912(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x48,0x73,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdq  $7, -536870912(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshrdq  $7, -536870910(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x48,0x73,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdq  $7, -536870910(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshldw  $7, (%rcx), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x40,0x70,0x29,0x07]
          vpshldw  $7, (%rcx), %zmm23, %zmm21

// CHECK: vpshldw  $7, -256(%rsp), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x40,0x70,0x6c,0x24,0xfc,0x07]
          vpshldw  $7, -256(%rsp), %zmm23, %zmm21

// CHECK: vpshldw  $7, 256(%rsp), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x40,0x70,0x6c,0x24,0x04,0x07]
          vpshldw  $7, 256(%rsp), %zmm23, %zmm21

// CHECK: vpshldw  $7, 268435456(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x40,0x70,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldw  $7, 268435456(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshldw  $7, -536870912(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x40,0x70,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldw  $7, -536870912(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshldw  $7, -536870910(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x40,0x70,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldw  $7, -536870910(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshldd  $7, (%rcx), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe3,0x45,0x40,0x71,0x29,0x07]
          vpshldd  $7, (%rcx), %zmm23, %zmm21

// CHECK: vpshldd  $7, -256(%rsp), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe3,0x45,0x40,0x71,0x6c,0x24,0xfc,0x07]
          vpshldd  $7, -256(%rsp), %zmm23, %zmm21

// CHECK: vpshldd  $7, 256(%rsp), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe3,0x45,0x40,0x71,0x6c,0x24,0x04,0x07]
          vpshldd  $7, 256(%rsp), %zmm23, %zmm21

// CHECK: vpshldd  $7, 268435456(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa3,0x45,0x40,0x71,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldd  $7, 268435456(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshldd  $7, -536870912(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa3,0x45,0x40,0x71,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldd  $7, -536870912(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshldd  $7, -536870910(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa3,0x45,0x40,0x71,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldd  $7, -536870910(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshldq  $7, (%rcx), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x40,0x71,0x29,0x07]
          vpshldq  $7, (%rcx), %zmm23, %zmm21

// CHECK: vpshldq  $7, -256(%rsp), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x40,0x71,0x6c,0x24,0xfc,0x07]
          vpshldq  $7, -256(%rsp), %zmm23, %zmm21

// CHECK: vpshldq  $7, 256(%rsp), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x40,0x71,0x6c,0x24,0x04,0x07]
          vpshldq  $7, 256(%rsp), %zmm23, %zmm21

// CHECK: vpshldq  $7, 268435456(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x40,0x71,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldq  $7, 268435456(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshldq  $7, -536870912(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x40,0x71,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldq  $7, -536870912(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshldq  $7, -536870910(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x40,0x71,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldq  $7, -536870910(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshrdw  $7, (%rcx), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x40,0x72,0x29,0x07]
          vpshrdw  $7, (%rcx), %zmm23, %zmm21

// CHECK: vpshrdw  $7, -256(%rsp), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x40,0x72,0x6c,0x24,0xfc,0x07]
          vpshrdw  $7, -256(%rsp), %zmm23, %zmm21

// CHECK: vpshrdw  $7, 256(%rsp), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x40,0x72,0x6c,0x24,0x04,0x07]
          vpshrdw  $7, 256(%rsp), %zmm23, %zmm21

// CHECK: vpshrdw  $7, 268435456(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x40,0x72,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdw  $7, 268435456(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshrdw  $7, -536870912(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x40,0x72,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdw  $7, -536870912(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshrdw  $7, -536870910(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x40,0x72,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdw  $7, -536870910(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshrdd  $7, (%rcx), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe3,0x45,0x40,0x73,0x29,0x07]
          vpshrdd  $7, (%rcx), %zmm23, %zmm21

// CHECK: vpshrdd  $7, -256(%rsp), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe3,0x45,0x40,0x73,0x6c,0x24,0xfc,0x07]
          vpshrdd  $7, -256(%rsp), %zmm23, %zmm21

// CHECK: vpshrdd  $7, 256(%rsp), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe3,0x45,0x40,0x73,0x6c,0x24,0x04,0x07]
          vpshrdd  $7, 256(%rsp), %zmm23, %zmm21

// CHECK: vpshrdd  $7, 268435456(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa3,0x45,0x40,0x73,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdd  $7, 268435456(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshrdd  $7, -536870912(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa3,0x45,0x40,0x73,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdd  $7, -536870912(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshrdd  $7, -536870910(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa3,0x45,0x40,0x73,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdd  $7, -536870910(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshrdq  $7, (%rcx), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x40,0x73,0x29,0x07]
          vpshrdq  $7, (%rcx), %zmm23, %zmm21

// CHECK: vpshrdq  $7, -256(%rsp), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x40,0x73,0x6c,0x24,0xfc,0x07]
          vpshrdq  $7, -256(%rsp), %zmm23, %zmm21

// CHECK: vpshrdq  $7, 256(%rsp), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x40,0x73,0x6c,0x24,0x04,0x07]
          vpshrdq  $7, 256(%rsp), %zmm23, %zmm21

// CHECK: vpshrdq  $7, 268435456(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x40,0x73,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdq  $7, 268435456(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshrdq  $7, -536870912(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x40,0x73,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdq  $7, -536870912(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshrdq  $7, -536870910(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x40,0x73,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdq  $7, -536870910(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshldw  $7, (%rcx), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x4a,0x70,0x09,0x07]
          vpshldw  $7, (%rcx), %zmm3, %zmm1 {%k2}

// CHECK: vpshldw  $7, -256(%rsp), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x4a,0x70,0x4c,0x24,0xfc,0x07]
          vpshldw  $7, -256(%rsp), %zmm3, %zmm1 {%k2}

// CHECK: vpshldw  $7, 256(%rsp), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x4a,0x70,0x4c,0x24,0x04,0x07]
          vpshldw  $7, 256(%rsp), %zmm3, %zmm1 {%k2}

// CHECK: vpshldw  $7, 268435456(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x4a,0x70,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldw  $7, 268435456(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshldw  $7, -536870912(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x4a,0x70,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldw  $7, -536870912(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshldw  $7, -536870910(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x4a,0x70,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldw  $7, -536870910(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshldd  $7, (%rcx), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0x65,0x4a,0x71,0x09,0x07]
          vpshldd  $7, (%rcx), %zmm3, %zmm1 {%k2}

// CHECK: vpshldd  $7, -256(%rsp), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0x65,0x4a,0x71,0x4c,0x24,0xfc,0x07]
          vpshldd  $7, -256(%rsp), %zmm3, %zmm1 {%k2}

// CHECK: vpshldd  $7, 256(%rsp), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0x65,0x4a,0x71,0x4c,0x24,0x04,0x07]
          vpshldd  $7, 256(%rsp), %zmm3, %zmm1 {%k2}

// CHECK: vpshldd  $7, 268435456(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0x65,0x4a,0x71,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldd  $7, 268435456(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshldd  $7, -536870912(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0x65,0x4a,0x71,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldd  $7, -536870912(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshldd  $7, -536870910(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0x65,0x4a,0x71,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldd  $7, -536870910(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshldq  $7, (%rcx), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x4a,0x71,0x09,0x07]
          vpshldq  $7, (%rcx), %zmm3, %zmm1 {%k2}

// CHECK: vpshldq  $7, -256(%rsp), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x4a,0x71,0x4c,0x24,0xfc,0x07]
          vpshldq  $7, -256(%rsp), %zmm3, %zmm1 {%k2}

// CHECK: vpshldq  $7, 256(%rsp), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x4a,0x71,0x4c,0x24,0x04,0x07]
          vpshldq  $7, 256(%rsp), %zmm3, %zmm1 {%k2}

// CHECK: vpshldq  $7, 268435456(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x4a,0x71,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldq  $7, 268435456(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshldq  $7, -536870912(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x4a,0x71,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldq  $7, -536870912(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshldq  $7, -536870910(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x4a,0x71,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldq  $7, -536870910(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdw  $7, (%rcx), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x4a,0x72,0x09,0x07]
          vpshrdw  $7, (%rcx), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdw  $7, -256(%rsp), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x4a,0x72,0x4c,0x24,0xfc,0x07]
          vpshrdw  $7, -256(%rsp), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdw  $7, 256(%rsp), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x4a,0x72,0x4c,0x24,0x04,0x07]
          vpshrdw  $7, 256(%rsp), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdw  $7, 268435456(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x4a,0x72,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdw  $7, 268435456(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdw  $7, -536870912(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x4a,0x72,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdw  $7, -536870912(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdw  $7, -536870910(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x4a,0x72,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdw  $7, -536870910(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdd  $7, (%rcx), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0x65,0x4a,0x73,0x09,0x07]
          vpshrdd  $7, (%rcx), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdd  $7, -256(%rsp), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0x65,0x4a,0x73,0x4c,0x24,0xfc,0x07]
          vpshrdd  $7, -256(%rsp), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdd  $7, 256(%rsp), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0x65,0x4a,0x73,0x4c,0x24,0x04,0x07]
          vpshrdd  $7, 256(%rsp), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdd  $7, 268435456(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0x65,0x4a,0x73,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdd  $7, 268435456(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdd  $7, -536870912(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0x65,0x4a,0x73,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdd  $7, -536870912(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdd  $7, -536870910(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0x65,0x4a,0x73,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdd  $7, -536870910(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdq  $7, (%rcx), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x4a,0x73,0x09,0x07]
          vpshrdq  $7, (%rcx), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdq  $7, -256(%rsp), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x4a,0x73,0x4c,0x24,0xfc,0x07]
          vpshrdq  $7, -256(%rsp), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdq  $7, 256(%rsp), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x4a,0x73,0x4c,0x24,0x04,0x07]
          vpshrdq  $7, 256(%rsp), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdq  $7, 268435456(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x4a,0x73,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdq  $7, 268435456(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdq  $7, -536870912(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x4a,0x73,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdq  $7, -536870912(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdq  $7, -536870910(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x4a,0x73,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdq  $7, -536870910(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshldw  $7, (%rcx), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x42,0x70,0x29,0x07]
          vpshldw  $7, (%rcx), %zmm23, %zmm21 {%k2}

// CHECK: vpshldw  $7, -256(%rsp), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x42,0x70,0x6c,0x24,0xfc,0x07]
          vpshldw  $7, -256(%rsp), %zmm23, %zmm21 {%k2}

// CHECK: vpshldw  $7, 256(%rsp), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x42,0x70,0x6c,0x24,0x04,0x07]
          vpshldw  $7, 256(%rsp), %zmm23, %zmm21 {%k2}

// CHECK: vpshldw  $7, 268435456(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x42,0x70,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldw  $7, 268435456(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshldw  $7, -536870912(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x42,0x70,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldw  $7, -536870912(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshldw  $7, -536870910(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x42,0x70,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldw  $7, -536870910(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshldd  $7, (%rcx), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0x45,0x42,0x71,0x29,0x07]
          vpshldd  $7, (%rcx), %zmm23, %zmm21 {%k2}

// CHECK: vpshldd  $7, -256(%rsp), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0x45,0x42,0x71,0x6c,0x24,0xfc,0x07]
          vpshldd  $7, -256(%rsp), %zmm23, %zmm21 {%k2}

// CHECK: vpshldd  $7, 256(%rsp), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0x45,0x42,0x71,0x6c,0x24,0x04,0x07]
          vpshldd  $7, 256(%rsp), %zmm23, %zmm21 {%k2}

// CHECK: vpshldd  $7, 268435456(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0x45,0x42,0x71,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldd  $7, 268435456(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshldd  $7, -536870912(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0x45,0x42,0x71,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldd  $7, -536870912(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshldd  $7, -536870910(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0x45,0x42,0x71,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldd  $7, -536870910(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshldq  $7, (%rcx), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x42,0x71,0x29,0x07]
          vpshldq  $7, (%rcx), %zmm23, %zmm21 {%k2}

// CHECK: vpshldq  $7, -256(%rsp), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x42,0x71,0x6c,0x24,0xfc,0x07]
          vpshldq  $7, -256(%rsp), %zmm23, %zmm21 {%k2}

// CHECK: vpshldq  $7, 256(%rsp), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x42,0x71,0x6c,0x24,0x04,0x07]
          vpshldq  $7, 256(%rsp), %zmm23, %zmm21 {%k2}

// CHECK: vpshldq  $7, 268435456(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x42,0x71,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldq  $7, 268435456(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshldq  $7, -536870912(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x42,0x71,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldq  $7, -536870912(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshldq  $7, -536870910(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x42,0x71,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldq  $7, -536870910(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdw  $7, (%rcx), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x42,0x72,0x29,0x07]
          vpshrdw  $7, (%rcx), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdw  $7, -256(%rsp), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x42,0x72,0x6c,0x24,0xfc,0x07]
          vpshrdw  $7, -256(%rsp), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdw  $7, 256(%rsp), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x42,0x72,0x6c,0x24,0x04,0x07]
          vpshrdw  $7, 256(%rsp), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdw  $7, 268435456(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x42,0x72,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdw  $7, 268435456(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdw  $7, -536870912(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x42,0x72,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdw  $7, -536870912(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdw  $7, -536870910(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x42,0x72,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdw  $7, -536870910(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdd  $7, (%rcx), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0x45,0x42,0x73,0x29,0x07]
          vpshrdd  $7, (%rcx), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdd  $7, -256(%rsp), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0x45,0x42,0x73,0x6c,0x24,0xfc,0x07]
          vpshrdd  $7, -256(%rsp), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdd  $7, 256(%rsp), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0x45,0x42,0x73,0x6c,0x24,0x04,0x07]
          vpshrdd  $7, 256(%rsp), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdd  $7, 268435456(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0x45,0x42,0x73,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdd  $7, 268435456(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdd  $7, -536870912(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0x45,0x42,0x73,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdd  $7, -536870912(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdd  $7, -536870910(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0x45,0x42,0x73,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdd  $7, -536870910(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdq  $7, (%rcx), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x42,0x73,0x29,0x07]
          vpshrdq  $7, (%rcx), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdq  $7, -256(%rsp), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x42,0x73,0x6c,0x24,0xfc,0x07]
          vpshrdq  $7, -256(%rsp), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdq  $7, 256(%rsp), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x42,0x73,0x6c,0x24,0x04,0x07]
          vpshrdq  $7, 256(%rsp), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdq  $7, 268435456(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x42,0x73,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdq  $7, 268435456(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdq  $7, -536870912(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x42,0x73,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdq  $7, -536870912(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdq  $7, -536870910(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x42,0x73,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdq  $7, -536870910(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshldvw %zmm3, %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x48,0x70,0xcb]
          vpshldvw %zmm3, %zmm3, %zmm1

// CHECK: vpshldvd %zmm3, %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf2,0x65,0x48,0x71,0xcb]
          vpshldvd %zmm3, %zmm3, %zmm1

// CHECK: vpshldvq %zmm3, %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x48,0x71,0xcb]
          vpshldvq %zmm3, %zmm3, %zmm1

// CHECK: vpshrdvw %zmm3, %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x48,0x72,0xcb]
          vpshrdvw %zmm3, %zmm3, %zmm1

// CHECK: vpshrdvd %zmm3, %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf2,0x65,0x48,0x73,0xcb]
          vpshrdvd %zmm3, %zmm3, %zmm1

// CHECK: vpshrdvq %zmm3, %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x48,0x73,0xcb]
          vpshrdvq %zmm3, %zmm3, %zmm1

// CHECK: vpshldvw %zmm23, %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x40,0x70,0xef]
          vpshldvw %zmm23, %zmm23, %zmm21

// CHECK: vpshldvd %zmm23, %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa2,0x45,0x40,0x71,0xef]
          vpshldvd %zmm23, %zmm23, %zmm21

// CHECK: vpshldvq %zmm23, %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x40,0x71,0xef]
          vpshldvq %zmm23, %zmm23, %zmm21

// CHECK: vpshrdvw %zmm23, %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x40,0x72,0xef]
          vpshrdvw %zmm23, %zmm23, %zmm21

// CHECK: vpshrdvd %zmm23, %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa2,0x45,0x40,0x73,0xef]
          vpshrdvd %zmm23, %zmm23, %zmm21

// CHECK: vpshrdvq %zmm23, %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x40,0x73,0xef]
          vpshrdvq %zmm23, %zmm23, %zmm21

// CHECK: vpshldvw %zmm3, %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x4a,0x70,0xcb]
          vpshldvw %zmm3, %zmm3, %zmm1 {%k2}

// CHECK: vpshldvd %zmm3, %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x65,0x4a,0x71,0xcb]
          vpshldvd %zmm3, %zmm3, %zmm1 {%k2}

// CHECK: vpshldvq %zmm3, %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x4a,0x71,0xcb]
          vpshldvq %zmm3, %zmm3, %zmm1 {%k2}

// CHECK: vpshrdvw %zmm3, %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x4a,0x72,0xcb]
          vpshrdvw %zmm3, %zmm3, %zmm1 {%k2}

// CHECK: vpshrdvd %zmm3, %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x65,0x4a,0x73,0xcb]
          vpshrdvd %zmm3, %zmm3, %zmm1 {%k2}

// CHECK: vpshrdvq %zmm3, %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x4a,0x73,0xcb]
          vpshrdvq %zmm3, %zmm3, %zmm1 {%k2}

// CHECK: vpshldvw %zmm23, %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x42,0x70,0xef]
          vpshldvw %zmm23, %zmm23, %zmm21 {%k2}

// CHECK: vpshldvd %zmm23, %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x45,0x42,0x71,0xef]
          vpshldvd %zmm23, %zmm23, %zmm21 {%k2}

// CHECK: vpshldvq %zmm23, %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x42,0x71,0xef]
          vpshldvq %zmm23, %zmm23, %zmm21 {%k2}

// CHECK: vpshrdvw %zmm23, %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x42,0x72,0xef]
          vpshrdvw %zmm23, %zmm23, %zmm21 {%k2}

// CHECK: vpshrdvd %zmm23, %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x45,0x42,0x73,0xef]
          vpshrdvd %zmm23, %zmm23, %zmm21 {%k2}

// CHECK: vpshrdvq %zmm23, %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x42,0x73,0xef]
          vpshrdvq %zmm23, %zmm23, %zmm21 {%k2}

// CHECK: vpshldvw  (%rcx), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x48,0x70,0x09]
          vpshldvw  (%rcx), %zmm3, %zmm1

// CHECK: vpshldvw  -256(%rsp), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x48,0x70,0x4c,0x24,0xfc]
          vpshldvw  -256(%rsp), %zmm3, %zmm1

// CHECK: vpshldvw  256(%rsp), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x48,0x70,0x4c,0x24,0x04]
          vpshldvw  256(%rsp), %zmm3, %zmm1

// CHECK: vpshldvw  268435456(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x48,0x70,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshldvw  268435456(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshldvw  -536870912(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x48,0x70,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvw  -536870912(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshldvw  -536870910(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x48,0x70,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvw  -536870910(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshldvd  (%rcx), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf2,0x65,0x48,0x71,0x09]
          vpshldvd  (%rcx), %zmm3, %zmm1

// CHECK: vpshldvd  -256(%rsp), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf2,0x65,0x48,0x71,0x4c,0x24,0xfc]
          vpshldvd  -256(%rsp), %zmm3, %zmm1

// CHECK: vpshldvd  256(%rsp), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf2,0x65,0x48,0x71,0x4c,0x24,0x04]
          vpshldvd  256(%rsp), %zmm3, %zmm1

// CHECK: vpshldvd  268435456(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb2,0x65,0x48,0x71,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshldvd  268435456(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshldvd  -536870912(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb2,0x65,0x48,0x71,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvd  -536870912(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshldvd  -536870910(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb2,0x65,0x48,0x71,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvd  -536870910(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshldvq  (%rcx), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x48,0x71,0x09]
          vpshldvq  (%rcx), %zmm3, %zmm1

// CHECK: vpshldvq  -256(%rsp), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x48,0x71,0x4c,0x24,0xfc]
          vpshldvq  -256(%rsp), %zmm3, %zmm1

// CHECK: vpshldvq  256(%rsp), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x48,0x71,0x4c,0x24,0x04]
          vpshldvq  256(%rsp), %zmm3, %zmm1

// CHECK: vpshldvq  268435456(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x48,0x71,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshldvq  268435456(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshldvq  -536870912(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x48,0x71,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvq  -536870912(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshldvq  -536870910(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x48,0x71,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvq  -536870910(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshrdvw  (%rcx), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x48,0x72,0x09]
          vpshrdvw  (%rcx), %zmm3, %zmm1

// CHECK: vpshrdvw  -256(%rsp), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x48,0x72,0x4c,0x24,0xfc]
          vpshrdvw  -256(%rsp), %zmm3, %zmm1

// CHECK: vpshrdvw  256(%rsp), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x48,0x72,0x4c,0x24,0x04]
          vpshrdvw  256(%rsp), %zmm3, %zmm1

// CHECK: vpshrdvw  268435456(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x48,0x72,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvw  268435456(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshrdvw  -536870912(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x48,0x72,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvw  -536870912(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshrdvw  -536870910(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x48,0x72,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvw  -536870910(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshrdvd  (%rcx), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf2,0x65,0x48,0x73,0x09]
          vpshrdvd  (%rcx), %zmm3, %zmm1

// CHECK: vpshrdvd  -256(%rsp), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf2,0x65,0x48,0x73,0x4c,0x24,0xfc]
          vpshrdvd  -256(%rsp), %zmm3, %zmm1

// CHECK: vpshrdvd  256(%rsp), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf2,0x65,0x48,0x73,0x4c,0x24,0x04]
          vpshrdvd  256(%rsp), %zmm3, %zmm1

// CHECK: vpshrdvd  268435456(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb2,0x65,0x48,0x73,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvd  268435456(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshrdvd  -536870912(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb2,0x65,0x48,0x73,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvd  -536870912(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshrdvd  -536870910(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb2,0x65,0x48,0x73,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvd  -536870910(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshrdvq  (%rcx), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x48,0x73,0x09]
          vpshrdvq  (%rcx), %zmm3, %zmm1

// CHECK: vpshrdvq  -256(%rsp), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x48,0x73,0x4c,0x24,0xfc]
          vpshrdvq  -256(%rsp), %zmm3, %zmm1

// CHECK: vpshrdvq  256(%rsp), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x48,0x73,0x4c,0x24,0x04]
          vpshrdvq  256(%rsp), %zmm3, %zmm1

// CHECK: vpshrdvq  268435456(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x48,0x73,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvq  268435456(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshrdvq  -536870912(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x48,0x73,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvq  -536870912(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshrdvq  -536870910(%rcx,%r14,8), %zmm3, %zmm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x48,0x73,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvq  -536870910(%rcx,%r14,8), %zmm3, %zmm1

// CHECK: vpshldvw  (%rcx), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x40,0x70,0x29]
          vpshldvw  (%rcx), %zmm23, %zmm21

// CHECK: vpshldvw  -256(%rsp), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x40,0x70,0x6c,0x24,0xfc]
          vpshldvw  -256(%rsp), %zmm23, %zmm21

// CHECK: vpshldvw  256(%rsp), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x40,0x70,0x6c,0x24,0x04]
          vpshldvw  256(%rsp), %zmm23, %zmm21

// CHECK: vpshldvw  268435456(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x40,0x70,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshldvw  268435456(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshldvw  -536870912(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x40,0x70,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvw  -536870912(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshldvw  -536870910(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x40,0x70,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvw  -536870910(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshldvd  (%rcx), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe2,0x45,0x40,0x71,0x29]
          vpshldvd  (%rcx), %zmm23, %zmm21

// CHECK: vpshldvd  -256(%rsp), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe2,0x45,0x40,0x71,0x6c,0x24,0xfc]
          vpshldvd  -256(%rsp), %zmm23, %zmm21

// CHECK: vpshldvd  256(%rsp), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe2,0x45,0x40,0x71,0x6c,0x24,0x04]
          vpshldvd  256(%rsp), %zmm23, %zmm21

// CHECK: vpshldvd  268435456(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa2,0x45,0x40,0x71,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshldvd  268435456(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshldvd  -536870912(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa2,0x45,0x40,0x71,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvd  -536870912(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshldvd  -536870910(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa2,0x45,0x40,0x71,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvd  -536870910(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshldvq  (%rcx), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x40,0x71,0x29]
          vpshldvq  (%rcx), %zmm23, %zmm21

// CHECK: vpshldvq  -256(%rsp), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x40,0x71,0x6c,0x24,0xfc]
          vpshldvq  -256(%rsp), %zmm23, %zmm21

// CHECK: vpshldvq  256(%rsp), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x40,0x71,0x6c,0x24,0x04]
          vpshldvq  256(%rsp), %zmm23, %zmm21

// CHECK: vpshldvq  268435456(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x40,0x71,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshldvq  268435456(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshldvq  -536870912(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x40,0x71,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvq  -536870912(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshldvq  -536870910(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x40,0x71,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvq  -536870910(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshrdvw  (%rcx), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x40,0x72,0x29]
          vpshrdvw  (%rcx), %zmm23, %zmm21

// CHECK: vpshrdvw  -256(%rsp), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x40,0x72,0x6c,0x24,0xfc]
          vpshrdvw  -256(%rsp), %zmm23, %zmm21

// CHECK: vpshrdvw  256(%rsp), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x40,0x72,0x6c,0x24,0x04]
          vpshrdvw  256(%rsp), %zmm23, %zmm21

// CHECK: vpshrdvw  268435456(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x40,0x72,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvw  268435456(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshrdvw  -536870912(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x40,0x72,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvw  -536870912(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshrdvw  -536870910(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x40,0x72,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvw  -536870910(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshrdvd  (%rcx), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe2,0x45,0x40,0x73,0x29]
          vpshrdvd  (%rcx), %zmm23, %zmm21

// CHECK: vpshrdvd  -256(%rsp), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe2,0x45,0x40,0x73,0x6c,0x24,0xfc]
          vpshrdvd  -256(%rsp), %zmm23, %zmm21

// CHECK: vpshrdvd  256(%rsp), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe2,0x45,0x40,0x73,0x6c,0x24,0x04]
          vpshrdvd  256(%rsp), %zmm23, %zmm21

// CHECK: vpshrdvd  268435456(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa2,0x45,0x40,0x73,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvd  268435456(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshrdvd  -536870912(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa2,0x45,0x40,0x73,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvd  -536870912(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshrdvd  -536870910(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa2,0x45,0x40,0x73,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvd  -536870910(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshrdvq  (%rcx), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x40,0x73,0x29]
          vpshrdvq  (%rcx), %zmm23, %zmm21

// CHECK: vpshrdvq  -256(%rsp), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x40,0x73,0x6c,0x24,0xfc]
          vpshrdvq  -256(%rsp), %zmm23, %zmm21

// CHECK: vpshrdvq  256(%rsp), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x40,0x73,0x6c,0x24,0x04]
          vpshrdvq  256(%rsp), %zmm23, %zmm21

// CHECK: vpshrdvq  268435456(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x40,0x73,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvq  268435456(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshrdvq  -536870912(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x40,0x73,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvq  -536870912(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshrdvq  -536870910(%rcx,%r14,8), %zmm23, %zmm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x40,0x73,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvq  -536870910(%rcx,%r14,8), %zmm23, %zmm21

// CHECK: vpshldvw  (%rcx), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x4a,0x70,0x09]
          vpshldvw  (%rcx), %zmm3, %zmm1 {%k2}

// CHECK: vpshldvw  -256(%rsp), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x4a,0x70,0x4c,0x24,0xfc]
          vpshldvw  -256(%rsp), %zmm3, %zmm1 {%k2}

// CHECK: vpshldvw  256(%rsp), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x4a,0x70,0x4c,0x24,0x04]
          vpshldvw  256(%rsp), %zmm3, %zmm1 {%k2}

// CHECK: vpshldvw  268435456(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x4a,0x70,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshldvw  268435456(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshldvw  -536870912(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x4a,0x70,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvw  -536870912(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshldvw  -536870910(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x4a,0x70,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvw  -536870910(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshldvd  (%rcx), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x65,0x4a,0x71,0x09]
          vpshldvd  (%rcx), %zmm3, %zmm1 {%k2}

// CHECK: vpshldvd  -256(%rsp), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x65,0x4a,0x71,0x4c,0x24,0xfc]
          vpshldvd  -256(%rsp), %zmm3, %zmm1 {%k2}

// CHECK: vpshldvd  256(%rsp), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x65,0x4a,0x71,0x4c,0x24,0x04]
          vpshldvd  256(%rsp), %zmm3, %zmm1 {%k2}

// CHECK: vpshldvd  268435456(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0x65,0x4a,0x71,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshldvd  268435456(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshldvd  -536870912(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0x65,0x4a,0x71,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvd  -536870912(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshldvd  -536870910(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0x65,0x4a,0x71,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvd  -536870910(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshldvq  (%rcx), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x4a,0x71,0x09]
          vpshldvq  (%rcx), %zmm3, %zmm1 {%k2}

// CHECK: vpshldvq  -256(%rsp), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x4a,0x71,0x4c,0x24,0xfc]
          vpshldvq  -256(%rsp), %zmm3, %zmm1 {%k2}

// CHECK: vpshldvq  256(%rsp), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x4a,0x71,0x4c,0x24,0x04]
          vpshldvq  256(%rsp), %zmm3, %zmm1 {%k2}

// CHECK: vpshldvq  268435456(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x4a,0x71,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshldvq  268435456(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshldvq  -536870912(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x4a,0x71,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvq  -536870912(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshldvq  -536870910(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x4a,0x71,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvq  -536870910(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdvw  (%rcx), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x4a,0x72,0x09]
          vpshrdvw  (%rcx), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdvw  -256(%rsp), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x4a,0x72,0x4c,0x24,0xfc]
          vpshrdvw  -256(%rsp), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdvw  256(%rsp), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x4a,0x72,0x4c,0x24,0x04]
          vpshrdvw  256(%rsp), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdvw  268435456(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x4a,0x72,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvw  268435456(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdvw  -536870912(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x4a,0x72,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvw  -536870912(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdvw  -536870910(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x4a,0x72,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvw  -536870910(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdvd  (%rcx), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x65,0x4a,0x73,0x09]
          vpshrdvd  (%rcx), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdvd  -256(%rsp), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x65,0x4a,0x73,0x4c,0x24,0xfc]
          vpshrdvd  -256(%rsp), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdvd  256(%rsp), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x65,0x4a,0x73,0x4c,0x24,0x04]
          vpshrdvd  256(%rsp), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdvd  268435456(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0x65,0x4a,0x73,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvd  268435456(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdvd  -536870912(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0x65,0x4a,0x73,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvd  -536870912(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdvd  -536870910(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0x65,0x4a,0x73,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvd  -536870910(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdvq  (%rcx), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x4a,0x73,0x09]
          vpshrdvq  (%rcx), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdvq  -256(%rsp), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x4a,0x73,0x4c,0x24,0xfc]
          vpshrdvq  -256(%rsp), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdvq  256(%rsp), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x4a,0x73,0x4c,0x24,0x04]
          vpshrdvq  256(%rsp), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdvq  268435456(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x4a,0x73,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvq  268435456(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdvq  -536870912(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x4a,0x73,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvq  -536870912(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshrdvq  -536870910(%rcx,%r14,8), %zmm3, %zmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x4a,0x73,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvq  -536870910(%rcx,%r14,8), %zmm3, %zmm1 {%k2}

// CHECK: vpshldvw  (%rcx), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x42,0x70,0x29]
          vpshldvw  (%rcx), %zmm23, %zmm21 {%k2}

// CHECK: vpshldvw  -256(%rsp), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x42,0x70,0x6c,0x24,0xfc]
          vpshldvw  -256(%rsp), %zmm23, %zmm21 {%k2}

// CHECK: vpshldvw  256(%rsp), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x42,0x70,0x6c,0x24,0x04]
          vpshldvw  256(%rsp), %zmm23, %zmm21 {%k2}

// CHECK: vpshldvw  268435456(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x42,0x70,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshldvw  268435456(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshldvw  -536870912(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x42,0x70,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvw  -536870912(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshldvw  -536870910(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x42,0x70,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvw  -536870910(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshldvd  (%rcx), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0x45,0x42,0x71,0x29]
          vpshldvd  (%rcx), %zmm23, %zmm21 {%k2}

// CHECK: vpshldvd  -256(%rsp), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0x45,0x42,0x71,0x6c,0x24,0xfc]
          vpshldvd  -256(%rsp), %zmm23, %zmm21 {%k2}

// CHECK: vpshldvd  256(%rsp), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0x45,0x42,0x71,0x6c,0x24,0x04]
          vpshldvd  256(%rsp), %zmm23, %zmm21 {%k2}

// CHECK: vpshldvd  268435456(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x45,0x42,0x71,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshldvd  268435456(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshldvd  -536870912(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x45,0x42,0x71,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvd  -536870912(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshldvd  -536870910(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x45,0x42,0x71,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvd  -536870910(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshldvq  (%rcx), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x42,0x71,0x29]
          vpshldvq  (%rcx), %zmm23, %zmm21 {%k2}

// CHECK: vpshldvq  -256(%rsp), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x42,0x71,0x6c,0x24,0xfc]
          vpshldvq  -256(%rsp), %zmm23, %zmm21 {%k2}

// CHECK: vpshldvq  256(%rsp), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x42,0x71,0x6c,0x24,0x04]
          vpshldvq  256(%rsp), %zmm23, %zmm21 {%k2}

// CHECK: vpshldvq  268435456(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x42,0x71,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshldvq  268435456(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshldvq  -536870912(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x42,0x71,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvq  -536870912(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshldvq  -536870910(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x42,0x71,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvq  -536870910(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdvw  (%rcx), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x42,0x72,0x29]
          vpshrdvw  (%rcx), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdvw  -256(%rsp), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x42,0x72,0x6c,0x24,0xfc]
          vpshrdvw  -256(%rsp), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdvw  256(%rsp), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x42,0x72,0x6c,0x24,0x04]
          vpshrdvw  256(%rsp), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdvw  268435456(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x42,0x72,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvw  268435456(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdvw  -536870912(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x42,0x72,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvw  -536870912(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdvw  -536870910(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x42,0x72,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvw  -536870910(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdvd  (%rcx), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0x45,0x42,0x73,0x29]
          vpshrdvd  (%rcx), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdvd  -256(%rsp), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0x45,0x42,0x73,0x6c,0x24,0xfc]
          vpshrdvd  -256(%rsp), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdvd  256(%rsp), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0x45,0x42,0x73,0x6c,0x24,0x04]
          vpshrdvd  256(%rsp), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdvd  268435456(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x45,0x42,0x73,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvd  268435456(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdvd  -536870912(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x45,0x42,0x73,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvd  -536870912(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdvd  -536870910(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x45,0x42,0x73,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvd  -536870910(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdvq  (%rcx), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x42,0x73,0x29]
          vpshrdvq  (%rcx), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdvq  -256(%rsp), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x42,0x73,0x6c,0x24,0xfc]
          vpshrdvq  -256(%rsp), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdvq  256(%rsp), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x42,0x73,0x6c,0x24,0x04]
          vpshrdvq  256(%rsp), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdvq  268435456(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x42,0x73,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvq  268435456(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdvq  -536870912(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x42,0x73,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvq  -536870912(%rcx,%r14,8), %zmm23, %zmm21 {%k2}

// CHECK: vpshrdvq  -536870910(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x42,0x73,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvq  -536870910(%rcx,%r14,8), %zmm23, %zmm21 {%k2}
