{- This module was generated from data in the Kate syntax
   highlighting file bash.xml, version 3, by Wilbert Berendsen (wilbert@kde.nl) -}

module Text.Highlighting.Kate.Syntax.Bash
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import qualified Text.Highlighting.Kate.Syntax.Modelines
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Bash"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.sh;*.bash;*.ebuild;*.eclass;*.nix;.bashrc;.bash_profile;.bash_login;.profile"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Bash","Start")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStContinuation = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  st <- getState
  if length contexts >= 2
    then case context of
      _ | synStContinuation st -> updateState $ \st -> st{ synStContinuation = False }
      ("Bash","Start") -> return ()
      ("Bash","FindAll") -> return ()
      ("Bash","FindMost") -> return ()
      ("Bash","FindComments") -> (popContext) >> pEndLine
      ("Bash","Comment") -> (popContext) >> pEndLine
      ("Bash","FindCommentsParen") -> (popContext) >> pEndLine
      ("Bash","CommentParen") -> (popContext) >> pEndLine
      ("Bash","FindCommentsBackq") -> (popContext) >> pEndLine
      ("Bash","CommentBackq") -> (popContext) >> pEndLine
      ("Bash","FindCommands") -> return ()
      ("Bash","FindSpecialCommands") -> return ()
      ("Bash","FindNormalCommands") -> return ()
      ("Bash","CommandArgs") -> (popContext) >> pEndLine
      ("Bash","FindCommandsBackq") -> return ()
      ("Bash","FindNormalCommandsBackq") -> return ()
      ("Bash","CommandArgsBackq") -> (popContext) >> pEndLine
      ("Bash","FindOthers") -> return ()
      ("Bash","FindStrings") -> return ()
      ("Bash","FindSubstitutions") -> return ()
      ("Bash","FindTests") -> return ()
      ("Bash","ExprDblParen") -> return ()
      ("Bash","ExprDblParenSubst") -> return ()
      ("Bash","ExprSubParen") -> return ()
      ("Bash","ExprBracket") -> return ()
      ("Bash","ExprDblBracket") -> return ()
      ("Bash","Group") -> return ()
      ("Bash","SubShell") -> return ()
      ("Bash","Assign") -> (popContext) >> pEndLine
      ("Bash","AssignArray") -> (popContext) >> pEndLine
      ("Bash","AssignSubscr") -> (popContext) >> pEndLine
      ("Bash","Subscript") -> return ()
      ("Bash","FunctionDef") -> (popContext) >> pEndLine
      ("Bash","VarName") -> (popContext) >> pEndLine
      ("Bash","ProcessSubst") -> return ()
      ("Bash","StringSQ") -> return ()
      ("Bash","StringDQ") -> return ()
      ("Bash","StringEsc") -> return ()
      ("Bash","VarBrace") -> return ()
      ("Bash","VarAlt") -> return ()
      ("Bash","VarSubst") -> return ()
      ("Bash","VarSubst2") -> return ()
      ("Bash","VarSub") -> return ()
      ("Bash","VarSub2") -> return ()
      ("Bash","SubstFile") -> return ()
      ("Bash","SubstCommand") -> return ()
      ("Bash","SubstBackq") -> return ()
      ("Bash","Case") -> return ()
      ("Bash","CaseIn") -> return ()
      ("Bash","CaseExpr") -> return ()
      ("Bash","HereDoc") -> return ()
      ("Bash","HereDocRemainder") -> (popContext) >> pEndLine
      ("Bash","HereDocQ") -> return ()
      ("Bash","HereDocNQ") -> return ()
      ("Bash","HereDocIQ") -> return ()
      ("Bash","HereDocINQ") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_keywords = Set.fromList $ words $ "else for function in select until while elif then set"
list_builtins = Set.fromList $ words $ ": source alias bg bind break builtin cd caller command compgen complete continue dirs disown echo enable eval exec exit fc fg getopts hash help history jobs kill let logout popd printf pushd pwd return set shift shopt suspend test time times trap type ulimit umask unalias wait"
list_builtins'5fvar = Set.fromList $ words $ "export unset declare typeset local read readonly"
list_unixcommands = Set.fromList $ words $ "arch awk bash bunzip2 bzcat bzcmp bzdiff bzegrep bzfgrep bzgrep bzip2 bzip2recover bzless bzmore cat chattr chgrp chmod chown chvt cp date dd deallocvt df dir dircolors dmesg dnsdomainname domainname du dumpkeys echo ed egrep false fgconsole fgrep fuser gawk getkeycodes gocr grep groff groups gunzip gzexe gzip hostname igawk install kbd_mode kbdrate killall last lastb link ln loadkeys loadunimap login ls lsattr lsmod lsmod.old lzcat lzcmp lzdiff lzegrep lzfgrep lzgrep lzless lzcat lzma lzmainfo lzmore mapscrn mesg mkdir mkfifo mknod mktemp more mount mv nano netstat nisdomainname nroff openvt pgawk pidof ping ps pstree pwd rbash readlink red resizecons rm rmdir run-parts sash sed setfont setkeycodes setleds setmetamode setserial sh showkey shred sleep ssed stat stty su sync tar tempfile touch troff true umount uname unicode_start unicode_stop unlink unlzma unxz utmpdump uuidgen vdir wall wc xz xzcat ypdomainname zcat zcmp zdiff zegrep zfgrep zforce zgrep zless zmore znew zsh aclocal aconnect aplay apm apmsleep apropos ar arecord as as86 autoconf autoheader automake awk basename bc bison c++ cal cat cc cdda2wav cdparanoia cdrdao cd-read cdrecord chfn chgrp chmod chown chroot chsh clear cmp co col comm cp cpio cpp cut dc dd df diff diff3 dir dircolors directomatic dirname du env expr fbset file find flex flex++ fmt free ftp funzip fuser g++ gawk gc gcc clang valgrind xdg-open cmake qmake svn git rsync gdb getent getopt gettext gettextize gimp gimp-remote gimptool gmake gs head hexdump id install join kill killall ld ld86 ldd less lex ln locate lockfile logname lp lpr ls lynx m4 make man mkdir mknod msgfmt mv namei nasm nawk nice nl nm nm86 nmap nohup nop od passwd patch pcregrep pcretest perl perror pidof pr printf procmail prune ps2ascii ps2epsi ps2frag ps2pdf ps2ps psbook psmerge psnup psresize psselect pstops rcs rev rm scp sed seq setterm shred size size86 skill slogin snice sort sox split ssh ssh-add ssh-agent ssh-keygen ssh-keyscan stat strings strip sudo suidperl sum tac tail tee test tr uniq unlink unzip updatedb updmap uptime users vmstat w wc wget whatis whereis which who whoami write xargs yacc yes zip zsoelim dcop kdialog kfile xhost xmodmap xset"

regex_'5b'5cs'3b'5d'28'3f'3d'23'29 = compileRegex True "[\\s;](?=#)"
regex_'5b'5e'29'5d'28'3f'3d'5c'29'29 = compileRegex True "[^)](?=\\))"
regex_'5b'5e'60'5d'28'3f'3d'60'29 = compileRegex True "[^`](?=`)"
regex_'5c'5b'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 = compileRegex True "\\[\\[(?=($|\\s))"
regex_'5cs'5c'5b'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 = compileRegex True "\\s\\[\\[(?=($|\\s))"
regex_'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 = compileRegex True "\\[(?=($|\\s))"
regex_'5cs'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 = compileRegex True "\\s\\[(?=($|\\s))"
regex_'5c'7b'28'3f'3d'28'24'7c'5cs'29'29 = compileRegex True "\\{(?=($|\\s))"
regex_'5cbdo'28'3f'21'5b'5cw'24'2b'2d'5d'29 = compileRegex True "\\bdo(?![\\w$+-])"
regex_'5cbdone'28'3f'21'5b'5cw'24'2b'2d'5d'29 = compileRegex True "\\bdone(?![\\w$+-])"
regex_'5cbif'28'3f'3d'28'24'7c'5cs'29'29 = compileRegex True "\\bif(?=($|\\s))"
regex_'5cbfi'28'3f'21'5b'5cw'24'2b'2d'5d'29 = compileRegex True "\\bfi(?![\\w$+-])"
regex_'5cbcase'28'3f'21'5b'5cw'24'2b'2d'5d'29 = compileRegex True "\\bcase(?![\\w$+-])"
regex_'5cb'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'5c'2b'3f'3d = compileRegex True "\\b[A-Za-z_][A-Za-z0-9_]*\\+?="
regex_'5cb'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'28'3f'3d'5c'5b'2e'2b'5c'5d'5c'2b'3f'3d'29 = compileRegex True "\\b[A-Za-z_][A-Za-z0-9_]*(?=\\[.+\\]\\+?=)"
regex_'5cbfunction'5cb = compileRegex True "\\bfunction\\b"
regex_'5bA'2dZa'2dz'5f'3a'5d'5bA'2dZa'2dz0'2d9'5f'3a'23'25'40'2d'5d'2a'5cs'2a'5c'28'5c'29 = compileRegex True "[A-Za-z_:][A-Za-z0-9_:#%@-]*\\s*\\(\\)"
regex_'5c'2e'28'3f'3d'5cs'29 = compileRegex True "\\.(?=\\s)"
regex_'5cd'2a'3c'3c'3c = compileRegex True "\\d*<<<"
regex_'5b'3c'3e'5d'5c'28 = compileRegex True "[<>]\\("
regex_'28'5b0'2d9'5d'2a'28'3e'7b1'2c2'7d'7c'3c'29'28'26'5b0'2d9'5d'2b'2d'3f'29'3f'7c'26'3e'7c'3e'26'7c'5b0'2d9'5d'2a'3c'3e'29 = compileRegex True "([0-9]*(>{1,2}|<)(&[0-9]+-?)?|&>|>&|[0-9]*<>)"
regex_'28'5b'7c'26'5d'29'5c1'3f = compileRegex True "([|&])\\1?"
regex_'28'5b'5cw'5f'40'2e'25'2a'3f'2b'2d'5d'7c'5c'5c_'29'2a'28'3f'3d'2f'29 = compileRegex True "([\\w_@.%*?+-]|\\\\ )*(?=/)"
regex_'7e'5cw'2a = compileRegex True "~\\w*"
regex_'2f'28'5b'5cw'5f'40'2e'25'2a'3f'2b'2d'5d'7c'5c'5c_'29'2a'28'3f'3d'28'5b'2f'29'3b'24'60'27'22'5d'7c'24'29'29 = compileRegex True "/([\\w_@.%*?+-]|\\\\ )*(?=([/);$`'\"]|$))"
regex_'2f'28'5b'5cw'5f'40'2e'25'2a'3f'2b'2d'5d'7c'5c'5c_'29'2a'28'3f'3d'28'5b'5cs'29'3b'24'60'27'22'5d'7c'24'29'29 = compileRegex True "/([\\w_@.%*?+-]|\\\\ )*(?=([\\s);$`'\"]|$))"
regex_'28'5b'5cw'5f'40'2e'25'2a'3f'2b'2d'5d'7c'5c'5c_'29'2a = compileRegex True "([\\w_@.%*?+-]|\\\\ )*"
regex_'5c'5c'24 = compileRegex True "\\\\$"
regex_'28'5b'7c'26'3b'5d'29'5c1'3f = compileRegex True "([|&;])\\1?"
regex_'2d'3f'2d'5ba'2dz'5d'5bA'2dZa'2dz0'2d9'5f'2d'5d'2a = compileRegex True "-?-[a-z][A-Za-z0-9_-]*"
regex_'5c'5c'5b'5d'5b'3b'5c'5c'24'60'7b'7d'28'29'7c'26'3c'3e'2a_'5d = compileRegex True "\\\\[][;\\\\$`{}()|&<>* ]"
regex_'5c'7b'28'3f'21'28'5cs'7c'24'29'29'5cS'2a'5c'7d = compileRegex True "\\{(?!(\\s|$))\\S*\\}"
regex_'2f'28'5b'5cw'5f'40'2e'25'2a'3f'2b'2d'5d'7c'5c'5c_'29'2a'28'3f'3d'28'5b'5cs'2f'29'3a'3b'24'60'27'22'5d'7c'24'29'29 = compileRegex True "/([\\w_@.%*?+-]|\\\\ )*(?=([\\s/):;$`'\"]|$))"
regex_'5c'24'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'5c'5b = compileRegex True "\\$[A-Za-z_][A-Za-z0-9_]*\\["
regex_'5c'24'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a = compileRegex True "\\$[A-Za-z_][A-Za-z0-9_]*"
regex_'5c'24'5b'2a'40'23'3f'24'21'5f0'2d9'2d'5d = compileRegex True "\\$[*@#?$!_0-9-]"
regex_'5c'24'5c'7b'5b'2a'40'23'3f'24'21'5f0'2d9'2d'5d'5c'7d = compileRegex True "\\$\\{[*@#?$!_0-9-]\\}"
regex_'5c'24'5c'7b'23'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'28'5c'5b'5b'2a'40'5d'5c'5d'29'3f'5c'7d = compileRegex True "\\$\\{#[A-Za-z_][A-Za-z0-9_]*(\\[[*@]\\])?\\}"
regex_'5c'24'5c'7b'21'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'28'5c'5b'5b'2a'40'5d'5c'5d'7c'5b'2a'40'5d'29'3f'5c'7d = compileRegex True "\\$\\{![A-Za-z_][A-Za-z0-9_]*(\\[[*@]\\]|[*@])?\\}"
regex_'5c'24'5c'7b'23'5b0'2d9'5d'2b'5c'7d = compileRegex True "\\$\\{#[0-9]+\\}"
regex_'5c'24'5c'7b'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a = compileRegex True "\\$\\{[A-Za-z_][A-Za-z0-9_]*"
regex_'5c'24'5c'7b'5b'2a'40'23'3f'24'21'5f0'2d9'2d'5d'28'3f'3d'5b'3a'23'25'2f'3d'3f'2b'2d'5d'29 = compileRegex True "\\$\\{[*@#?$!_0-9-](?=[:#%/=?+-])"
regex_'5c'5c'5b'60'24'5c'5c'5d = compileRegex True "\\\\[`$\\\\]"
regex_'2d'5babcdefghkprstuwxOGLSNozn'5d'28'3f'3d'5cs'29 = compileRegex True "-[abcdefghkprstuwxOGLSNozn](?=\\s)"
regex_'2d'28'5bno'5dt'7cef'29'28'3f'3d'5cs'29 = compileRegex True "-([no]t|ef)(?=\\s)"
regex_'28'5b'21'3d'5d'3d'3f'7c'5b'3e'3c'5d'29'28'3f'3d'5cs'29 = compileRegex True "([!=]=?|[><])(?=\\s)"
regex_'2d'28eq'7cne'7c'5bgl'5d'5bte'5d'29'28'3f'3d'5cs'29 = compileRegex True "-(eq|ne|[gl][te])(?=\\s)"
regex_'5cs'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 = compileRegex True "\\s\\](?=($|[\\s;|&]))"
regex_'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 = compileRegex True "\\](?=($|[\\s;|&]))"
regex_'5cs'5c'5d'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 = compileRegex True "\\s\\]\\](?=($|[\\s;|&]))"
regex_'5c'5d'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 = compileRegex True "\\]\\](?=($|[\\s;|&]))"
regex_'5b'5cw'3a'2c'2b'5f'2e'2f'2d'5d = compileRegex True "[\\w:,+_./-]"
regex_'5cs'2b'5bA'2dZa'2dz'5f'3a'5d'5bA'2dZa'2dz0'2d9'5f'3a'23'25'40'2d'5d'2a'28'5cs'2a'5c'28'5c'29'29'3f = compileRegex True "\\s+[A-Za-z_:][A-Za-z0-9_:#%@-]*(\\s*\\(\\))?"
regex_'2d'5bA'2dZa'2dz0'2d9'5d'2b = compileRegex True "-[A-Za-z0-9]+"
regex_'2d'2d'5ba'2dz'5d'5bA'2dZa'2dz0'2d9'5f'2d'5d'2a = compileRegex True "--[a-z][A-Za-z0-9_-]*"
regex_'5cb'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a = compileRegex True "\\b[A-Za-z_][A-Za-z0-9_]*"
regex_'5b'5e'5d'7d'29'7c'3b'60'26'3e'3c'5d = compileRegex True "[^]})|;`&><]"
regex_'5c'5c'5b'60'22'5c'5c'24'5cn'5d = compileRegex True "\\\\[`\"\\\\$\\n]"
regex_'5c'5c'5babefnrtv'5c'5c'27'5d = compileRegex True "\\\\[abefnrtv\\\\']"
regex_'5c'5c'28'5b0'2d7'5d'7b1'2c3'7d'7cx'5bA'2dFa'2df0'2d9'5d'7b1'2c2'7d'7cc'2e'29 = compileRegex True "\\\\([0-7]{1,3}|x[A-Fa-f0-9]{1,2}|c.)"
regex_'28'3a'3f'5b'2d'3d'3f'2b'5d'7c'23'23'3f'7c'25'25'3f'29 = compileRegex True "(:?[-=?+]|##?|%%?)"
regex_'2f'2f'3f = compileRegex True "//?"
regex_'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a = compileRegex True "[A-Za-z_][A-Za-z0-9_]*"
regex_'5b0'2d9'5d'2b'28'3f'3d'5b'3a'7d'5d'29 = compileRegex True "[0-9]+(?=[:}])"
regex_'5b0'2d9'5d'28'3f'3d'5b'3a'7d'5d'29 = compileRegex True "[0-9](?=[:}])"
regex_'5csin'5cb = compileRegex True "\\sin\\b"
regex_'5cbesac'28'3f'3d'24'7c'5b'5cs'3b'29'5d'29 = compileRegex True "\\besac(?=$|[\\s;)])"
regex_esac'28'3f'3d'24'7c'5b'5cs'3b'29'5d'29 = compileRegex True "esac(?=$|[\\s;)])"
regex_'28'3c'3c'2d'5cs'2a'22'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'22'29 = compileRegex True "(<<-\\s*\"([^|&;()<>\\s]+)\")"
regex_'28'3c'3c'2d'5cs'2a'27'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'27'29 = compileRegex True "(<<-\\s*'([^|&;()<>\\s]+)')"
regex_'28'3c'3c'2d'5cs'2a'5c'5c'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29 = compileRegex True "(<<-\\s*\\\\([^|&;()<>\\s]+))"
regex_'28'3c'3c'2d'5cs'2a'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29 = compileRegex True "(<<-\\s*([^|&;()<>\\s]+))"
regex_'28'3c'3c'5cs'2a'22'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'22'29 = compileRegex True "(<<\\s*\"([^|&;()<>\\s]+)\")"
regex_'28'3c'3c'5cs'2a'27'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'27'29 = compileRegex True "(<<\\s*'([^|&;()<>\\s]+)')"
regex_'28'3c'3c'5cs'2a'5c'5c'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29 = compileRegex True "(<<\\s*\\\\([^|&;()<>\\s]+))"
regex_'28'3c'3c'5cs'2a'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29 = compileRegex True "(<<\\s*([^|&;()<>\\s]+))"

parseRules ("Bash","Start") =
  (((parseRules ("Bash","FindAll")))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","Start")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","FindAll") =
  (((parseRules ("Bash","FindComments")))
   <|>
   ((parseRules ("Bash","FindCommands")))
   <|>
   ((parseRules ("Bash","FindStrings")))
   <|>
   ((parseRules ("Bash","FindSubstitutions")))
   <|>
   ((parseRules ("Bash","FindOthers")))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","FindAll")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","FindMost") =
  (((parseRules ("Bash","FindComments")))
   <|>
   ((parseRules ("Bash","FindStrings")))
   <|>
   ((parseRules ("Bash","FindSubstitutions")))
   <|>
   ((parseRules ("Bash","FindOthers")))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","FindMost")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","FindComments") =
  (((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext ("Bash","Comment"))
   <|>
   ((pRegExpr regex_'5b'5cs'3b'5d'28'3f'3d'23'29 >>= withAttribute NormalTok) >>~ pushContext ("Bash","Comment"))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","FindComments")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","Comment") =
  (((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((Text.Highlighting.Kate.Syntax.Modelines.parseExpression (Just ("Modelines","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","Comment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Bash","FindCommentsParen") =
  (((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext ("Bash","CommentParen"))
   <|>
   ((pRegExpr regex_'5b'5cs'3b'5d'28'3f'3d'23'29 >>= withAttribute NormalTok) >>~ pushContext ("Bash","CommentParen"))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","FindCommentsParen")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","CommentParen") =
  (((pRegExpr regex_'5b'5e'29'5d'28'3f'3d'5c'29'29 >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","CommentParen")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Bash","FindCommentsBackq") =
  (((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext ("Bash","CommentBackq"))
   <|>
   ((pRegExpr regex_'5b'5cs'3b'5d'28'3f'3d'23'29 >>= withAttribute NormalTok) >>~ pushContext ("Bash","CommentBackq"))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","FindCommentsBackq")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","CommentBackq") =
  (((pRegExpr regex_'5b'5e'60'5d'28'3f'3d'60'29 >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","CommentBackq")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Bash","FindCommands") =
  (((parseRules ("Bash","FindSpecialCommands")))
   <|>
   ((parseRules ("Bash","FindNormalCommands")))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","FindCommands")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","FindSpecialCommands") =
  (((pDetect2Chars False '(' '(' >>= withAttribute KeywordTok) >>~ pushContext ("Bash","ExprDblParen"))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5c'5b'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 >>= withAttribute KeywordTok) >>~ pushContext ("Bash","ExprDblBracket"))
   <|>
   ((pRegExpr regex_'5cs'5c'5b'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 >>= withAttribute KeywordTok) >>~ pushContext ("Bash","ExprDblBracket"))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 >>= withAttribute BuiltInTok) >>~ pushContext ("Bash","ExprBracket"))
   <|>
   ((pRegExpr regex_'5cs'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 >>= withAttribute BuiltInTok) >>~ pushContext ("Bash","ExprBracket"))
   <|>
   ((pRegExpr regex_'5c'7b'28'3f'3d'28'24'7c'5cs'29'29 >>= withAttribute KeywordTok) >>~ pushContext ("Bash","Group"))
   <|>
   ((pDetectChar False '(' >>= withAttribute KeywordTok) >>~ pushContext ("Bash","SubShell"))
   <|>
   ((pRegExpr regex_'5cbdo'28'3f'21'5b'5cw'24'2b'2d'5d'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbdone'28'3f'21'5b'5cw'24'2b'2d'5d'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbif'28'3f'3d'28'24'7c'5cs'29'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbfi'28'3f'21'5b'5cw'24'2b'2d'5d'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbcase'28'3f'21'5b'5cw'24'2b'2d'5d'29 >>= withAttribute KeywordTok) >>~ pushContext ("Bash","Case"))
   <|>
   ((pRegExpr regex_'5cb'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'5c'2b'3f'3d >>= withAttribute VariableTok) >>~ pushContext ("Bash","Assign"))
   <|>
   ((pRegExpr regex_'5cb'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'28'3f'3d'5c'5b'2e'2b'5c'5d'5c'2b'3f'3d'29 >>= withAttribute VariableTok) >>~ pushContext ("Bash","AssignSubscr"))
   <|>
   ((pString False ":()" >>= withAttribute FunctionTok))
   <|>
   ((pRegExpr regex_'5cbfunction'5cb >>= withAttribute KeywordTok) >>~ pushContext ("Bash","FunctionDef"))
   <|>
   ((pRegExpr regex_'5bA'2dZa'2dz'5f'3a'5d'5bA'2dZa'2dz0'2d9'5f'3a'23'25'40'2d'5d'2a'5cs'2a'5c'28'5c'29 >>= withAttribute FunctionTok))
   <|>
   ((pKeyword " \n\t()!+,<=>&*;?|~\\`" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5c'2e'28'3f'3d'5cs'29 >>= withAttribute BuiltInTok))
   <|>
   ((pKeyword " \n\t()!+,<=>&*;?|~\\`" list_builtins'5fvar >>= withAttribute BuiltInTok) >>~ pushContext ("Bash","VarName"))
   <|>
   ((pRegExpr regex_'5cd'2a'3c'3c'3c >>= withAttribute OperatorTok))
   <|>
   ((lookAhead (pString False "<<") >> pushContext ("Bash","HereDoc") >> currentContext >>= parseRules))
   <|>
   ((pRegExpr regex_'5b'3c'3e'5d'5c'28 >>= withAttribute OperatorTok) >>~ pushContext ("Bash","ProcessSubst"))
   <|>
   ((pRegExpr regex_'28'5b0'2d9'5d'2a'28'3e'7b1'2c2'7d'7c'3c'29'28'26'5b0'2d9'5d'2b'2d'3f'29'3f'7c'26'3e'7c'3e'26'7c'5b0'2d9'5d'2a'3c'3e'29 >>= withAttribute OperatorTok))
   <|>
   ((pRegExpr regex_'28'5b'7c'26'5d'29'5c1'3f >>= withAttribute KeywordTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","FindSpecialCommands")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","FindNormalCommands") =
  (((pKeyword " \n\t()!+,<=>&*;?|~\\`" list_builtins >>= withAttribute BuiltInTok) >>~ pushContext ("Bash","CommandArgs"))
   <|>
   ((pKeyword " \n\t()!+,<=>&*;?|~\\`" list_unixcommands >>= withAttribute FunctionTok) >>~ pushContext ("Bash","CommandArgs"))
   <|>
   ((pRegExpr regex_'28'5b'5cw'5f'40'2e'25'2a'3f'2b'2d'5d'7c'5c'5c_'29'2a'28'3f'3d'2f'29 >>= withAttribute ExtensionTok))
   <|>
   ((pRegExpr regex_'7e'5cw'2a >>= withAttribute ExtensionTok))
   <|>
   ((pRegExpr regex_'2f'28'5b'5cw'5f'40'2e'25'2a'3f'2b'2d'5d'7c'5c'5c_'29'2a'28'3f'3d'28'5b'2f'29'3b'24'60'27'22'5d'7c'24'29'29 >>= withAttribute ExtensionTok))
   <|>
   ((pRegExpr regex_'2f'28'5b'5cw'5f'40'2e'25'2a'3f'2b'2d'5d'7c'5c'5c_'29'2a'28'3f'3d'28'5b'5cs'29'3b'24'60'27'22'5d'7c'24'29'29 >>= withAttribute ExtensionTok) >>~ pushContext ("Bash","CommandArgs"))
   <|>
   ((pRegExpr regex_'28'5b'5cw'5f'40'2e'25'2a'3f'2b'2d'5d'7c'5c'5c_'29'2a >>= withAttribute ExtensionTok) >>~ pushContext ("Bash","CommandArgs"))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","FindNormalCommands")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","CommandArgs") =
  (((pLineContinue >>= withAttribute NormalTok))
   <|>
   ((parseRules ("Bash","FindMost")))
   <|>
   ((pRegExpr regex_'5c'5c'24 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5c'2e'28'3f'3d'5cs'29 >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5cd'2a'3c'3c'3c >>= withAttribute OperatorTok))
   <|>
   ((lookAhead (pString False "<<") >> pushContext ("Bash","HereDoc") >> currentContext >>= parseRules))
   <|>
   ((pRegExpr regex_'5b'3c'3e'5d'5c'28 >>= withAttribute OperatorTok) >>~ pushContext ("Bash","ProcessSubst"))
   <|>
   ((pRegExpr regex_'28'5b0'2d9'5d'2a'28'3e'7b1'2c2'7d'7c'3c'29'28'26'5b0'2d9'5d'2b'2d'3f'29'3f'7c'26'3e'7c'3e'26'7c'5b0'2d9'5d'2a'3c'3e'29 >>= withAttribute OperatorTok))
   <|>
   ((pRegExpr regex_'28'5b'7c'26'3b'5d'29'5c1'3f >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'2d'3f'2d'5ba'2dz'5d'5bA'2dZa'2dz0'2d9'5f'2d'5d'2a >>= withAttribute NormalTok))
   <|>
   ((pKeyword " \n\t()!+,<=>&*;?|~\\`" list_keywords >>= withAttribute NormalTok))
   <|>
   ((lookAhead (pAnyChar ")}") >> (popContext) >> currentContext >>= parseRules))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","CommandArgs")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","FindCommandsBackq") =
  (((parseRules ("Bash","FindSpecialCommands")))
   <|>
   ((parseRules ("Bash","FindNormalCommandsBackq")))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","FindCommandsBackq")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","FindNormalCommandsBackq") =
  (((pKeyword " \n\t()!+,<=>&*;?|~\\`" list_builtins >>= withAttribute BuiltInTok) >>~ pushContext ("Bash","CommandArgsBackq"))
   <|>
   ((pKeyword " \n\t()!+,<=>&*;?|~\\`" list_unixcommands >>= withAttribute FunctionTok) >>~ pushContext ("Bash","CommandArgsBackq"))
   <|>
   ((pRegExpr regex_'28'5b'5cw'5f'40'2e'25'2a'3f'2b'2d'5d'7c'5c'5c_'29'2a'28'3f'3d'2f'29 >>= withAttribute ExtensionTok))
   <|>
   ((pRegExpr regex_'7e'5cw'2a >>= withAttribute ExtensionTok))
   <|>
   ((pRegExpr regex_'2f'28'5b'5cw'5f'40'2e'25'2a'3f'2b'2d'5d'7c'5c'5c_'29'2a'28'3f'3d'28'5b'2f'29'3b'24'60'27'22'5d'7c'24'29'29 >>= withAttribute ExtensionTok))
   <|>
   ((pRegExpr regex_'2f'28'5b'5cw'5f'40'2e'25'2a'3f'2b'2d'5d'7c'5c'5c_'29'2a'28'3f'3d'28'5b'5cs'29'3b'24'60'27'22'5d'7c'24'29'29 >>= withAttribute ExtensionTok) >>~ pushContext ("Bash","CommandArgsBackq"))
   <|>
   ((pRegExpr regex_'28'5b'5cw'5f'40'2e'25'2a'3f'2b'2d'5d'7c'5c'5c_'29'2a >>= withAttribute ExtensionTok) >>~ pushContext ("Bash","CommandArgsBackq"))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","FindNormalCommandsBackq")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","CommandArgsBackq") =
  (((pLineContinue >>= withAttribute NormalTok))
   <|>
   ((lookAhead (pDetectChar False '`') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((parseRules ("Bash","CommandArgs")))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","CommandArgsBackq")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","FindOthers") =
  (((pRegExpr regex_'5c'5c'5b'5d'5b'3b'5c'5c'24'60'7b'7d'28'29'7c'26'3c'3e'2a_'5d >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'5c'5c'24 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5c'7b'28'3f'21'28'5cs'7c'24'29'29'5cS'2a'5c'7d >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'28'5b'5cw'5f'40'2e'25'2a'3f'2b'2d'5d'7c'5c'5c_'29'2a'28'3f'3d'2f'29 >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'7e'5cw'2a >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'2f'28'5b'5cw'5f'40'2e'25'2a'3f'2b'2d'5d'7c'5c'5c_'29'2a'28'3f'3d'28'5b'5cs'2f'29'3a'3b'24'60'27'22'5d'7c'24'29'29 >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","FindOthers")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","FindStrings") =
  (((pDetect2Chars False '\\' '\'' >>= withAttribute DataTypeTok))
   <|>
   ((pDetect2Chars False '\\' '"' >>= withAttribute DataTypeTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext ("Bash","StringSQ"))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("Bash","StringDQ"))
   <|>
   ((pDetect2Chars False '$' '\'' >>= withAttribute StringTok) >>~ pushContext ("Bash","StringEsc"))
   <|>
   ((pDetect2Chars False '$' '"' >>= withAttribute StringTok) >>~ pushContext ("Bash","StringDQ"))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","FindStrings")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","FindSubstitutions") =
  (((pRegExpr regex_'5c'24'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'5c'5b >>= withAttribute VariableTok) >>~ pushContext ("Bash","Subscript"))
   <|>
   ((pRegExpr regex_'5c'24'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a >>= withAttribute VariableTok))
   <|>
   ((pRegExpr regex_'5c'24'5b'2a'40'23'3f'24'21'5f0'2d9'2d'5d >>= withAttribute VariableTok))
   <|>
   ((pRegExpr regex_'5c'24'5c'7b'5b'2a'40'23'3f'24'21'5f0'2d9'2d'5d'5c'7d >>= withAttribute VariableTok))
   <|>
   ((pRegExpr regex_'5c'24'5c'7b'23'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'28'5c'5b'5b'2a'40'5d'5c'5d'29'3f'5c'7d >>= withAttribute VariableTok))
   <|>
   ((pRegExpr regex_'5c'24'5c'7b'21'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'28'5c'5b'5b'2a'40'5d'5c'5d'7c'5b'2a'40'5d'29'3f'5c'7d >>= withAttribute VariableTok))
   <|>
   ((pRegExpr regex_'5c'24'5c'7b'23'5b0'2d9'5d'2b'5c'7d >>= withAttribute VariableTok))
   <|>
   ((pRegExpr regex_'5c'24'5c'7b'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a >>= withAttribute VariableTok) >>~ pushContext ("Bash","VarBrace"))
   <|>
   ((pRegExpr regex_'5c'24'5c'7b'5b'2a'40'23'3f'24'21'5f0'2d9'2d'5d'28'3f'3d'5b'3a'23'25'2f'3d'3f'2b'2d'5d'29 >>= withAttribute VariableTok) >>~ pushContext ("Bash","VarBrace"))
   <|>
   ((pString False "$((" >>= withAttribute VariableTok) >>~ pushContext ("Bash","ExprDblParenSubst"))
   <|>
   ((pString False "$(<" >>= withAttribute OperatorTok) >>~ pushContext ("Bash","SubstFile"))
   <|>
   ((pString False "$(" >>= withAttribute VariableTok) >>~ pushContext ("Bash","SubstCommand"))
   <|>
   ((pDetectChar False '`' >>= withAttribute KeywordTok) >>~ pushContext ("Bash","SubstBackq"))
   <|>
   ((pRegExpr regex_'5c'5c'5b'60'24'5c'5c'5d >>= withAttribute DataTypeTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","FindSubstitutions")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","FindTests") =
  (((pRegExpr regex_'2d'5babcdefghkprstuwxOGLSNozn'5d'28'3f'3d'5cs'29 >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'2d'28'5bno'5dt'7cef'29'28'3f'3d'5cs'29 >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'28'5b'21'3d'5d'3d'3f'7c'5b'3e'3c'5d'29'28'3f'3d'5cs'29 >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'2d'28eq'7cne'7c'5bgl'5d'5bte'5d'29'28'3f'3d'5cs'29 >>= withAttribute OtherTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","FindTests")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","ExprDblParen") =
  (((pDetect2Chars False ')' ')' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext ("Bash","ExprSubParen"))
   <|>
   ((parseRules ("Bash","FindMost")))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","ExprDblParen")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","ExprDblParenSubst") =
  (((pDetect2Chars False ')' ')' >>= withAttribute VariableTok) >>~ (popContext))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext ("Bash","ExprSubParen"))
   <|>
   ((parseRules ("Bash","FindMost")))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","ExprDblParenSubst")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","ExprSubParen") =
  (((pDetectChar False ')' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext ("Bash","ExprSubParen"))
   <|>
   ((parseRules ("Bash","FindMost")))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","ExprSubParen")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","ExprBracket") =
  (((pRegExpr regex_'5cs'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 >>= withAttribute BuiltInTok) >>~ (popContext))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 >>= withAttribute BuiltInTok) >>~ (popContext))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext ("Bash","ExprSubParen"))
   <|>
   ((parseRules ("Bash","FindTests")))
   <|>
   ((parseRules ("Bash","FindMost")))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","ExprBracket")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","ExprDblBracket") =
  (((pRegExpr regex_'5cs'5c'5d'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5c'5d'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext ("Bash","ExprSubParen"))
   <|>
   ((parseRules ("Bash","FindTests")))
   <|>
   ((parseRules ("Bash","FindMost")))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","ExprDblBracket")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","Group") =
  (((pDetectChar False '}' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((parseRules ("Bash","FindAll")))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","Group")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","SubShell") =
  (((pDetectChar False ')' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((parseRules ("Bash","FindAll")))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","SubShell")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","Assign") =
  (((pDetectChar False '(' >>= withAttribute VariableTok) >>~ pushContext ("Bash","AssignArray"))
   <|>
   ((parseRules ("Bash","FindStrings")))
   <|>
   ((parseRules ("Bash","FindSubstitutions")))
   <|>
   ((parseRules ("Bash","FindOthers")))
   <|>
   ((pRegExpr regex_'5b'5cw'3a'2c'2b'5f'2e'2f'2d'5d >>= withAttribute NormalTok))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("Bash","AssignArray") =
  (((pDetectChar False ')' >>= withAttribute VariableTok) >>~ (popContext))
   <|>
   ((pDetectChar False '[' >>= withAttribute VariableTok) >>~ pushContext ("Bash","Subscript"))
   <|>
   ((pDetectChar False '=' >>= withAttribute VariableTok) >>~ pushContext ("Bash","Assign"))
   <|>
   ((parseRules ("Bash","FindMost")))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","AssignArray")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","AssignSubscr") =
  (((pDetectChar False '[' >>= withAttribute VariableTok) >>~ pushContext ("Bash","Subscript"))
   <|>
   ((pDetect2Chars False '+' '=' >>= withAttribute VariableTok) >>~ pushContext ("Bash","Assign"))
   <|>
   ((pDetectChar False '=' >>= withAttribute VariableTok) >>~ pushContext ("Bash","Assign"))
   <|>
   ((parseRules ("Bash","FindStrings")))
   <|>
   ((parseRules ("Bash","FindSubstitutions")))
   <|>
   ((parseRules ("Bash","FindOthers")))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("Bash","Subscript") =
  (((pDetectChar False ']' >>= withAttribute VariableTok) >>~ (popContext))
   <|>
   ((parseRules ("Bash","FindStrings")))
   <|>
   ((parseRules ("Bash","FindSubstitutions")))
   <|>
   ((parseRules ("Bash","FindOthers")))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","Subscript")) >> pDefault >>= withAttribute VariableTok))

parseRules ("Bash","FunctionDef") =
  (((pRegExpr regex_'5cs'2b'5bA'2dZa'2dz'5f'3a'5d'5bA'2dZa'2dz0'2d9'5f'3a'23'25'40'2d'5d'2a'28'5cs'2a'5c'28'5c'29'29'3f >>= withAttribute FunctionTok) >>~ (popContext))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("Bash","VarName") =
  (((pRegExpr regex_'2d'5bA'2dZa'2dz0'2d9'5d'2b >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'2d'2d'5ba'2dz'5d'5bA'2dZa'2dz0'2d9'5f'2d'5d'2a >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5cb'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a >>= withAttribute VariableTok))
   <|>
   ((pDetectChar False '[' >>= withAttribute VariableTok) >>~ pushContext ("Bash","Subscript"))
   <|>
   ((pDetectChar False '=' >>= withAttribute VariableTok) >>~ pushContext ("Bash","Assign"))
   <|>
   ((parseRules ("Bash","FindMost")))
   <|>
   ((pRegExpr regex_'5b'5e'5d'7d'29'7c'3b'60'26'3e'3c'5d >>= withAttribute NormalTok))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("Bash","ProcessSubst") =
  (((pDetectChar False ')' >>= withAttribute OperatorTok) >>~ (popContext))
   <|>
   ((parseRules ("Bash","FindCommentsParen")))
   <|>
   ((parseRules ("Bash","FindCommands")))
   <|>
   ((parseRules ("Bash","FindStrings")))
   <|>
   ((parseRules ("Bash","FindSubstitutions")))
   <|>
   ((parseRules ("Bash","FindOthers")))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","ProcessSubst")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","StringSQ") =
  (((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","StringSQ")) >> pDefault >>= withAttribute StringTok))

parseRules ("Bash","StringDQ") =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5c'5c'5b'60'22'5c'5c'24'5cn'5d >>= withAttribute DataTypeTok))
   <|>
   ((parseRules ("Bash","FindSubstitutions")))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","StringDQ")) >> pDefault >>= withAttribute StringTok))

parseRules ("Bash","StringEsc") =
  (((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5c'5c'5babefnrtv'5c'5c'27'5d >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'5c'5c'28'5b0'2d7'5d'7b1'2c3'7d'7cx'5bA'2dFa'2df0'2d9'5d'7b1'2c2'7d'7cc'2e'29 >>= withAttribute DataTypeTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","StringEsc")) >> pDefault >>= withAttribute StringTok))

parseRules ("Bash","VarBrace") =
  (((pDetectChar False '}' >>= withAttribute VariableTok) >>~ (popContext))
   <|>
   ((pDetectChar False '[' >>= withAttribute VariableTok) >>~ pushContext ("Bash","Subscript"))
   <|>
   ((pRegExpr regex_'28'3a'3f'5b'2d'3d'3f'2b'5d'7c'23'23'3f'7c'25'25'3f'29 >>= withAttribute VariableTok) >>~ pushContext ("Bash","VarAlt"))
   <|>
   ((pRegExpr regex_'2f'2f'3f >>= withAttribute VariableTok) >>~ pushContext ("Bash","VarSubst"))
   <|>
   ((pDetectChar False ':' >>= withAttribute VariableTok) >>~ pushContext ("Bash","VarSub"))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","VarBrace")) >> pDefault >>= withAttribute ErrorTok))

parseRules ("Bash","VarAlt") =
  (((pDetectChar False '}' >>= withAttribute VariableTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules ("Bash","FindStrings")))
   <|>
   ((parseRules ("Bash","FindSubstitutions")))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","VarAlt")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","VarSubst") =
  (((pDetectChar False '}' >>= withAttribute VariableTok) >>~ (popContext >> popContext))
   <|>
   ((pDetectChar False '/' >>= withAttribute VariableTok) >>~ pushContext ("Bash","VarSubst2"))
   <|>
   ((parseRules ("Bash","FindStrings")))
   <|>
   ((parseRules ("Bash","FindSubstitutions")))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","VarSubst")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","VarSubst2") =
  (((pDetectChar False '}' >>= withAttribute VariableTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((parseRules ("Bash","FindStrings")))
   <|>
   ((parseRules ("Bash","FindSubstitutions")))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","VarSubst2")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","VarSub") =
  (((pDetectChar False ':' >>= withAttribute VariableTok) >>~ pushContext ("Bash","VarSub2"))
   <|>
   ((pDetectChar False '}' >>= withAttribute VariableTok) >>~ (popContext >> popContext))
   <|>
   ((pRegExpr regex_'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a >>= withAttribute VariableTok))
   <|>
   ((pRegExpr regex_'5b0'2d9'5d'2b'28'3f'3d'5b'3a'7d'5d'29 >>= withAttribute VariableTok))
   <|>
   ((parseRules ("Bash","FindSubstitutions")))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","VarSub")) >> pDefault >>= withAttribute ErrorTok))

parseRules ("Bash","VarSub2") =
  (((pDetectChar False '}' >>= withAttribute VariableTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((pRegExpr regex_'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a >>= withAttribute VariableTok))
   <|>
   ((pRegExpr regex_'5b0'2d9'5d'28'3f'3d'5b'3a'7d'5d'29 >>= withAttribute VariableTok))
   <|>
   ((parseRules ("Bash","FindSubstitutions")))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","VarSub2")) >> pDefault >>= withAttribute ErrorTok))

parseRules ("Bash","SubstFile") =
  (((pDetectChar False ')' >>= withAttribute OperatorTok) >>~ (popContext))
   <|>
   ((parseRules ("Bash","FindCommentsParen")))
   <|>
   ((parseRules ("Bash","FindStrings")))
   <|>
   ((parseRules ("Bash","FindSubstitutions")))
   <|>
   ((parseRules ("Bash","FindOthers")))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","SubstFile")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","SubstCommand") =
  (((pDetectChar False ')' >>= withAttribute VariableTok) >>~ (popContext))
   <|>
   ((parseRules ("Bash","FindCommentsParen")))
   <|>
   ((parseRules ("Bash","FindCommands")))
   <|>
   ((parseRules ("Bash","FindStrings")))
   <|>
   ((parseRules ("Bash","FindSubstitutions")))
   <|>
   ((parseRules ("Bash","FindOthers")))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","SubstCommand")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","SubstBackq") =
  (((pDetectChar False '`' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((parseRules ("Bash","FindCommentsBackq")))
   <|>
   ((parseRules ("Bash","FindCommandsBackq")))
   <|>
   ((parseRules ("Bash","FindStrings")))
   <|>
   ((parseRules ("Bash","FindSubstitutions")))
   <|>
   ((parseRules ("Bash","FindOthers")))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","SubstBackq")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","Case") =
  (((pRegExpr regex_'5csin'5cb >>= withAttribute KeywordTok) >>~ pushContext ("Bash","CaseIn"))
   <|>
   ((parseRules ("Bash","FindMost")))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","Case")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","CaseIn") =
  (((pRegExpr regex_'5cbesac'28'3f'3d'24'7c'5b'5cs'3b'29'5d'29 >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((pDetectChar False ')' >>= withAttribute KeywordTok) >>~ pushContext ("Bash","CaseExpr"))
   <|>
   ((pAnyChar "(|" >>= withAttribute KeywordTok))
   <|>
   ((parseRules ("Bash","FindMost")))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","CaseIn")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","CaseExpr") =
  (((pDetect2Chars False ';' ';' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pFirstNonSpace >> lookAhead (pRegExpr regex_esac'28'3f'3d'24'7c'5b'5cs'3b'29'5d'29) >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((parseRules ("Bash","FindAll")))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","CaseExpr")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","HereDoc") =
  (((lookAhead (pRegExpr regex_'28'3c'3c'2d'5cs'2a'22'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'22'29) >> pushContext ("Bash","HereDocIQ") >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExpr regex_'28'3c'3c'2d'5cs'2a'27'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'27'29) >> pushContext ("Bash","HereDocIQ") >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExpr regex_'28'3c'3c'2d'5cs'2a'5c'5c'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29) >> pushContext ("Bash","HereDocIQ") >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExpr regex_'28'3c'3c'2d'5cs'2a'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29) >> pushContext ("Bash","HereDocINQ") >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExpr regex_'28'3c'3c'5cs'2a'22'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'22'29) >> pushContext ("Bash","HereDocQ") >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExpr regex_'28'3c'3c'5cs'2a'27'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'27'29) >> pushContext ("Bash","HereDocQ") >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExpr regex_'28'3c'3c'5cs'2a'5c'5c'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29) >> pushContext ("Bash","HereDocQ") >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExpr regex_'28'3c'3c'5cs'2a'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29) >> pushContext ("Bash","HereDocNQ") >> currentContext >>= parseRules))
   <|>
   ((pString False "<<" >>= withAttribute OperatorTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","HereDoc")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","HereDocRemainder") =
  (((parseRules ("Bash","FindAll")))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","HereDocRemainder")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","HereDocQ") =
  (((pRegExprDynamic "%1" >>= withAttribute OperatorTok) >>~ pushContext ("Bash","HereDocRemainder"))
   <|>
   ((pColumn 0 >> pRegExprDynamic "%2\\b" >>= withAttribute OperatorTok) >>~ (popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","HereDocQ")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","HereDocNQ") =
  (((pRegExprDynamic "%1" >>= withAttribute OperatorTok) >>~ pushContext ("Bash","HereDocRemainder"))
   <|>
   ((pColumn 0 >> pRegExprDynamic "%2\\b" >>= withAttribute OperatorTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules ("Bash","FindSubstitutions")))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","HereDocNQ")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","HereDocIQ") =
  (((pRegExprDynamic "%1" >>= withAttribute OperatorTok) >>~ pushContext ("Bash","HereDocRemainder"))
   <|>
   ((pColumn 0 >> pRegExprDynamic "\\t*%2\\b" >>= withAttribute OperatorTok) >>~ (popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","HereDocIQ")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Bash","HereDocINQ") =
  (((pRegExprDynamic "%1" >>= withAttribute OperatorTok) >>~ pushContext ("Bash","HereDocRemainder"))
   <|>
   ((pColumn 0 >> pRegExprDynamic "\\t*%2\\b" >>= withAttribute OperatorTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules ("Bash","FindSubstitutions")))
   <|>
   (currentContext >>= \x -> guard (x == ("Bash","HereDocINQ")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Alerts", _) = Text.Highlighting.Kate.Syntax.Alert.parseExpression Nothing
parseRules ("Modelines", _) = Text.Highlighting.Kate.Syntax.Modelines.parseExpression Nothing

parseRules x = parseRules ("Bash","Start") <|> fail ("Unknown context" ++ show x)
