/**
 * Author......: See docs/credits.txt
 * License.....: MIT
 */

//#define NEW_SIMD_CODE

#include "inc_vendor.cl"
#include "inc_hash_constants.h"
#include "inc_hash_functions.cl"
#include "inc_types.cl"
#include "inc_common.cl"
#include "inc_rp.h"
#include "inc_rp.cl"
#include "inc_scalar.cl"
#include "inc_hash_sha512.cl"

__kernel void m01760_mxx (KERN_ATTR_RULES ())
{
  /**
   * modifier
   */

  const u64 lid = get_local_id (0);
  const u64 gid = get_global_id (0);

  if (gid >= gid_max) return;

  /**
   * base
   */

  COPY_PW (pws[gid]);

  const u32 salt_len = salt_bufs[salt_pos].salt_len;

  u32 s[64] = { 0 };

  for (int i = 0, idx = 0; i < salt_len; i += 4, idx += 1)
  {
    s[idx] = swap32_S (salt_bufs[salt_pos].salt_buf[idx]);
  }

  sha512_hmac_ctx_t ctx0;

  sha512_hmac_init (&ctx0, s, salt_len);

  /**
   * loop
   */

  for (u32 il_pos = 0; il_pos < il_cnt; il_pos++)
  {
    pw_t tmp = PASTE_PW;

    tmp.pw_len = apply_rules (rules_buf[il_pos].cmds, tmp.i, tmp.pw_len);

    sha512_hmac_ctx_t ctx = ctx0;

    sha512_hmac_update_swap (&ctx, tmp.i, tmp.pw_len);

    sha512_hmac_final (&ctx);

    const u32 r0 = l32_from_64_S (ctx.opad.h[7]);
    const u32 r1 = h32_from_64_S (ctx.opad.h[7]);
    const u32 r2 = l32_from_64_S (ctx.opad.h[3]);
    const u32 r3 = h32_from_64_S (ctx.opad.h[3]);

    COMPARE_M_SCALAR (r0, r1, r2, r3);
  }
}

__kernel void m01760_sxx (KERN_ATTR_RULES ())
{
  /**
   * modifier
   */

  const u64 lid = get_local_id (0);
  const u64 gid = get_global_id (0);

  if (gid >= gid_max) return;

  /**
   * digest
   */

  const u32 search[4] =
  {
    digests_buf[digests_offset].digest_buf[DGST_R0],
    digests_buf[digests_offset].digest_buf[DGST_R1],
    digests_buf[digests_offset].digest_buf[DGST_R2],
    digests_buf[digests_offset].digest_buf[DGST_R3]
  };

  /**
   * base
   */

  COPY_PW (pws[gid]);

  const u32 salt_len = salt_bufs[salt_pos].salt_len;

  u32 s[64] = { 0 };

  for (int i = 0, idx = 0; i < salt_len; i += 4, idx += 1)
  {
    s[idx] = swap32_S (salt_bufs[salt_pos].salt_buf[idx]);
  }

  sha512_hmac_ctx_t ctx0;

  sha512_hmac_init (&ctx0, s, salt_len);

  /**
   * loop
   */

  for (u32 il_pos = 0; il_pos < il_cnt; il_pos++)
  {
    pw_t tmp = PASTE_PW;

    tmp.pw_len = apply_rules (rules_buf[il_pos].cmds, tmp.i, tmp.pw_len);

    sha512_hmac_ctx_t ctx = ctx0;

    sha512_hmac_update_swap (&ctx, tmp.i, tmp.pw_len);

    sha512_hmac_final (&ctx);

    const u32 r0 = l32_from_64_S (ctx.opad.h[7]);
    const u32 r1 = h32_from_64_S (ctx.opad.h[7]);
    const u32 r2 = l32_from_64_S (ctx.opad.h[3]);
    const u32 r3 = h32_from_64_S (ctx.opad.h[3]);

    COMPARE_S_SCALAR (r0, r1, r2, r3);
  }
}
