// Code generated by "./generator ./org.freedesktop.login1"; DO NOT EDIT.

// SPDX-FileCopyrightText: 2018 - 2022 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later
package login1

import (
	"fmt"

	"github.com/godbus/dbus"
	"github.com/linuxdeepin/go-lib/dbusutil"
	"github.com/linuxdeepin/go-lib/dbusutil/proxy"
	"github.com/stretchr/testify/mock"
)

type MockManager struct {
	MockInterfaceManager // interface org.freedesktop.login1.Manager
	proxy.MockObject
}

type MockInterfaceManager struct {
	mock.Mock
}

// method GetSession

func (v *MockInterfaceManager) GoGetSession(flags dbus.Flags, ch chan *dbus.Call, sessionId string) *dbus.Call {
	mockArgs := v.Called(flags, ch, sessionId)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) GetSession(flags dbus.Flags, sessionId string) (dbus.ObjectPath, error) {
	mockArgs := v.Called(flags, sessionId)

	ret0, ok := mockArgs.Get(0).(dbus.ObjectPath)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// method GetSessionByPID

func (v *MockInterfaceManager) GoGetSessionByPID(flags dbus.Flags, ch chan *dbus.Call, pid uint32) *dbus.Call {
	mockArgs := v.Called(flags, ch, pid)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) GetSessionByPID(flags dbus.Flags, pid uint32) (dbus.ObjectPath, error) {
	mockArgs := v.Called(flags, pid)

	ret0, ok := mockArgs.Get(0).(dbus.ObjectPath)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// method GetUser

func (v *MockInterfaceManager) GoGetUser(flags dbus.Flags, ch chan *dbus.Call, uid uint32) *dbus.Call {
	mockArgs := v.Called(flags, ch, uid)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) GetUser(flags dbus.Flags, uid uint32) (dbus.ObjectPath, error) {
	mockArgs := v.Called(flags, uid)

	ret0, ok := mockArgs.Get(0).(dbus.ObjectPath)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// method GetUserByPID

func (v *MockInterfaceManager) GoGetUserByPID(flags dbus.Flags, ch chan *dbus.Call, pid uint32) *dbus.Call {
	mockArgs := v.Called(flags, ch, pid)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) GetUserByPID(flags dbus.Flags, pid uint32) (dbus.ObjectPath, error) {
	mockArgs := v.Called(flags, pid)

	ret0, ok := mockArgs.Get(0).(dbus.ObjectPath)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// method GetSeat

func (v *MockInterfaceManager) GoGetSeat(flags dbus.Flags, ch chan *dbus.Call, seatId string) *dbus.Call {
	mockArgs := v.Called(flags, ch, seatId)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) GetSeat(flags dbus.Flags, seatId string) (dbus.ObjectPath, error) {
	mockArgs := v.Called(flags, seatId)

	ret0, ok := mockArgs.Get(0).(dbus.ObjectPath)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// method ListSessions

func (v *MockInterfaceManager) GoListSessions(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) ListSessions(flags dbus.Flags) ([]SessionDetail, error) {
	mockArgs := v.Called(flags)

	ret0, ok := mockArgs.Get(0).([]SessionDetail)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// method ListUsers

func (v *MockInterfaceManager) GoListUsers(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) ListUsers(flags dbus.Flags) ([]UserDetail, error) {
	mockArgs := v.Called(flags)

	ret0, ok := mockArgs.Get(0).([]UserDetail)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// method ListSeats

func (v *MockInterfaceManager) GoListSeats(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) ListSeats(flags dbus.Flags) ([]SeatInfo, error) {
	mockArgs := v.Called(flags)

	ret0, ok := mockArgs.Get(0).([]SeatInfo)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// method ListInhibitors

func (v *MockInterfaceManager) GoListInhibitors(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) ListInhibitors(flags dbus.Flags) ([]InhibitorInfo, error) {
	mockArgs := v.Called(flags)

	ret0, ok := mockArgs.Get(0).([]InhibitorInfo)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// method CreateSession

func (v *MockInterfaceManager) GoCreateSession(flags dbus.Flags, ch chan *dbus.Call, uid uint32, pid uint32, service string, type0 string, class string, desktop string, seatId string, vtnr uint32, tty string, display string, remote bool, remoteUser string, remoteHost string, properties [][]interface{}) *dbus.Call {
	mockArgs := v.Called(flags, ch, uid, pid, service, type0, class, desktop, seatId, vtnr, tty, display, remote, remoteUser, remoteHost, properties)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) CreateSession(flags dbus.Flags, uid uint32, pid uint32, service string, type0 string, class string, desktop string, seatId string, vtnr uint32, tty string, display string, remote bool, remoteUser string, remoteHost string, properties [][]interface{}) (string, dbus.ObjectPath, string, dbus.UnixFD, uint32, string, uint32, bool, error) {
	mockArgs := v.Called(flags, uid, pid, service, type0, class, desktop, seatId, vtnr, tty, display, remote, remoteUser, remoteHost, properties)

	ret1, ok := mockArgs.Get(1).(dbus.ObjectPath)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 1, mockArgs.Get(1)))
	}

	ret3, ok := mockArgs.Get(3).(dbus.UnixFD)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 3, mockArgs.Get(3)))
	}

	ret4, ok := mockArgs.Get(4).(uint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 4, mockArgs.Get(4)))
	}

	ret6, ok := mockArgs.Get(6).(uint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 6, mockArgs.Get(6)))
	}

	return mockArgs.String(0), ret1, mockArgs.String(2), ret3, ret4, mockArgs.String(5), ret6, mockArgs.Bool(7), mockArgs.Error(8)
}

// method ReleaseSession

func (v *MockInterfaceManager) GoReleaseSession(flags dbus.Flags, ch chan *dbus.Call, sessionId string) *dbus.Call {
	mockArgs := v.Called(flags, ch, sessionId)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) ReleaseSession(flags dbus.Flags, sessionId string) error {
	mockArgs := v.Called(flags, sessionId)

	return mockArgs.Error(0)
}

// method ActivateSession

func (v *MockInterfaceManager) GoActivateSession(flags dbus.Flags, ch chan *dbus.Call, sessionId string) *dbus.Call {
	mockArgs := v.Called(flags, ch, sessionId)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) ActivateSession(flags dbus.Flags, sessionId string) error {
	mockArgs := v.Called(flags, sessionId)

	return mockArgs.Error(0)
}

// method ActivateSessionOnSeat

func (v *MockInterfaceManager) GoActivateSessionOnSeat(flags dbus.Flags, ch chan *dbus.Call, sessionId string, seatId string) *dbus.Call {
	mockArgs := v.Called(flags, ch, sessionId, seatId)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) ActivateSessionOnSeat(flags dbus.Flags, sessionId string, seatId string) error {
	mockArgs := v.Called(flags, sessionId, seatId)

	return mockArgs.Error(0)
}

// method LockSession

func (v *MockInterfaceManager) GoLockSession(flags dbus.Flags, ch chan *dbus.Call, sessionId string) *dbus.Call {
	mockArgs := v.Called(flags, ch, sessionId)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) LockSession(flags dbus.Flags, sessionId string) error {
	mockArgs := v.Called(flags, sessionId)

	return mockArgs.Error(0)
}

// method UnlockSession

func (v *MockInterfaceManager) GoUnlockSession(flags dbus.Flags, ch chan *dbus.Call, sessionId string) *dbus.Call {
	mockArgs := v.Called(flags, ch, sessionId)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) UnlockSession(flags dbus.Flags, sessionId string) error {
	mockArgs := v.Called(flags, sessionId)

	return mockArgs.Error(0)
}

// method LockSessions

func (v *MockInterfaceManager) GoLockSessions(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) LockSessions(flags dbus.Flags) error {
	mockArgs := v.Called(flags)

	return mockArgs.Error(0)
}

// method UnlockSessions

func (v *MockInterfaceManager) GoUnlockSessions(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) UnlockSessions(flags dbus.Flags) error {
	mockArgs := v.Called(flags)

	return mockArgs.Error(0)
}

// method KillSession

func (v *MockInterfaceManager) GoKillSession(flags dbus.Flags, ch chan *dbus.Call, sessionId string, who string, signo int32) *dbus.Call {
	mockArgs := v.Called(flags, ch, sessionId, who, signo)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) KillSession(flags dbus.Flags, sessionId string, who string, signo int32) error {
	mockArgs := v.Called(flags, sessionId, who, signo)

	return mockArgs.Error(0)
}

// method KillUser

func (v *MockInterfaceManager) GoKillUser(flags dbus.Flags, ch chan *dbus.Call, uid uint32, signo int32) *dbus.Call {
	mockArgs := v.Called(flags, ch, uid, signo)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) KillUser(flags dbus.Flags, uid uint32, signo int32) error {
	mockArgs := v.Called(flags, uid, signo)

	return mockArgs.Error(0)
}

// method TerminateSession

func (v *MockInterfaceManager) GoTerminateSession(flags dbus.Flags, ch chan *dbus.Call, sessionId string) *dbus.Call {
	mockArgs := v.Called(flags, ch, sessionId)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) TerminateSession(flags dbus.Flags, sessionId string) error {
	mockArgs := v.Called(flags, sessionId)

	return mockArgs.Error(0)
}

// method TerminateUser

func (v *MockInterfaceManager) GoTerminateUser(flags dbus.Flags, ch chan *dbus.Call, uid uint32) *dbus.Call {
	mockArgs := v.Called(flags, ch, uid)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) TerminateUser(flags dbus.Flags, uid uint32) error {
	mockArgs := v.Called(flags, uid)

	return mockArgs.Error(0)
}

// method TerminateSeat

func (v *MockInterfaceManager) GoTerminateSeat(flags dbus.Flags, ch chan *dbus.Call, seatId string) *dbus.Call {
	mockArgs := v.Called(flags, ch, seatId)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) TerminateSeat(flags dbus.Flags, seatId string) error {
	mockArgs := v.Called(flags, seatId)

	return mockArgs.Error(0)
}

// method SetUserLinger

func (v *MockInterfaceManager) GoSetUserLinger(flags dbus.Flags, ch chan *dbus.Call, uid uint32, linger bool, interactive bool) *dbus.Call {
	mockArgs := v.Called(flags, ch, uid, linger, interactive)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) SetUserLinger(flags dbus.Flags, uid uint32, linger bool, interactive bool) error {
	mockArgs := v.Called(flags, uid, linger, interactive)

	return mockArgs.Error(0)
}

// method AttachDevice

func (v *MockInterfaceManager) GoAttachDevice(flags dbus.Flags, ch chan *dbus.Call, seatId string, sysfs string, interactive bool) *dbus.Call {
	mockArgs := v.Called(flags, ch, seatId, sysfs, interactive)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) AttachDevice(flags dbus.Flags, seatId string, sysfs string, interactive bool) error {
	mockArgs := v.Called(flags, seatId, sysfs, interactive)

	return mockArgs.Error(0)
}

// method FlushDevices

func (v *MockInterfaceManager) GoFlushDevices(flags dbus.Flags, ch chan *dbus.Call, interactive bool) *dbus.Call {
	mockArgs := v.Called(flags, ch, interactive)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) FlushDevices(flags dbus.Flags, interactive bool) error {
	mockArgs := v.Called(flags, interactive)

	return mockArgs.Error(0)
}

// method PowerOff

func (v *MockInterfaceManager) GoPowerOff(flags dbus.Flags, ch chan *dbus.Call, interactive bool) *dbus.Call {
	mockArgs := v.Called(flags, ch, interactive)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) PowerOff(flags dbus.Flags, interactive bool) error {
	mockArgs := v.Called(flags, interactive)

	return mockArgs.Error(0)
}

// method Reboot

func (v *MockInterfaceManager) GoReboot(flags dbus.Flags, ch chan *dbus.Call, interactive bool) *dbus.Call {
	mockArgs := v.Called(flags, ch, interactive)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) Reboot(flags dbus.Flags, interactive bool) error {
	mockArgs := v.Called(flags, interactive)

	return mockArgs.Error(0)
}

// method Suspend

func (v *MockInterfaceManager) GoSuspend(flags dbus.Flags, ch chan *dbus.Call, interactive bool) *dbus.Call {
	mockArgs := v.Called(flags, ch, interactive)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) Suspend(flags dbus.Flags, interactive bool) error {
	mockArgs := v.Called(flags, interactive)

	return mockArgs.Error(0)
}

// method Hibernate

func (v *MockInterfaceManager) GoHibernate(flags dbus.Flags, ch chan *dbus.Call, interactive bool) *dbus.Call {
	mockArgs := v.Called(flags, ch, interactive)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) Hibernate(flags dbus.Flags, interactive bool) error {
	mockArgs := v.Called(flags, interactive)

	return mockArgs.Error(0)
}

// method HybridSleep

func (v *MockInterfaceManager) GoHybridSleep(flags dbus.Flags, ch chan *dbus.Call, interactive bool) *dbus.Call {
	mockArgs := v.Called(flags, ch, interactive)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) HybridSleep(flags dbus.Flags, interactive bool) error {
	mockArgs := v.Called(flags, interactive)

	return mockArgs.Error(0)
}

// method CanPowerOff

func (v *MockInterfaceManager) GoCanPowerOff(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) CanPowerOff(flags dbus.Flags) (string, error) {
	mockArgs := v.Called(flags)

	return mockArgs.String(0), mockArgs.Error(1)
}

// method CanReboot

func (v *MockInterfaceManager) GoCanReboot(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) CanReboot(flags dbus.Flags) (string, error) {
	mockArgs := v.Called(flags)

	return mockArgs.String(0), mockArgs.Error(1)
}

// method CanSuspend

func (v *MockInterfaceManager) GoCanSuspend(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) CanSuspend(flags dbus.Flags) (string, error) {
	mockArgs := v.Called(flags)

	return mockArgs.String(0), mockArgs.Error(1)
}

// method CanHibernate

func (v *MockInterfaceManager) GoCanHibernate(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) CanHibernate(flags dbus.Flags) (string, error) {
	mockArgs := v.Called(flags)

	return mockArgs.String(0), mockArgs.Error(1)
}

// method CanHybridSleep

func (v *MockInterfaceManager) GoCanHybridSleep(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) CanHybridSleep(flags dbus.Flags) (string, error) {
	mockArgs := v.Called(flags)

	return mockArgs.String(0), mockArgs.Error(1)
}

// method ScheduleShutdown

func (v *MockInterfaceManager) GoScheduleShutdown(flags dbus.Flags, ch chan *dbus.Call, type0 string, usec uint64) *dbus.Call {
	mockArgs := v.Called(flags, ch, type0, usec)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) ScheduleShutdown(flags dbus.Flags, type0 string, usec uint64) error {
	mockArgs := v.Called(flags, type0, usec)

	return mockArgs.Error(0)
}

// method CancelScheduledShutdown

func (v *MockInterfaceManager) GoCancelScheduledShutdown(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) CancelScheduledShutdown(flags dbus.Flags) (bool, error) {
	mockArgs := v.Called(flags)

	return mockArgs.Bool(0), mockArgs.Error(1)
}

// method Inhibit

func (v *MockInterfaceManager) GoInhibit(flags dbus.Flags, ch chan *dbus.Call, what string, who string, why string, mode string) *dbus.Call {
	mockArgs := v.Called(flags, ch, what, who, why, mode)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) Inhibit(flags dbus.Flags, what string, who string, why string, mode string) (dbus.UnixFD, error) {
	mockArgs := v.Called(flags, what, who, why, mode)

	ret0, ok := mockArgs.Get(0).(dbus.UnixFD)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// method CanRebootToFirmwareSetup

func (v *MockInterfaceManager) GoCanRebootToFirmwareSetup(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) CanRebootToFirmwareSetup(flags dbus.Flags) (string, error) {
	mockArgs := v.Called(flags)

	return mockArgs.String(0), mockArgs.Error(1)
}

// method SetRebootToFirmwareSetup

func (v *MockInterfaceManager) GoSetRebootToFirmwareSetup(flags dbus.Flags, ch chan *dbus.Call, enable bool) *dbus.Call {
	mockArgs := v.Called(flags, ch, enable)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) SetRebootToFirmwareSetup(flags dbus.Flags, enable bool) error {
	mockArgs := v.Called(flags, enable)

	return mockArgs.Error(0)
}

// method SetWallMessage

func (v *MockInterfaceManager) GoSetWallMessage(flags dbus.Flags, ch chan *dbus.Call, wallMessage string, enable bool) *dbus.Call {
	mockArgs := v.Called(flags, ch, wallMessage, enable)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) SetWallMessage(flags dbus.Flags, wallMessage string, enable bool) error {
	mockArgs := v.Called(flags, wallMessage, enable)

	return mockArgs.Error(0)
}

// signal SessionNew

func (v *MockInterfaceManager) ConnectSessionNew(cb func(sessionId string, sessionPath dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	mockArgs := v.Called(cb)

	ret0, ok := mockArgs.Get(0).(dbusutil.SignalHandlerId)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// signal SessionRemoved

func (v *MockInterfaceManager) ConnectSessionRemoved(cb func(sessionId string, sessionPath dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	mockArgs := v.Called(cb)

	ret0, ok := mockArgs.Get(0).(dbusutil.SignalHandlerId)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// signal UserNew

func (v *MockInterfaceManager) ConnectUserNew(cb func(uid uint32, userPath dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	mockArgs := v.Called(cb)

	ret0, ok := mockArgs.Get(0).(dbusutil.SignalHandlerId)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// signal UserRemoved

func (v *MockInterfaceManager) ConnectUserRemoved(cb func(uid uint32, userPath dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	mockArgs := v.Called(cb)

	ret0, ok := mockArgs.Get(0).(dbusutil.SignalHandlerId)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// signal SeatNew

func (v *MockInterfaceManager) ConnectSeatNew(cb func(seatId string, seatPath dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	mockArgs := v.Called(cb)

	ret0, ok := mockArgs.Get(0).(dbusutil.SignalHandlerId)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// signal SeatRemoved

func (v *MockInterfaceManager) ConnectSeatRemoved(cb func(seatId string, seatPath dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	mockArgs := v.Called(cb)

	ret0, ok := mockArgs.Get(0).(dbusutil.SignalHandlerId)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// signal PrepareForShutdown

func (v *MockInterfaceManager) ConnectPrepareForShutdown(cb func(start bool)) (dbusutil.SignalHandlerId, error) {
	mockArgs := v.Called(cb)

	ret0, ok := mockArgs.Get(0).(dbusutil.SignalHandlerId)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// signal PrepareForSleep

func (v *MockInterfaceManager) ConnectPrepareForSleep(cb func(start bool)) (dbusutil.SignalHandlerId, error) {
	mockArgs := v.Called(cb)

	ret0, ok := mockArgs.Get(0).(dbusutil.SignalHandlerId)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// property EnableWallMessages b

func (v *MockInterfaceManager) EnableWallMessages() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property WallMessage s

func (v *MockInterfaceManager) WallMessage() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property NAutoVTs u

func (v *MockInterfaceManager) NAutoVTs() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property KillOnlyUsers as

func (v *MockInterfaceManager) KillOnlyUsers() proxy.PropStringArray {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropStringArray)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property KillExcludeUsers as

func (v *MockInterfaceManager) KillExcludeUsers() proxy.PropStringArray {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropStringArray)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property KillUserProcesses b

func (v *MockInterfaceManager) KillUserProcesses() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property RebootToFirmwareSetup b

func (v *MockInterfaceManager) RebootToFirmwareSetup() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property IdleHint b

func (v *MockInterfaceManager) IdleHint() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property IdleSinceHint t

func (v *MockInterfaceManager) IdleSinceHint() proxy.PropUint64 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint64)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property IdleSinceHintMonotonic t

func (v *MockInterfaceManager) IdleSinceHintMonotonic() proxy.PropUint64 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint64)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property BlockInhibited s

func (v *MockInterfaceManager) BlockInhibited() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property DelayInhibited s

func (v *MockInterfaceManager) DelayInhibited() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property InhibitDelayMaxUSec t

func (v *MockInterfaceManager) InhibitDelayMaxUSec() proxy.PropUint64 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint64)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property HandlePowerKey s

func (v *MockInterfaceManager) HandlePowerKey() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property HandleSuspendKey s

func (v *MockInterfaceManager) HandleSuspendKey() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property HandleHibernateKey s

func (v *MockInterfaceManager) HandleHibernateKey() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property HandleLidSwitch s

func (v *MockInterfaceManager) HandleLidSwitch() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property HandleLidSwitchDocked s

func (v *MockInterfaceManager) HandleLidSwitchDocked() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property HoldoffTimeoutUSec t

func (v *MockInterfaceManager) HoldoffTimeoutUSec() proxy.PropUint64 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint64)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property IdleAction s

func (v *MockInterfaceManager) IdleAction() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property IdleActionUSec t

func (v *MockInterfaceManager) IdleActionUSec() proxy.PropUint64 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint64)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property PreparingForShutdown b

func (v *MockInterfaceManager) PreparingForShutdown() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property PreparingForSleep b

func (v *MockInterfaceManager) PreparingForSleep() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

type MockPropManagerScheduledShutdown struct {
	mock.Mock
}

func (p MockPropManagerScheduledShutdown) Get(flags dbus.Flags) (value ScheduledShutdown, err error) {
	args := p.Called(flags)

	var ok bool
	value, ok = args.Get(0).(ScheduledShutdown)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, args.Get(0)))
	}

	err = args.Error(1)

	return
}

func (p MockPropManagerScheduledShutdown) Set(flags dbus.Flags, value ScheduledShutdown) error {
	args := p.Called(flags, value)

	return args.Error(0)
}

func (p MockPropManagerScheduledShutdown) ConnectChanged(cb func(hasValue bool, value ScheduledShutdown)) error {
	args := p.Called(cb)

	return args.Error(0)
}

// property ScheduledShutdown (st)

func (v *MockInterfaceManager) ScheduledShutdown() PropManagerScheduledShutdown {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*MockPropManagerScheduledShutdown)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Docked b

func (v *MockInterfaceManager) Docked() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property RemoveIPC b

func (v *MockInterfaceManager) RemoveIPC() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property RuntimeDirectorySize t

func (v *MockInterfaceManager) RuntimeDirectorySize() proxy.PropUint64 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint64)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property InhibitorsMax t

func (v *MockInterfaceManager) InhibitorsMax() proxy.PropUint64 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint64)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property NCurrentInhibitors t

func (v *MockInterfaceManager) NCurrentInhibitors() proxy.PropUint64 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint64)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property SessionsMax t

func (v *MockInterfaceManager) SessionsMax() proxy.PropUint64 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint64)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property NCurrentSessions t

func (v *MockInterfaceManager) NCurrentSessions() proxy.PropUint64 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint64)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property UserTasksMax t

func (v *MockInterfaceManager) UserTasksMax() proxy.PropUint64 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint64)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

type MockSeat struct {
	MockInterfaceSeat // interface org.freedesktop.login1.Seat
	proxy.MockObject
}

type MockInterfaceSeat struct {
	mock.Mock
}

// method Terminate

func (v *MockInterfaceSeat) GoTerminate(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceSeat) Terminate(flags dbus.Flags) error {
	mockArgs := v.Called(flags)

	return mockArgs.Error(0)
}

// method ActivateSession

func (v *MockInterfaceSeat) GoActivateSession(flags dbus.Flags, ch chan *dbus.Call, sessionId string) *dbus.Call {
	mockArgs := v.Called(flags, ch, sessionId)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceSeat) ActivateSession(flags dbus.Flags, sessionId string) error {
	mockArgs := v.Called(flags, sessionId)

	return mockArgs.Error(0)
}

// method SwitchTo

func (v *MockInterfaceSeat) GoSwitchTo(flags dbus.Flags, ch chan *dbus.Call, vtnr uint32) *dbus.Call {
	mockArgs := v.Called(flags, ch, vtnr)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceSeat) SwitchTo(flags dbus.Flags, vtnr uint32) error {
	mockArgs := v.Called(flags, vtnr)

	return mockArgs.Error(0)
}

// method SwitchToNext

func (v *MockInterfaceSeat) GoSwitchToNext(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceSeat) SwitchToNext(flags dbus.Flags) error {
	mockArgs := v.Called(flags)

	return mockArgs.Error(0)
}

// method SwitchToPrevious

func (v *MockInterfaceSeat) GoSwitchToPrevious(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceSeat) SwitchToPrevious(flags dbus.Flags) error {
	mockArgs := v.Called(flags)

	return mockArgs.Error(0)
}

// property Id s

func (v *MockInterfaceSeat) Id() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property ActiveSession (so)

func (v *MockInterfaceSeat) ActiveSession() PropSessionInfo {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*MockPropSessionInfo)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property CanMultiSession b

func (v *MockInterfaceSeat) CanMultiSession() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property CanTTY b

func (v *MockInterfaceSeat) CanTTY() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property CanGraphical b

func (v *MockInterfaceSeat) CanGraphical() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Sessions a(so)

func (v *MockInterfaceSeat) Sessions() PropSessionInfoSlice {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*MockPropSessionInfoSlice)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property IdleHint b

func (v *MockInterfaceSeat) IdleHint() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property IdleSinceHint t

func (v *MockInterfaceSeat) IdleSinceHint() proxy.PropUint64 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint64)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property IdleSinceHintMonotonic t

func (v *MockInterfaceSeat) IdleSinceHintMonotonic() proxy.PropUint64 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint64)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

type MockSession struct {
	MockInterfaceSession // interface org.freedesktop.login1.Session
	proxy.MockObject
}

type MockInterfaceSession struct {
	mock.Mock
}

// method Terminate

func (v *MockInterfaceSession) GoTerminate(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceSession) Terminate(flags dbus.Flags) error {
	mockArgs := v.Called(flags)

	return mockArgs.Error(0)
}

// method Activate

func (v *MockInterfaceSession) GoActivate(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceSession) Activate(flags dbus.Flags) error {
	mockArgs := v.Called(flags)

	return mockArgs.Error(0)
}

// method Lock

func (v *MockInterfaceSession) GoLock(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceSession) Lock(flags dbus.Flags) error {
	mockArgs := v.Called(flags)

	return mockArgs.Error(0)
}

// method Unlock

func (v *MockInterfaceSession) GoUnlock(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceSession) Unlock(flags dbus.Flags) error {
	mockArgs := v.Called(flags)

	return mockArgs.Error(0)
}

// method SetIdleHint

func (v *MockInterfaceSession) GoSetIdleHint(flags dbus.Flags, ch chan *dbus.Call, idle bool) *dbus.Call {
	mockArgs := v.Called(flags, ch, idle)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceSession) SetIdleHint(flags dbus.Flags, idle bool) error {
	mockArgs := v.Called(flags, idle)

	return mockArgs.Error(0)
}

// method SetLockedHint

func (v *MockInterfaceSession) GoSetLockedHint(flags dbus.Flags, ch chan *dbus.Call, locked bool) *dbus.Call {
	mockArgs := v.Called(flags, ch, locked)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceSession) SetLockedHint(flags dbus.Flags, locked bool) error {
	mockArgs := v.Called(flags, locked)

	return mockArgs.Error(0)
}

// method Kill

func (v *MockInterfaceSession) GoKill(flags dbus.Flags, ch chan *dbus.Call, who string, signo int32) *dbus.Call {
	mockArgs := v.Called(flags, ch, who, signo)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceSession) Kill(flags dbus.Flags, who string, signo int32) error {
	mockArgs := v.Called(flags, who, signo)

	return mockArgs.Error(0)
}

// method TakeControl

func (v *MockInterfaceSession) GoTakeControl(flags dbus.Flags, ch chan *dbus.Call, force bool) *dbus.Call {
	mockArgs := v.Called(flags, ch, force)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceSession) TakeControl(flags dbus.Flags, force bool) error {
	mockArgs := v.Called(flags, force)

	return mockArgs.Error(0)
}

// method ReleaseControl

func (v *MockInterfaceSession) GoReleaseControl(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceSession) ReleaseControl(flags dbus.Flags) error {
	mockArgs := v.Called(flags)

	return mockArgs.Error(0)
}

// method TakeDevice

func (v *MockInterfaceSession) GoTakeDevice(flags dbus.Flags, ch chan *dbus.Call, major uint32, minor uint32) *dbus.Call {
	mockArgs := v.Called(flags, ch, major, minor)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceSession) TakeDevice(flags dbus.Flags, major uint32, minor uint32) (dbus.UnixFD, bool, error) {
	mockArgs := v.Called(flags, major, minor)

	ret0, ok := mockArgs.Get(0).(dbus.UnixFD)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Bool(1), mockArgs.Error(2)
}

// method ReleaseDevice

func (v *MockInterfaceSession) GoReleaseDevice(flags dbus.Flags, ch chan *dbus.Call, major uint32, minor uint32) *dbus.Call {
	mockArgs := v.Called(flags, ch, major, minor)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceSession) ReleaseDevice(flags dbus.Flags, major uint32, minor uint32) error {
	mockArgs := v.Called(flags, major, minor)

	return mockArgs.Error(0)
}

// method PauseDeviceComplete

func (v *MockInterfaceSession) GoPauseDeviceComplete(flags dbus.Flags, ch chan *dbus.Call, major uint32, minor uint32) *dbus.Call {
	mockArgs := v.Called(flags, ch, major, minor)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceSession) PauseDeviceComplete(flags dbus.Flags, major uint32, minor uint32) error {
	mockArgs := v.Called(flags, major, minor)

	return mockArgs.Error(0)
}

// signal PauseDevice

func (v *MockInterfaceSession) ConnectPauseDevice(cb func(major uint32, minor uint32, type0 string)) (dbusutil.SignalHandlerId, error) {
	mockArgs := v.Called(cb)

	ret0, ok := mockArgs.Get(0).(dbusutil.SignalHandlerId)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// signal ResumeDevice

func (v *MockInterfaceSession) ConnectResumeDevice(cb func(major uint32, minor uint32, fd dbus.UnixFD)) (dbusutil.SignalHandlerId, error) {
	mockArgs := v.Called(cb)

	ret0, ok := mockArgs.Get(0).(dbusutil.SignalHandlerId)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// signal Lock

func (v *MockInterfaceSession) ConnectLock(cb func()) (dbusutil.SignalHandlerId, error) {
	mockArgs := v.Called(cb)

	ret0, ok := mockArgs.Get(0).(dbusutil.SignalHandlerId)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// signal Unlock

func (v *MockInterfaceSession) ConnectUnlock(cb func()) (dbusutil.SignalHandlerId, error) {
	mockArgs := v.Called(cb)

	ret0, ok := mockArgs.Get(0).(dbusutil.SignalHandlerId)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// property Id s

func (v *MockInterfaceSession) Id() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

type MockPropSessionUser struct {
	mock.Mock
}

func (p MockPropSessionUser) Get(flags dbus.Flags) (value UserInfo, err error) {
	args := p.Called(flags)

	var ok bool
	value, ok = args.Get(0).(UserInfo)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, args.Get(0)))
	}

	err = args.Error(1)

	return
}

func (p MockPropSessionUser) Set(flags dbus.Flags, value UserInfo) error {
	args := p.Called(flags, value)

	return args.Error(0)
}

func (p MockPropSessionUser) ConnectChanged(cb func(hasValue bool, value UserInfo)) error {
	args := p.Called(cb)

	return args.Error(0)
}

// property User (uo)

func (v *MockInterfaceSession) User() PropSessionUser {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*MockPropSessionUser)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Name s

func (v *MockInterfaceSession) Name() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Timestamp t

func (v *MockInterfaceSession) Timestamp() proxy.PropUint64 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint64)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property TimestampMonotonic t

func (v *MockInterfaceSession) TimestampMonotonic() proxy.PropUint64 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint64)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property VTNr u

func (v *MockInterfaceSession) VTNr() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

type MockPropSessionSeat struct {
	mock.Mock
}

func (p MockPropSessionSeat) Get(flags dbus.Flags) (value SeatInfo, err error) {
	args := p.Called(flags)

	var ok bool
	value, ok = args.Get(0).(SeatInfo)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, args.Get(0)))
	}

	err = args.Error(1)

	return
}

func (p MockPropSessionSeat) Set(flags dbus.Flags, value SeatInfo) error {
	args := p.Called(flags, value)

	return args.Error(0)
}

func (p MockPropSessionSeat) ConnectChanged(cb func(hasValue bool, value SeatInfo)) error {
	args := p.Called(cb)

	return args.Error(0)
}

// property Seat (so)

func (v *MockInterfaceSession) Seat() PropSessionSeat {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*MockPropSessionSeat)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property TTY s

func (v *MockInterfaceSession) TTY() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Display s

func (v *MockInterfaceSession) Display() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Remote b

func (v *MockInterfaceSession) Remote() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property RemoteHost s

func (v *MockInterfaceSession) RemoteHost() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property RemoteUser s

func (v *MockInterfaceSession) RemoteUser() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Service s

func (v *MockInterfaceSession) Service() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Desktop s

func (v *MockInterfaceSession) Desktop() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Scope s

func (v *MockInterfaceSession) Scope() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Leader u

func (v *MockInterfaceSession) Leader() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Audit u

func (v *MockInterfaceSession) Audit() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Type s

func (v *MockInterfaceSession) Type() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Class s

func (v *MockInterfaceSession) Class() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Active b

func (v *MockInterfaceSession) Active() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property State s

func (v *MockInterfaceSession) State() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property IdleHint b

func (v *MockInterfaceSession) IdleHint() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property IdleSinceHint t

func (v *MockInterfaceSession) IdleSinceHint() proxy.PropUint64 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint64)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property IdleSinceHintMonotonic t

func (v *MockInterfaceSession) IdleSinceHintMonotonic() proxy.PropUint64 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint64)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property LockedHint b

func (v *MockInterfaceSession) LockedHint() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

type MockUser struct {
	MockInterfaceUser // interface org.freedesktop.login1.User
	proxy.MockObject
}

type MockInterfaceUser struct {
	mock.Mock
}

// method Terminate

func (v *MockInterfaceUser) GoTerminate(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceUser) Terminate(flags dbus.Flags) error {
	mockArgs := v.Called(flags)

	return mockArgs.Error(0)
}

// method Kill

func (v *MockInterfaceUser) GoKill(flags dbus.Flags, ch chan *dbus.Call, signo int32) *dbus.Call {
	mockArgs := v.Called(flags, ch, signo)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceUser) Kill(flags dbus.Flags, signo int32) error {
	mockArgs := v.Called(flags, signo)

	return mockArgs.Error(0)
}

// property UID u

func (v *MockInterfaceUser) UID() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property GID u

func (v *MockInterfaceUser) GID() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Name s

func (v *MockInterfaceUser) Name() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Timestamp t

func (v *MockInterfaceUser) Timestamp() proxy.PropUint64 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint64)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property TimestampMonotonic t

func (v *MockInterfaceUser) TimestampMonotonic() proxy.PropUint64 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint64)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property RuntimePath s

func (v *MockInterfaceUser) RuntimePath() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Service s

func (v *MockInterfaceUser) Service() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Slice s

func (v *MockInterfaceUser) Slice() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Display (so)

func (v *MockInterfaceUser) Display() PropSessionInfo {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*MockPropSessionInfo)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property State s

func (v *MockInterfaceUser) State() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Sessions a(so)

func (v *MockInterfaceUser) Sessions() PropSessionInfoSlice {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*MockPropSessionInfoSlice)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property IdleHint b

func (v *MockInterfaceUser) IdleHint() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property IdleSinceHint t

func (v *MockInterfaceUser) IdleSinceHint() proxy.PropUint64 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint64)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property IdleSinceHintMonotonic t

func (v *MockInterfaceUser) IdleSinceHintMonotonic() proxy.PropUint64 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint64)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Linger b

func (v *MockInterfaceUser) Linger() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

type MockPropSessionInfo struct {
	mock.Mock
}

func (p MockPropSessionInfo) Get(flags dbus.Flags) (value SessionInfo, err error) {
	args := p.Called(flags)

	var ok bool
	value, ok = args.Get(0).(SessionInfo)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, args.Get(0)))
	}

	err = args.Error(1)

	return
}

func (p MockPropSessionInfo) Set(flags dbus.Flags, value SessionInfo) error {
	args := p.Called(flags, value)

	return args.Error(0)
}

func (p MockPropSessionInfo) ConnectChanged(cb func(hasValue bool, value SessionInfo)) error {
	args := p.Called(cb)

	return args.Error(0)
}

type MockPropSessionInfoSlice struct {
	mock.Mock
}

func (p MockPropSessionInfoSlice) Get(flags dbus.Flags) (value []SessionInfo, err error) {
	args := p.Called(flags)

	var ok bool
	value, ok = args.Get(0).([]SessionInfo)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, args.Get(0)))
	}

	err = args.Error(1)

	return
}

func (p MockPropSessionInfoSlice) Set(flags dbus.Flags, value []SessionInfo) error {
	args := p.Called(flags, value)

	return args.Error(0)
}

func (p MockPropSessionInfoSlice) ConnectChanged(cb func(hasValue bool, value []SessionInfo)) error {
	args := p.Called(cb)

	return args.Error(0)
}
