
! Copyright (C) 2018 T. Mueller, J. K. Dewhurst, S. Sharma and E. K. U. Gross.
! This file is distributed under the terms of the GNU General Public License.
! See the file COPYING for license details.

subroutine pksuinit
use modmain
use modulr
use modrandom
use modomp
implicit none
! local variables
integer iq,idm,is,ias,ir
! zero the Kohn-Sham potential for all Q
do iq=1,nqpt
  do ias=1,natmtot
    is=idxis(ias)
    vsqmt(1:npcmt(is),ias,iq)=0.d0
  end do
end do
vsqir(:,:)=0.d0
! initialise the external potential
do ir=1,nqpt
  vclru(ir)=rndulr*cmplx(randomu()-0.5d0,randomu()-0.5d0,8)
end do
if (.not.spinpol) return
! zero the Kohn-Sham magnetic field for all Q
do iq=1,nqpt
  do idm=1,ndmag
    do ias=1,natmtot
      is=idxis(ias)
      bsqmt(1:npcmt(is),ias,idm,iq)=0.d0
    end do
  end do
end do
bsqir(:,:,:)=0.d0
! initialise the external magnetic fields
do idm=1,ndmag
  do ir=1,nqpt
    bfcru(ir,idm)=rndulr*cmplx(randomu()-0.5d0,randomu()-0.5d0,8)
  end do
  do ias=1,natmtot
    do ir=1,nqpt
      bfcmtru(ir,ias,idm)=rndulr*cmplx(randomu()-0.5d0,randomu()-0.5d0,8)
    end do
  end do
end do
return
end subroutine

