/*
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     Hou Lei <houlei@uniontech.com>
 *
 * Maintainer: Liu Zheng <liuzheng@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "screengrabber.h"

#include "../utils/desktopinfo.h"

#include <QDBusInterface>
#include <QDBusReply>
#include <QDir>
#include <QPixmap>
#include <QScreen>
#include <QGuiApplication>
#include <QApplication>
#include <QDesktopWidget>
#include <QStandardPaths>

ScreenGrabber::ScreenGrabber(QObject *parent) : QObject(parent)
{

}

QPixmap ScreenGrabber::grabEntireDesktop(bool &ok, const QRect &rect, const qreal devicePixelRatio)
{
    Q_UNUSED(devicePixelRatio);
    ok = true;
    if (m_info.waylandDectected()) {
        QPixmap res;
        QDBusInterface kwinInterface(QStringLiteral("org.kde.KWin"),
                                     QStringLiteral("/Screenshot"),
                                     QStringLiteral("org.kde.kwin.Screenshot"));
        QDBusReply<QString> reply = kwinInterface.call(QStringLiteral("screenshotFullscreen"));
        res = QPixmap(reply.value());
        if (!res.isNull()) {
            QFile dbusResult(reply.value());
            dbusResult.remove();
        } else {
            ok = false;
        }
        return res;
    }
/*
    QRect r(rect.topLeft() * devicePixelRatio, rect.size());

    int t_screenNum = QApplication::desktop()->screenCount();

    if (t_screenNum == 1) {
        QList<QScreen *> screenList = qApp->screens();
        for (auto it = screenList.constBegin(); it != screenList.constEnd(); ++it) {
            if ((*it)->geometry().contains(r)) {
                return (*it)->grabWindow(0, rect.x(), rect.y(), rect.width(), rect.height());
            }
        }
    } else {
    */
        QScreen *t_primaryScreen = QGuiApplication::primaryScreen();
        // 在多屏模式下, winId 不是0 
        return t_primaryScreen->grabWindow(QApplication::desktop()->winId(), rect.x(), rect.y(), rect.width(), rect.height());
    //}
    //return QPixmap();
}
