/*
 * Copyright (C) 2019 ~ 2020 Uniontech Software Technology Co., Ltd.
 *
 * Author:     huangyonga<huangyonga@uniontech.com>
 * Maintainer: huangyonga<huangyonga@uniontech.com>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include "closepopupwidget.h"

#include <DCheckBox>
#include <DFrame>
#include <DLabel>
#include <DMainWindow>
#include <DRadioButton>
#include <DSettingsOption>
#include <DApplication>

#include <QDir>
#include <QStandardPaths>
#include <QGroupBox>
#include <QVBoxLayout>
#include <QVBoxLayout>
#include <qsettingbackend.h>
#include <QStandardPaths>
#include <QThread>

#include "utils.h"
#include "GlobalDefine.h"
#include "TrObject.h"

DCORE_USE_NAMESPACE

ClosePopUpWidget::ClosePopUpWidget(DWidget *parent)
    : DDialog(parent)
{
    InitUi();
    InitConnect();
}

ClosePopUpWidget::~ClosePopUpWidget()
{
    //删除指针
    if (m_backend) {
        delete m_backend;
        m_backend = nullptr;
    }
    if (m_pDSettings) {
        delete m_pDSettings;
        m_pDSettings = nullptr;
    }
}

void ClosePopUpWidget::initBtnState()
{
    if (m_minRadioBtn->isChecked())
        emit stateChanged(true);

    if (m_extRadioBtn->isChecked())
        emit stateChanged(false);

    emit askStateChanged(m_remember->isChecked());
}

void ClosePopUpWidget::InitUi()
{
    setTitle(TrObject::getInstance()->getDlgTitle(dlg_ClosePopUpWidget));

    m_extRadioBtn = new DRadioButton(TrObject::getInstance()->getDlgBtnText(Dlg_Btn_Exit));
    m_extRadioBtn->setObjectName("CloseConfirmDialogExit");
    m_minRadioBtn = new DRadioButton(TrObject::getInstance()->getDlgBtnText(Minimize_to_system_tray));
    m_minRadioBtn->setObjectName("CloseConfirmDialogMini");
    m_remember = new DCheckBox(TrObject::getInstance()->getCheckBoxText(Do_not_ask_again));
    m_remember->setObjectName("CloseConfirmDialogAsk");
    DFontSizeManager::instance()->bind(m_extRadioBtn, DFontSizeManager::T6);
    DFontSizeManager::instance()->bind(m_minRadioBtn, DFontSizeManager::T6);
    DFontSizeManager::instance()->bind(m_remember, DFontSizeManager::T6);

    setIcon(QIcon::fromTheme(PhoneAssistantModel::g_app_icon_name));
    this->addContent(m_extRadioBtn);
    this->addContent(m_minRadioBtn);
    this->addContent(m_remember);

    addButton(TrObject::getInstance()->getDlgBtnText(Dlg_Btn_cancel), false, ButtonNormal);
    addButton(TrObject::getInstance()->getDlgBtnText(Dlg_Btn_Confirm), true, ButtonRecommend);

    this->setFixedWidth(380);
}

void ClosePopUpWidget::InitConnect()
{
    QString m_configPath = QString("%1/%2/%3/config.conf").arg(QStandardPaths::writableLocation(QStandardPaths::ConfigLocation)).arg(PhoneAssistantModel::g_organization_name).arg(PhoneAssistantModel::g_application_name);

    m_backend = new QSettingBackend(m_configPath, this);
    m_pDSettings = DSettings::fromJsonFile(":/resources/settings.json");
    m_pDSettings->setBackend(m_backend);

    bool miniOrClose = m_backend->getOption("base.Closemainwindow.radiogroupclose").toBool();

    QFile fileconfig(m_configPath);
    if (!fileconfig.exists()) {
        m_minRadioBtn->setChecked(true);
        m_extRadioBtn->setChecked(false);
    }

    if (miniOrClose) {
        m_minRadioBtn->setChecked(true);
    } else {
        m_extRadioBtn->setChecked(true);
    }

    bool nRemeber = m_backend->getOption("base.Closemainwindow.askmealways").toBool();
    m_remember->setChecked(!nRemeber);

    auto settingsAsk = m_pDSettings->option("base.Closemainwindow.askmealways");
    auto settingsRadioGroup = m_pDSettings->option("base.Closemainwindow.radiogroupclose");

    connect(this, &ClosePopUpWidget::stateChanged, this, [=](bool checked) {
        if (settingsRadioGroup) {
            settingsRadioGroup->setValue(checked);
            isExit = checked;
        }
    });

    connect(this, &ClosePopUpWidget::askStateChanged, this, [=](bool checked) {
        if (settingsAsk) {
            settingsAsk->setValue(!checked);
        }
    });
}
