/*
* Copyright (C) 2019 ~ 2020 Uniontech Software Technology Co.,Ltd.
*
* Author:     wangzhixuan <wangzhixuan@uniontech.com>
*
* Maintainer: wangzhixuan <wangzhixuan@uniontech.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef CUSTOMWIDGET_H
#define CUSTOMWIDGET_H

#include <DWidget>

#include <QVBoxLayout>
#include <QStackedLayout>

#include "defines.h"

class BaseListView;
class BaseTreeView;

class SpinnerWidget;

class BaseItemModel;

DWIDGET_USE_NAMESPACE

/**
 * @brief 应用各个 Ui界面 第一 继承， app、music、video、ebook、filemanager 基类
 */
class FileDisplayTask;
class CustomWidgetPrivate;
class CustomWidget : public DWidget
{
    Q_OBJECT
    Q_DECLARE_PRIVATE(CustomWidget)
public:
    explicit CustomWidget(DWidget *p = nullptr);
    virtual ~CustomWidget() override;

    //signals:
    //    void sigFindCount(QString strPhoneID, int nCount);

public:
    /**
     * @brief 当左侧选项切换， 当前显示的界面需要根据自己的数据情况，设置顶部标题栏的状态
     */
    virtual void setWidgetBtnState() = 0;

    /**
     * @brief 设备移除的时候， 清空当前数据
     * @param devInfo
     */
    virtual void clearWidgetInfo(const QString &devInfo) = 0;

protected:
    virtual void refreshWidgetData() = 0; //  刷新

    // 是否开启读取线程 QThread::isRunning
    virtual bool isReading() = 0;
    // 暂停读取
    virtual bool pauseRead() = 0;
    // 继续读取
    virtual bool continueRead() = 0;

    void resizeEvent(QResizeEvent *event) override;
    virtual void setVisible(bool visible) override;

protected:
    DWidget *getTreeWidget(DWidget *);
    void spinnerStart();
    void spinnerStop();
    void setShowText(const QString &strText);
    bool SpinnerIsVisible();
    bool execMsgBox(const QString &strText, bool bShowCancel = true); //返回 true同意
    /**
     * @brief 导出的文件夹路径 选择对话框
     * @return
     */
    QString getExportPath();
    /**
     * @brief 消息提醒
     */
    void sendOkMessage(const QString &);
    void sendWarnMessage(const QString &);

    bool checkOperating();

protected slots:
    virtual void slotTitleWidgetBtnClicked(const int &) = 0;
    virtual void slotCustomContextMenuRequested(const QPoint &);
    virtual void slotLoadDataEnd();
    //    virtual void slotStackedCurrentChanged(int);

private:
    //    void initTreeViews();
    void initSpinnerWidget();

    void initConnection();

protected:
    enum ViewMode { VIEW_ICON_MODE,
                    VIEW_LIST_MODE,
                    VIEW_EMPTY
    };

    int m_currFileViewMode = VIEW_ICON_MODE; //  当前显示 网格、列表

    BaseTreeView *m_pTreeViewFrame = nullptr;
    BaseListView *m_pListViewFrame = nullptr;

    SpinnerWidget *m_pSpinnerWidget = nullptr; //  每一个UI 对应自己的 spinner
    QVBoxLayout *m_pMmainLayout = nullptr;
    QStackedLayout *m_pStackViewLayout = nullptr;

    E_Widget_Type m_pWidgetType = E_No_Define;

    FileDisplayTask *m_loadTask = nullptr;
    CustomWidgetPrivate *d_ptr;
};

#endif // CUSTOMWIDGET_H
