#ifndef UTIL_H_included
#define UTIL_H_included 1

#include <errno.h>
#include <stdbool.h>

#define TOK      0
#define TERROR   errno?-errno:-1

#define MAX_LINE_LEN    1024
#define MAX_CMD_LEN     1024
#define CONFIG_FILE  "/etc/deepin-fix-init.cfg"

#define TUI_LOG(params) tui_log_msg params

typedef struct tui_cfg {
    char *root_dev;
    char *root_type;
    bool b_debug;
}tui_cfg;

int excute_shell_command(const char *cmd,char *buf,unsigned int buf_len);
int tui_strcat(char *dest,char *src,unsigned int dest_max_len);
void tui_log_msg(const char *fmt,...);

int init_log(const char *filename);
void close_log();
void read_config();
#endif