/*
 *  Copyright (C) 2010  Giorgio Wicklein <g.wicklein@giowisys.com>
 *
 *  This file is part of DaemonFS.
 *
 *  DaemonFS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  DaemonFS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with DaemonFS.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef FILEWATCHERENGINE_H
#define FILEWATCHERENGINE_H


//-----------------------------------------------------------------------------
// Hearders
//-----------------------------------------------------------------------------

#include <QObject>
#include <QMap>


//-----------------------------------------------------------------------------
// Forward declarations
//-----------------------------------------------------------------------------

class QFileSystemWatcher;
class QDateTime;

//-----------------------------------------------------------------------------
// FileWatcherEngine
//-----------------------------------------------------------------------------

class FileWatcherEngine : public QObject
{
    Q_OBJECT

public:
    FileWatcherEngine(QObject *parent = 0);
    ~FileWatcherEngine();

    void addPaths(QStringList&);
    void clear();
    QDateTime getLastModification(QString);
    bool isDeleted(QString);
    bool isNew(QString);

signals:
    void fschanged(QString);
    void addToTableSignal(QString);

private:
    void getAllFiles(QString, QStringList&);

    QFileSystemWatcher *fileSystemWatcher;
    QMap<QString, QDateTime> *fileMap;

private slots:
    void fileChanged(QString);
    void dirChanged(QString);
};

#endif // FILEWATCHERENGINE_H
