#! /bin/perl -w
#
# dump a NIS+ Table to a file
#
# Nistool is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# Nistool is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with the NIS+ Server; see the file COPYING.  If
# not, write to the Free Software Foundation, Inc., 675 Mass Ave,
# Cambridge, MA 02139, USA.
#
# Version: 0.1alpha
# Author: Ralf Lehmann <ralfl@darwin.muc.de>
#

use Nisplus;
use strict;

my $D;
my $DIR; 
my $T;
my $create=0;
my $withheader=0;
my $append=0;
my $RETSTR;

## Tables that can be dumped with nisaddent
my $STANDARD = "aliases bootparams ethers group hosts netgroup netid netmasks networks passwd protocols rpc services shadow timezone";

if ($#ARGV < 1 || $#ARGV > 2 ) {usage();}
if ($ARGV[0] =~ /^-.*/) {
	$_ = shift @ARGV;
	$create=1 if /c/;
}
$D = shift @ARGV;
$DIR = shift @ARGV;

if (!($D =~ /.*\.$/)) {
	$!=1;
	die "Error: Domainname must be fully qualified.\n";
}
if (-e $DIR && !(-d $DIR)){ 
	$!=1;
	die "Error: $DIR exists but is not a directory.\n";
}
if(!(-e $DIR) && $create){
	mkdir($DIR, 0700) || die "Error: Can't make directory $DIR";
}
if (!(-e $DIR)){
	$!=1;
	die "Error: Directory $DIR does not exist.\n";
}
my $o = Nisplus->new($D);
$o->getattr();
if ($RETSTR = $o->get_error()){
	$!=1;
	die "Error: $RETSTR\n";
}
if ($o->{'Type'} ne 'DIRECTORY') {
	$! = 1;
	die "Error: $D is not a domain.\n";
}
if (Nisplus::get_first($D) eq 'org_dir' || Nisplus::get_first($D) eq "groups_dir"){
	$!=1;
	die "Error: $D is not a domain.\n";
}
my $org_dir = Nisplus->new('org_dir' . '.' . $D);
$org_dir->getattr();
if($RETSTR = $org_dir->get_error()){
	$! = 1;
	die "Error: $RETSTR\n";
}
## here we going to check groups_dir
##
## code to come

dumpdomain();
exit 0;

##
## dump a domain
##
sub dumpdomain{
	my $t;
	my @list = $org_dir->list();
	foreach $t (@list) {
		$T=$t;
		my $FI = $DIR . '/' . Nisplus::get_first($T);
print "$t $FI\n";
		`./dump_table.pl $t $FI`;
		if (Nisplus::get_first($T) eq 'passwd'){
			$FI = $DIR . '/' . 'shadow';
			$T = 'shadow.' . Nisplus::strip_first($T);
			`./dump_table.pl $T $FI`;
		}
	}
}



##
## find an error in th eoutput string
##
sub find_error {
	my $RET;
	foreach (@_){
		if (/Error/ || /error/ || /cannot/) { 
			if (defined($RET)) {$RET .= $_ ; }
			else { $RET=$_;}
		}
	}
	return $RET;
}


sub usage {
	print STDERR "usage: $0 [-c] domain dumpdirectory\n";
	exit 1;
}
