/*
 * omnibook.h -- High level data structures and functions of omnibook
 *               support code
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * Written by Sos Pter <sp@osb.hu>, 2002-2003
 */

/*
 * Module informations
 */

#define MODULE_NAME		"omnibook"
#define MODULE_VERSION		"2003-02-26"

/*
 * EC types
 */

extern int omnibook_ectype;
enum {
	NONE,
	XE3GF,
	XE3GC,
	OB500,
	OB510,
	OB6000,
	OB6100,
	XE4500,
	OB4150
};

extern struct __init proc_dir_entry *omnibook_proc_root;
extern int __init omnibook_userset;

extern int omnibook_get_ac(void);

struct omnibook_battery_info {
	u8 type;	/* 1 - Li-Ion, 2 NiMH */
	u16 sn;		/* Serial number */
	u16 dv;		/* Design Voltage */
	u16 dc;		/* Design Capacity */
};
struct omnibook_battery_status {
	u16 pv;		/* Present Voltage */
	u16 rc;		/* Remaining Capacity */
	u16 lc;		/* Last Full Capacity */
	u8 gauge;	/* Gauge in % */
	u8 status;	/* 0 - unknown, 1 - charged, 2 - discharging, 3 - charging, 4 - critical) */
};
enum {
	OMNIBOOK_BATTSTAT_UNKNOWN,
	OMNIBOOK_BATTSTAT_CHARGED,
	OMNIBOOK_BATTSTAT_DISCHARGING,
	OMNIBOOK_BATTSTAT_CHARGING,
	OMNIBOOK_BATTSTAT_CRITICAL
};

extern int omnibook_get_battery_info(int num, struct omnibook_battery_info *battinfo);
extern int omnibook_get_battery_status(int num, struct omnibook_battery_status *battstat);

extern int omnibook_console_blank_enabled;
extern int omnibook_lcd_blank(int blank);
extern int omnibook_console_blank_enable(void);
extern int omnibook_console_blank_disable(void);

extern int omnibook_get_display(void);

extern int omnibook_get_dock(void);

extern int omnibook_get_fan(void);
extern int omnibook_fan_on(void);
extern int omnibook_fan_off(void);

/*
 * Default temperature limits.
 * Danger! You may overheat your CPU!
 * Do not change these values unless you exactly know what you do.
 */

#define OMNIBOOK_FAN_LEVELS			7
#define OMNIBOOK_FAN_MIN			25	/* Minimal value of fan off temperature */
#define OMNIBOOK_FOT_MAX			75	/* Maximal value of fan off temperature */
#define OMNIBOOK_FAN_MAX			95	/* Maximal value of fan on temperature */
#define OMNIBOOK_FOT_DEFAULT			60	/* Default value of fan off temperature */
#define OMNIBOOK_FAN1_DEFAULT			75	/* Default value of fan speed 1 temperature */
#define OMNIBOOK_FAN2_DEFAULT			85	/* Default value of fan speed 2 temperature */
#define OMNIBOOK_FAN3_DEFAULT			90	/* Default value of fan speed 3 temperature */
#define OMNIBOOK_FAN4_DEFAULT			95	/* Default value of fan speed 4 temperature */
#define OMNIBOOK_FAN5_DEFAULT			95	/* Default value of fan speed 5 temperature */
#define OMNIBOOK_FAN6_DEFAULT			95	/* Default value of fan speed 6 temperature */
#define OMNIBOOK_FAN7_DEFAULT			95	/* Default value of fan speed 7 temperature */
#define OMNIBOOK_FAN_POLICY_STRING		32	/* Maximal length of temperature policy control string */

extern int omnibook_get_fan_policy(u8 (*fan)[OMNIBOOK_FAN_LEVELS]);
extern int omnibook_set_fan_policy(u8 (*fan)[OMNIBOOK_FAN_LEVELS]);
extern int omnibook_set_fan_policy_defaults(void);

extern int omnibook_get_lcd_brightness(void);
extern int omnibook_set_lcd_brightness(u8 brgt);

extern int omnibook_onetouch_enabled;
extern int omnibook_onetouch_enable(void);
extern int omnibook_onetouch_disable(void);

extern int omnibook_key_polling_enabled;
extern int omnibook_key_polling_enable(void);
extern int omnibook_key_polling_disable(void);

extern int omnibook_get_cpu_temp(void);

extern int omnibook_touchpad_enabled;
extern int omnibook_touchpad_enable(void);
extern int omnibook_touchpad_disable(void);

/* End of file */
