#ifndef _FTPFS_PROC_H_
#define _FTPFS_PROC_H_

#include "ftpfs_cache.h"

void ftp_init_root_dirent(struct ftp_sb_info *, struct ftp_fattr *);
unsigned long ftp_inet_addr(char *);
int ftp_parse_options(struct ftp_sb_info *, void *);
int sock_send(struct socket *, const void *, int);
int sock_recv(struct socket *, unsigned char *, int, unsigned);
int ftp_connect(struct ftp_sb_info*);
void ftp_disconnect(struct ftp_sb_info*);
int ftp_execute_open(struct ftp_sb_info*, char*, char*, unsigned long, struct socket**);
int ftp_loaddir(struct ftp_sb_info*, char*, struct ftp_directory*);
int ftp_get_name(struct dentry*, char*);
inline void ftp_lock(struct ftp_sb_info*);
inline void ftp_unlock(struct ftp_sb_info*);
int ftp_get_attr(struct dentry*, struct ftp_fattr*, struct ftp_sb_info*);
struct inode* ftp_iget(struct super_block*, struct ftp_fattr*);
int ftp_read(struct dentry*, unsigned long, unsigned long, char*);
int ftp_proc_mkdir(struct ftp_sb_info*, char*);
int ftp_proc_rmdir(struct ftp_sb_info*, char*);
int ftp_proc_rename(struct ftp_sb_info*, char*, char*);
int ftp_proc_unlink(struct ftp_sb_info*, char*);
int ftp_proc_create(struct ftp_sb_info*, char*);
int ftp_write(struct dentry*, unsigned long, unsigned long, char*);
void ftp_echo(char*);
void ftp_ech(int);

#endif
