#ifndef SHA256_H
#define SHA256_H

#ifndef __KERNEL__
#define __KERNEL__
#endif
#include <asm/types.h>
#include <linux/byteorder/little_endian.h>

#define SHA256_DIGEST_SIZE	32
#define SHA256_HMAC_BLOCK_SIZE	64

struct sha256_ctx {
	u32 count[2];
	u32 state[8];
	u8 buf[128];
};

static inline u32 Ch(u32 x, u32 y, u32 z)
{
	return ((x & y) ^ (~x & z));
}

static inline u32 Maj(u32 x, u32 y, u32 z)
{
	return ((x & y) ^ (x & z) ^ (y & z));
}

static inline u32 RORu32(u32 x, u32 y)
{
	return (x >> y) | (x << (32 - y));
}

#define e0(x)       (RORu32(x, 2) ^ RORu32(x,13) ^ RORu32(x,22))
#define e1(x)       (RORu32(x, 6) ^ RORu32(x,11) ^ RORu32(x,25))
#define s0(x)       (RORu32(x, 7) ^ RORu32(x,18) ^ (x >> 3))
#define s1(x)       (RORu32(x,17) ^ RORu32(x,19) ^ (x >> 10))

#define H0         0x6a09e667
#define H1         0xbb67ae85
#define H2         0x3c6ef372
#define H3         0xa54ff53a
#define H4         0x510e527f
#define H5         0x9b05688c
#define H6         0x1f83d9ab
#define H7         0x5be0cd19

static inline void LOAD_OP(int I, u32 *W, const u8 *input)
{
	u32 t1 = input[(4 * I)] & 0xff;

	t1 <<= 8;
	t1 |= input[(4 * I) + 1] & 0xff;
	t1 <<= 8;
	t1 |= input[(4 * I) + 2] & 0xff;
	t1 <<= 8;
	t1 |= input[(4 * I) + 3] & 0xff;
	W[I] = t1;
}

static inline void BLEND_OP(int I, u32 *W)
{
	W[I] = s1(W[I-2]) + W[I-7] + s0(W[I-15]) + W[I-16];
}

extern void sha256_init(void *ctx);
extern void sha256_update(void *ctx, const u8 *data, unsigned int len);
extern void sha256_final(void* ctx, u8 *out);

#endif
