/*
 * Copyright (C) 2004 Red Hat UK Ltd.
 *
 * This file is released under the GPL.
 */

#ifndef DM_BH_LIST_H
#define DM_BH_LIST_H

#include <linux/fs.h>

struct bh_list {
	struct buffer_head *head;
	struct buffer_head *tail;
};

static inline void bh_list_init(struct bh_list *bl)
{
	bl->head = bl->tail = NULL;
}

static inline void bh_list_add(struct bh_list *bl, struct buffer_head *bh)
{
	bh->b_reqnext = NULL;

	if (bl->tail)
		bl->tail->b_reqnext = bh;
	else
		bl->head = bh;

	bl->tail = bh;
}

static inline void bh_list_merge(struct bh_list *bl, struct bh_list *bl2)
{
	if (bl->tail)
		bl->tail->b_reqnext = bl2->head;
	else
		bl->head = bl2->head;

	bl->tail = bl2->tail;
}

static inline struct buffer_head *bh_list_pop(struct bh_list *bl)
{
	struct buffer_head *bh = bl->head;

	if (bh) {
		bl->head = bl->head->b_reqnext;
		if (!bl->head)
			bl->tail = NULL;

		bh->b_reqnext = NULL;
	}

	return bh;
}

static inline struct buffer_head *bh_list_get(struct bh_list *bl)
{
	struct buffer_head *bh = bl->head;

	bl->head = bl->tail = NULL;

	return bh;
}

#endif
