/*
   CIPE - encrypted IP over UDP tunneling

   ioctl.c - ioctl interface, user side

   Copyright 1996 Olaf Titz <olaf@bigred.inka.de>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version
   2 of the License, or (at your option) any later version.
*/
/* $Id: ioctl.c,v 1.6 2000/12/15 17:55:00 olaf Exp $ */

#include "cipe.h"
#include "ioctl.h"
#include "version.h"
#include <sys/ioctl.h>

#define IFRSETUP                                                        \
    struct ifreq ifr;                                                   \
    strcpy(ifr.ifr_name, ifname);                                       \
    sio->magic=VERSION_MAGIC;                                           \
    ifr.ifr_data=(void*)sio;

#ifdef SIOCGIFCIPPAR
int ioctl_getpar(int fd, char *ifname, struct siocgifcippar *sio)
{
    IFRSETUP;
    return ioctl(fd, SIOCGIFCIPPAR, &ifr);
}
#endif

int ioctl_setpar(int fd, char *ifname, struct siocsifcippar *sio)
{
    IFRSETUP;
    return ioctl(fd, SIOCSIFCIPPAR, &ifr);
}

int ioctl_setkey(int fd, char *ifname, struct siocsifcipkey *sio)
{
    int e;
    IFRSETUP;
    e=ioctl(fd, SIOCSIFCIPKEY, &ifr);
    memset(sio, 0, sizeof(*sio));
    return e;
}

int ioctl_attach(int fd, char *ifname, struct siocsifcipatt *sio)
{
    IFRSETUP;
    return ioctl(fd, SIOCSIFCIPATT, &ifr);
}

int ioctl_alloc(int fd, char *ifname, struct siocsifcipall *sio)
{
    IFRSETUP;
    return ioctl(fd, SIOCSIFCIPALL, &ifr);
}

int ioctl_unalloc(int fd, char *ifname, struct siocsifcipall *sio)
{
    IFRSETUP;
    return ioctl(fd, SIOCSIFCIPUNA, &ifr);
}
