#ifndef _SCSI_SCSIMON_H
#define _SCSI_SCSIMON_H

/*
   SCSI upper level driver that permits user applications to monitor
   the state of SCSI devices and hosts. The original purpose of this
   driver is to support hotplugging notification.

*       Copyright (C) 2001 Douglas Gilbert

    Version: 0.0.92 (20010313)
    Initial version

*/

/* Use [c 10 247] ("misc" char device, minor 247) with the device name: 
   /dev/scsimon  [/dev/misc/scsimon under devfs]. This is unofficial,
   need allocation in Documentation/devices.txt . [This driver was
   called "scsiinfo" < version 0.0.92 and used misc minor number 210 .] */
#define SCSIMON_MINOR 247


/* Borrow ioctl numbers from sg driver, starting at 0x22a0 */
/* Third argument of ioctls is "int *" unless otherwise noted */

/* Ignored 3rd argument */
#define SCSIMON_LOCK_MOD 0x22a0
#define SCSIMON_UNLOCK_MOD 0x22a1

#define SCSIMON_GET_VERSION_NUM 0x22a2

/* 3rd argument assumed to be pointer to struct scsimon_state object */
#define SCSIMON_GET_STATE 0x22a3

/* Maximum number of elements kept in detached device list [default: 10] */
#define SCSIMON_SET_MX_DLIST_LEN 0x22a4
#define SCSIMON_GET_MX_DLIST_LEN 0x22a5

/* Major ioctls to access lists of attached  devices, detached devices and
   hosts. The third argument is a pointer to an object of type
   'struct scsimon_[att | det | host]_list' with enough space to accommodate
   'max_num' elements of the array which is the last member of these structs */
#define SCSIMON_GET_ATT_LIST 0x22a6 
#define SCSIMON_GET_DET_LIST 0x22a7
#define SCSIMON_GET_HOST_LIST 0x22a8


struct scsimon_state {
    struct timespec init_time;  /* time since boot that this driver loaded */
    unsigned int devices_attached; /* which is also device list length */
    unsigned int total_attachs;
    unsigned int total_detachs;
    unsigned int detach_list_len;
    int count_hosts;		/* host numbers not necessarily consecutive */
    unsigned int high_host;	/* highest host number */
    unsigned long event_count;
    int lock_mod_state;		/* 0 -> module not locked down */
};

/* Note: the attach event count represents a unique key by which the
         "session" of an attached device can be identified */

struct scsimon_device {
    unsigned int host;
    unsigned int bus;
    unsigned int target;
    unsigned int lun;
    char vendor[8];	/* from INQUIRY during mid level scan */
    char model[16];
    char rev[4];
    char scsi_type;
    char scsi_level;
    char removable;
    char emulated;
    /* more here ?? */
    char dummy[16];
};

struct scsimon_host {	
    unsigned int host;
    int host_scsi_id;
    char host_name[16];
    char host_info[80];
    char emulated;
    char is_module;
    /* more here ?? */
    char dummy[16];
};

struct scsimon_att_dev {	/* attached device info */
    struct timespec att_time;	/* time since boot that this device attached */
    unsigned long att_event;	/* event count of attach */
    struct scsimon_device d;
};

struct scsimon_det_dev {	/* detached device info */
    struct timespec det_time;  /* time since boot that this device attached */
    unsigned long det_event;
    unsigned long att_event;
    char host_name[12];
    char host_info[80];
    struct scsimon_device d;
};

struct scsimon_att_list {
    unsigned long match_event;	/* [i] 0 -> get max_num, otherwise get match */
    int flags;			/* [i] 0 at the moment */
    int max_num;		/* [i] app must allocate enough space ... */ 
    unsigned long curr_event;	/* [o] event number at time of call */
    int num_out;		/* [o] actual number output */ 
    struct scsimon_att_dev arr[1]; /* [o] must be space for max_num elems */
};

struct scsimon_det_list {
    unsigned long match_event;	/* [i] 0 -> get max_num, otherwise get */
    				/*     match (on att_event) */
    int flags;			/* [i] 0 at the moment */
    int max_num;		/* [i] app must allocate enough space ... */ 
    unsigned long curr_event;	/* [o] event number at time of call */
    int num_out;		/* [o] actual number output */ 
    struct scsimon_det_dev arr[1]; /* [o] must be space for max_num elems */
};

#define SCSIMON_HOST_FLAG_ALL 0		/* fetch up to max_num hosts */
#define SCSIMON_HOST_FLAG_MATCH 1	/* fetch 'host' (when max_num >= 1) */

struct scsimon_host_list {
    unsigned int host;		/* [i] used if SCSIMON_HOST_FLAG_MATCH set */
    int flags;			/* [i] see SCSIMON_HOST_FLAG... values */
    int max_num;		/* [i] app must allocate enough space ... */ 
    unsigned long curr_event;	/* [o] event number at time of call */
    int num_out;		/* [o] actual number output */ 
    struct scsimon_host arr[1]; /* [o] must be space for max_num elems */
};

#endif
