// **********************************************************************
// * IBMASM HEADER FILE                                                 *
// *                                                                    *
// * Written by Matthew DeLoera (deloera@us.ibm.com)                    *
// * (C) Copyright IBM Corporation, 1998-2001                           *
// *                                                                    *
// *  This software may be used and distributed according to the terms  *
// *  of the GNU Public License, incorporated herein by reference.      *
// **********************************************************************


#ifndef __SYSSCOUT_H_
#define __SYSSCOUT_H_

//#include <stddef.h>
//#define DBG  1 // Comment out if additional debug messages are not needed.


/* The following macro returns a bitwise mirror image of a UCHAR (8 bits) */

#define MIRROR_BITS(x) (UCHAR)(                                          \
                        ((UCHAR)((UCHAR)(UCHAR)(x)) >> 4)               | \
                        ((UCHAR)((UCHAR)(UCHAR)(x)) << 4)                 \
                       )

#define SCOUT_VENDORID              0x1014 // IBM==0x1014 
#define SCOUT_DEVICEID              0x010F // Scout

#define SCOUT_NO_MFAS_AVAILABLE     0xFFFFFFFF // return code from tarantula

//------------------------------------------------------------------------
//              TARANTULA PCI CONFIG REGISTER OFFSETS
//------------------------------------------------------------------------
#define SCOUT_RTR_BASE              0x010
#define SCOUT_RTR_IO_BASE           0x018
#define SCOUT_INT_STATUS_REGISTER   0x13A0   // I2OHISR = Host Interrupt Status Register
#define SCOUT_INT_CONTROL_REGISTER  0x13A4   // HIMR = Host Interrupt Mask Register
#define MEMORY_ACCESS_ENABLE        0x02     //Bit 1
#define BUS_MASTER_ENABLE           0x04     //Bit 2

//------------------------------------------------------------------------
//              TARANTULA PCI REGISTER OFFSETS FOR I2O 
//------------------------------------------------------------------------
#define SCOUT_INBOUND_QUEUE_PORT    0x040   // contains address of next free MFA
#define SCOUT_OUTBOUND_QUEUE_PORT   0x044   // contains address of posted MFA

#define SCOUT_INTR_ENABLE_MASK      0x00000008 // Bit 3
#define SCOUT_INTR_STATUS_MASK      0x00000008 // Bit 3
#define SCOUT_COM_INTR_ENABLE_MASK  0x00000010 // Bit 4

//#define SCOUT_NO_MFAS_AVAILABLE     0xFFFFFFFF
#define SCOUT_I2O_INT_ENABLE_BIT    0x00000080 // Bit 7

#define SCOUT_COM_A_BASE            0x0000
#define SCOUT_COM_B_BASE            0x0100   
#define SCOUT_COM_C_BASE            0x0200   
#define SCOUT_COM_D_BASE            0x0300   

//------------------------------------------------------------------------
//              Bit masks for detecting Ranger/Wiseman/Eagle
//------------------------------------------------------------------------
#define NO_DEVICE_FOUND            0x00        //All Zeroes
#define RANGER_DEVICE_FOUND        0x01        //Bit 0
#define WISEMAN_DEVICE_FOUND       0x02        //Bit 1
#define EAGLE_DEVICE_FOUND         0x04        //Bit 2

//------------------------------------------------------------------------
//              TARANTULA I2O read/write macros
//------------------------------------------------------------------------
#define SCOUT_SP_INTERRUPTS  (SCOUT_INTR_ENABLE_MASK)
//#define SCOUT_COM_INTERRUPTS (SCOUT_INTR_ENABLE_MASK)

#define SCOUT_INT_STATUS_REGISTER_OFFSET  0x00
#define SCOUT_INT_CONTROL_REGISTER_OFFSET 0x04


#define SCOUT_DISABLE_COM_INTERRUPTS(intrbase)           \
   WRITE_REGISTER_ULONG( (PULONG)(intrbase + SCOUT_INT_CONTROL_REGISTER_OFFSET),                     \
                     READ_REGISTER_ULONG( (PULONG)(intrbase + SCOUT_INT_CONTROL_REGISTER_OFFSET) ) | \
                     (SCOUT_COM_INTR_ENABLE_MASK))

#define SCOUT_ENABLE_COM_INTERRUPTS(intrbase)           \
   WRITE_REGISTER_ULONG( (PULONG)(intrbase + SCOUT_INT_CONTROL_REGISTER_OFFSET),                     \
                     READ_REGISTER_ULONG( (PULONG)(intrbase + SCOUT_INT_CONTROL_REGISTER_OFFSET) ) & \
                     (~SCOUT_COM_INTR_ENABLE_MASK))

#define SCOUT_READ_INT_STATUS(pcibase)                    \
   READ_REGISTER_ULONG( (PULONG)(pcibase + SCOUT_INT_STATUS_REGISTER) )

#define SCOUT_READ_COM_INT_STATUS(intrbase)                    \
   READ_REGISTER_ULONG( (PULONG)(intrbase + SCOUT_INT_STATUS_REGISTER_OFFSET) )


#define SCOUT_READ_COM_INT_CONTROL(intrbase)                    \
   READ_REGISTER_ULONG( (PULONG)(intrbase + SCOUT_INT_CONTROL_REGISTER_OFFSET) )


#define SCOUT_ENABLE_ALL_SP_INTERRUPTS(pcibase)           \
   WRITE_REGISTER_ULONG( (PULONG)(pcibase + SCOUT_INT_CONTROL_REGISTER),                     \
                     READ_REGISTER_ULONG( (PULONG)(pcibase + SCOUT_INT_CONTROL_REGISTER) ) & \
                     (~SCOUT_SP_INTERRUPTS))

#define SCOUT_RESTORE_SP_INTERRUPTS(pcibase, iTemp)       \
   WRITE_REGISTER_ULONG( (PULONG)(pcibase + SCOUT_INT_CONTROL_REGISTER),                      \
                     READ_REGISTER_ULONG( (PULONG)(pcibase + SCOUT_INT_CONTROL_REGISTER) ) |  \
                     (iTemp & SCOUT_SP_INTERRUPTS) )

#define SCOUT_DISABLE_ALL_SP_INTERRUPTS(pcibase, iTemp)   \
   WRITE_REGISTER_ULONG( (PULONG)(pcibase + SCOUT_INT_CONTROL_REGISTER),                      \
                     (iTemp = READ_REGISTER_ULONG( (PULONG)(pcibase + SCOUT_INT_CONTROL_REGISTER) )) |  \
                     (SCOUT_SP_INTERRUPTS) )


#define SCOUT_READ_SP_OUTBOUND_Q(pcibase)               \
   READ_REGISTER_ULONG( (PULONG)(pcibase + SCOUT_OUTBOUND_QUEUE_PORT) )


#define SCOUT_WRITE_SP_OUTBOUND_Q(pcibase, addr)               \
   WRITE_REGISTER_ULONG( (PULONG)(pcibase + SCOUT_OUTBOUND_QUEUE_PORT), addr )

#define SCOUT_READ_SP_INBOUND_Q(pcibase)               \
   READ_REGISTER_ULONG( (PULONG)(pcibase + SCOUT_INBOUND_QUEUE_PORT) )


#define SCOUT_WRITE_SP_INBOUND_Q(pcibase, addr)               \
   WRITE_REGISTER_ULONG( (PULONG)(pcibase + SCOUT_INBOUND_QUEUE_PORT), addr )

#endif

