#ifndef _SHFS_DCACHE_H_
#define _SHFS_DCACHE_H_

#define SHFS_MAX_AGE(info)	(((info)->mnt.ttl * HZ) / 1000)

#include <linux/slab.h>
#include <linux/kdev_t.h>
#include <linux/fs.h>

extern kmem_cache_t	*dir_head_cache;
extern kmem_cache_t	*dir_entry_cache;
extern kmem_cache_t	*dir_name_cache;

struct shfs_dir_head {
	time_t		age;
	struct		shfs_dir_entry *first;
};

struct shfs_dir_entry {
	struct 		shfs_dir_entry *next;

	umode_t		mode;
	char        	*name;
	char		ename[20];
	unsigned long	ino;
	uid_t		uid;
	gid_t		gid;
	off_t		size;
	kdev_t		rdev;
	nlink_t		nlink;
	unsigned long	blocksize;
	unsigned long	blocks;
	time_t		atime;
};

struct shfs_sb_info;

int shfs_dcache_get_dir(struct dentry*, struct shfs_dir_entry**);
int shfs_dcache_get_entry(struct dentry*, struct shfs_dir_entry**);
void shfs_dcache_invalidate_dir(struct inode*);
void shfs_dcache_clear_inode(struct inode*);
void shfs_dcache_update_fattr(struct dentry*, struct iattr*);
int shfs_dcache_revalidate_entry(struct dentry*);

#endif	/* _SHFS_DCACHE_H_ */
