/*******************************************************************
 * This file is part of the Emulex Linux Device Driver for         *
 * Enterprise Fibre Channel Host Bus Adapters.                     *
 * Refer to the README file included with this package for         *
 * driver version and adapter support.                             *
 * Copyright (C) 2003 Emulex Corporation.                          *
 * www.emulex.com                                                  *
 *                                                                 *
 * This program is free software; you can redistribute it and/or   *
 * modify it under the terms of the GNU General Public License     *
 * as published by the Free Software Foundation; either version 2  *
 * of the License, or (at your option) any later version.          *
 *                                                                 *
 * This program is distributed in the hope that it will be useful, *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of  *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the   *
 * GNU General Public License for more details, a copy of which    *
 * can be found in the file COPYING included with this package.    *
 *******************************************************************/

#ifndef HBA_API_H
#define HBA_API_H

/* Library version string */
#define HBA_LIBVERSION 1

/* DLL imports for WIN32 operation */
#define HBA_API

/* OS specific definitions */


typedef unsigned char    HBA_UINT8; /* Unsigned  8 bits */
typedef          char    HBA_INT8;      /* Signed    8 bits */
typedef unsigned short   HBA_UINT16;    /* Unsigned 16 bits */
typedef          short   HBA_INT16; /* Signed   16 bits */
typedef unsigned int     HBA_UINT32;    /* Unsigned 32 bits */
typedef          int     HBA_INT32;     /* Signed   32 bits */
typedef void*            HBA_PVOID;     /* Pointer  to void */
typedef HBA_UINT32       HBA_VOID32;    /* Opaque   32 bits */
typedef long long        HBA_INT64;
typedef long long        HBA_UINT64;



/* 4.2.1    Handle to Device */
typedef HBA_UINT32  HBA_HANDLE;

/* 4.2.2    Status Return Values */
typedef HBA_UINT32 HBA_STATUS;

#define HBA_STATUS_OK                   0
#define HBA_STATUS_ERROR            1   /* Error */
#define HBA_STATUS_ERROR_NOT_SUPPORTED      2   /* Function not supported.*/
#define HBA_STATUS_ERROR_INVALID_HANDLE     3   /* invalid handle */
#define HBA_STATUS_ERROR_ARG            4   /* Bad argument */
#define HBA_STATUS_ERROR_ILLEGAL_WWN        5   /* WWN not recognized */
#define HBA_STATUS_ERROR_ILLEGAL_INDEX      6   /* Index not recognized */
#define HBA_STATUS_ERROR_MORE_DATA      7   /* Larger buffer required */
#define HBA_STATUS_ERROR_STALE_DATA     8   /* need a refresh */



/* 4.2.3    Port Operational Modes Values */

typedef HBA_UINT32 HBA_PORTTYPE;        

#define HBA_PORTTYPE_UNKNOWN            1 /* Unknown */
#define HBA_PORTTYPE_OTHER              2 /* Other */
#define HBA_PORTTYPE_NOTPRESENT         3 /* Not present */
#define HBA_PORTTYPE_NPORT              5 /* Fabric  */
#define HBA_PORTTYPE_NLPORT         6 /* Public Loop */
#define HBA_PORTTYPE_FLPORT     7 /* Fabric Loop Port */
#define HBA_PORTTYPE_FPORT          8 /* Fabric Port */
#define HBA_PORTTYPE_EPORT      9 /* Fabric expansion port */
#define HBA_PORTTYPE_GPORT      10 /* Generic Fabric Port */
#define HBA_PORTTYPE_LPORT              20 /* Private Loop */
#define HBA_PORTTYPE_PTP        21 /* Point to Point */


typedef HBA_UINT32 HBA_PORTSTATE;       
#define HBA_PORTSTATE_UNKNOWN       1 /* Unknown */
#define HBA_PORTSTATE_ONLINE        2 /* Operational */
#define HBA_PORTSTATE_OFFLINE       3 /* User Offline */
#define HBA_PORTSTATE_BYPASSED          4 /* Bypassed */
#define HBA_PORTSTATE_DIAGNOSTICS       5 /* In diagnostics mode */
#define HBA_PORTSTATE_LINKDOWN      6 /* Link Down */
#define HBA_PORTSTATE_ERROR         7 /* Port Error */
#define HBA_PORTSTATE_LOOPBACK      8 /* Loopback */


typedef HBA_UINT32 HBA_PORTSPEED;
#define HBA_PORTSPEED_1GBIT     1 /* 1 GBit/sec */
#define HBA_PORTSPEED_2GBIT     2 /* 2 GBit/sec */
#define HBA_PORTSPEED_10GBIT        4 /* 10 GBit/sec */



/* 4.2.4    Class of Service Values - See GS-2 Spec.*/

typedef HBA_UINT32 HBA_COS;


/* 4.2.5    Fc4Types Values */

typedef struct HBA_fc4types {
   HBA_UINT8 bits[32]; /* 32 bytes of FC-4 per GS-2 */
} HBA_FC4TYPES, *PHBA_FC4TYPES;

/* 4.2.6    Basic Types */

typedef struct HBA_wwn {
   HBA_UINT8 wwn[8];
} HBA_WWN, *PHBA_WWN;

typedef struct HBA_ipaddress {
   int  ipversion;      /* see enumerations in RNID */
   union
   {
      unsigned char ipv4address[4];
      unsigned char ipv6address[16];
   } ipaddress;
} HBA_IPADDRESS, *PHBA_IPADDRESS;

/* 4.2.7    Adapter Attributes */
typedef struct hba_AdapterAttributes {
   char         Manufacturer[64];   /*Emulex */
   char         SerialNumber[64];   /* A12345 */
   char         Model[256];             /* QLA2200 */
    char        ModelDescription[256];  /* Agilent TachLite */
   HBA_WWN      NodeWWN; 
   char         NodeSymbolicName[256];  /* From GS-3 */
   char         HardwareVersion[256];   /* Vendor use */
   char         DriverVersion[256];     /* Vendor use */
    char        OptionROMVersion[256];  /* Vendor use  - i.e. hardware boot ROM*/
   char         FirmwareVersion[256];   /* Vendor use */
   HBA_UINT32       VendorSpecificID;   /* Vendor specific */
    HBA_UINT32      NumberOfPorts;
   char         DriverName[256];    /* Binary path and/or name of driver file. */
} HBA_ADAPTERATTRIBUTES, *PHBA_ADAPTERATTRIBUTES;

/* 4.2.8    Port Attributes */
typedef struct HBA_PortAttributes {
    HBA_WWN         NodeWWN;
   HBA_WWN      PortWWN;
   HBA_UINT32       PortFcId;
   HBA_PORTTYPE     PortType;       /*PTP, Fabric, etc. */
   HBA_PORTSTATE    PortState;
   HBA_COS      PortSupportedClassofService;
   HBA_FC4TYPES     PortSupportedFc4Types;
   HBA_FC4TYPES     PortActiveFc4Types;
   char         PortSymbolicName[256];
   char         OSDeviceName[256];  /* \device\ScsiPort3  */
   HBA_PORTSPEED    PortSupportedSpeed;
   HBA_PORTSPEED    PortSpeed; 
   HBA_UINT32       PortMaxFrameSize;
   HBA_WWN      FabricName;
   HBA_UINT32       NumberofDiscoveredPorts;
} HBA_PORTATTRIBUTES, *PHBA_PORTATTRIBUTES;



/* 4.2.9    Port Statistics */

typedef struct HBA_PortStatistics {
   HBA_INT64        SecondsSinceLastReset;
   HBA_INT64        TxFrames;
   HBA_INT64        TxWords;
   HBA_INT64        RxFrames;
   HBA_INT64        RxWords;
   HBA_INT64        LIPCount;
   HBA_INT64        NOSCount;
   HBA_INT64        ErrorFrames;
   HBA_INT64        DumpedFrames;
   HBA_INT64        LinkFailureCount;
   HBA_INT64        LossOfSyncCount;
   HBA_INT64        LossOfSignalCount;
   HBA_INT64        PrimitiveSeqProtocolErrCount;
   HBA_INT64        InvalidTxWordCount;
   HBA_INT64        InvalidCRCCount;
} HBA_PORTSTATISTICS, *PHBA_PORTSTATISTICS;



/* 4.2.10   FCP Attributes */

typedef enum HBA_fcpbindingtype { TO_D_ID, TO_WWN } HBA_FCPBINDINGTYPE;

typedef struct HBA_ScsiId {
   char         OSDeviceName[256];  /* \device\ScsiPort3  */
   HBA_UINT32       ScsiBusNumber;      /* Bus on the HBA */
   HBA_UINT32       ScsiTargetNumber;   /* SCSI Target ID to OS */
   HBA_UINT32       ScsiOSLun;  
} HBA_SCSIID, *PHBA_SCSIID;

typedef struct HBA_FcpId {
   HBA_UINT32       FcId;
   HBA_WWN      NodeWWN;
   HBA_WWN      PortWWN;
   HBA_UINT64       FcpLun;
} HBA_FCPID, *PHBA_FCPID;

typedef struct HBA_FcpScsiEntry {
   HBA_SCSIID       ScsiId;
   HBA_FCPID        FcpId;
} HBA_FCPSCSIENTRY, *PHBA_FCPSCSIENTRY;

typedef struct HBA_FCPTargetMapping {
   HBA_UINT32       NumberOfEntries;
   HBA_FCPSCSIENTRY     entry[1];   /* Variable length array containing mappings*/
} HBA_FCPTARGETMAPPING, *PHBA_FCPTARGETMAPPING;

typedef struct HBA_FCPBindingEntry {
   HBA_FCPBINDINGTYPE   type;
   HBA_SCSIID       ScsiId;
   HBA_FCPID        FcpId;  /* WWN valid only if type is to WWN, FcpLun always valid */
   HBA_UINT32       FcId;   /* valid only if type is to DID */
} HBA_FCPBINDINGENTRY, *PHBA_FCPBINDINGENTRY;

typedef struct HBA_FCPBinding {
   HBA_UINT32       NumberOfEntries;
   HBA_FCPBINDINGENTRY  entry[1]; /* Variable length array */
} HBA_FCPBINDING, *PHBA_FCPBINDING;

/* 4.2.11   FC-3 Management Atrributes */

typedef enum HBA_wwntype { NODE_WWN, PORT_WWN } HBA_WWNTYPE;

typedef struct HBA_MgmtInfo {
   HBA_WWN      wwn;
   HBA_UINT32       unittype;
   HBA_UINT32       PortId;
   HBA_UINT32       NumberOfAttachedNodes;
   HBA_UINT16       IPVersion;
   HBA_UINT16       UDPPort;
   HBA_UINT8        IPAddress[16];
   HBA_UINT16       reserved;
   HBA_UINT16       TopologyDiscoveryFlags;
} HBA_MGMTINFO, *PHBA_MGMTINFO;

#define HBA_EVENT_LIP_OCCURRED          1
#define HBA_EVENT_LINK_UP           2
#define HBA_EVENT_LINK_DOWN         3
#define HBA_EVENT_LIP_RESET_OCCURRED        4
#define HBA_EVENT_RSCN              5
#define HBA_EVENT_PROPRIETARY           0xFFFF

typedef struct HBA_Link_EventInfo {
   HBA_UINT32 PortFcId;     /* Port which this event occurred */
   HBA_UINT32 Reserved[3];
} HBA_LINK_EVENTINFO, *PHBA_LINK_EVENTINFO;

typedef struct HBA_RSCN_EventInfo {
   HBA_UINT32 PortFcId;    /* Port which this event occurred */
   HBA_UINT32 NPortPage;   /* Reference FC-FS for  RSCN ELS "Affected N-Port Pages"*/
   HBA_UINT32 Reserved[2];
} HBA_RSCN_EVENTINFO, *PHBA_RSCN_EVENTINFO;

typedef struct HBA_Pty_EventInfo {
   HBA_UINT32 PtyData[4];  /* Proprietary data */
} HBA_PTY_EVENTINFO, *PHBA_PTY_EVENTINFO;

typedef struct HBA_EventInfo {
   HBA_UINT32 EventCode;
   union {
      HBA_LINK_EVENTINFO Link_EventInfo;
      HBA_RSCN_EVENTINFO RSCN_EventInfo;
      HBA_PTY_EVENTINFO Pty_EventInfo;
   } Event;
} HBA_EVENTINFO, *PHBA_EVENTINFO;

/* Used for OSDeviceName */
typedef struct HBA_osdn {
   char        drvname[32];
   HBA_UINT32  instance;
   HBA_UINT32  target;
   HBA_UINT32  lun;
   HBA_UINT32  bus;
   char        flags;
   char        sizeSN;
   char        InquirySN[32];
} HBA_OSDN;

/* Function Prototypes */
#if (!defined(_KERNEL) && !defined(__KERNEL__))
uint32 GetAdapterAttributes(uint32, HBA_ADAPTERATTRIBUTES *);
uint32 GetAdapterPortAttributes(uint32, HBA_UINT32, HBA_PORTATTRIBUTES *);
uint32 GetPortStatistics(uint32, HBA_UINT32, HBA_PORTSTATISTICS *);
uint32 GetDiscoveredPortAttributes(uint32, HBA_UINT32, HBA_UINT32, HBA_PORTATTRIBUTES *);
uint32 GetPortAttributesByWWN(uint32, HBA_WWN *, HBA_PORTATTRIBUTES *);
uint32 GetPortAttributesByIndex(uint32, HBA_UINT32, HBA_UINT32, HBA_PORTATTRIBUTES *);
uint32 GetEventBuffer(uint32, PHBA_EVENTINFO, HBA_UINT32 *);
uint32 SetRNIDMgmtInfo(uint32, HBA_MGMTINFO *);
uint32 GetRNIDMgmtInfo(uint32, HBA_MGMTINFO *);
uint32 SendRNID(uint32, HBA_WWN *, HBA_WWNTYPE, void *, HBA_UINT32 *);
void   ResetStatistics(uint32, HBA_UINT32);
uint32 RefreshInformation(uint32);
uint32 GetFcpTargetMapping(uint32, PHBA_FCPTARGETMAPPING);
uint32 GetFcpPersistentBinding(uint32, PHBA_FCPBINDING);
uint32 SendCTPassThru(uint32, void *, HBA_UINT32, void *, HBA_UINT32 *);
uint32 SendReportLUNs(uint32, HBA_WWN *, void *, HBA_UINT32 *, void *,
       HBA_UINT32 *);
uint32 SendReadCapacity(uint32, HBA_WWN *, HBA_UINT64, void *, HBA_UINT32 *,
       void *, HBA_UINT32 *);
uint32 SendScsiInquiry(uint32, HBA_WWN *, HBA_UINT64, HBA_UINT8, HBA_UINT32,
       void *, HBA_UINT32 *, void *, HBA_UINT32 *);
#endif


#endif

