/*
 * Copyright 2008 Sony Corporation
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *   * Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *   * Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *   * Neither the names of the copyright holders nor the names of their
 *     contributors may be used to endorse or promote products derived from this
 *     software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "e_cell.h"

#ifndef OPENSSL_NO_RIPEMD
#include "rmd_dgst.c"

ALIGNED(static RIPEMD160_CTX g_ctx, SHARED_DATA_ALIGN);

static int spe_digest_init(spe_digest_request_t *dgst)
	{
	ALIGN_HINT(dgst, SHARED_DATA_ALIGN, 0);

	return RIPEMD160_Init(&g_ctx);
	}

static int spe_digest_update(spe_digest_request_t *dgst, const void *in, unsigned int size)
	{
	ALIGN_HINT(dgst, SHARED_DATA_ALIGN, 0);
	ALIGN_HINT(in, SHARED_DATA_ALIGN, 0);

	return RIPEMD160_Update(&g_ctx, in, size);
	}

static int spe_digest_final(spe_digest_request_t *dgst, spe_digest_result_t *result)
	{
	ALIGN_HINT(dgst, SHARED_DATA_ALIGN, 0);
	ALIGN_HINT(result, SHARED_DATA_ALIGN, 0);

	return RIPEMD160_Final(result->digest, &g_ctx);
	}

#include "spe_digest.c"

#endif /* !OPENSSL_NO_RIPEMD */
