/*
 * Copyright (c) 1997 by Procom Technology,Inc.
 *
 * This program can be redistributed or modified under the terms of the 
 * GNU General Public License as published by the Free Software Foundation.
 * This program is distributed without any warranty or implied warranty
 * of merchantability or fitness for a particular purpose.
 *
 * See the GNU General Public License for more details.
 *
 */
 
/* 
 * Defines the SAP component 
 */

#ifndef LLC_SAP_H
#define LLC_SAP_H


typedef struct
{
   us8                 state;
   mph_t               mp_handle;
   void *              parent_station;
   us8                 p_bit;              /* only lowest-order bit used */
   us8                 f_bit;              /* only lowest-order bit used */
   primitive_call_t    request;            /* provided by LLC layer */
   primitive_call_t    response;           /* provided by LLC layer */
   primitive_call_t    indicate;           /* provided by network layer */
   primitive_call_t    confirm;            /* provided by network layer */
   address_t           local_dl_addr;      /* SAP value in this 'lsap' */
   dll_t               connection_list;    /* connection this one manages */
   dll_t               avail_events;       /* events available for queuing */
   dll_t               event_q;
   dll_t               mac_pdu_q;          /* PDUs ready to send to MAC */
   dll_t               nwk_pdu_q;          /* PDUs rdy to send to network */
} sap_t;


#ifdef LLC_SAP_C
#define EXTRN
#else
#define EXTRN extern
#endif /* LLC_SAP_C */


EXTRN us16         sap_initialize (sap_t * sap);
EXTRN us16         sap_assign_conn (sap_t * sap, void * connection);
EXTRN us16         sap_unassign_conn (sap_t * sap, void * connection);
EXTRN us16         sap_find_conn (sap_t * sap, address_t * remote_addr,
                                                         void ** conn_ptr);
EXTRN us16         sap_get_event (sap_t * sap, void ** event);
EXTRN us16         sap_send_event (sap_t * sap, void * event);
EXTRN us16         sap_rtn_pdu (sap_t * sap, frame_t * pdu_frame, void *event);
EXTRN us16         sap_send_pdu (sap_t * sap, frame_t * pdu);


#undef EXTRN
#endif /* LLC_SAP_H */

