/*
 * Copyright (c) 1997 by Procom Technology,Inc.
 *
 * This program can be redistributed or modified under the terms of the 
 * GNU General Public License as published by the Free Software Foundation.
 * This program is distributed without any warranty or implied warranty
 * of merchantability or fitness for a particular purpose.
 *
 * See the GNU General Public License for more details.
 *
 */
 
/* 
 * Station component state transition events 
 */

#ifndef LLC_EVNT_H
#define LLC_EVNT_H


/* Types of events (possible values in 'event->type') */
#define STATION_EV_TYPE_SIMPLE         1
#define STATION_EV_TYPE_CONDITION      2
#define STATION_EV_TYPE_PRIM           3
#define STATION_EV_TYPE_PDU            4       /* command/response PDU */
#define STATION_EV_TYPE_ACK_TIMER      5
#define STATION_EV_TYPE_RPT_STATUS     6


/* Events */
#define STATION_EV_ENABLE_WITH_DUP_ADDR_CHECK                  1
#define STATION_EV_ENABLE_WITHOUT_DUP_ADDR_CHECK               2
#define STATION_EV_ACK_TIMER_EXPIRED_LT_RETRY_COUNT_MAX_RETRY  3
#define STATION_EV_ACK_TIMER_EXPIRED_EQ_RETRY_COUNT_MAX_RETRY  4
#define STATION_EV_RX_NULL_DSAP_XID_C                          5
#define STATION_EV_RX_NULL_DSAP_0_XID_R_XID_R_COUNT_EQ         6
#define STATION_EV_RX_NULL_DSAP_1_XID_R_XID_R_COUNT_EQ         7
#define STATION_EV_RX_NULL_DSAP_TEST_C                         8
#define STATION_EV_DISABLE_REQUEST                             9


/* Interfaces for various types of supported events */

typedef struct
{
   us8             event;
} stat_event_simple_if_t;


typedef struct
{
   us8             prim;       /* connect, disconnect, reset, ... */
   us8             type;       /* request, indicate, response, confirm */
} stat_event_prim_if_t;


typedef struct
{                      
/*   us8               event; */
   us8                 reason;
   frame_t *           frame;
} stat_event_pdu_if_t;


typedef struct
{
   void *           timer_specific;
} stat_event_timer_if_t;


typedef struct
{
   us8             status;
} stat_event_rpt_sts_if_t;


typedef union
{
   stat_event_simple_if_t  a;          /* 'a' for simple, easy ... */
   stat_event_prim_if_t    prim;
   stat_event_pdu_if_t     pdu;
   stat_event_timer_if_t   tmr;
   stat_event_rpt_sts_if_t rsts;       /* report status */
} stat_event_if_t;


typedef struct
{
   us8                 type;
   stat_event_if_t     data;
} station_state_event_t;


typedef us16       (*station_event_t)(station_t * station, 
                                             station_state_event_t *event);


#ifdef LLC_EVNT_C
#define EXTRN
#else
#define EXTRN extern
#endif /* LLC_EVNT_C */


EXTRN us16     stat_ev_enable_with_dup_addr_check (station_t * station,
                                              station_state_event_t *event);
EXTRN us16     stat_ev_enable_without_dup_addr_check (station_t * station,
                                              station_state_event_t *event);
EXTRN us16     stat_ev_ack_timer_expired_lt_retry_count_max_retry (
                         station_t * station, station_state_event_t *event);
EXTRN us16     stat_ev_ack_timer_expired_eq_retry_count_max_retry (
                         station_t * station, station_state_event_t *event);
EXTRN us16     stat_ev_rx_null_dsap_xid_c (station_t * station,
                                              station_state_event_t *event);
EXTRN us16     stat_ev_rx_null_dsap_0_xid_r_xid_r_count_eq (
                         station_t * station, station_state_event_t *event);
EXTRN us16     stat_ev_rx_null_dsap_1_xid_r_xid_r_count_eq (
                         station_t * station, station_state_event_t *event);
EXTRN us16     stat_ev_rx_null_dsap_test_c (station_t * station,
                                              station_state_event_t *event);
EXTRN us16     stat_ev_disable_request (station_t * station, 
                                              station_state_event_t *event);


#undef EXTRN
#endif /* LLC_EVNT_H */


