/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "k8s.io/api/apps/v1"
	appsv1 "k8s.io/client-go/applyconfigurations/apps/v1"
	gentype "k8s.io/client-go/gentype"
	typedappsv1 "k8s.io/client-go/kubernetes/typed/apps/v1"
)

// fakeDaemonSets implements DaemonSetInterface
type fakeDaemonSets struct {
	*gentype.FakeClientWithListAndApply[*v1.DaemonSet, *v1.DaemonSetList, *appsv1.DaemonSetApplyConfiguration]
	Fake *FakeAppsV1
}

func newFakeDaemonSets(fake *FakeAppsV1, namespace string) typedappsv1.DaemonSetInterface {
	return &fakeDaemonSets{
		gentype.NewFakeClientWithListAndApply[*v1.DaemonSet, *v1.DaemonSetList, *appsv1.DaemonSetApplyConfiguration](
			fake.Fake,
			namespace,
			v1.SchemeGroupVersion.WithResource("daemonsets"),
			v1.SchemeGroupVersion.WithKind("DaemonSet"),
			func() *v1.DaemonSet { return &v1.DaemonSet{} },
			func() *v1.DaemonSetList { return &v1.DaemonSetList{} },
			func(dst, src *v1.DaemonSetList) { dst.ListMeta = src.ListMeta },
			func(list *v1.DaemonSetList) []*v1.DaemonSet { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.DaemonSetList, items []*v1.DaemonSet) { list.Items = gentype.FromPointerSlice(items) },
		),
		fake,
	}
}
