package network

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"bytes"
	"encoding/json"
	"fmt"
	"strconv"
	"strings"

	"github.com/chromedp/cdproto/cdp"
	"github.com/chromedp/cdproto/io"
	"github.com/chromedp/cdproto/runtime"
	"github.com/chromedp/cdproto/security"
	"github.com/go-json-experiment/json/jsontext"
)

// ResourceType resource type as it was perceived by the rendering engine.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-ResourceType
type ResourceType string

// String returns the ResourceType as string value.
func (t ResourceType) String() string {
	return string(t)
}

// ResourceType values.
const (
	ResourceTypeDocument           ResourceType = "Document"
	ResourceTypeStylesheet         ResourceType = "Stylesheet"
	ResourceTypeImage              ResourceType = "Image"
	ResourceTypeMedia              ResourceType = "Media"
	ResourceTypeFont               ResourceType = "Font"
	ResourceTypeScript             ResourceType = "Script"
	ResourceTypeTextTrack          ResourceType = "TextTrack"
	ResourceTypeXHR                ResourceType = "XHR"
	ResourceTypeFetch              ResourceType = "Fetch"
	ResourceTypePrefetch           ResourceType = "Prefetch"
	ResourceTypeEventSource        ResourceType = "EventSource"
	ResourceTypeWebSocket          ResourceType = "WebSocket"
	ResourceTypeManifest           ResourceType = "Manifest"
	ResourceTypeSignedExchange     ResourceType = "SignedExchange"
	ResourceTypePing               ResourceType = "Ping"
	ResourceTypeCSPViolationReport ResourceType = "CSPViolationReport"
	ResourceTypePreflight          ResourceType = "Preflight"
	ResourceTypeOther              ResourceType = "Other"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *ResourceType) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch ResourceType(s) {
	case ResourceTypeDocument:
		*t = ResourceTypeDocument
	case ResourceTypeStylesheet:
		*t = ResourceTypeStylesheet
	case ResourceTypeImage:
		*t = ResourceTypeImage
	case ResourceTypeMedia:
		*t = ResourceTypeMedia
	case ResourceTypeFont:
		*t = ResourceTypeFont
	case ResourceTypeScript:
		*t = ResourceTypeScript
	case ResourceTypeTextTrack:
		*t = ResourceTypeTextTrack
	case ResourceTypeXHR:
		*t = ResourceTypeXHR
	case ResourceTypeFetch:
		*t = ResourceTypeFetch
	case ResourceTypePrefetch:
		*t = ResourceTypePrefetch
	case ResourceTypeEventSource:
		*t = ResourceTypeEventSource
	case ResourceTypeWebSocket:
		*t = ResourceTypeWebSocket
	case ResourceTypeManifest:
		*t = ResourceTypeManifest
	case ResourceTypeSignedExchange:
		*t = ResourceTypeSignedExchange
	case ResourceTypePing:
		*t = ResourceTypePing
	case ResourceTypeCSPViolationReport:
		*t = ResourceTypeCSPViolationReport
	case ResourceTypePreflight:
		*t = ResourceTypePreflight
	case ResourceTypeOther:
		*t = ResourceTypeOther
	default:
		return fmt.Errorf("unknown ResourceType value: %v", s)
	}
	return nil
}

// RequestID unique network request identifier. Note that this does not
// identify individual HTTP requests that are part of a network request.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-RequestId
type RequestID string

// String returns the RequestID as string value.
func (t RequestID) String() string {
	return string(t)
}

// InterceptionID unique intercepted request identifier.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-InterceptionId
type InterceptionID string

// String returns the InterceptionID as string value.
func (t InterceptionID) String() string {
	return string(t)
}

// ErrorReason network level fetch failure reason.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-ErrorReason
type ErrorReason string

// String returns the ErrorReason as string value.
func (t ErrorReason) String() string {
	return string(t)
}

// ErrorReason values.
const (
	ErrorReasonFailed               ErrorReason = "Failed"
	ErrorReasonAborted              ErrorReason = "Aborted"
	ErrorReasonTimedOut             ErrorReason = "TimedOut"
	ErrorReasonAccessDenied         ErrorReason = "AccessDenied"
	ErrorReasonConnectionClosed     ErrorReason = "ConnectionClosed"
	ErrorReasonConnectionReset      ErrorReason = "ConnectionReset"
	ErrorReasonConnectionRefused    ErrorReason = "ConnectionRefused"
	ErrorReasonConnectionAborted    ErrorReason = "ConnectionAborted"
	ErrorReasonConnectionFailed     ErrorReason = "ConnectionFailed"
	ErrorReasonNameNotResolved      ErrorReason = "NameNotResolved"
	ErrorReasonInternetDisconnected ErrorReason = "InternetDisconnected"
	ErrorReasonAddressUnreachable   ErrorReason = "AddressUnreachable"
	ErrorReasonBlockedByClient      ErrorReason = "BlockedByClient"
	ErrorReasonBlockedByResponse    ErrorReason = "BlockedByResponse"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *ErrorReason) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch ErrorReason(s) {
	case ErrorReasonFailed:
		*t = ErrorReasonFailed
	case ErrorReasonAborted:
		*t = ErrorReasonAborted
	case ErrorReasonTimedOut:
		*t = ErrorReasonTimedOut
	case ErrorReasonAccessDenied:
		*t = ErrorReasonAccessDenied
	case ErrorReasonConnectionClosed:
		*t = ErrorReasonConnectionClosed
	case ErrorReasonConnectionReset:
		*t = ErrorReasonConnectionReset
	case ErrorReasonConnectionRefused:
		*t = ErrorReasonConnectionRefused
	case ErrorReasonConnectionAborted:
		*t = ErrorReasonConnectionAborted
	case ErrorReasonConnectionFailed:
		*t = ErrorReasonConnectionFailed
	case ErrorReasonNameNotResolved:
		*t = ErrorReasonNameNotResolved
	case ErrorReasonInternetDisconnected:
		*t = ErrorReasonInternetDisconnected
	case ErrorReasonAddressUnreachable:
		*t = ErrorReasonAddressUnreachable
	case ErrorReasonBlockedByClient:
		*t = ErrorReasonBlockedByClient
	case ErrorReasonBlockedByResponse:
		*t = ErrorReasonBlockedByResponse
	default:
		return fmt.Errorf("unknown ErrorReason value: %v", s)
	}
	return nil
}

// Headers request / response headers as keys / values of JSON object.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-Headers
type Headers map[string]any

// ConnectionType the underlying connection technology that the browser is
// supposedly using.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-ConnectionType
type ConnectionType string

// String returns the ConnectionType as string value.
func (t ConnectionType) String() string {
	return string(t)
}

// ConnectionType values.
const (
	ConnectionTypeNone       ConnectionType = "none"
	ConnectionTypeCellular2g ConnectionType = "cellular2g"
	ConnectionTypeCellular3g ConnectionType = "cellular3g"
	ConnectionTypeCellular4g ConnectionType = "cellular4g"
	ConnectionTypeBluetooth  ConnectionType = "bluetooth"
	ConnectionTypeEthernet   ConnectionType = "ethernet"
	ConnectionTypeWifi       ConnectionType = "wifi"
	ConnectionTypeWimax      ConnectionType = "wimax"
	ConnectionTypeOther      ConnectionType = "other"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *ConnectionType) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch ConnectionType(s) {
	case ConnectionTypeNone:
		*t = ConnectionTypeNone
	case ConnectionTypeCellular2g:
		*t = ConnectionTypeCellular2g
	case ConnectionTypeCellular3g:
		*t = ConnectionTypeCellular3g
	case ConnectionTypeCellular4g:
		*t = ConnectionTypeCellular4g
	case ConnectionTypeBluetooth:
		*t = ConnectionTypeBluetooth
	case ConnectionTypeEthernet:
		*t = ConnectionTypeEthernet
	case ConnectionTypeWifi:
		*t = ConnectionTypeWifi
	case ConnectionTypeWimax:
		*t = ConnectionTypeWimax
	case ConnectionTypeOther:
		*t = ConnectionTypeOther
	default:
		return fmt.Errorf("unknown ConnectionType value: %v", s)
	}
	return nil
}

// CookieSameSite represents the cookie's 'SameSite' status:
// https://tools.ietf.org/html/draft-west-first-party-cookies.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-CookieSameSite
type CookieSameSite string

// String returns the CookieSameSite as string value.
func (t CookieSameSite) String() string {
	return string(t)
}

// CookieSameSite values.
const (
	CookieSameSiteStrict CookieSameSite = "Strict"
	CookieSameSiteLax    CookieSameSite = "Lax"
	CookieSameSiteNone   CookieSameSite = "None"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *CookieSameSite) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch CookieSameSite(s) {
	case CookieSameSiteStrict:
		*t = CookieSameSiteStrict
	case CookieSameSiteLax:
		*t = CookieSameSiteLax
	case CookieSameSiteNone:
		*t = CookieSameSiteNone
	default:
		return fmt.Errorf("unknown CookieSameSite value: %v", s)
	}
	return nil
}

// CookiePriority represents the cookie's 'Priority' status:
// https://tools.ietf.org/html/draft-west-cookie-priority-00.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-CookiePriority
type CookiePriority string

// String returns the CookiePriority as string value.
func (t CookiePriority) String() string {
	return string(t)
}

// CookiePriority values.
const (
	CookiePriorityLow    CookiePriority = "Low"
	CookiePriorityMedium CookiePriority = "Medium"
	CookiePriorityHigh   CookiePriority = "High"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *CookiePriority) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch CookiePriority(s) {
	case CookiePriorityLow:
		*t = CookiePriorityLow
	case CookiePriorityMedium:
		*t = CookiePriorityMedium
	case CookiePriorityHigh:
		*t = CookiePriorityHigh
	default:
		return fmt.Errorf("unknown CookiePriority value: %v", s)
	}
	return nil
}

// CookieSourceScheme represents the source scheme of the origin that
// originally set the cookie. A value of "Unset" allows protocol clients to
// emulate legacy cookie scope for the scheme. This is a temporary ability and
// it will be removed in the future.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-CookieSourceScheme
type CookieSourceScheme string

// String returns the CookieSourceScheme as string value.
func (t CookieSourceScheme) String() string {
	return string(t)
}

// CookieSourceScheme values.
const (
	CookieSourceSchemeUnset     CookieSourceScheme = "Unset"
	CookieSourceSchemeNonSecure CookieSourceScheme = "NonSecure"
	CookieSourceSchemeSecure    CookieSourceScheme = "Secure"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *CookieSourceScheme) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch CookieSourceScheme(s) {
	case CookieSourceSchemeUnset:
		*t = CookieSourceSchemeUnset
	case CookieSourceSchemeNonSecure:
		*t = CookieSourceSchemeNonSecure
	case CookieSourceSchemeSecure:
		*t = CookieSourceSchemeSecure
	default:
		return fmt.Errorf("unknown CookieSourceScheme value: %v", s)
	}
	return nil
}

// ResourceTiming timing information for the request.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-ResourceTiming
type ResourceTiming struct {
	RequestTime                 float64 `json:"requestTime"`                                    // Timing's requestTime is a baseline in seconds, while the other numbers are ticks in milliseconds relatively to this requestTime.
	ProxyStart                  float64 `json:"proxyStart"`                                     // Started resolving proxy.
	ProxyEnd                    float64 `json:"proxyEnd"`                                       // Finished resolving proxy.
	DNSStart                    float64 `json:"dnsStart"`                                       // Started DNS address resolve.
	DNSEnd                      float64 `json:"dnsEnd"`                                         // Finished DNS address resolve.
	ConnectStart                float64 `json:"connectStart"`                                   // Started connecting to the remote host.
	ConnectEnd                  float64 `json:"connectEnd"`                                     // Connected to the remote host.
	SslStart                    float64 `json:"sslStart"`                                       // Started SSL handshake.
	SslEnd                      float64 `json:"sslEnd"`                                         // Finished SSL handshake.
	WorkerStart                 float64 `json:"workerStart"`                                    // Started running ServiceWorker.
	WorkerReady                 float64 `json:"workerReady"`                                    // Finished Starting ServiceWorker.
	WorkerFetchStart            float64 `json:"workerFetchStart"`                               // Started fetch event.
	WorkerRespondWithSettled    float64 `json:"workerRespondWithSettled"`                       // Settled fetch event respondWith promise.
	WorkerRouterEvaluationStart float64 `json:"workerRouterEvaluationStart,omitempty,omitzero"` // Started ServiceWorker static routing source evaluation.
	WorkerCacheLookupStart      float64 `json:"workerCacheLookupStart,omitempty,omitzero"`      // Started cache lookup when the source was evaluated to cache.
	SendStart                   float64 `json:"sendStart"`                                      // Started sending request.
	SendEnd                     float64 `json:"sendEnd"`                                        // Finished sending request.
	PushStart                   float64 `json:"pushStart"`                                      // Time the server started pushing request.
	PushEnd                     float64 `json:"pushEnd"`                                        // Time the server finished pushing request.
	ReceiveHeadersStart         float64 `json:"receiveHeadersStart"`                            // Started receiving response headers.
	ReceiveHeadersEnd           float64 `json:"receiveHeadersEnd"`                              // Finished receiving response headers.
}

// ResourcePriority loading priority of a resource request.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-ResourcePriority
type ResourcePriority string

// String returns the ResourcePriority as string value.
func (t ResourcePriority) String() string {
	return string(t)
}

// ResourcePriority values.
const (
	ResourcePriorityVeryLow  ResourcePriority = "VeryLow"
	ResourcePriorityLow      ResourcePriority = "Low"
	ResourcePriorityMedium   ResourcePriority = "Medium"
	ResourcePriorityHigh     ResourcePriority = "High"
	ResourcePriorityVeryHigh ResourcePriority = "VeryHigh"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *ResourcePriority) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch ResourcePriority(s) {
	case ResourcePriorityVeryLow:
		*t = ResourcePriorityVeryLow
	case ResourcePriorityLow:
		*t = ResourcePriorityLow
	case ResourcePriorityMedium:
		*t = ResourcePriorityMedium
	case ResourcePriorityHigh:
		*t = ResourcePriorityHigh
	case ResourcePriorityVeryHigh:
		*t = ResourcePriorityVeryHigh
	default:
		return fmt.Errorf("unknown ResourcePriority value: %v", s)
	}
	return nil
}

// PostDataEntry post data entry for HTTP request.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-PostDataEntry
type PostDataEntry struct {
	Bytes string `json:"bytes,omitempty,omitzero"`
}

// Request HTTP request data.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-Request
type Request struct {
	URL              string                    `json:"url"`                                 // Request URL (without fragment).
	URLFragment      string                    `json:"urlFragment,omitempty,omitzero"`      // Fragment of the requested URL starting with hash, if present.
	Method           string                    `json:"method"`                              // HTTP request method.
	Headers          Headers                   `json:"headers"`                             // HTTP request headers.
	HasPostData      bool                      `json:"hasPostData,omitempty,omitzero"`      // True when the request has POST data. Note that postData might still be omitted when this flag is true when the data is too long.
	PostDataEntries  []*PostDataEntry          `json:"postDataEntries,omitempty,omitzero"`  // Request body elements (post data broken into individual entries).
	MixedContentType security.MixedContentType `json:"mixedContentType,omitempty,omitzero"` // The mixed content type of the request.
	InitialPriority  ResourcePriority          `json:"initialPriority"`                     // Priority of the resource request at the time request is sent.
	ReferrerPolicy   ReferrerPolicy            `json:"referrerPolicy"`                      // The referrer policy of the request, as defined in https://www.w3.org/TR/referrer-policy/
	IsLinkPreload    bool                      `json:"isLinkPreload,omitempty,omitzero"`    // Whether is loaded via link preload.
	TrustTokenParams *TrustTokenParams         `json:"trustTokenParams,omitempty,omitzero"` // Set for requests when the TrustToken API is used. Contains the parameters passed by the developer (e.g. via "fetch") as understood by the backend.
	IsSameSite       bool                      `json:"isSameSite,omitempty,omitzero"`       // True if this resource request is considered to be the 'same site' as the request corresponding to the main frame.
}

// SignedCertificateTimestamp details of a signed certificate timestamp
// (SCT).
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-SignedCertificateTimestamp
type SignedCertificateTimestamp struct {
	Status             string  `json:"status"`             // Validation status.
	Origin             string  `json:"origin"`             // Origin.
	LogDescription     string  `json:"logDescription"`     // Log name / description.
	LogID              string  `json:"logId"`              // Log ID.
	Timestamp          float64 `json:"timestamp"`          // Issuance date. Unlike TimeSinceEpoch, this contains the number of milliseconds since January 1, 1970, UTC, not the number of seconds.
	HashAlgorithm      string  `json:"hashAlgorithm"`      // Hash algorithm.
	SignatureAlgorithm string  `json:"signatureAlgorithm"` // Signature algorithm.
	SignatureData      string  `json:"signatureData"`      // Signature data.
}

// SecurityDetails security details about a request.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-SecurityDetails
type SecurityDetails struct {
	Protocol                          string                            `json:"protocol"`                                    // Protocol name (e.g. "TLS 1.2" or "QUIC").
	KeyExchange                       string                            `json:"keyExchange"`                                 // Key Exchange used by the connection, or the empty string if not applicable.
	KeyExchangeGroup                  string                            `json:"keyExchangeGroup,omitempty,omitzero"`         // (EC)DH group used by the connection, if applicable.
	Cipher                            string                            `json:"cipher"`                                      // Cipher name.
	Mac                               string                            `json:"mac,omitempty,omitzero"`                      // TLS MAC. Note that AEAD ciphers do not have separate MACs.
	CertificateID                     security.CertificateID            `json:"certificateId"`                               // Certificate ID value.
	SubjectName                       string                            `json:"subjectName"`                                 // Certificate subject name.
	SanList                           []string                          `json:"sanList"`                                     // Subject Alternative Name (SAN) DNS names and IP addresses.
	Issuer                            string                            `json:"issuer"`                                      // Name of the issuing CA.
	ValidFrom                         *cdp.TimeSinceEpoch               `json:"validFrom"`                                   // Certificate valid from date.
	ValidTo                           *cdp.TimeSinceEpoch               `json:"validTo"`                                     // Certificate valid to (expiration) date
	SignedCertificateTimestampList    []*SignedCertificateTimestamp     `json:"signedCertificateTimestampList"`              // List of signed certificate timestamps (SCTs).
	CertificateTransparencyCompliance CertificateTransparencyCompliance `json:"certificateTransparencyCompliance"`           // Whether the request complied with Certificate Transparency policy
	ServerSignatureAlgorithm          int64                             `json:"serverSignatureAlgorithm,omitempty,omitzero"` // The signature algorithm used by the server in the TLS server signature, represented as a TLS SignatureScheme code point. Omitted if not applicable or not known.
	EncryptedClientHello              bool                              `json:"encryptedClientHello"`                        // Whether the connection used Encrypted ClientHello
}

// CertificateTransparencyCompliance whether the request complied with
// Certificate Transparency policy.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-CertificateTransparencyCompliance
type CertificateTransparencyCompliance string

// String returns the CertificateTransparencyCompliance as string value.
func (t CertificateTransparencyCompliance) String() string {
	return string(t)
}

// CertificateTransparencyCompliance values.
const (
	CertificateTransparencyComplianceUnknown      CertificateTransparencyCompliance = "unknown"
	CertificateTransparencyComplianceNotCompliant CertificateTransparencyCompliance = "not-compliant"
	CertificateTransparencyComplianceCompliant    CertificateTransparencyCompliance = "compliant"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *CertificateTransparencyCompliance) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch CertificateTransparencyCompliance(s) {
	case CertificateTransparencyComplianceUnknown:
		*t = CertificateTransparencyComplianceUnknown
	case CertificateTransparencyComplianceNotCompliant:
		*t = CertificateTransparencyComplianceNotCompliant
	case CertificateTransparencyComplianceCompliant:
		*t = CertificateTransparencyComplianceCompliant
	default:
		return fmt.Errorf("unknown CertificateTransparencyCompliance value: %v", s)
	}
	return nil
}

// BlockedReason the reason why request was blocked.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-BlockedReason
type BlockedReason string

// String returns the BlockedReason as string value.
func (t BlockedReason) String() string {
	return string(t)
}

// BlockedReason values.
const (
	BlockedReasonOther                                                   BlockedReason = "other"
	BlockedReasonCsp                                                     BlockedReason = "csp"
	BlockedReasonMixedContent                                            BlockedReason = "mixed-content"
	BlockedReasonOrigin                                                  BlockedReason = "origin"
	BlockedReasonInspector                                               BlockedReason = "inspector"
	BlockedReasonSubresourceFilter                                       BlockedReason = "subresource-filter"
	BlockedReasonContentType                                             BlockedReason = "content-type"
	BlockedReasonCoepFrameResourceNeedsCoepHeader                        BlockedReason = "coep-frame-resource-needs-coep-header"
	BlockedReasonCoopSandboxedIframeCannotNavigateToCoopPage             BlockedReason = "coop-sandboxed-iframe-cannot-navigate-to-coop-page"
	BlockedReasonCorpNotSameOrigin                                       BlockedReason = "corp-not-same-origin"
	BlockedReasonCorpNotSameOriginAfterDefaultedToSameOriginByCoep       BlockedReason = "corp-not-same-origin-after-defaulted-to-same-origin-by-coep"
	BlockedReasonCorpNotSameOriginAfterDefaultedToSameOriginByDip        BlockedReason = "corp-not-same-origin-after-defaulted-to-same-origin-by-dip"
	BlockedReasonCorpNotSameOriginAfterDefaultedToSameOriginByCoepAndDip BlockedReason = "corp-not-same-origin-after-defaulted-to-same-origin-by-coep-and-dip"
	BlockedReasonCorpNotSameSite                                         BlockedReason = "corp-not-same-site"
	BlockedReasonSriMessageSignatureMismatch                             BlockedReason = "sri-message-signature-mismatch"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *BlockedReason) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch BlockedReason(s) {
	case BlockedReasonOther:
		*t = BlockedReasonOther
	case BlockedReasonCsp:
		*t = BlockedReasonCsp
	case BlockedReasonMixedContent:
		*t = BlockedReasonMixedContent
	case BlockedReasonOrigin:
		*t = BlockedReasonOrigin
	case BlockedReasonInspector:
		*t = BlockedReasonInspector
	case BlockedReasonSubresourceFilter:
		*t = BlockedReasonSubresourceFilter
	case BlockedReasonContentType:
		*t = BlockedReasonContentType
	case BlockedReasonCoepFrameResourceNeedsCoepHeader:
		*t = BlockedReasonCoepFrameResourceNeedsCoepHeader
	case BlockedReasonCoopSandboxedIframeCannotNavigateToCoopPage:
		*t = BlockedReasonCoopSandboxedIframeCannotNavigateToCoopPage
	case BlockedReasonCorpNotSameOrigin:
		*t = BlockedReasonCorpNotSameOrigin
	case BlockedReasonCorpNotSameOriginAfterDefaultedToSameOriginByCoep:
		*t = BlockedReasonCorpNotSameOriginAfterDefaultedToSameOriginByCoep
	case BlockedReasonCorpNotSameOriginAfterDefaultedToSameOriginByDip:
		*t = BlockedReasonCorpNotSameOriginAfterDefaultedToSameOriginByDip
	case BlockedReasonCorpNotSameOriginAfterDefaultedToSameOriginByCoepAndDip:
		*t = BlockedReasonCorpNotSameOriginAfterDefaultedToSameOriginByCoepAndDip
	case BlockedReasonCorpNotSameSite:
		*t = BlockedReasonCorpNotSameSite
	case BlockedReasonSriMessageSignatureMismatch:
		*t = BlockedReasonSriMessageSignatureMismatch
	default:
		return fmt.Errorf("unknown BlockedReason value: %v", s)
	}
	return nil
}

// CorsError the reason why request was blocked.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-CorsError
type CorsError string

// String returns the CorsError as string value.
func (t CorsError) String() string {
	return string(t)
}

// CorsError values.
const (
	CorsErrorDisallowedByMode                          CorsError = "DisallowedByMode"
	CorsErrorInvalidResponse                           CorsError = "InvalidResponse"
	CorsErrorWildcardOriginNotAllowed                  CorsError = "WildcardOriginNotAllowed"
	CorsErrorMissingAllowOriginHeader                  CorsError = "MissingAllowOriginHeader"
	CorsErrorMultipleAllowOriginValues                 CorsError = "MultipleAllowOriginValues"
	CorsErrorInvalidAllowOriginValue                   CorsError = "InvalidAllowOriginValue"
	CorsErrorAllowOriginMismatch                       CorsError = "AllowOriginMismatch"
	CorsErrorInvalidAllowCredentials                   CorsError = "InvalidAllowCredentials"
	CorsErrorCorsDisabledScheme                        CorsError = "CorsDisabledScheme"
	CorsErrorPreflightInvalidStatus                    CorsError = "PreflightInvalidStatus"
	CorsErrorPreflightDisallowedRedirect               CorsError = "PreflightDisallowedRedirect"
	CorsErrorPreflightWildcardOriginNotAllowed         CorsError = "PreflightWildcardOriginNotAllowed"
	CorsErrorPreflightMissingAllowOriginHeader         CorsError = "PreflightMissingAllowOriginHeader"
	CorsErrorPreflightMultipleAllowOriginValues        CorsError = "PreflightMultipleAllowOriginValues"
	CorsErrorPreflightInvalidAllowOriginValue          CorsError = "PreflightInvalidAllowOriginValue"
	CorsErrorPreflightAllowOriginMismatch              CorsError = "PreflightAllowOriginMismatch"
	CorsErrorPreflightInvalidAllowCredentials          CorsError = "PreflightInvalidAllowCredentials"
	CorsErrorPreflightMissingAllowExternal             CorsError = "PreflightMissingAllowExternal"
	CorsErrorPreflightInvalidAllowExternal             CorsError = "PreflightInvalidAllowExternal"
	CorsErrorPreflightMissingAllowPrivateNetwork       CorsError = "PreflightMissingAllowPrivateNetwork"
	CorsErrorPreflightInvalidAllowPrivateNetwork       CorsError = "PreflightInvalidAllowPrivateNetwork"
	CorsErrorInvalidAllowMethodsPreflightResponse      CorsError = "InvalidAllowMethodsPreflightResponse"
	CorsErrorInvalidAllowHeadersPreflightResponse      CorsError = "InvalidAllowHeadersPreflightResponse"
	CorsErrorMethodDisallowedByPreflightResponse       CorsError = "MethodDisallowedByPreflightResponse"
	CorsErrorHeaderDisallowedByPreflightResponse       CorsError = "HeaderDisallowedByPreflightResponse"
	CorsErrorRedirectContainsCredentials               CorsError = "RedirectContainsCredentials"
	CorsErrorInsecurePrivateNetwork                    CorsError = "InsecurePrivateNetwork"
	CorsErrorInvalidPrivateNetworkAccess               CorsError = "InvalidPrivateNetworkAccess"
	CorsErrorUnexpectedPrivateNetworkAccess            CorsError = "UnexpectedPrivateNetworkAccess"
	CorsErrorNoCorsRedirectModeNotFollow               CorsError = "NoCorsRedirectModeNotFollow"
	CorsErrorPreflightMissingPrivateNetworkAccessID    CorsError = "PreflightMissingPrivateNetworkAccessId"
	CorsErrorPreflightMissingPrivateNetworkAccessName  CorsError = "PreflightMissingPrivateNetworkAccessName"
	CorsErrorPrivateNetworkAccessPermissionUnavailable CorsError = "PrivateNetworkAccessPermissionUnavailable"
	CorsErrorPrivateNetworkAccessPermissionDenied      CorsError = "PrivateNetworkAccessPermissionDenied"
	CorsErrorLocalNetworkAccessPermissionDenied        CorsError = "LocalNetworkAccessPermissionDenied"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *CorsError) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch CorsError(s) {
	case CorsErrorDisallowedByMode:
		*t = CorsErrorDisallowedByMode
	case CorsErrorInvalidResponse:
		*t = CorsErrorInvalidResponse
	case CorsErrorWildcardOriginNotAllowed:
		*t = CorsErrorWildcardOriginNotAllowed
	case CorsErrorMissingAllowOriginHeader:
		*t = CorsErrorMissingAllowOriginHeader
	case CorsErrorMultipleAllowOriginValues:
		*t = CorsErrorMultipleAllowOriginValues
	case CorsErrorInvalidAllowOriginValue:
		*t = CorsErrorInvalidAllowOriginValue
	case CorsErrorAllowOriginMismatch:
		*t = CorsErrorAllowOriginMismatch
	case CorsErrorInvalidAllowCredentials:
		*t = CorsErrorInvalidAllowCredentials
	case CorsErrorCorsDisabledScheme:
		*t = CorsErrorCorsDisabledScheme
	case CorsErrorPreflightInvalidStatus:
		*t = CorsErrorPreflightInvalidStatus
	case CorsErrorPreflightDisallowedRedirect:
		*t = CorsErrorPreflightDisallowedRedirect
	case CorsErrorPreflightWildcardOriginNotAllowed:
		*t = CorsErrorPreflightWildcardOriginNotAllowed
	case CorsErrorPreflightMissingAllowOriginHeader:
		*t = CorsErrorPreflightMissingAllowOriginHeader
	case CorsErrorPreflightMultipleAllowOriginValues:
		*t = CorsErrorPreflightMultipleAllowOriginValues
	case CorsErrorPreflightInvalidAllowOriginValue:
		*t = CorsErrorPreflightInvalidAllowOriginValue
	case CorsErrorPreflightAllowOriginMismatch:
		*t = CorsErrorPreflightAllowOriginMismatch
	case CorsErrorPreflightInvalidAllowCredentials:
		*t = CorsErrorPreflightInvalidAllowCredentials
	case CorsErrorPreflightMissingAllowExternal:
		*t = CorsErrorPreflightMissingAllowExternal
	case CorsErrorPreflightInvalidAllowExternal:
		*t = CorsErrorPreflightInvalidAllowExternal
	case CorsErrorPreflightMissingAllowPrivateNetwork:
		*t = CorsErrorPreflightMissingAllowPrivateNetwork
	case CorsErrorPreflightInvalidAllowPrivateNetwork:
		*t = CorsErrorPreflightInvalidAllowPrivateNetwork
	case CorsErrorInvalidAllowMethodsPreflightResponse:
		*t = CorsErrorInvalidAllowMethodsPreflightResponse
	case CorsErrorInvalidAllowHeadersPreflightResponse:
		*t = CorsErrorInvalidAllowHeadersPreflightResponse
	case CorsErrorMethodDisallowedByPreflightResponse:
		*t = CorsErrorMethodDisallowedByPreflightResponse
	case CorsErrorHeaderDisallowedByPreflightResponse:
		*t = CorsErrorHeaderDisallowedByPreflightResponse
	case CorsErrorRedirectContainsCredentials:
		*t = CorsErrorRedirectContainsCredentials
	case CorsErrorInsecurePrivateNetwork:
		*t = CorsErrorInsecurePrivateNetwork
	case CorsErrorInvalidPrivateNetworkAccess:
		*t = CorsErrorInvalidPrivateNetworkAccess
	case CorsErrorUnexpectedPrivateNetworkAccess:
		*t = CorsErrorUnexpectedPrivateNetworkAccess
	case CorsErrorNoCorsRedirectModeNotFollow:
		*t = CorsErrorNoCorsRedirectModeNotFollow
	case CorsErrorPreflightMissingPrivateNetworkAccessID:
		*t = CorsErrorPreflightMissingPrivateNetworkAccessID
	case CorsErrorPreflightMissingPrivateNetworkAccessName:
		*t = CorsErrorPreflightMissingPrivateNetworkAccessName
	case CorsErrorPrivateNetworkAccessPermissionUnavailable:
		*t = CorsErrorPrivateNetworkAccessPermissionUnavailable
	case CorsErrorPrivateNetworkAccessPermissionDenied:
		*t = CorsErrorPrivateNetworkAccessPermissionDenied
	case CorsErrorLocalNetworkAccessPermissionDenied:
		*t = CorsErrorLocalNetworkAccessPermissionDenied
	default:
		return fmt.Errorf("unknown CorsError value: %v", s)
	}
	return nil
}

// CorsErrorStatus [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-CorsErrorStatus
type CorsErrorStatus struct {
	CorsError       CorsError `json:"corsError"`
	FailedParameter string    `json:"failedParameter"`
}

// ServiceWorkerResponseSource source of serviceworker response.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-ServiceWorkerResponseSource
type ServiceWorkerResponseSource string

// String returns the ServiceWorkerResponseSource as string value.
func (t ServiceWorkerResponseSource) String() string {
	return string(t)
}

// ServiceWorkerResponseSource values.
const (
	ServiceWorkerResponseSourceCacheStorage ServiceWorkerResponseSource = "cache-storage"
	ServiceWorkerResponseSourceHTTPCache    ServiceWorkerResponseSource = "http-cache"
	ServiceWorkerResponseSourceFallbackCode ServiceWorkerResponseSource = "fallback-code"
	ServiceWorkerResponseSourceNetwork      ServiceWorkerResponseSource = "network"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *ServiceWorkerResponseSource) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch ServiceWorkerResponseSource(s) {
	case ServiceWorkerResponseSourceCacheStorage:
		*t = ServiceWorkerResponseSourceCacheStorage
	case ServiceWorkerResponseSourceHTTPCache:
		*t = ServiceWorkerResponseSourceHTTPCache
	case ServiceWorkerResponseSourceFallbackCode:
		*t = ServiceWorkerResponseSourceFallbackCode
	case ServiceWorkerResponseSourceNetwork:
		*t = ServiceWorkerResponseSourceNetwork
	default:
		return fmt.Errorf("unknown ServiceWorkerResponseSource value: %v", s)
	}
	return nil
}

// TrustTokenParams determines what type of Trust Token operation is executed
// and depending on the type, some additional parameters. The values are
// specified in third_party/blink/renderer/core/fetch/trust_token.idl.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-TrustTokenParams
type TrustTokenParams struct {
	Operation     TrustTokenOperationType       `json:"operation"`
	RefreshPolicy TrustTokenParamsRefreshPolicy `json:"refreshPolicy"`              // Only set for "token-redemption" operation and determine whether to request a fresh SRR or use a still valid cached SRR.
	Issuers       []string                      `json:"issuers,omitempty,omitzero"` // Origins of issuers from whom to request tokens or redemption records.
}

// TrustTokenOperationType [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-TrustTokenOperationType
type TrustTokenOperationType string

// String returns the TrustTokenOperationType as string value.
func (t TrustTokenOperationType) String() string {
	return string(t)
}

// TrustTokenOperationType values.
const (
	TrustTokenOperationTypeIssuance   TrustTokenOperationType = "Issuance"
	TrustTokenOperationTypeRedemption TrustTokenOperationType = "Redemption"
	TrustTokenOperationTypeSigning    TrustTokenOperationType = "Signing"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *TrustTokenOperationType) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch TrustTokenOperationType(s) {
	case TrustTokenOperationTypeIssuance:
		*t = TrustTokenOperationTypeIssuance
	case TrustTokenOperationTypeRedemption:
		*t = TrustTokenOperationTypeRedemption
	case TrustTokenOperationTypeSigning:
		*t = TrustTokenOperationTypeSigning
	default:
		return fmt.Errorf("unknown TrustTokenOperationType value: %v", s)
	}
	return nil
}

// AlternateProtocolUsage the reason why Chrome uses a specific transport
// protocol for HTTP semantics.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-AlternateProtocolUsage
type AlternateProtocolUsage string

// String returns the AlternateProtocolUsage as string value.
func (t AlternateProtocolUsage) String() string {
	return string(t)
}

// AlternateProtocolUsage values.
const (
	AlternateProtocolUsageAlternativeJobWonWithoutRace AlternateProtocolUsage = "alternativeJobWonWithoutRace"
	AlternateProtocolUsageAlternativeJobWonRace        AlternateProtocolUsage = "alternativeJobWonRace"
	AlternateProtocolUsageMainJobWonRace               AlternateProtocolUsage = "mainJobWonRace"
	AlternateProtocolUsageMappingMissing               AlternateProtocolUsage = "mappingMissing"
	AlternateProtocolUsageBroken                       AlternateProtocolUsage = "broken"
	AlternateProtocolUsageDNSAlpnH3jobWonWithoutRace   AlternateProtocolUsage = "dnsAlpnH3JobWonWithoutRace"
	AlternateProtocolUsageDNSAlpnH3jobWonRace          AlternateProtocolUsage = "dnsAlpnH3JobWonRace"
	AlternateProtocolUsageUnspecifiedReason            AlternateProtocolUsage = "unspecifiedReason"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *AlternateProtocolUsage) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch AlternateProtocolUsage(s) {
	case AlternateProtocolUsageAlternativeJobWonWithoutRace:
		*t = AlternateProtocolUsageAlternativeJobWonWithoutRace
	case AlternateProtocolUsageAlternativeJobWonRace:
		*t = AlternateProtocolUsageAlternativeJobWonRace
	case AlternateProtocolUsageMainJobWonRace:
		*t = AlternateProtocolUsageMainJobWonRace
	case AlternateProtocolUsageMappingMissing:
		*t = AlternateProtocolUsageMappingMissing
	case AlternateProtocolUsageBroken:
		*t = AlternateProtocolUsageBroken
	case AlternateProtocolUsageDNSAlpnH3jobWonWithoutRace:
		*t = AlternateProtocolUsageDNSAlpnH3jobWonWithoutRace
	case AlternateProtocolUsageDNSAlpnH3jobWonRace:
		*t = AlternateProtocolUsageDNSAlpnH3jobWonRace
	case AlternateProtocolUsageUnspecifiedReason:
		*t = AlternateProtocolUsageUnspecifiedReason
	default:
		return fmt.Errorf("unknown AlternateProtocolUsage value: %v", s)
	}
	return nil
}

// ServiceWorkerRouterSource source of service worker router.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-ServiceWorkerRouterSource
type ServiceWorkerRouterSource string

// String returns the ServiceWorkerRouterSource as string value.
func (t ServiceWorkerRouterSource) String() string {
	return string(t)
}

// ServiceWorkerRouterSource values.
const (
	ServiceWorkerRouterSourceNetwork                    ServiceWorkerRouterSource = "network"
	ServiceWorkerRouterSourceCache                      ServiceWorkerRouterSource = "cache"
	ServiceWorkerRouterSourceFetchEvent                 ServiceWorkerRouterSource = "fetch-event"
	ServiceWorkerRouterSourceRaceNetworkAndFetchHandler ServiceWorkerRouterSource = "race-network-and-fetch-handler"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *ServiceWorkerRouterSource) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch ServiceWorkerRouterSource(s) {
	case ServiceWorkerRouterSourceNetwork:
		*t = ServiceWorkerRouterSourceNetwork
	case ServiceWorkerRouterSourceCache:
		*t = ServiceWorkerRouterSourceCache
	case ServiceWorkerRouterSourceFetchEvent:
		*t = ServiceWorkerRouterSourceFetchEvent
	case ServiceWorkerRouterSourceRaceNetworkAndFetchHandler:
		*t = ServiceWorkerRouterSourceRaceNetworkAndFetchHandler
	default:
		return fmt.Errorf("unknown ServiceWorkerRouterSource value: %v", s)
	}
	return nil
}

// ServiceWorkerRouterInfo [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-ServiceWorkerRouterInfo
type ServiceWorkerRouterInfo struct {
	RuleIDMatched     int64                     `json:"ruleIdMatched,omitempty,omitzero"`     // ID of the rule matched. If there is a matched rule, this field will be set, otherwiser no value will be set.
	MatchedSourceType ServiceWorkerRouterSource `json:"matchedSourceType,omitempty,omitzero"` // The router source of the matched rule. If there is a matched rule, this field will be set, otherwise no value will be set.
	ActualSourceType  ServiceWorkerRouterSource `json:"actualSourceType,omitempty,omitzero"`  // The actual router source used.
}

// Response HTTP response data.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-Response
type Response struct {
	URL                         string                      `json:"url"`                                            // Response URL. This URL can be different from CachedResource.url in case of redirect.
	Status                      int64                       `json:"status"`                                         // HTTP response status code.
	StatusText                  string                      `json:"statusText"`                                     // HTTP response status text.
	Headers                     Headers                     `json:"headers"`                                        // HTTP response headers.
	MimeType                    string                      `json:"mimeType"`                                       // Resource mimeType as determined by the browser.
	Charset                     string                      `json:"charset"`                                        // Resource charset as determined by the browser (if applicable).
	RequestHeaders              Headers                     `json:"requestHeaders,omitempty,omitzero"`              // Refined HTTP request headers that were actually transmitted over the network.
	ConnectionReused            bool                        `json:"connectionReused"`                               // Specifies whether physical connection was actually reused for this request.
	ConnectionID                float64                     `json:"connectionId"`                                   // Physical connection id that was actually used for this request.
	RemoteIPAddress             string                      `json:"remoteIPAddress,omitempty,omitzero"`             // Remote IP address.
	RemotePort                  int64                       `json:"remotePort,omitempty,omitzero"`                  // Remote port.
	FromDiskCache               bool                        `json:"fromDiskCache,omitempty,omitzero"`               // Specifies that the request was served from the disk cache.
	FromServiceWorker           bool                        `json:"fromServiceWorker,omitempty,omitzero"`           // Specifies that the request was served from the ServiceWorker.
	FromPrefetchCache           bool                        `json:"fromPrefetchCache,omitempty,omitzero"`           // Specifies that the request was served from the prefetch cache.
	FromEarlyHints              bool                        `json:"fromEarlyHints,omitempty,omitzero"`              // Specifies that the request was served from the prefetch cache.
	ServiceWorkerRouterInfo     *ServiceWorkerRouterInfo    `json:"serviceWorkerRouterInfo,omitempty,omitzero"`     // Information about how ServiceWorker Static Router API was used. If this field is set with matchedSourceType field, a matching rule is found. If this field is set without matchedSource, no matching rule is found. Otherwise, the API is not used.
	EncodedDataLength           float64                     `json:"encodedDataLength"`                              // Total number of bytes received for this request so far.
	Timing                      *ResourceTiming             `json:"timing,omitempty,omitzero"`                      // Timing information for the given request.
	ServiceWorkerResponseSource ServiceWorkerResponseSource `json:"serviceWorkerResponseSource,omitempty,omitzero"` // Response source of response from ServiceWorker.
	ResponseTime                *cdp.TimeSinceEpochMilli    `json:"responseTime,omitempty,omitzero"`                // The time at which the returned response was generated.
	CacheStorageCacheName       string                      `json:"cacheStorageCacheName,omitempty,omitzero"`       // Cache Storage Cache Name.
	Protocol                    string                      `json:"protocol,omitempty,omitzero"`                    // Protocol used to fetch this request.
	AlternateProtocolUsage      AlternateProtocolUsage      `json:"alternateProtocolUsage,omitempty,omitzero"`      // The reason why Chrome uses a specific transport protocol for HTTP semantics.
	SecurityState               security.State              `json:"securityState"`                                  // Security state of the request resource.
	SecurityDetails             *SecurityDetails            `json:"securityDetails,omitempty,omitzero"`             // Security details for the request.
}

// WebSocketRequest webSocket request data.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-WebSocketRequest
type WebSocketRequest struct {
	Headers Headers `json:"headers"` // HTTP request headers.
}

// WebSocketResponse webSocket response data.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-WebSocketResponse
type WebSocketResponse struct {
	Status             int64   `json:"status"`                                // HTTP response status code.
	StatusText         string  `json:"statusText"`                            // HTTP response status text.
	Headers            Headers `json:"headers"`                               // HTTP response headers.
	HeadersText        string  `json:"headersText,omitempty,omitzero"`        // HTTP response headers text.
	RequestHeaders     Headers `json:"requestHeaders,omitempty,omitzero"`     // HTTP request headers.
	RequestHeadersText string  `json:"requestHeadersText,omitempty,omitzero"` // HTTP request headers text.
}

// WebSocketFrame webSocket message data. This represents an entire WebSocket
// message, not just a fragmented frame as the name suggests.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-WebSocketFrame
type WebSocketFrame struct {
	Opcode      float64 `json:"opcode"`      // WebSocket message opcode.
	Mask        bool    `json:"mask"`        // WebSocket message mask.
	PayloadData string  `json:"payloadData"` // WebSocket message payload data. If the opcode is 1, this is a text message and payloadData is a UTF-8 string. If the opcode isn't 1, then payloadData is a base64 encoded string representing binary data.
}

// CachedResource information about the cached resource.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-CachedResource
type CachedResource struct {
	URL      string       `json:"url"`                         // Resource URL. This is the url of the original network request.
	Type     ResourceType `json:"type"`                        // Type of this resource.
	Response *Response    `json:"response,omitempty,omitzero"` // Cached response data.
	BodySize float64      `json:"bodySize"`                    // Cached response body size.
}

// Initiator information about the request initiator.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-Initiator
type Initiator struct {
	Type         InitiatorType       `json:"type"`                            // Type of this initiator.
	Stack        *runtime.StackTrace `json:"stack,omitempty,omitzero"`        // Initiator JavaScript stack trace, set for Script only. Requires the Debugger domain to be enabled.
	URL          string              `json:"url,omitempty,omitzero"`          // Initiator URL, set for Parser type or for Script type (when script is importing module) or for SignedExchange type.
	LineNumber   float64             `json:"lineNumber,omitempty,omitzero"`   // Initiator line number, set for Parser type or for Script type (when script is importing module) (0-based).
	ColumnNumber float64             `json:"columnNumber,omitempty,omitzero"` // Initiator column number, set for Parser type or for Script type (when script is importing module) (0-based).
	RequestID    RequestID           `json:"requestId,omitempty,omitzero"`    // Set if another request triggered this request (e.g. preflight).
}

// CookiePartitionKey cookiePartitionKey object The representation of the
// components of the key that are created by the cookiePartitionKey class
// contained in net/cookies/cookie_partition_key.h.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-CookiePartitionKey
type CookiePartitionKey struct {
	TopLevelSite         string `json:"topLevelSite"`         // The site of the top-level URL the browser was visiting at the start of the request to the endpoint that set the cookie.
	HasCrossSiteAncestor bool   `json:"hasCrossSiteAncestor"` // Indicates if the cookie has any ancestors that are cross-site to the topLevelSite.
}

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *CookiePartitionKey) OrigUnmarshalJSON(buf []byte) error {
	if l := len(buf); l > 2 && buf[0] == '"' && buf[l-1] == '"' {
		var err error
		t.TopLevelSite, err = strconv.Unquote(string(buf))
		return err
	}
	dec := json.NewDecoder(bytes.NewReader(buf))
	dec.DisallowUnknownFields()
	var v struct {
		TopLevelSite         string `json:"topLevelSite"`
		HasCrossSiteAncestor bool   `json:"hasCrossSiteAncestor"`
	}
	if err := dec.Decode(&v); err != nil {
		return err
	}
	t.TopLevelSite, t.HasCrossSiteAncestor = v.TopLevelSite, v.HasCrossSiteAncestor
	return nil
}

// Cookie cookie object.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-Cookie
type Cookie struct {
	Name               string              `json:"name"`                                  // Cookie name.
	Value              string              `json:"value"`                                 // Cookie value.
	Domain             string              `json:"domain"`                                // Cookie domain.
	Path               string              `json:"path"`                                  // Cookie path.
	Expires            float64             `json:"expires"`                               // Cookie expiration date as the number of seconds since the UNIX epoch.
	Size               int64               `json:"size"`                                  // Cookie size.
	HTTPOnly           bool                `json:"httpOnly"`                              // True if cookie is http-only.
	Secure             bool                `json:"secure"`                                // True if cookie is secure.
	Session            bool                `json:"session"`                               // True in case of session cookie.
	SameSite           CookieSameSite      `json:"sameSite,omitempty,omitzero"`           // Cookie SameSite type.
	Priority           CookiePriority      `json:"priority"`                              // Cookie Priority
	SourceScheme       CookieSourceScheme  `json:"sourceScheme"`                          // Cookie source scheme type.
	SourcePort         int64               `json:"sourcePort"`                            // Cookie source port. Valid values are {-1, [1, 65535]}, -1 indicates an unspecified port. An unspecified port value allows protocol clients to emulate legacy cookie scope for the port. This is a temporary ability and it will be removed in the future.
	PartitionKey       *CookiePartitionKey `json:"partitionKey,omitempty,omitzero"`       // Cookie partition key.
	PartitionKeyOpaque bool                `json:"partitionKeyOpaque,omitempty,omitzero"` // True if cookie partition key is opaque.
}

// SetCookieBlockedReason types of reasons why a cookie may not be stored
// from a response.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-SetCookieBlockedReason
type SetCookieBlockedReason string

// String returns the SetCookieBlockedReason as string value.
func (t SetCookieBlockedReason) String() string {
	return string(t)
}

// SetCookieBlockedReason values.
const (
	SetCookieBlockedReasonSecureOnly                               SetCookieBlockedReason = "SecureOnly"
	SetCookieBlockedReasonSameSiteStrict                           SetCookieBlockedReason = "SameSiteStrict"
	SetCookieBlockedReasonSameSiteLax                              SetCookieBlockedReason = "SameSiteLax"
	SetCookieBlockedReasonSameSiteUnspecifiedTreatedAsLax          SetCookieBlockedReason = "SameSiteUnspecifiedTreatedAsLax"
	SetCookieBlockedReasonSameSiteNoneInsecure                     SetCookieBlockedReason = "SameSiteNoneInsecure"
	SetCookieBlockedReasonUserPreferences                          SetCookieBlockedReason = "UserPreferences"
	SetCookieBlockedReasonThirdPartyPhaseout                       SetCookieBlockedReason = "ThirdPartyPhaseout"
	SetCookieBlockedReasonThirdPartyBlockedInFirstPartySet         SetCookieBlockedReason = "ThirdPartyBlockedInFirstPartySet"
	SetCookieBlockedReasonSyntaxError                              SetCookieBlockedReason = "SyntaxError"
	SetCookieBlockedReasonSchemeNotSupported                       SetCookieBlockedReason = "SchemeNotSupported"
	SetCookieBlockedReasonOverwriteSecure                          SetCookieBlockedReason = "OverwriteSecure"
	SetCookieBlockedReasonInvalidDomain                            SetCookieBlockedReason = "InvalidDomain"
	SetCookieBlockedReasonInvalidPrefix                            SetCookieBlockedReason = "InvalidPrefix"
	SetCookieBlockedReasonUnknownError                             SetCookieBlockedReason = "UnknownError"
	SetCookieBlockedReasonSchemefulSameSiteStrict                  SetCookieBlockedReason = "SchemefulSameSiteStrict"
	SetCookieBlockedReasonSchemefulSameSiteLax                     SetCookieBlockedReason = "SchemefulSameSiteLax"
	SetCookieBlockedReasonSchemefulSameSiteUnspecifiedTreatedAsLax SetCookieBlockedReason = "SchemefulSameSiteUnspecifiedTreatedAsLax"
	SetCookieBlockedReasonSamePartyFromCrossPartyContext           SetCookieBlockedReason = "SamePartyFromCrossPartyContext"
	SetCookieBlockedReasonSamePartyConflictsWithOtherAttributes    SetCookieBlockedReason = "SamePartyConflictsWithOtherAttributes"
	SetCookieBlockedReasonNameValuePairExceedsMaxSize              SetCookieBlockedReason = "NameValuePairExceedsMaxSize"
	SetCookieBlockedReasonDisallowedCharacter                      SetCookieBlockedReason = "DisallowedCharacter"
	SetCookieBlockedReasonNoCookieContent                          SetCookieBlockedReason = "NoCookieContent"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *SetCookieBlockedReason) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch SetCookieBlockedReason(s) {
	case SetCookieBlockedReasonSecureOnly:
		*t = SetCookieBlockedReasonSecureOnly
	case SetCookieBlockedReasonSameSiteStrict:
		*t = SetCookieBlockedReasonSameSiteStrict
	case SetCookieBlockedReasonSameSiteLax:
		*t = SetCookieBlockedReasonSameSiteLax
	case SetCookieBlockedReasonSameSiteUnspecifiedTreatedAsLax:
		*t = SetCookieBlockedReasonSameSiteUnspecifiedTreatedAsLax
	case SetCookieBlockedReasonSameSiteNoneInsecure:
		*t = SetCookieBlockedReasonSameSiteNoneInsecure
	case SetCookieBlockedReasonUserPreferences:
		*t = SetCookieBlockedReasonUserPreferences
	case SetCookieBlockedReasonThirdPartyPhaseout:
		*t = SetCookieBlockedReasonThirdPartyPhaseout
	case SetCookieBlockedReasonThirdPartyBlockedInFirstPartySet:
		*t = SetCookieBlockedReasonThirdPartyBlockedInFirstPartySet
	case SetCookieBlockedReasonSyntaxError:
		*t = SetCookieBlockedReasonSyntaxError
	case SetCookieBlockedReasonSchemeNotSupported:
		*t = SetCookieBlockedReasonSchemeNotSupported
	case SetCookieBlockedReasonOverwriteSecure:
		*t = SetCookieBlockedReasonOverwriteSecure
	case SetCookieBlockedReasonInvalidDomain:
		*t = SetCookieBlockedReasonInvalidDomain
	case SetCookieBlockedReasonInvalidPrefix:
		*t = SetCookieBlockedReasonInvalidPrefix
	case SetCookieBlockedReasonUnknownError:
		*t = SetCookieBlockedReasonUnknownError
	case SetCookieBlockedReasonSchemefulSameSiteStrict:
		*t = SetCookieBlockedReasonSchemefulSameSiteStrict
	case SetCookieBlockedReasonSchemefulSameSiteLax:
		*t = SetCookieBlockedReasonSchemefulSameSiteLax
	case SetCookieBlockedReasonSchemefulSameSiteUnspecifiedTreatedAsLax:
		*t = SetCookieBlockedReasonSchemefulSameSiteUnspecifiedTreatedAsLax
	case SetCookieBlockedReasonSamePartyFromCrossPartyContext:
		*t = SetCookieBlockedReasonSamePartyFromCrossPartyContext
	case SetCookieBlockedReasonSamePartyConflictsWithOtherAttributes:
		*t = SetCookieBlockedReasonSamePartyConflictsWithOtherAttributes
	case SetCookieBlockedReasonNameValuePairExceedsMaxSize:
		*t = SetCookieBlockedReasonNameValuePairExceedsMaxSize
	case SetCookieBlockedReasonDisallowedCharacter:
		*t = SetCookieBlockedReasonDisallowedCharacter
	case SetCookieBlockedReasonNoCookieContent:
		*t = SetCookieBlockedReasonNoCookieContent
	default:
		return fmt.Errorf("unknown SetCookieBlockedReason value: %v", s)
	}
	return nil
}

// CookieBlockedReason types of reasons why a cookie may not be sent with a
// request.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-CookieBlockedReason
type CookieBlockedReason string

// String returns the CookieBlockedReason as string value.
func (t CookieBlockedReason) String() string {
	return string(t)
}

// CookieBlockedReason values.
const (
	CookieBlockedReasonSecureOnly                               CookieBlockedReason = "SecureOnly"
	CookieBlockedReasonNotOnPath                                CookieBlockedReason = "NotOnPath"
	CookieBlockedReasonDomainMismatch                           CookieBlockedReason = "DomainMismatch"
	CookieBlockedReasonSameSiteStrict                           CookieBlockedReason = "SameSiteStrict"
	CookieBlockedReasonSameSiteLax                              CookieBlockedReason = "SameSiteLax"
	CookieBlockedReasonSameSiteUnspecifiedTreatedAsLax          CookieBlockedReason = "SameSiteUnspecifiedTreatedAsLax"
	CookieBlockedReasonSameSiteNoneInsecure                     CookieBlockedReason = "SameSiteNoneInsecure"
	CookieBlockedReasonUserPreferences                          CookieBlockedReason = "UserPreferences"
	CookieBlockedReasonThirdPartyPhaseout                       CookieBlockedReason = "ThirdPartyPhaseout"
	CookieBlockedReasonThirdPartyBlockedInFirstPartySet         CookieBlockedReason = "ThirdPartyBlockedInFirstPartySet"
	CookieBlockedReasonUnknownError                             CookieBlockedReason = "UnknownError"
	CookieBlockedReasonSchemefulSameSiteStrict                  CookieBlockedReason = "SchemefulSameSiteStrict"
	CookieBlockedReasonSchemefulSameSiteLax                     CookieBlockedReason = "SchemefulSameSiteLax"
	CookieBlockedReasonSchemefulSameSiteUnspecifiedTreatedAsLax CookieBlockedReason = "SchemefulSameSiteUnspecifiedTreatedAsLax"
	CookieBlockedReasonSamePartyFromCrossPartyContext           CookieBlockedReason = "SamePartyFromCrossPartyContext"
	CookieBlockedReasonNameValuePairExceedsMaxSize              CookieBlockedReason = "NameValuePairExceedsMaxSize"
	CookieBlockedReasonPortMismatch                             CookieBlockedReason = "PortMismatch"
	CookieBlockedReasonSchemeMismatch                           CookieBlockedReason = "SchemeMismatch"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *CookieBlockedReason) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch CookieBlockedReason(s) {
	case CookieBlockedReasonSecureOnly:
		*t = CookieBlockedReasonSecureOnly
	case CookieBlockedReasonNotOnPath:
		*t = CookieBlockedReasonNotOnPath
	case CookieBlockedReasonDomainMismatch:
		*t = CookieBlockedReasonDomainMismatch
	case CookieBlockedReasonSameSiteStrict:
		*t = CookieBlockedReasonSameSiteStrict
	case CookieBlockedReasonSameSiteLax:
		*t = CookieBlockedReasonSameSiteLax
	case CookieBlockedReasonSameSiteUnspecifiedTreatedAsLax:
		*t = CookieBlockedReasonSameSiteUnspecifiedTreatedAsLax
	case CookieBlockedReasonSameSiteNoneInsecure:
		*t = CookieBlockedReasonSameSiteNoneInsecure
	case CookieBlockedReasonUserPreferences:
		*t = CookieBlockedReasonUserPreferences
	case CookieBlockedReasonThirdPartyPhaseout:
		*t = CookieBlockedReasonThirdPartyPhaseout
	case CookieBlockedReasonThirdPartyBlockedInFirstPartySet:
		*t = CookieBlockedReasonThirdPartyBlockedInFirstPartySet
	case CookieBlockedReasonUnknownError:
		*t = CookieBlockedReasonUnknownError
	case CookieBlockedReasonSchemefulSameSiteStrict:
		*t = CookieBlockedReasonSchemefulSameSiteStrict
	case CookieBlockedReasonSchemefulSameSiteLax:
		*t = CookieBlockedReasonSchemefulSameSiteLax
	case CookieBlockedReasonSchemefulSameSiteUnspecifiedTreatedAsLax:
		*t = CookieBlockedReasonSchemefulSameSiteUnspecifiedTreatedAsLax
	case CookieBlockedReasonSamePartyFromCrossPartyContext:
		*t = CookieBlockedReasonSamePartyFromCrossPartyContext
	case CookieBlockedReasonNameValuePairExceedsMaxSize:
		*t = CookieBlockedReasonNameValuePairExceedsMaxSize
	case CookieBlockedReasonPortMismatch:
		*t = CookieBlockedReasonPortMismatch
	case CookieBlockedReasonSchemeMismatch:
		*t = CookieBlockedReasonSchemeMismatch
	default:
		return fmt.Errorf("unknown CookieBlockedReason value: %v", s)
	}
	return nil
}

// CookieExemptionReason types of reasons why a cookie should have been
// blocked by 3PCD but is exempted for the request.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-CookieExemptionReason
type CookieExemptionReason string

// String returns the CookieExemptionReason as string value.
func (t CookieExemptionReason) String() string {
	return string(t)
}

// CookieExemptionReason values.
const (
	CookieExemptionReasonNone                         CookieExemptionReason = "None"
	CookieExemptionReasonUserSetting                  CookieExemptionReason = "UserSetting"
	CookieExemptionReasonTPCDMetadata                 CookieExemptionReason = "TPCDMetadata"
	CookieExemptionReasonTPCDDeprecationTrial         CookieExemptionReason = "TPCDDeprecationTrial"
	CookieExemptionReasonTopLevelTPCDDeprecationTrial CookieExemptionReason = "TopLevelTPCDDeprecationTrial"
	CookieExemptionReasonTPCDHeuristics               CookieExemptionReason = "TPCDHeuristics"
	CookieExemptionReasonEnterprisePolicy             CookieExemptionReason = "EnterprisePolicy"
	CookieExemptionReasonStorageAccess                CookieExemptionReason = "StorageAccess"
	CookieExemptionReasonTopLevelStorageAccess        CookieExemptionReason = "TopLevelStorageAccess"
	CookieExemptionReasonScheme                       CookieExemptionReason = "Scheme"
	CookieExemptionReasonSameSiteNoneCookiesInSandbox CookieExemptionReason = "SameSiteNoneCookiesInSandbox"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *CookieExemptionReason) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch CookieExemptionReason(s) {
	case CookieExemptionReasonNone:
		*t = CookieExemptionReasonNone
	case CookieExemptionReasonUserSetting:
		*t = CookieExemptionReasonUserSetting
	case CookieExemptionReasonTPCDMetadata:
		*t = CookieExemptionReasonTPCDMetadata
	case CookieExemptionReasonTPCDDeprecationTrial:
		*t = CookieExemptionReasonTPCDDeprecationTrial
	case CookieExemptionReasonTopLevelTPCDDeprecationTrial:
		*t = CookieExemptionReasonTopLevelTPCDDeprecationTrial
	case CookieExemptionReasonTPCDHeuristics:
		*t = CookieExemptionReasonTPCDHeuristics
	case CookieExemptionReasonEnterprisePolicy:
		*t = CookieExemptionReasonEnterprisePolicy
	case CookieExemptionReasonStorageAccess:
		*t = CookieExemptionReasonStorageAccess
	case CookieExemptionReasonTopLevelStorageAccess:
		*t = CookieExemptionReasonTopLevelStorageAccess
	case CookieExemptionReasonScheme:
		*t = CookieExemptionReasonScheme
	case CookieExemptionReasonSameSiteNoneCookiesInSandbox:
		*t = CookieExemptionReasonSameSiteNoneCookiesInSandbox
	default:
		return fmt.Errorf("unknown CookieExemptionReason value: %v", s)
	}
	return nil
}

// BlockedSetCookieWithReason a cookie which was not stored from a response
// with the corresponding reason.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-BlockedSetCookieWithReason
type BlockedSetCookieWithReason struct {
	BlockedReasons []SetCookieBlockedReason `json:"blockedReasons"`            // The reason(s) this cookie was blocked.
	CookieLine     string                   `json:"cookieLine"`                // The string representing this individual cookie as it would appear in the header. This is not the entire "cookie" or "set-cookie" header which could have multiple cookies.
	Cookie         *Cookie                  `json:"cookie,omitempty,omitzero"` // The cookie object which represents the cookie which was not stored. It is optional because sometimes complete cookie information is not available, such as in the case of parsing errors.
}

// ExemptedSetCookieWithReason a cookie should have been blocked by 3PCD but
// is exempted and stored from a response with the corresponding reason. A
// cookie could only have at most one exemption reason.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-ExemptedSetCookieWithReason
type ExemptedSetCookieWithReason struct {
	ExemptionReason CookieExemptionReason `json:"exemptionReason"` // The reason the cookie was exempted.
	CookieLine      string                `json:"cookieLine"`      // The string representing this individual cookie as it would appear in the header.
	Cookie          *Cookie               `json:"cookie"`          // The cookie object representing the cookie.
}

// AssociatedCookie a cookie associated with the request which may or may not
// be sent with it. Includes the cookies itself and reasons for blocking or
// exemption.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-AssociatedCookie
type AssociatedCookie struct {
	Cookie          *Cookie               `json:"cookie"`                             // The cookie object representing the cookie which was not sent.
	BlockedReasons  []CookieBlockedReason `json:"blockedReasons"`                     // The reason(s) the cookie was blocked. If empty means the cookie is included.
	ExemptionReason CookieExemptionReason `json:"exemptionReason,omitempty,omitzero"` // The reason the cookie should have been blocked by 3PCD but is exempted. A cookie could only have at most one exemption reason.
}

// CookieParam cookie parameter object.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-CookieParam
type CookieParam struct {
	Name         string              `json:"name"`                            // Cookie name.
	Value        string              `json:"value"`                           // Cookie value.
	URL          string              `json:"url,omitempty,omitzero"`          // The request-URI to associate with the setting of the cookie. This value can affect the default domain, path, source port, and source scheme values of the created cookie.
	Domain       string              `json:"domain,omitempty,omitzero"`       // Cookie domain.
	Path         string              `json:"path,omitempty,omitzero"`         // Cookie path.
	Secure       bool                `json:"secure,omitempty,omitzero"`       // True if cookie is secure.
	HTTPOnly     bool                `json:"httpOnly,omitempty,omitzero"`     // True if cookie is http-only.
	SameSite     CookieSameSite      `json:"sameSite,omitempty,omitzero"`     // Cookie SameSite type.
	Expires      *cdp.TimeSinceEpoch `json:"expires,omitempty,omitzero"`      // Cookie expiration date, session cookie if not set
	Priority     CookiePriority      `json:"priority,omitempty,omitzero"`     // Cookie Priority.
	SameParty    bool                `json:"sameParty,omitempty,omitzero"`    // True if cookie is SameParty.
	SourceScheme CookieSourceScheme  `json:"sourceScheme,omitempty,omitzero"` // Cookie source scheme type.
	SourcePort   int64               `json:"sourcePort,omitempty,omitzero"`   // Cookie source port. Valid values are {-1, [1, 65535]}, -1 indicates an unspecified port. An unspecified port value allows protocol clients to emulate legacy cookie scope for the port. This is a temporary ability and it will be removed in the future.
	PartitionKey *CookiePartitionKey `json:"partitionKey,omitempty,omitzero"` // Cookie partition key. If not set, the cookie will be set as not partitioned.
}

// AuthChallenge authorization challenge for HTTP status code 401 or 407.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-AuthChallenge
type AuthChallenge struct {
	Source AuthChallengeSource `json:"source,omitempty,omitzero"` // Source of the authentication challenge.
	Origin string              `json:"origin"`                    // Origin of the challenger.
	Scheme string              `json:"scheme"`                    // The authentication scheme used, such as basic or digest
	Realm  string              `json:"realm"`                     // The realm of the challenge. May be empty.
}

// AuthChallengeResponse response to an AuthChallenge.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-AuthChallengeResponse
type AuthChallengeResponse struct {
	Response AuthChallengeResponseResponse `json:"response"`                    // The decision on what to do in response to the authorization challenge.  Default means deferring to the default behavior of the net stack, which will likely either the Cancel authentication or display a popup dialog box.
	Username string                        `json:"username,omitempty,omitzero"` // The username to provide, possibly empty. Should only be set if response is ProvideCredentials.
	Password string                        `json:"password,omitempty,omitzero"` // The password to provide, possibly empty. Should only be set if response is ProvideCredentials.
}

// InterceptionStage stages of the interception to begin intercepting.
// Request will intercept before the request is sent. Response will intercept
// after the response is received.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-InterceptionStage
type InterceptionStage string

// String returns the InterceptionStage as string value.
func (t InterceptionStage) String() string {
	return string(t)
}

// InterceptionStage values.
const (
	InterceptionStageRequest         InterceptionStage = "Request"
	InterceptionStageHeadersReceived InterceptionStage = "HeadersReceived"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *InterceptionStage) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch InterceptionStage(s) {
	case InterceptionStageRequest:
		*t = InterceptionStageRequest
	case InterceptionStageHeadersReceived:
		*t = InterceptionStageHeadersReceived
	default:
		return fmt.Errorf("unknown InterceptionStage value: %v", s)
	}
	return nil
}

// RequestPattern request pattern for interception.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-RequestPattern
type RequestPattern struct {
	URLPattern        string            `json:"urlPattern,omitempty,omitzero"`        // Wildcards ('*' -> zero or more, '?' -> exactly one) are allowed. Escape character is backslash. Omitting is equivalent to "*".
	ResourceType      ResourceType      `json:"resourceType,omitempty,omitzero"`      // If set, only requests for matching resource types will be intercepted.
	InterceptionStage InterceptionStage `json:"interceptionStage,omitempty,omitzero"` // Stage at which to begin intercepting requests. Default is Request.
}

// SignedExchangeSignature information about a signed exchange signature.
// https://wicg.github.io/webpackage/draft-yasskin-httpbis-origin-signed-exchanges-impl.html#rfc.section.3.1.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-SignedExchangeSignature
type SignedExchangeSignature struct {
	Label        string   `json:"label"`                           // Signed exchange signature label.
	Signature    string   `json:"signature"`                       // The hex string of signed exchange signature.
	Integrity    string   `json:"integrity"`                       // Signed exchange signature integrity.
	CertURL      string   `json:"certUrl,omitempty,omitzero"`      // Signed exchange signature cert Url.
	CertSha256   string   `json:"certSha256,omitempty,omitzero"`   // The hex string of signed exchange signature cert sha256.
	ValidityURL  string   `json:"validityUrl"`                     // Signed exchange signature validity Url.
	Date         int64    `json:"date"`                            // Signed exchange signature date.
	Expires      int64    `json:"expires"`                         // Signed exchange signature expires.
	Certificates []string `json:"certificates,omitempty,omitzero"` // The encoded certificates.
}

// SignedExchangeHeader information about a signed exchange header.
// https://wicg.github.io/webpackage/draft-yasskin-httpbis-origin-signed-exchanges-impl.html#cbor-representation.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-SignedExchangeHeader
type SignedExchangeHeader struct {
	RequestURL      string                     `json:"requestUrl"`      // Signed exchange request URL.
	ResponseCode    int64                      `json:"responseCode"`    // Signed exchange response code.
	ResponseHeaders Headers                    `json:"responseHeaders"` // Signed exchange response headers.
	Signatures      []*SignedExchangeSignature `json:"signatures"`      // Signed exchange response signature.
	HeaderIntegrity string                     `json:"headerIntegrity"` // Signed exchange header integrity hash in the form of sha256-<base64-hash-value>.
}

// SignedExchangeErrorField field type for a signed exchange related error.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-SignedExchangeErrorField
type SignedExchangeErrorField string

// String returns the SignedExchangeErrorField as string value.
func (t SignedExchangeErrorField) String() string {
	return string(t)
}

// SignedExchangeErrorField values.
const (
	SignedExchangeErrorFieldSignatureSig         SignedExchangeErrorField = "signatureSig"
	SignedExchangeErrorFieldSignatureIntegrity   SignedExchangeErrorField = "signatureIntegrity"
	SignedExchangeErrorFieldSignatureCertURL     SignedExchangeErrorField = "signatureCertUrl"
	SignedExchangeErrorFieldSignatureCertSha256  SignedExchangeErrorField = "signatureCertSha256"
	SignedExchangeErrorFieldSignatureValidityURL SignedExchangeErrorField = "signatureValidityUrl"
	SignedExchangeErrorFieldSignatureTimestamps  SignedExchangeErrorField = "signatureTimestamps"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *SignedExchangeErrorField) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch SignedExchangeErrorField(s) {
	case SignedExchangeErrorFieldSignatureSig:
		*t = SignedExchangeErrorFieldSignatureSig
	case SignedExchangeErrorFieldSignatureIntegrity:
		*t = SignedExchangeErrorFieldSignatureIntegrity
	case SignedExchangeErrorFieldSignatureCertURL:
		*t = SignedExchangeErrorFieldSignatureCertURL
	case SignedExchangeErrorFieldSignatureCertSha256:
		*t = SignedExchangeErrorFieldSignatureCertSha256
	case SignedExchangeErrorFieldSignatureValidityURL:
		*t = SignedExchangeErrorFieldSignatureValidityURL
	case SignedExchangeErrorFieldSignatureTimestamps:
		*t = SignedExchangeErrorFieldSignatureTimestamps
	default:
		return fmt.Errorf("unknown SignedExchangeErrorField value: %v", s)
	}
	return nil
}

// SignedExchangeError information about a signed exchange response.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-SignedExchangeError
type SignedExchangeError struct {
	Message        string                   `json:"message"`                           // Error message.
	SignatureIndex int64                    `json:"signatureIndex,omitempty,omitzero"` // The index of the signature which caused the error.
	ErrorField     SignedExchangeErrorField `json:"errorField,omitempty,omitzero"`     // The field which caused the error.
}

// SignedExchangeInfo information about a signed exchange response.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-SignedExchangeInfo
type SignedExchangeInfo struct {
	OuterResponse   *Response              `json:"outerResponse"`                      // The outer response of signed HTTP exchange which was received from network.
	Header          *SignedExchangeHeader  `json:"header,omitempty,omitzero"`          // Information about the signed exchange header.
	SecurityDetails *SecurityDetails       `json:"securityDetails,omitempty,omitzero"` // Security details for the signed exchange header.
	Errors          []*SignedExchangeError `json:"errors,omitempty,omitzero"`          // Errors occurred while handling the signed exchange.
}

// ContentEncoding list of content encodings supported by the backend.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-ContentEncoding
type ContentEncoding string

// String returns the ContentEncoding as string value.
func (t ContentEncoding) String() string {
	return string(t)
}

// ContentEncoding values.
const (
	ContentEncodingDeflate ContentEncoding = "deflate"
	ContentEncodingGzip    ContentEncoding = "gzip"
	ContentEncodingBr      ContentEncoding = "br"
	ContentEncodingZstd    ContentEncoding = "zstd"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *ContentEncoding) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch ContentEncoding(s) {
	case ContentEncodingDeflate:
		*t = ContentEncodingDeflate
	case ContentEncodingGzip:
		*t = ContentEncodingGzip
	case ContentEncodingBr:
		*t = ContentEncodingBr
	case ContentEncodingZstd:
		*t = ContentEncodingZstd
	default:
		return fmt.Errorf("unknown ContentEncoding value: %v", s)
	}
	return nil
}

// DirectSocketDNSQueryType [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-DirectSocketDnsQueryType
type DirectSocketDNSQueryType string

// String returns the DirectSocketDNSQueryType as string value.
func (t DirectSocketDNSQueryType) String() string {
	return string(t)
}

// DirectSocketDNSQueryType values.
const (
	DirectSocketDNSQueryTypeIpv4 DirectSocketDNSQueryType = "ipv4"
	DirectSocketDNSQueryTypeIpv6 DirectSocketDNSQueryType = "ipv6"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *DirectSocketDNSQueryType) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch DirectSocketDNSQueryType(s) {
	case DirectSocketDNSQueryTypeIpv4:
		*t = DirectSocketDNSQueryTypeIpv4
	case DirectSocketDNSQueryTypeIpv6:
		*t = DirectSocketDNSQueryTypeIpv6
	default:
		return fmt.Errorf("unknown DirectSocketDNSQueryType value: %v", s)
	}
	return nil
}

// DirectTCPSocketOptions [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-DirectTCPSocketOptions
type DirectTCPSocketOptions struct {
	NoDelay           bool                     `json:"noDelay"`                              // TCP_NODELAY option
	KeepAliveDelay    float64                  `json:"keepAliveDelay,omitempty,omitzero"`    // Expected to be unsigned integer.
	SendBufferSize    float64                  `json:"sendBufferSize,omitempty,omitzero"`    // Expected to be unsigned integer.
	ReceiveBufferSize float64                  `json:"receiveBufferSize,omitempty,omitzero"` // Expected to be unsigned integer.
	DNSQueryType      DirectSocketDNSQueryType `json:"dnsQueryType,omitempty,omitzero"`
}

// PrivateNetworkRequestPolicy [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-PrivateNetworkRequestPolicy
type PrivateNetworkRequestPolicy string

// String returns the PrivateNetworkRequestPolicy as string value.
func (t PrivateNetworkRequestPolicy) String() string {
	return string(t)
}

// PrivateNetworkRequestPolicy values.
const (
	PrivateNetworkRequestPolicyAllow                          PrivateNetworkRequestPolicy = "Allow"
	PrivateNetworkRequestPolicyBlockFromInsecureToMorePrivate PrivateNetworkRequestPolicy = "BlockFromInsecureToMorePrivate"
	PrivateNetworkRequestPolicyWarnFromInsecureToMorePrivate  PrivateNetworkRequestPolicy = "WarnFromInsecureToMorePrivate"
	PrivateNetworkRequestPolicyPreflightBlock                 PrivateNetworkRequestPolicy = "PreflightBlock"
	PrivateNetworkRequestPolicyPreflightWarn                  PrivateNetworkRequestPolicy = "PreflightWarn"
	PrivateNetworkRequestPolicyPermissionBlock                PrivateNetworkRequestPolicy = "PermissionBlock"
	PrivateNetworkRequestPolicyPermissionWarn                 PrivateNetworkRequestPolicy = "PermissionWarn"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *PrivateNetworkRequestPolicy) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch PrivateNetworkRequestPolicy(s) {
	case PrivateNetworkRequestPolicyAllow:
		*t = PrivateNetworkRequestPolicyAllow
	case PrivateNetworkRequestPolicyBlockFromInsecureToMorePrivate:
		*t = PrivateNetworkRequestPolicyBlockFromInsecureToMorePrivate
	case PrivateNetworkRequestPolicyWarnFromInsecureToMorePrivate:
		*t = PrivateNetworkRequestPolicyWarnFromInsecureToMorePrivate
	case PrivateNetworkRequestPolicyPreflightBlock:
		*t = PrivateNetworkRequestPolicyPreflightBlock
	case PrivateNetworkRequestPolicyPreflightWarn:
		*t = PrivateNetworkRequestPolicyPreflightWarn
	case PrivateNetworkRequestPolicyPermissionBlock:
		*t = PrivateNetworkRequestPolicyPermissionBlock
	case PrivateNetworkRequestPolicyPermissionWarn:
		*t = PrivateNetworkRequestPolicyPermissionWarn
	default:
		return fmt.Errorf("unknown PrivateNetworkRequestPolicy value: %v", s)
	}
	return nil
}

// IPAddressSpace [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-IPAddressSpace
type IPAddressSpace string

// String returns the IPAddressSpace as string value.
func (t IPAddressSpace) String() string {
	return string(t)
}

// IPAddressSpace values.
const (
	IPAddressSpaceLocal   IPAddressSpace = "Local"
	IPAddressSpacePrivate IPAddressSpace = "Private"
	IPAddressSpacePublic  IPAddressSpace = "Public"
	IPAddressSpaceUnknown IPAddressSpace = "Unknown"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *IPAddressSpace) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch IPAddressSpace(s) {
	case IPAddressSpaceLocal:
		*t = IPAddressSpaceLocal
	case IPAddressSpacePrivate:
		*t = IPAddressSpacePrivate
	case IPAddressSpacePublic:
		*t = IPAddressSpacePublic
	case IPAddressSpaceUnknown:
		*t = IPAddressSpaceUnknown
	default:
		return fmt.Errorf("unknown IPAddressSpace value: %v", s)
	}
	return nil
}

// ConnectTiming [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-ConnectTiming
type ConnectTiming struct {
	RequestTime float64 `json:"requestTime"` // Timing's requestTime is a baseline in seconds, while the other numbers are ticks in milliseconds relatively to this requestTime. Matches ResourceTiming's requestTime for the same request (but not for redirected requests).
}

// ClientSecurityState [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-ClientSecurityState
type ClientSecurityState struct {
	InitiatorIsSecureContext    bool                        `json:"initiatorIsSecureContext"`
	InitiatorIPAddressSpace     IPAddressSpace              `json:"initiatorIPAddressSpace"`
	PrivateNetworkRequestPolicy PrivateNetworkRequestPolicy `json:"privateNetworkRequestPolicy"`
}

// CrossOriginOpenerPolicyValue [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-CrossOriginOpenerPolicyValue
type CrossOriginOpenerPolicyValue string

// String returns the CrossOriginOpenerPolicyValue as string value.
func (t CrossOriginOpenerPolicyValue) String() string {
	return string(t)
}

// CrossOriginOpenerPolicyValue values.
const (
	CrossOriginOpenerPolicyValueSameOrigin                 CrossOriginOpenerPolicyValue = "SameOrigin"
	CrossOriginOpenerPolicyValueSameOriginAllowPopups      CrossOriginOpenerPolicyValue = "SameOriginAllowPopups"
	CrossOriginOpenerPolicyValueRestrictProperties         CrossOriginOpenerPolicyValue = "RestrictProperties"
	CrossOriginOpenerPolicyValueUnsafeNone                 CrossOriginOpenerPolicyValue = "UnsafeNone"
	CrossOriginOpenerPolicyValueSameOriginPlusCoep         CrossOriginOpenerPolicyValue = "SameOriginPlusCoep"
	CrossOriginOpenerPolicyValueRestrictPropertiesPlusCoep CrossOriginOpenerPolicyValue = "RestrictPropertiesPlusCoep"
	CrossOriginOpenerPolicyValueNoopenerAllowPopups        CrossOriginOpenerPolicyValue = "NoopenerAllowPopups"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *CrossOriginOpenerPolicyValue) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch CrossOriginOpenerPolicyValue(s) {
	case CrossOriginOpenerPolicyValueSameOrigin:
		*t = CrossOriginOpenerPolicyValueSameOrigin
	case CrossOriginOpenerPolicyValueSameOriginAllowPopups:
		*t = CrossOriginOpenerPolicyValueSameOriginAllowPopups
	case CrossOriginOpenerPolicyValueRestrictProperties:
		*t = CrossOriginOpenerPolicyValueRestrictProperties
	case CrossOriginOpenerPolicyValueUnsafeNone:
		*t = CrossOriginOpenerPolicyValueUnsafeNone
	case CrossOriginOpenerPolicyValueSameOriginPlusCoep:
		*t = CrossOriginOpenerPolicyValueSameOriginPlusCoep
	case CrossOriginOpenerPolicyValueRestrictPropertiesPlusCoep:
		*t = CrossOriginOpenerPolicyValueRestrictPropertiesPlusCoep
	case CrossOriginOpenerPolicyValueNoopenerAllowPopups:
		*t = CrossOriginOpenerPolicyValueNoopenerAllowPopups
	default:
		return fmt.Errorf("unknown CrossOriginOpenerPolicyValue value: %v", s)
	}
	return nil
}

// CrossOriginOpenerPolicyStatus [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-CrossOriginOpenerPolicyStatus
type CrossOriginOpenerPolicyStatus struct {
	Value                       CrossOriginOpenerPolicyValue `json:"value"`
	ReportOnlyValue             CrossOriginOpenerPolicyValue `json:"reportOnlyValue"`
	ReportingEndpoint           string                       `json:"reportingEndpoint,omitempty,omitzero"`
	ReportOnlyReportingEndpoint string                       `json:"reportOnlyReportingEndpoint,omitempty,omitzero"`
}

// CrossOriginEmbedderPolicyValue [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-CrossOriginEmbedderPolicyValue
type CrossOriginEmbedderPolicyValue string

// String returns the CrossOriginEmbedderPolicyValue as string value.
func (t CrossOriginEmbedderPolicyValue) String() string {
	return string(t)
}

// CrossOriginEmbedderPolicyValue values.
const (
	CrossOriginEmbedderPolicyValueNone           CrossOriginEmbedderPolicyValue = "None"
	CrossOriginEmbedderPolicyValueCredentialless CrossOriginEmbedderPolicyValue = "Credentialless"
	CrossOriginEmbedderPolicyValueRequireCorp    CrossOriginEmbedderPolicyValue = "RequireCorp"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *CrossOriginEmbedderPolicyValue) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch CrossOriginEmbedderPolicyValue(s) {
	case CrossOriginEmbedderPolicyValueNone:
		*t = CrossOriginEmbedderPolicyValueNone
	case CrossOriginEmbedderPolicyValueCredentialless:
		*t = CrossOriginEmbedderPolicyValueCredentialless
	case CrossOriginEmbedderPolicyValueRequireCorp:
		*t = CrossOriginEmbedderPolicyValueRequireCorp
	default:
		return fmt.Errorf("unknown CrossOriginEmbedderPolicyValue value: %v", s)
	}
	return nil
}

// CrossOriginEmbedderPolicyStatus [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-CrossOriginEmbedderPolicyStatus
type CrossOriginEmbedderPolicyStatus struct {
	Value                       CrossOriginEmbedderPolicyValue `json:"value"`
	ReportOnlyValue             CrossOriginEmbedderPolicyValue `json:"reportOnlyValue"`
	ReportingEndpoint           string                         `json:"reportingEndpoint,omitempty,omitzero"`
	ReportOnlyReportingEndpoint string                         `json:"reportOnlyReportingEndpoint,omitempty,omitzero"`
}

// ContentSecurityPolicySource [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-ContentSecurityPolicySource
type ContentSecurityPolicySource string

// String returns the ContentSecurityPolicySource as string value.
func (t ContentSecurityPolicySource) String() string {
	return string(t)
}

// ContentSecurityPolicySource values.
const (
	ContentSecurityPolicySourceHTTP ContentSecurityPolicySource = "HTTP"
	ContentSecurityPolicySourceMeta ContentSecurityPolicySource = "Meta"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *ContentSecurityPolicySource) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch ContentSecurityPolicySource(s) {
	case ContentSecurityPolicySourceHTTP:
		*t = ContentSecurityPolicySourceHTTP
	case ContentSecurityPolicySourceMeta:
		*t = ContentSecurityPolicySourceMeta
	default:
		return fmt.Errorf("unknown ContentSecurityPolicySource value: %v", s)
	}
	return nil
}

// ContentSecurityPolicyStatus [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-ContentSecurityPolicyStatus
type ContentSecurityPolicyStatus struct {
	EffectiveDirectives string                      `json:"effectiveDirectives"`
	IsEnforced          bool                        `json:"isEnforced"`
	Source              ContentSecurityPolicySource `json:"source"`
}

// SecurityIsolationStatus [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-SecurityIsolationStatus
type SecurityIsolationStatus struct {
	Coop *CrossOriginOpenerPolicyStatus   `json:"coop,omitempty,omitzero"`
	Coep *CrossOriginEmbedderPolicyStatus `json:"coep,omitempty,omitzero"`
	Csp  []*ContentSecurityPolicyStatus   `json:"csp,omitempty,omitzero"`
}

// ReportStatus the status of a Reporting API report.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-ReportStatus
type ReportStatus string

// String returns the ReportStatus as string value.
func (t ReportStatus) String() string {
	return string(t)
}

// ReportStatus values.
const (
	ReportStatusQueued           ReportStatus = "Queued"
	ReportStatusPending          ReportStatus = "Pending"
	ReportStatusMarkedForRemoval ReportStatus = "MarkedForRemoval"
	ReportStatusSuccess          ReportStatus = "Success"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *ReportStatus) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch ReportStatus(s) {
	case ReportStatusQueued:
		*t = ReportStatusQueued
	case ReportStatusPending:
		*t = ReportStatusPending
	case ReportStatusMarkedForRemoval:
		*t = ReportStatusMarkedForRemoval
	case ReportStatusSuccess:
		*t = ReportStatusSuccess
	default:
		return fmt.Errorf("unknown ReportStatus value: %v", s)
	}
	return nil
}

// ReportID [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-ReportId
type ReportID string

// String returns the ReportID as string value.
func (t ReportID) String() string {
	return string(t)
}

// ReportingAPIReport an object representing a report generated by the
// Reporting API.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-ReportingApiReport
type ReportingAPIReport struct {
	ID                ReportID            `json:"id"`
	InitiatorURL      string              `json:"initiatorUrl"`      // The URL of the document that triggered the report.
	Destination       string              `json:"destination"`       // The name of the endpoint group that should be used to deliver the report.
	Type              string              `json:"type"`              // The type of the report (specifies the set of data that is contained in the report body).
	Timestamp         *cdp.TimeSinceEpoch `json:"timestamp"`         // When the report was generated.
	Depth             int64               `json:"depth"`             // How many uploads deep the related request was.
	CompletedAttempts int64               `json:"completedAttempts"` // The number of delivery attempts made so far, not including an active attempt.
	Body              jsontext.Value      `json:"body"`
	Status            ReportStatus        `json:"status"`
}

// ReportingAPIEndpoint [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-ReportingApiEndpoint
type ReportingAPIEndpoint struct {
	URL       string `json:"url"`       // The URL of the endpoint to which reports may be delivered.
	GroupName string `json:"groupName"` // Name of the endpoint group.
}

// LoadNetworkResourcePageResult an object providing the result of a network
// resource load.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-LoadNetworkResourcePageResult
type LoadNetworkResourcePageResult struct {
	Success        bool            `json:"success"`
	NetError       float64         `json:"netError,omitempty,omitzero"` // Optional values used for error reporting.
	NetErrorName   string          `json:"netErrorName,omitempty,omitzero"`
	HTTPStatusCode float64         `json:"httpStatusCode,omitempty,omitzero"`
	Stream         io.StreamHandle `json:"stream,omitempty,omitzero"`  // If successful, one of the following two fields holds the result.
	Headers        Headers         `json:"headers,omitempty,omitzero"` // Response headers.
}

// LoadNetworkResourceOptions an options object that may be extended later to
// better support CORS, CORB and streaming.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-LoadNetworkResourceOptions
type LoadNetworkResourceOptions struct {
	DisableCache       bool `json:"disableCache"`
	IncludeCredentials bool `json:"includeCredentials"`
}

// ReferrerPolicy the referrer policy of the request, as defined in
// https://www.w3.org/TR/referrer-policy/.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-Request
type ReferrerPolicy string

// String returns the ReferrerPolicy as string value.
func (t ReferrerPolicy) String() string {
	return string(t)
}

// ReferrerPolicy values.
const (
	ReferrerPolicyUnsafeURL                   ReferrerPolicy = "unsafe-url"
	ReferrerPolicyNoReferrerWhenDowngrade     ReferrerPolicy = "no-referrer-when-downgrade"
	ReferrerPolicyNoReferrer                  ReferrerPolicy = "no-referrer"
	ReferrerPolicyOrigin                      ReferrerPolicy = "origin"
	ReferrerPolicyOriginWhenCrossOrigin       ReferrerPolicy = "origin-when-cross-origin"
	ReferrerPolicySameOrigin                  ReferrerPolicy = "same-origin"
	ReferrerPolicyStrictOrigin                ReferrerPolicy = "strict-origin"
	ReferrerPolicyStrictOriginWhenCrossOrigin ReferrerPolicy = "strict-origin-when-cross-origin"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *ReferrerPolicy) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch ReferrerPolicy(s) {
	case ReferrerPolicyUnsafeURL:
		*t = ReferrerPolicyUnsafeURL
	case ReferrerPolicyNoReferrerWhenDowngrade:
		*t = ReferrerPolicyNoReferrerWhenDowngrade
	case ReferrerPolicyNoReferrer:
		*t = ReferrerPolicyNoReferrer
	case ReferrerPolicyOrigin:
		*t = ReferrerPolicyOrigin
	case ReferrerPolicyOriginWhenCrossOrigin:
		*t = ReferrerPolicyOriginWhenCrossOrigin
	case ReferrerPolicySameOrigin:
		*t = ReferrerPolicySameOrigin
	case ReferrerPolicyStrictOrigin:
		*t = ReferrerPolicyStrictOrigin
	case ReferrerPolicyStrictOriginWhenCrossOrigin:
		*t = ReferrerPolicyStrictOriginWhenCrossOrigin
	default:
		return fmt.Errorf("unknown ReferrerPolicy value: %v", s)
	}
	return nil
}

// TrustTokenParamsRefreshPolicy only set for "token-redemption" operation
// and determine whether to request a fresh SRR or use a still valid cached SRR.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-TrustTokenParams
type TrustTokenParamsRefreshPolicy string

// String returns the TrustTokenParamsRefreshPolicy as string value.
func (t TrustTokenParamsRefreshPolicy) String() string {
	return string(t)
}

// TrustTokenParamsRefreshPolicy values.
const (
	TrustTokenParamsRefreshPolicyUseCached TrustTokenParamsRefreshPolicy = "UseCached"
	TrustTokenParamsRefreshPolicyRefresh   TrustTokenParamsRefreshPolicy = "Refresh"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *TrustTokenParamsRefreshPolicy) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch TrustTokenParamsRefreshPolicy(s) {
	case TrustTokenParamsRefreshPolicyUseCached:
		*t = TrustTokenParamsRefreshPolicyUseCached
	case TrustTokenParamsRefreshPolicyRefresh:
		*t = TrustTokenParamsRefreshPolicyRefresh
	default:
		return fmt.Errorf("unknown TrustTokenParamsRefreshPolicy value: %v", s)
	}
	return nil
}

// InitiatorType type of this initiator.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-Initiator
type InitiatorType string

// String returns the InitiatorType as string value.
func (t InitiatorType) String() string {
	return string(t)
}

// InitiatorType values.
const (
	InitiatorTypeParser         InitiatorType = "parser"
	InitiatorTypeScript         InitiatorType = "script"
	InitiatorTypePreload        InitiatorType = "preload"
	InitiatorTypeSignedExchange InitiatorType = "SignedExchange"
	InitiatorTypePreflight      InitiatorType = "preflight"
	InitiatorTypeOther          InitiatorType = "other"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *InitiatorType) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch InitiatorType(s) {
	case InitiatorTypeParser:
		*t = InitiatorTypeParser
	case InitiatorTypeScript:
		*t = InitiatorTypeScript
	case InitiatorTypePreload:
		*t = InitiatorTypePreload
	case InitiatorTypeSignedExchange:
		*t = InitiatorTypeSignedExchange
	case InitiatorTypePreflight:
		*t = InitiatorTypePreflight
	case InitiatorTypeOther:
		*t = InitiatorTypeOther
	default:
		return fmt.Errorf("unknown InitiatorType value: %v", s)
	}
	return nil
}

// AuthChallengeSource source of the authentication challenge.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-AuthChallenge
type AuthChallengeSource string

// String returns the AuthChallengeSource as string value.
func (t AuthChallengeSource) String() string {
	return string(t)
}

// AuthChallengeSource values.
const (
	AuthChallengeSourceServer AuthChallengeSource = "Server"
	AuthChallengeSourceProxy  AuthChallengeSource = "Proxy"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *AuthChallengeSource) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch AuthChallengeSource(s) {
	case AuthChallengeSourceServer:
		*t = AuthChallengeSourceServer
	case AuthChallengeSourceProxy:
		*t = AuthChallengeSourceProxy
	default:
		return fmt.Errorf("unknown AuthChallengeSource value: %v", s)
	}
	return nil
}

// AuthChallengeResponseResponse the decision on what to do in response to
// the authorization challenge. Default means deferring to the default behavior
// of the net stack, which will likely either the Cancel authentication or
// display a popup dialog box.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#type-AuthChallengeResponse
type AuthChallengeResponseResponse string

// String returns the AuthChallengeResponseResponse as string value.
func (t AuthChallengeResponseResponse) String() string {
	return string(t)
}

// AuthChallengeResponseResponse values.
const (
	AuthChallengeResponseResponseDefault            AuthChallengeResponseResponse = "Default"
	AuthChallengeResponseResponseCancelAuth         AuthChallengeResponseResponse = "CancelAuth"
	AuthChallengeResponseResponseProvideCredentials AuthChallengeResponseResponse = "ProvideCredentials"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *AuthChallengeResponseResponse) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch AuthChallengeResponseResponse(s) {
	case AuthChallengeResponseResponseDefault:
		*t = AuthChallengeResponseResponseDefault
	case AuthChallengeResponseResponseCancelAuth:
		*t = AuthChallengeResponseResponseCancelAuth
	case AuthChallengeResponseResponseProvideCredentials:
		*t = AuthChallengeResponseResponseProvideCredentials
	default:
		return fmt.Errorf("unknown AuthChallengeResponseResponse value: %v", s)
	}
	return nil
}

// TrustTokenOperationDoneStatus detailed success or error status of the
// operation. 'AlreadyExists' also signifies a successful operation, as the
// result of the operation already exists und thus, the operation was abort
// preemptively (e.g. a cache hit).
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Network#event-trustTokenOperationDone
type TrustTokenOperationDoneStatus string

// String returns the TrustTokenOperationDoneStatus as string value.
func (t TrustTokenOperationDoneStatus) String() string {
	return string(t)
}

// TrustTokenOperationDoneStatus values.
const (
	TrustTokenOperationDoneStatusOk                 TrustTokenOperationDoneStatus = "Ok"
	TrustTokenOperationDoneStatusInvalidArgument    TrustTokenOperationDoneStatus = "InvalidArgument"
	TrustTokenOperationDoneStatusMissingIssuerKeys  TrustTokenOperationDoneStatus = "MissingIssuerKeys"
	TrustTokenOperationDoneStatusFailedPrecondition TrustTokenOperationDoneStatus = "FailedPrecondition"
	TrustTokenOperationDoneStatusResourceExhausted  TrustTokenOperationDoneStatus = "ResourceExhausted"
	TrustTokenOperationDoneStatusAlreadyExists      TrustTokenOperationDoneStatus = "AlreadyExists"
	TrustTokenOperationDoneStatusResourceLimited    TrustTokenOperationDoneStatus = "ResourceLimited"
	TrustTokenOperationDoneStatusUnauthorized       TrustTokenOperationDoneStatus = "Unauthorized"
	TrustTokenOperationDoneStatusBadResponse        TrustTokenOperationDoneStatus = "BadResponse"
	TrustTokenOperationDoneStatusInternalError      TrustTokenOperationDoneStatus = "InternalError"
	TrustTokenOperationDoneStatusUnknownError       TrustTokenOperationDoneStatus = "UnknownError"
	TrustTokenOperationDoneStatusFulfilledLocally   TrustTokenOperationDoneStatus = "FulfilledLocally"
	TrustTokenOperationDoneStatusSiteIssuerLimit    TrustTokenOperationDoneStatus = "SiteIssuerLimit"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *TrustTokenOperationDoneStatus) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch TrustTokenOperationDoneStatus(s) {
	case TrustTokenOperationDoneStatusOk:
		*t = TrustTokenOperationDoneStatusOk
	case TrustTokenOperationDoneStatusInvalidArgument:
		*t = TrustTokenOperationDoneStatusInvalidArgument
	case TrustTokenOperationDoneStatusMissingIssuerKeys:
		*t = TrustTokenOperationDoneStatusMissingIssuerKeys
	case TrustTokenOperationDoneStatusFailedPrecondition:
		*t = TrustTokenOperationDoneStatusFailedPrecondition
	case TrustTokenOperationDoneStatusResourceExhausted:
		*t = TrustTokenOperationDoneStatusResourceExhausted
	case TrustTokenOperationDoneStatusAlreadyExists:
		*t = TrustTokenOperationDoneStatusAlreadyExists
	case TrustTokenOperationDoneStatusResourceLimited:
		*t = TrustTokenOperationDoneStatusResourceLimited
	case TrustTokenOperationDoneStatusUnauthorized:
		*t = TrustTokenOperationDoneStatusUnauthorized
	case TrustTokenOperationDoneStatusBadResponse:
		*t = TrustTokenOperationDoneStatusBadResponse
	case TrustTokenOperationDoneStatusInternalError:
		*t = TrustTokenOperationDoneStatusInternalError
	case TrustTokenOperationDoneStatusUnknownError:
		*t = TrustTokenOperationDoneStatusUnknownError
	case TrustTokenOperationDoneStatusFulfilledLocally:
		*t = TrustTokenOperationDoneStatusFulfilledLocally
	case TrustTokenOperationDoneStatusSiteIssuerLimit:
		*t = TrustTokenOperationDoneStatusSiteIssuerLimit
	default:
		return fmt.Errorf("unknown TrustTokenOperationDoneStatus value: %v", s)
	}
	return nil
}
