// Package domdebugger provides the Chrome DevTools Protocol
// commands, types, and events for the DOMDebugger domain.
//
// DOM debugging allows setting breakpoints on particular DOM operations and
// events. JavaScript execution will stop on these operations as if there was a
// regular breakpoint set.
//
// Generated by the cdproto-gen command.
package domdebugger

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"context"

	"github.com/chromedp/cdproto/cdp"
	"github.com/chromedp/cdproto/runtime"
)

// GetEventListenersParams returns event listeners of the given object.
type GetEventListenersParams struct {
	ObjectID runtime.RemoteObjectID `json:"objectId"`                  // Identifier of the object to return listeners for.
	Depth    int64                  `json:"depth,omitempty,omitzero"`  // The maximum depth at which Node children should be retrieved, defaults to 1. Use -1 for the entire subtree or provide an integer larger than 0.
	Pierce   bool                   `json:"pierce,omitempty,omitzero"` // Whether or not iframes and shadow roots should be traversed when returning the subtree (default is false). Reports listeners for all contexts if pierce is enabled.
}

// GetEventListeners returns event listeners of the given object.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/DOMDebugger#method-getEventListeners
//
// parameters:
//
//	objectID - Identifier of the object to return listeners for.
func GetEventListeners(objectID runtime.RemoteObjectID) *GetEventListenersParams {
	return &GetEventListenersParams{
		ObjectID: objectID,
	}
}

// WithDepth the maximum depth at which Node children should be retrieved,
// defaults to 1. Use -1 for the entire subtree or provide an integer larger
// than 0.
func (p GetEventListenersParams) WithDepth(depth int64) *GetEventListenersParams {
	p.Depth = depth
	return &p
}

// WithPierce whether or not iframes and shadow roots should be traversed
// when returning the subtree (default is false). Reports listeners for all
// contexts if pierce is enabled.
func (p GetEventListenersParams) WithPierce(pierce bool) *GetEventListenersParams {
	p.Pierce = pierce
	return &p
}

// GetEventListenersReturns return values.
type GetEventListenersReturns struct {
	Listeners []*EventListener `json:"listeners,omitempty,omitzero"` // Array of relevant listeners.
}

// Do executes DOMDebugger.getEventListeners against the provided context.
//
// returns:
//
//	listeners - Array of relevant listeners.
func (p *GetEventListenersParams) Do(ctx context.Context) (listeners []*EventListener, err error) {
	// execute
	var res GetEventListenersReturns
	err = cdp.Execute(ctx, CommandGetEventListeners, p, &res)
	if err != nil {
		return nil, err
	}

	return res.Listeners, nil
}

// RemoveDOMBreakpointParams removes DOM breakpoint that was set using
// setDOMBreakpoint.
type RemoveDOMBreakpointParams struct {
	NodeID cdp.NodeID        `json:"nodeId"` // Identifier of the node to remove breakpoint from.
	Type   DOMBreakpointType `json:"type"`   // Type of the breakpoint to remove.
}

// RemoveDOMBreakpoint removes DOM breakpoint that was set using
// setDOMBreakpoint.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/DOMDebugger#method-removeDOMBreakpoint
//
// parameters:
//
//	nodeID - Identifier of the node to remove breakpoint from.
//	type - Type of the breakpoint to remove.
func RemoveDOMBreakpoint(nodeID cdp.NodeID, typeVal DOMBreakpointType) *RemoveDOMBreakpointParams {
	return &RemoveDOMBreakpointParams{
		NodeID: nodeID,
		Type:   typeVal,
	}
}

// Do executes DOMDebugger.removeDOMBreakpoint against the provided context.
func (p *RemoveDOMBreakpointParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandRemoveDOMBreakpoint, p, nil)
}

// RemoveEventListenerBreakpointParams removes breakpoint on particular DOM
// event.
type RemoveEventListenerBreakpointParams struct {
	EventName  string `json:"eventName"`                     // Event name.
	TargetName string `json:"targetName,omitempty,omitzero"` // EventTarget interface name.
}

// RemoveEventListenerBreakpoint removes breakpoint on particular DOM event.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/DOMDebugger#method-removeEventListenerBreakpoint
//
// parameters:
//
//	eventName - Event name.
func RemoveEventListenerBreakpoint(eventName string) *RemoveEventListenerBreakpointParams {
	return &RemoveEventListenerBreakpointParams{
		EventName: eventName,
	}
}

// WithTargetName eventTarget interface name.
func (p RemoveEventListenerBreakpointParams) WithTargetName(targetName string) *RemoveEventListenerBreakpointParams {
	p.TargetName = targetName
	return &p
}

// Do executes DOMDebugger.removeEventListenerBreakpoint against the provided context.
func (p *RemoveEventListenerBreakpointParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandRemoveEventListenerBreakpoint, p, nil)
}

// RemoveXHRBreakpointParams removes breakpoint from XMLHttpRequest.
type RemoveXHRBreakpointParams struct {
	URL string `json:"url"` // Resource URL substring.
}

// RemoveXHRBreakpoint removes breakpoint from XMLHttpRequest.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/DOMDebugger#method-removeXHRBreakpoint
//
// parameters:
//
//	url - Resource URL substring.
func RemoveXHRBreakpoint(url string) *RemoveXHRBreakpointParams {
	return &RemoveXHRBreakpointParams{
		URL: url,
	}
}

// Do executes DOMDebugger.removeXHRBreakpoint against the provided context.
func (p *RemoveXHRBreakpointParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandRemoveXHRBreakpoint, p, nil)
}

// SetBreakOnCSPViolationParams sets breakpoint on particular CSP violations.
type SetBreakOnCSPViolationParams struct {
	ViolationTypes []CSPViolationType `json:"violationTypes"` // CSP Violations to stop upon.
}

// SetBreakOnCSPViolation sets breakpoint on particular CSP violations.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/DOMDebugger#method-setBreakOnCSPViolation
//
// parameters:
//
//	violationTypes - CSP Violations to stop upon.
func SetBreakOnCSPViolation(violationTypes []CSPViolationType) *SetBreakOnCSPViolationParams {
	return &SetBreakOnCSPViolationParams{
		ViolationTypes: violationTypes,
	}
}

// Do executes DOMDebugger.setBreakOnCSPViolation against the provided context.
func (p *SetBreakOnCSPViolationParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetBreakOnCSPViolation, p, nil)
}

// SetDOMBreakpointParams sets breakpoint on particular operation with DOM.
type SetDOMBreakpointParams struct {
	NodeID cdp.NodeID        `json:"nodeId"` // Identifier of the node to set breakpoint on.
	Type   DOMBreakpointType `json:"type"`   // Type of the operation to stop upon.
}

// SetDOMBreakpoint sets breakpoint on particular operation with DOM.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/DOMDebugger#method-setDOMBreakpoint
//
// parameters:
//
//	nodeID - Identifier of the node to set breakpoint on.
//	type - Type of the operation to stop upon.
func SetDOMBreakpoint(nodeID cdp.NodeID, typeVal DOMBreakpointType) *SetDOMBreakpointParams {
	return &SetDOMBreakpointParams{
		NodeID: nodeID,
		Type:   typeVal,
	}
}

// Do executes DOMDebugger.setDOMBreakpoint against the provided context.
func (p *SetDOMBreakpointParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetDOMBreakpoint, p, nil)
}

// SetEventListenerBreakpointParams sets breakpoint on particular DOM event.
type SetEventListenerBreakpointParams struct {
	EventName  string `json:"eventName"`                     // DOM Event name to stop on (any DOM event will do).
	TargetName string `json:"targetName,omitempty,omitzero"` // EventTarget interface name to stop on. If equal to "*" or not provided, will stop on any EventTarget.
}

// SetEventListenerBreakpoint sets breakpoint on particular DOM event.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/DOMDebugger#method-setEventListenerBreakpoint
//
// parameters:
//
//	eventName - DOM Event name to stop on (any DOM event will do).
func SetEventListenerBreakpoint(eventName string) *SetEventListenerBreakpointParams {
	return &SetEventListenerBreakpointParams{
		EventName: eventName,
	}
}

// WithTargetName eventTarget interface name to stop on. If equal to "*" or
// not provided, will stop on any EventTarget.
func (p SetEventListenerBreakpointParams) WithTargetName(targetName string) *SetEventListenerBreakpointParams {
	p.TargetName = targetName
	return &p
}

// Do executes DOMDebugger.setEventListenerBreakpoint against the provided context.
func (p *SetEventListenerBreakpointParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetEventListenerBreakpoint, p, nil)
}

// SetXHRBreakpointParams sets breakpoint on XMLHttpRequest.
type SetXHRBreakpointParams struct {
	URL string `json:"url"` // Resource URL substring. All XHRs having this substring in the URL will get stopped upon.
}

// SetXHRBreakpoint sets breakpoint on XMLHttpRequest.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/DOMDebugger#method-setXHRBreakpoint
//
// parameters:
//
//	url - Resource URL substring. All XHRs having this substring in the URL will get stopped upon.
func SetXHRBreakpoint(url string) *SetXHRBreakpointParams {
	return &SetXHRBreakpointParams{
		URL: url,
	}
}

// Do executes DOMDebugger.setXHRBreakpoint against the provided context.
func (p *SetXHRBreakpointParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetXHRBreakpoint, p, nil)
}

// Command names.
const (
	CommandGetEventListeners             = "DOMDebugger.getEventListeners"
	CommandRemoveDOMBreakpoint           = "DOMDebugger.removeDOMBreakpoint"
	CommandRemoveEventListenerBreakpoint = "DOMDebugger.removeEventListenerBreakpoint"
	CommandRemoveXHRBreakpoint           = "DOMDebugger.removeXHRBreakpoint"
	CommandSetBreakOnCSPViolation        = "DOMDebugger.setBreakOnCSPViolation"
	CommandSetDOMBreakpoint              = "DOMDebugger.setDOMBreakpoint"
	CommandSetEventListenerBreakpoint    = "DOMDebugger.setEventListenerBreakpoint"
	CommandSetXHRBreakpoint              = "DOMDebugger.setXHRBreakpoint"
)
