package browser

import (
	"fmt"
	"strings"
)

// Code generated by cdproto-gen. DO NOT EDIT.

// WindowID [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Browser#type-WindowID
type WindowID int64

// Int64 returns the WindowID as int64 value.
func (t WindowID) Int64() int64 {
	return int64(t)
}

// WindowState the state of the browser window.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Browser#type-WindowState
type WindowState string

// String returns the WindowState as string value.
func (t WindowState) String() string {
	return string(t)
}

// WindowState values.
const (
	WindowStateNormal     WindowState = "normal"
	WindowStateMinimized  WindowState = "minimized"
	WindowStateMaximized  WindowState = "maximized"
	WindowStateFullscreen WindowState = "fullscreen"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *WindowState) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch WindowState(s) {
	case WindowStateNormal:
		*t = WindowStateNormal
	case WindowStateMinimized:
		*t = WindowStateMinimized
	case WindowStateMaximized:
		*t = WindowStateMaximized
	case WindowStateFullscreen:
		*t = WindowStateFullscreen
	default:
		return fmt.Errorf("unknown WindowState value: %v", s)
	}
	return nil
}

// Bounds browser window bounds information.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Browser#type-Bounds
type Bounds struct {
	Left        int64       `json:"left,omitempty,omitzero"`        // The offset from the left edge of the screen to the window in pixels.
	Top         int64       `json:"top,omitempty,omitzero"`         // The offset from the top edge of the screen to the window in pixels.
	Width       int64       `json:"width,omitempty,omitzero"`       // The window width in pixels.
	Height      int64       `json:"height,omitempty,omitzero"`      // The window height in pixels.
	WindowState WindowState `json:"windowState,omitempty,omitzero"` // The window state. Default to normal.
}

// PermissionType [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Browser#type-PermissionType
type PermissionType string

// String returns the PermissionType as string value.
func (t PermissionType) String() string {
	return string(t)
}

// PermissionType values.
const (
	PermissionTypeAr                       PermissionType = "ar"
	PermissionTypeAudioCapture             PermissionType = "audioCapture"
	PermissionTypeAutomaticFullscreen      PermissionType = "automaticFullscreen"
	PermissionTypeBackgroundFetch          PermissionType = "backgroundFetch"
	PermissionTypeBackgroundSync           PermissionType = "backgroundSync"
	PermissionTypeCameraPanTiltZoom        PermissionType = "cameraPanTiltZoom"
	PermissionTypeCapturedSurfaceControl   PermissionType = "capturedSurfaceControl"
	PermissionTypeClipboardReadWrite       PermissionType = "clipboardReadWrite"
	PermissionTypeClipboardSanitizedWrite  PermissionType = "clipboardSanitizedWrite"
	PermissionTypeDisplayCapture           PermissionType = "displayCapture"
	PermissionTypeDurableStorage           PermissionType = "durableStorage"
	PermissionTypeGeolocation              PermissionType = "geolocation"
	PermissionTypeHandTracking             PermissionType = "handTracking"
	PermissionTypeIdleDetection            PermissionType = "idleDetection"
	PermissionTypeKeyboardLock             PermissionType = "keyboardLock"
	PermissionTypeLocalFonts               PermissionType = "localFonts"
	PermissionTypeLocalNetworkAccess       PermissionType = "localNetworkAccess"
	PermissionTypeMidi                     PermissionType = "midi"
	PermissionTypeMidiSysex                PermissionType = "midiSysex"
	PermissionTypeNfc                      PermissionType = "nfc"
	PermissionTypeNotifications            PermissionType = "notifications"
	PermissionTypePaymentHandler           PermissionType = "paymentHandler"
	PermissionTypePeriodicBackgroundSync   PermissionType = "periodicBackgroundSync"
	PermissionTypePointerLock              PermissionType = "pointerLock"
	PermissionTypeProtectedMediaIdentifier PermissionType = "protectedMediaIdentifier"
	PermissionTypeSensors                  PermissionType = "sensors"
	PermissionTypeSmartCard                PermissionType = "smartCard"
	PermissionTypeSpeakerSelection         PermissionType = "speakerSelection"
	PermissionTypeStorageAccess            PermissionType = "storageAccess"
	PermissionTypeTopLevelStorageAccess    PermissionType = "topLevelStorageAccess"
	PermissionTypeVideoCapture             PermissionType = "videoCapture"
	PermissionTypeVr                       PermissionType = "vr"
	PermissionTypeWakeLockScreen           PermissionType = "wakeLockScreen"
	PermissionTypeWakeLockSystem           PermissionType = "wakeLockSystem"
	PermissionTypeWebAppInstallation       PermissionType = "webAppInstallation"
	PermissionTypeWebPrinting              PermissionType = "webPrinting"
	PermissionTypeWindowManagement         PermissionType = "windowManagement"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *PermissionType) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch PermissionType(s) {
	case PermissionTypeAr:
		*t = PermissionTypeAr
	case PermissionTypeAudioCapture:
		*t = PermissionTypeAudioCapture
	case PermissionTypeAutomaticFullscreen:
		*t = PermissionTypeAutomaticFullscreen
	case PermissionTypeBackgroundFetch:
		*t = PermissionTypeBackgroundFetch
	case PermissionTypeBackgroundSync:
		*t = PermissionTypeBackgroundSync
	case PermissionTypeCameraPanTiltZoom:
		*t = PermissionTypeCameraPanTiltZoom
	case PermissionTypeCapturedSurfaceControl:
		*t = PermissionTypeCapturedSurfaceControl
	case PermissionTypeClipboardReadWrite:
		*t = PermissionTypeClipboardReadWrite
	case PermissionTypeClipboardSanitizedWrite:
		*t = PermissionTypeClipboardSanitizedWrite
	case PermissionTypeDisplayCapture:
		*t = PermissionTypeDisplayCapture
	case PermissionTypeDurableStorage:
		*t = PermissionTypeDurableStorage
	case PermissionTypeGeolocation:
		*t = PermissionTypeGeolocation
	case PermissionTypeHandTracking:
		*t = PermissionTypeHandTracking
	case PermissionTypeIdleDetection:
		*t = PermissionTypeIdleDetection
	case PermissionTypeKeyboardLock:
		*t = PermissionTypeKeyboardLock
	case PermissionTypeLocalFonts:
		*t = PermissionTypeLocalFonts
	case PermissionTypeLocalNetworkAccess:
		*t = PermissionTypeLocalNetworkAccess
	case PermissionTypeMidi:
		*t = PermissionTypeMidi
	case PermissionTypeMidiSysex:
		*t = PermissionTypeMidiSysex
	case PermissionTypeNfc:
		*t = PermissionTypeNfc
	case PermissionTypeNotifications:
		*t = PermissionTypeNotifications
	case PermissionTypePaymentHandler:
		*t = PermissionTypePaymentHandler
	case PermissionTypePeriodicBackgroundSync:
		*t = PermissionTypePeriodicBackgroundSync
	case PermissionTypePointerLock:
		*t = PermissionTypePointerLock
	case PermissionTypeProtectedMediaIdentifier:
		*t = PermissionTypeProtectedMediaIdentifier
	case PermissionTypeSensors:
		*t = PermissionTypeSensors
	case PermissionTypeSmartCard:
		*t = PermissionTypeSmartCard
	case PermissionTypeSpeakerSelection:
		*t = PermissionTypeSpeakerSelection
	case PermissionTypeStorageAccess:
		*t = PermissionTypeStorageAccess
	case PermissionTypeTopLevelStorageAccess:
		*t = PermissionTypeTopLevelStorageAccess
	case PermissionTypeVideoCapture:
		*t = PermissionTypeVideoCapture
	case PermissionTypeVr:
		*t = PermissionTypeVr
	case PermissionTypeWakeLockScreen:
		*t = PermissionTypeWakeLockScreen
	case PermissionTypeWakeLockSystem:
		*t = PermissionTypeWakeLockSystem
	case PermissionTypeWebAppInstallation:
		*t = PermissionTypeWebAppInstallation
	case PermissionTypeWebPrinting:
		*t = PermissionTypeWebPrinting
	case PermissionTypeWindowManagement:
		*t = PermissionTypeWindowManagement
	default:
		return fmt.Errorf("unknown PermissionType value: %v", s)
	}
	return nil
}

// PermissionSetting [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Browser#type-PermissionSetting
type PermissionSetting string

// String returns the PermissionSetting as string value.
func (t PermissionSetting) String() string {
	return string(t)
}

// PermissionSetting values.
const (
	PermissionSettingGranted PermissionSetting = "granted"
	PermissionSettingDenied  PermissionSetting = "denied"
	PermissionSettingPrompt  PermissionSetting = "prompt"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *PermissionSetting) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch PermissionSetting(s) {
	case PermissionSettingGranted:
		*t = PermissionSettingGranted
	case PermissionSettingDenied:
		*t = PermissionSettingDenied
	case PermissionSettingPrompt:
		*t = PermissionSettingPrompt
	default:
		return fmt.Errorf("unknown PermissionSetting value: %v", s)
	}
	return nil
}

// PermissionDescriptor definition of PermissionDescriptor defined in the
// Permissions API: https://w3c.github.io/permissions/#dom-permissiondescriptor.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Browser#type-PermissionDescriptor
type PermissionDescriptor struct {
	Name                     string `json:"name"`                                        // Name of permission. See https://cs.chromium.org/chromium/src/third_party/blink/renderer/modules/permissions/permission_descriptor.idl for valid permission names.
	Sysex                    bool   `json:"sysex,omitempty,omitzero"`                    // For "midi" permission, may also specify sysex control.
	UserVisibleOnly          bool   `json:"userVisibleOnly,omitempty,omitzero"`          // For "push" permission, may specify userVisibleOnly. Note that userVisibleOnly = true is the only currently supported type.
	AllowWithoutSanitization bool   `json:"allowWithoutSanitization,omitempty,omitzero"` // For "clipboard" permission, may specify allowWithoutSanitization.
	AllowWithoutGesture      bool   `json:"allowWithoutGesture,omitempty,omitzero"`      // For "fullscreen" permission, must specify allowWithoutGesture:true.
	PanTiltZoom              bool   `json:"panTiltZoom,omitempty,omitzero"`              // For "camera" permission, may specify panTiltZoom.
}

// CommandID browser command ids used by executeBrowserCommand.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Browser#type-BrowserCommandId
type CommandID string

// String returns the CommandID as string value.
func (t CommandID) String() string {
	return string(t)
}

// CommandID values.
const (
	CommandIDOpenTabSearch  CommandID = "openTabSearch"
	CommandIDCloseTabSearch CommandID = "closeTabSearch"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *CommandID) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch CommandID(s) {
	case CommandIDOpenTabSearch:
		*t = CommandIDOpenTabSearch
	case CommandIDCloseTabSearch:
		*t = CommandIDCloseTabSearch
	default:
		return fmt.Errorf("unknown CommandID value: %v", s)
	}
	return nil
}

// Bucket chrome histogram bucket.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Browser#type-Bucket
type Bucket struct {
	Low   int64 `json:"low"`   // Minimum value (inclusive).
	High  int64 `json:"high"`  // Maximum value (exclusive).
	Count int64 `json:"count"` // Number of samples.
}

// Histogram chrome histogram.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Browser#type-Histogram
type Histogram struct {
	Name    string    `json:"name"`    // Name.
	Sum     int64     `json:"sum"`     // Sum of sample values.
	Count   int64     `json:"count"`   // Total number of samples.
	Buckets []*Bucket `json:"buckets"` // Buckets.
}

// PrivacySandboxAPI [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Browser#type-PrivacySandboxAPI
type PrivacySandboxAPI string

// String returns the PrivacySandboxAPI as string value.
func (t PrivacySandboxAPI) String() string {
	return string(t)
}

// PrivacySandboxAPI values.
const (
	PrivacySandboxAPIBiddingAndAuctionServices PrivacySandboxAPI = "BiddingAndAuctionServices"
	PrivacySandboxAPITrustedKeyValue           PrivacySandboxAPI = "TrustedKeyValue"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *PrivacySandboxAPI) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch PrivacySandboxAPI(s) {
	case PrivacySandboxAPIBiddingAndAuctionServices:
		*t = PrivacySandboxAPIBiddingAndAuctionServices
	case PrivacySandboxAPITrustedKeyValue:
		*t = PrivacySandboxAPITrustedKeyValue
	default:
		return fmt.Errorf("unknown PrivacySandboxAPI value: %v", s)
	}
	return nil
}

// DownloadProgressState download status.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Browser#event-downloadProgress
type DownloadProgressState string

// String returns the DownloadProgressState as string value.
func (t DownloadProgressState) String() string {
	return string(t)
}

// DownloadProgressState values.
const (
	DownloadProgressStateInProgress DownloadProgressState = "inProgress"
	DownloadProgressStateCompleted  DownloadProgressState = "completed"
	DownloadProgressStateCanceled   DownloadProgressState = "canceled"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *DownloadProgressState) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch DownloadProgressState(s) {
	case DownloadProgressStateInProgress:
		*t = DownloadProgressStateInProgress
	case DownloadProgressStateCompleted:
		*t = DownloadProgressStateCompleted
	case DownloadProgressStateCanceled:
		*t = DownloadProgressStateCanceled
	default:
		return fmt.Errorf("unknown DownloadProgressState value: %v", s)
	}
	return nil
}

// SetDownloadBehaviorBehavior whether to allow all or deny all download
// requests, or use default Chrome behavior if available (otherwise deny).
// |allowAndName| allows download and names files according to their download
// guids.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Browser#method-setDownloadBehavior
type SetDownloadBehaviorBehavior string

// String returns the SetDownloadBehaviorBehavior as string value.
func (t SetDownloadBehaviorBehavior) String() string {
	return string(t)
}

// SetDownloadBehaviorBehavior values.
const (
	SetDownloadBehaviorBehaviorDeny         SetDownloadBehaviorBehavior = "deny"
	SetDownloadBehaviorBehaviorAllow        SetDownloadBehaviorBehavior = "allow"
	SetDownloadBehaviorBehaviorAllowAndName SetDownloadBehaviorBehavior = "allowAndName"
	SetDownloadBehaviorBehaviorDefault      SetDownloadBehaviorBehavior = "default"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *SetDownloadBehaviorBehavior) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch SetDownloadBehaviorBehavior(s) {
	case SetDownloadBehaviorBehaviorDeny:
		*t = SetDownloadBehaviorBehaviorDeny
	case SetDownloadBehaviorBehaviorAllow:
		*t = SetDownloadBehaviorBehaviorAllow
	case SetDownloadBehaviorBehaviorAllowAndName:
		*t = SetDownloadBehaviorBehaviorAllowAndName
	case SetDownloadBehaviorBehaviorDefault:
		*t = SetDownloadBehaviorBehaviorDefault
	default:
		return fmt.Errorf("unknown SetDownloadBehaviorBehavior value: %v", s)
	}
	return nil
}
