package bluetoothemulation

import (
	"fmt"
	"strings"
)

// Code generated by cdproto-gen. DO NOT EDIT.

// CentralState indicates the various states of Central.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#type-CentralState
type CentralState string

// String returns the CentralState as string value.
func (t CentralState) String() string {
	return string(t)
}

// CentralState values.
const (
	CentralStateAbsent     CentralState = "absent"
	CentralStatePoweredOff CentralState = "powered-off"
	CentralStatePoweredOn  CentralState = "powered-on"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *CentralState) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch CentralState(s) {
	case CentralStateAbsent:
		*t = CentralStateAbsent
	case CentralStatePoweredOff:
		*t = CentralStatePoweredOff
	case CentralStatePoweredOn:
		*t = CentralStatePoweredOn
	default:
		return fmt.Errorf("unknown CentralState value: %v", s)
	}
	return nil
}

// ManufacturerData stores the manufacturer data.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#type-ManufacturerData
type ManufacturerData struct {
	Key  int64  `json:"key"`  // Company identifier https://bitbucket.org/bluetooth-SIG/public/src/main/assigned_numbers/company_identifiers/company_identifiers.yaml https://usb.org/developers
	Data string `json:"data"` // Manufacturer-specific data
}

// ScanRecord stores the byte data of the advertisement packet sent by a
// Bluetooth device.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#type-ScanRecord
type ScanRecord struct {
	Name             string              `json:"name,omitempty,omitzero"`
	UUIDs            []string            `json:"uuids,omitempty,omitzero"`
	Appearance       int64               `json:"appearance,omitempty,omitzero"`       // Stores the external appearance description of the device.
	TxPower          int64               `json:"txPower,omitempty,omitzero"`          // Stores the transmission power of a broadcasting device.
	ManufacturerData []*ManufacturerData `json:"manufacturerData,omitempty,omitzero"` // Key is the company identifier and the value is an array of bytes of manufacturer specific data.
}

// ScanEntry stores the advertisement packet information that is sent by a
// Bluetooth device.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#type-ScanEntry
type ScanEntry struct {
	DeviceAddress string      `json:"deviceAddress"`
	Rssi          int64       `json:"rssi"`
	ScanRecord    *ScanRecord `json:"scanRecord"`
}
