/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	context "context"

	networkingv1 "k8s.io/api/networking/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	applyconfigurationsnetworkingv1 "k8s.io/client-go/applyconfigurations/networking/v1"
	gentype "k8s.io/client-go/gentype"
	scheme "k8s.io/client-go/kubernetes/scheme"
)

// IPAddressesGetter has a method to return a IPAddressInterface.
// A group's client should implement this interface.
type IPAddressesGetter interface {
	IPAddresses() IPAddressInterface
}

// IPAddressInterface has methods to work with IPAddress resources.
type IPAddressInterface interface {
	Create(ctx context.Context, iPAddress *networkingv1.IPAddress, opts metav1.CreateOptions) (*networkingv1.IPAddress, error)
	Update(ctx context.Context, iPAddress *networkingv1.IPAddress, opts metav1.UpdateOptions) (*networkingv1.IPAddress, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*networkingv1.IPAddress, error)
	List(ctx context.Context, opts metav1.ListOptions) (*networkingv1.IPAddressList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *networkingv1.IPAddress, err error)
	Apply(ctx context.Context, iPAddress *applyconfigurationsnetworkingv1.IPAddressApplyConfiguration, opts metav1.ApplyOptions) (result *networkingv1.IPAddress, err error)
	IPAddressExpansion
}

// iPAddresses implements IPAddressInterface
type iPAddresses struct {
	*gentype.ClientWithListAndApply[*networkingv1.IPAddress, *networkingv1.IPAddressList, *applyconfigurationsnetworkingv1.IPAddressApplyConfiguration]
}

// newIPAddresses returns a IPAddresses
func newIPAddresses(c *NetworkingV1Client) *iPAddresses {
	return &iPAddresses{
		gentype.NewClientWithListAndApply[*networkingv1.IPAddress, *networkingv1.IPAddressList, *applyconfigurationsnetworkingv1.IPAddressApplyConfiguration](
			"ipaddresses",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *networkingv1.IPAddress { return &networkingv1.IPAddress{} },
			func() *networkingv1.IPAddressList { return &networkingv1.IPAddressList{} },
			gentype.PrefersProtobuf[*networkingv1.IPAddress](),
		),
	}
}
