/* ====================================================================
 * Copyright (c) 2006, 2008  Martin Hauner
 *                           http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "InfoCmd.h"
#include "InfoParam.h"
#include "CmdResultCallback.h"
#include "CmdProgressCallback.h"
#include "svn/Client.h"


InfoCmd::InfoCmd( InfoParam* param, CmdResultCallback* cb )
: ScCmd(param->getId()), _param(param), _cb(cb)
{
}

InfoCmd::~InfoCmd()
{
  delete _cb;
}

void InfoCmd::run()
{
  sc::Error* err;

  _prgscb->started( _param, getCancel() );

  err = _client->info( _param->getPathOrUrl(), *_param->getRevision(),
    *_param->getPegRevision(), _param->getBaton(), _param->getRecurse() );

  _param->setError( err );
  _prgscb->finished( _param );

  _cb->handleResult( _param, err );
}
