/* ====================================================================
 * Copyright (c) 2006, 2008-2009  Martin Hauner
 *                                http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_WCVIEW_H
#define _SC_WCVIEW_H

// sc
#include "util/Id.h"
class WcViewModel;
class WcViewTreeItemModel;
class TabWidget;
class ActionStorage;

// qt
#include <QtGui/QWidget>


class WcView : public QWidget
{
  typedef QWidget super;
  Q_OBJECT

public:
  WcView( ID id, WcViewModel* model, ActionStorage* actions, QWidget*
    parent );

  ID getId() const;

public slots:
  void rootChange( QString path, QString url );

private:
  void setTitle( QWidget* w, QString path, QString url );

  ID                   _id;
  TabWidget*           _tabs;

  WcViewModel*         _model;
  WcViewTreeItemModel* _itemModel;
};


#endif // _SC_WCVIEW_H
