/* ====================================================================
 * Copyright (c) 2003-2008, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_LOGDIALOG2_H
#define _SC_LOGDIALOG2_H

// sc
#include "sublib/TargetId.h"
#include "svn/LogEntryTypes.h"
#include "svn/ClientTypes.h"
#include "util/String.h"
class RevisionWidget;
class DiffViewModel;
class MergeViewModel;
class LogViewModel;
class Project;
class LogEntryLvi;
class LogCallback;
class LogBaton;
class LogParam;
class DiffParam;
class PropSetRevParam;
class ActionStorage;
namespace svn {
  class Error;
}

// qt
#include <QtGui/QMainWindow>
class QCheckBox;
class QPushButton;
class QRadioButton;
class QTreeWidget;
class QTreeWidgetItem;
class QTextEdit;
class QSpinBox;
class QLineEdit;
class QMenu;

// sys
#include <vector>

/**
 * Dialog class for displaying log messages information.
 */
class LogDialog2 : public QMainWindow, public TargetId
{
  typedef QMainWindow super;
  Q_OBJECT 

public:
  typedef std::vector<LogEntryLvi*> LogEntryLvis;  

  LogDialog2( LogViewModel* model, const QFont& font, QWidget *parent = NULL );
  virtual ~LogDialog2();

  void setSource( const sc::String& source, bool folder );

public slots:
  void run();
  void selected( QTreeWidgetItem* item, QTreeWidgetItem* old );
  void clickedPath( QTreeWidgetItem* item, int column );
  void logChanged();
  void addLogEntry( svn::LogEntryPtr );
  void finished();

  void set();
  void diff();
  void merge();
  void undo();

  void find( const QString& text );
  void findNext();
  void findPrev();

  void contextMenuRequest( const QPoint& pos );
  void updateSelection();
  void diffToggled(bool checked);

signals:
  void showDiff( DiffViewModel* );
  void showMerge( MergeViewModel* );

private:
  void merge( bool undo );
  void getSelection( svn::LogEntries& entries );
  void getSelectedRevisions( LogEntryLvis& entries );
  void getSelectedPaths( svn::Paths& paths );
  void find( const QString& text, bool forward, int findIndex );

  LogViewModel*    _model;
  const Project*   _prj;

  RevisionWidget*  _rwStart;
  RevisionWidget*  _rwStop;

  QCheckBox*       _limitCheck;
  QSpinBox*        _limit;

  QLineEdit*       _find;
  int              _findIdx;
  QString          _findLastText;
  LogEntryLvi*     _findLastLvi;

  QCheckBox*       _changedPaths;
  QCheckBox*       _strictHistory;
  QRadioButton*    _diffv;
  QRadioButton*    _diffp;

  QTreeWidget*     _revs;
  QTreeWidget*     _paths;
  QTextEdit*       _log;
  QPushButton*     _set;

  QPushButton*     _findNext;
  QPushButton*     _findPrev;

  QPushButton*     _run;
  QPushButton*     _done;

  ActionStorage*   _actions;
  QMenu*           _menu; 
};

#endif // _SC_LOGDIALOG2_H
