/* ====================================================================
 * Copyright (c) 2007,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_LISTVIEWHEADERHANDLER_H
#define _SC_LISTVIEWHEADERHANDLER_H

// sc

// qt
#include <QtCore/QObject>
class Q3Header;

/**
 * This class is used to propagate header layout changes to all QListView Widgets
 * of the same type (@c WcViewTree, @c WcViewFlat, etc) and to store the layout
 * info in the configuration. The @c QListView @c name() will be used to store
 * the layout.
 * Eache @c QListView type uses its own handler class. The @c indexChange and
 * @c sizeChange signals of the @c QListView @c QHeader are catched and the
 * changes will be propagated to all other registered @c QHeaders.
 *
 * @todo a bit annyoing is that we propagate each change of @c QHeader, even during
 * setup and filling its parent @c QListView. That fires a lot of unwanted updates.
 */
class ListViewHeaderHandler : public QObject
{
  typedef QObject super;
  Q_OBJECT

public:
  ListViewHeaderHandler();
  ~ListViewHeaderHandler();

  /** register a new @c Q3Header* */
  void add( Q3Header* );

  /** unregister a @c Q3Header */
  void del( Q3Header* );

public slots:
  void sizeChanged( int section, int oldSize, int newSize );
  void indexChanged( int section, int fromIndex, int toIndex );

private:
  class Data;
  Data* _data;
};

#endif // _SC_LISTVIEWHEADERHANDLER_H
