/* ====================================================================
 * Copyright (c) 2003-2008  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_CONFIGMANAGER_H
#define _SC_CONFIGMANAGER_H

//sc
#include "settings/ProjectSettings.h"
#include "settings/ToolsSettings.h"
#include "settings/FontSettings.h"
#include "settings/CommitLogHistory.h"
#include "settings/SubversionSettings.h"
#include "sublib/settings/ColorSettings.h"
#include "sublib/settings/LayoutSettings.h"
#include "sublib/DebugSettings.h"
class ConfigFile;
class ConfigData;

// qt
class Q3Header;


class ConfigManager :
  public ProjectSettings,
  public FontSettings,
  public ColorSettings,
  public LayoutSettings,
  public ToolsSettings,
  public CommitLogHistory,
  public SubversionSettings,
  public DebugSettings
{
public:
  ConfigManager();
  ~ConfigManager();

  void load();
  void save();

  /**
   * \name ProjectSettings.
   */
  // @{
  void getProjects( Projects& projects );
  void setProject( const Project* project );
  void removeProject( const Project* project );
  // @}

  /**
   * \name FontSettings.
   */
  // @{
  QFont getGeneralFont();
  void setGeneralFont( const QFont& );
  QFont getEditorFont();
  void setEditorFont( const QFont& );
  // @}

  /**
   * \name ColorSettings.
   */
  // @{
  void getColors( Colors& );
  void setColors( const Colors& );
  // @}

  /**
   * \name LayoutSettings.
   */
  // @{
  int  getValue( const QString& key, int def );
  void setValue( const QString& key, int value );
  QSize getSize( const QString& key, const QSize& def );
  void  setSize( const QString& key, const QSize& size );
  QRect getRect( const QString& key, const QRect& def );
  void  setRect( const QString& key, const QRect& rect );
  QByteArray getByteArray( const QString& key, const QByteArray& def );
  void setByteArray( const QString& key, const QByteArray& bytearray );
  void getHeaderColumns( const QString& key, Q3Header* );
  void setHeaderColumns( const QString& key, const Q3Header* );
  // @}

  /**
   * \name ToolsSettings.
   */
  // @{
  sc::String getBuiltinDiffCmd();
  sc::String getDiffCmd();
  void setDiffCmd( const sc::String& );
  sc::String getBuiltinMergeCmd();
  sc::String getMergeCmd();
  void setMergeCmd( const sc::String& );
  // @}

  /**
   * \name CommitLogHistory.
   */
  // @{
  void getLogs( Logs& logs );
  void addLog( const sc::String& );
  // @}

  /**
   * \name SubversionSettings.
   */
  // @{
  bool getAspDotNetHack();
  void setAspDotNetHack( bool enable );
  // @}

  /**
   * \name DebugSettings.
   */
  // @{
  bool getDump();
  void setDump(bool);
  bool getLog();
  void setLog(bool);
  bool getL10n();
  void setL10n(bool);
  // @}

  /// \name Options.
  // @{
  bool getOptCommandForce() const;
  void setOptCommandForce( bool );
  bool getOptCommandRecursive() const;  // obsolete
  void setOptCommandRecursive( bool );  // obsolete
  bool getOptStatusUpdates() const;     // obsolete
  void setOptStatusUpdates( bool );     // obsolete
  bool getOptStatusIgnored() const;     // obsolete
  void setOptStatusIgnored( bool );     // obsolete
  bool getOptStatusRecursive() const;   // obsolete
  void setOptStatusRecursive( bool );   // obsolete
  // @}

private:
  Color getColor( long id, const sc::String& name, const QColor& def, const sc::String& desc );

  /** remove obsolete keys */
  void clean();

private:
  ConfigFile* _file;
  ConfigData* _cfg;

private:
  bool        _dbgDump;    // DebugSettings, not persistent
  bool        _dbgLog;     // DebugSettings, not persistent
};


#endif //  _SC_CONFIGMANAGER_H
