/* ====================================================================
 * Copyright (c) 2008-2009  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc test
#include "WcViewItemTest.h"


WcViewItemTest::WcViewItemTest( const sc::String& name, bool dir, bool
  changed )
: _name(name)
{
  if( dir )
    _type = WcViewItemTypeDir;
  else
    _type = WcViewItemTypeFile;

  if( changed )
    _state = WcViewItemStateChanged;
  else
    _state = WcViewItemStateNormal;

}

WcViewItemTest::WcViewItemTest( const sc::String& name, WcViewItemType
  type, WcViewItemState state )
: _name(name), _type(type), _state(state)
{
}

const sc::String& WcViewItemTest::path() const
{
  return _name;
}

bool WcViewItemTest::isDir() const
{
  return _type == WcViewItemTypeDir;
}

bool WcViewItemTest::isChanged() const
{
  return _state == WcViewItemStateChanged;
}

bool WcViewItemTest::isIgnored() const
{ 
  return false;
}

bool WcViewItemTest::isSwitched() const
{
  return false;
}

bool WcViewItemTest::isOutOfDate() const
{
  return false;
}

StatusId WcViewItemTest::getTextStatus() const
{
  if( isChanged() )
    return StatusModified;
  else
    return StatusNone;
}


WcViewItemPtr createItem( const char* name, WcViewItemType type,
  WcViewItemState state)
{
  return WcViewItemPtr(
    new WcViewItemTest(sc::String(name),type,state) );
}


WcViewItemDataTest::WcViewItemDataTest ()
: _columns (1)
{
}

WcViewItemDataTest::WcViewItemDataTest (int columns)
: _columns(columns)
{
}

int WcViewItemDataTest::columns() const
{
  return _columns;
}

QString WcViewItemDataTest::data( int column, const WcViewItem* ) const
{
  return QString();
}

QColor WcViewItemDataTest::color( int column, const WcViewItem* ) const
{
  return QColor();
}

QVariant WcViewItemDataTest::dataSort( int column, const WcViewItem* ) const
{
  return QVariant();
}

QString WcViewItemDataTest::header( int column ) const
{
  return QString();
}

Qt::Alignment WcViewItemDataTest::alignment( int column ) const
{
  return Qt::AlignCenter;
}

bool WcViewItemDataTest::deep( int column ) const
{
  return false;
}
