// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use Emblem;
use Icon;
use ffi;
use glib;
use glib::StaticType;
use glib::Value;
use glib::object::Downcast;
use glib::object::IsA;
use glib::signal::SignalHandlerId;
use glib::signal::connect;
use glib::translate::*;
use glib_ffi;
use gobject_ffi;
use std::boxed::Box as Box_;
use std::mem;
use std::mem::transmute;
use std::ptr;

glib_wrapper! {
    pub struct EmblemedIcon(Object<ffi::GEmblemedIcon, ffi::GEmblemedIconClass>): Icon;

    match fn {
        get_type => || ffi::g_emblemed_icon_get_type(),
    }
}

impl EmblemedIcon {
    pub fn new<'a, P: IsA<Icon>, Q: Into<Option<&'a Emblem>>>(icon: &P, emblem: Q) -> EmblemedIcon {
        let emblem = emblem.into();
        let emblem = emblem.to_glib_none();
        unsafe {
            from_glib_full(ffi::g_emblemed_icon_new(icon.to_glib_none().0, emblem.0))
        }
    }
}

pub trait EmblemedIconExt {
    fn add_emblem(&self, emblem: &Emblem);

    fn clear_emblems(&self);

    fn get_emblems(&self) -> Vec<Emblem>;

    fn get_icon(&self) -> Option<Icon>;

    fn get_property_gicon(&self) -> Option<Icon>;

    fn connect_property_gicon_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<EmblemedIcon> + IsA<glib::object::Object>> EmblemedIconExt for O {
    fn add_emblem(&self, emblem: &Emblem) {
        unsafe {
            ffi::g_emblemed_icon_add_emblem(self.to_glib_none().0, emblem.to_glib_none().0);
        }
    }

    fn clear_emblems(&self) {
        unsafe {
            ffi::g_emblemed_icon_clear_emblems(self.to_glib_none().0);
        }
    }

    fn get_emblems(&self) -> Vec<Emblem> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::g_emblemed_icon_get_emblems(self.to_glib_none().0))
        }
    }

    fn get_icon(&self) -> Option<Icon> {
        unsafe {
            from_glib_none(ffi::g_emblemed_icon_get_icon(self.to_glib_none().0))
        }
    }

    fn get_property_gicon(&self) -> Option<Icon> {
        unsafe {
            let mut value = Value::from_type(<Icon as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "gicon".to_glib_none().0, value.to_glib_none_mut().0);
            value.get()
        }
    }

    fn connect_property_gicon_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::gicon",
                transmute(notify_gicon_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }
}

unsafe extern "C" fn notify_gicon_trampoline<P>(this: *mut ffi::GEmblemedIcon, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<EmblemedIcon> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&EmblemedIcon::from_glib_borrow(this).downcast_unchecked())
}
