import os
import sys
import subprocess

import gobject

import dbus
import dbus.service
import dbus.mainloop.glib

def log(msg, *args):
    if len(args):
        print msg % args
    else:
        print msg

class EchoServer(dbus.service.Object):
    """The echo service."""
    SERVICE_NAME = 'org.laptop.Echo'
    INTERFACE_NAME = 'org.laptop.Echo'

    def __init__(self, bus_or_name):
        dbus.service.Object.__init__(self, bus_or_name, '/')

    @dbus.service.method(INTERFACE_NAME,
                         in_signature='s',
                         out_signature='s')
    def echo(self, msg):
        return msg

def run():
    """Start the Rainbow DBus service."""
    parser = OptionParser(version='0.1')
    parser.add_option('-f', '--bus-config-file', default='./session-olpc.conf',
                      help='The dbus session bus config file to test.')
    opts, args = parser.parse_args()


    dbus.mainloop.glib.DBusGMainLoop(set_as_default=True)

    bus = dbus.SystemBus()
    name = dbus.service.BusName(Rainbow.SERVICE_NAME, bus)
    EchoServer(name)

    print 'Echo service running mainloop.'
    mainloop = gobject.MainLoop()
    mainloop.run()

def main():
    run()

if __name__ == '__main__':
    main()
