# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class ArmErrorResponse(_serialization.Model):
    """ArmErrorResponse.

    :ivar error: ARM error response body.
    :vartype error: ~azure.mgmt.advisor.models.ARMErrorResponseBody
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ARMErrorResponseBody"},
    }

    def __init__(self, *, error: Optional["_models.ARMErrorResponseBody"] = None, **kwargs):
        """
        :keyword error: ARM error response body.
        :paramtype error: ~azure.mgmt.advisor.models.ARMErrorResponseBody
        """
        super().__init__(**kwargs)
        self.error = error


class ARMErrorResponseBody(_serialization.Model):
    """ARM error response body.

    :ivar message: Gets or sets the string that describes the error in detail and provides
     debugging information.
    :vartype message: str
    :ivar code: Gets or sets the string that can be used to programmatically identify the error.
    :vartype code: str
    """

    _attribute_map = {
        "message": {"key": "message", "type": "str"},
        "code": {"key": "code", "type": "str"},
    }

    def __init__(self, *, message: Optional[str] = None, code: Optional[str] = None, **kwargs):
        """
        :keyword message: Gets or sets the string that describes the error in detail and provides
         debugging information.
        :paramtype message: str
        :keyword code: Gets or sets the string that can be used to programmatically identify the error.
        :paramtype code: str
        """
        super().__init__(**kwargs)
        self.message = message
        self.code = code


class Resource(_serialization.Model):
    """An Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ConfigData(Resource):
    """The Advisor configuration data structure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar exclude: Exclude the resource from Advisor evaluations. Valid values: False (default) or
     True.
    :vartype exclude: bool
    :ivar low_cpu_threshold: Minimum percentage threshold for Advisor low CPU utilization
     evaluation. Valid only for subscriptions. Valid values: 5 (default), 10, 15 or 20. Known values
     are: "5", "10", "15", and "20".
    :vartype low_cpu_threshold: str or ~azure.mgmt.advisor.models.CpuThreshold
    :ivar digests: Advisor digest configuration. Valid only for subscriptions.
    :vartype digests: list[~azure.mgmt.advisor.models.DigestConfig]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "exclude": {"key": "properties.exclude", "type": "bool"},
        "low_cpu_threshold": {"key": "properties.lowCpuThreshold", "type": "str"},
        "digests": {"key": "properties.digests", "type": "[DigestConfig]"},
    }

    def __init__(
        self,
        *,
        exclude: Optional[bool] = None,
        low_cpu_threshold: Optional[Union[str, "_models.CpuThreshold"]] = None,
        digests: Optional[List["_models.DigestConfig"]] = None,
        **kwargs
    ):
        """
        :keyword exclude: Exclude the resource from Advisor evaluations. Valid values: False (default)
         or True.
        :paramtype exclude: bool
        :keyword low_cpu_threshold: Minimum percentage threshold for Advisor low CPU utilization
         evaluation. Valid only for subscriptions. Valid values: 5 (default), 10, 15 or 20. Known values
         are: "5", "10", "15", and "20".
        :paramtype low_cpu_threshold: str or ~azure.mgmt.advisor.models.CpuThreshold
        :keyword digests: Advisor digest configuration. Valid only for subscriptions.
        :paramtype digests: list[~azure.mgmt.advisor.models.DigestConfig]
        """
        super().__init__(**kwargs)
        self.exclude = exclude
        self.low_cpu_threshold = low_cpu_threshold
        self.digests = digests


class ConfigurationListResult(_serialization.Model):
    """The list of Advisor configurations.

    :ivar value: The list of configurations.
    :vartype value: list[~azure.mgmt.advisor.models.ConfigData]
    :ivar next_link: The link used to get the next page of configurations.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ConfigData]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ConfigData"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: The list of configurations.
        :paramtype value: list[~azure.mgmt.advisor.models.ConfigData]
        :keyword next_link: The link used to get the next page of configurations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DigestConfig(_serialization.Model):
    """Advisor Digest configuration entity.

    :ivar name: Name of digest configuration. Value is case-insensitive and must be unique within a
     subscription.
    :vartype name: str
    :ivar action_group_resource_id: Action group resource id used by digest.
    :vartype action_group_resource_id: str
    :ivar frequency: Frequency that digest will be triggered, in days. Value must be between 7 and
     30 days inclusive.
    :vartype frequency: int
    :ivar categories: Categories to send digest for. If categories are not provided, then digest
     will be sent for all categories.
    :vartype categories: list[str or ~azure.mgmt.advisor.models.Category]
    :ivar language: Language for digest content body. Value must be ISO 639-1 code for one of Azure
     portal supported languages. Otherwise, it will be converted into one. Default value is English
     (en).
    :vartype language: str
    :ivar state: State of digest configuration. Known values are: "Active" and "Disabled".
    :vartype state: str or ~azure.mgmt.advisor.models.DigestConfigState
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "action_group_resource_id": {"key": "actionGroupResourceId", "type": "str"},
        "frequency": {"key": "frequency", "type": "int"},
        "categories": {"key": "categories", "type": "[str]"},
        "language": {"key": "language", "type": "str"},
        "state": {"key": "state", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        action_group_resource_id: Optional[str] = None,
        frequency: Optional[int] = None,
        categories: Optional[List[Union[str, "_models.Category"]]] = None,
        language: Optional[str] = None,
        state: Optional[Union[str, "_models.DigestConfigState"]] = None,
        **kwargs
    ):
        """
        :keyword name: Name of digest configuration. Value is case-insensitive and must be unique
         within a subscription.
        :paramtype name: str
        :keyword action_group_resource_id: Action group resource id used by digest.
        :paramtype action_group_resource_id: str
        :keyword frequency: Frequency that digest will be triggered, in days. Value must be between 7
         and 30 days inclusive.
        :paramtype frequency: int
        :keyword categories: Categories to send digest for. If categories are not provided, then digest
         will be sent for all categories.
        :paramtype categories: list[str or ~azure.mgmt.advisor.models.Category]
        :keyword language: Language for digest content body. Value must be ISO 639-1 code for one of
         Azure portal supported languages. Otherwise, it will be converted into one. Default value is
         English (en).
        :paramtype language: str
        :keyword state: State of digest configuration. Known values are: "Active" and "Disabled".
        :paramtype state: str or ~azure.mgmt.advisor.models.DigestConfigState
        """
        super().__init__(**kwargs)
        self.name = name
        self.action_group_resource_id = action_group_resource_id
        self.frequency = frequency
        self.categories = categories
        self.language = language
        self.state = state


class MetadataEntity(_serialization.Model):
    """The metadata entity contract.

    :ivar id: The resource Id of the metadata entity.
    :vartype id: str
    :ivar type: The type of the metadata entity.
    :vartype type: str
    :ivar name: The name of the metadata entity.
    :vartype name: str
    :ivar display_name: The display name.
    :vartype display_name: str
    :ivar depends_on: The list of keys on which this entity depends on.
    :vartype depends_on: list[str]
    :ivar applicable_scenarios: The list of scenarios applicable to this metadata entity.
    :vartype applicable_scenarios: list[str or ~azure.mgmt.advisor.models.Scenario]
    :ivar supported_values: The list of supported values.
    :vartype supported_values: list[~azure.mgmt.advisor.models.MetadataSupportedValueDetail]
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "depends_on": {"key": "properties.dependsOn", "type": "[str]"},
        "applicable_scenarios": {"key": "properties.applicableScenarios", "type": "[str]"},
        "supported_values": {"key": "properties.supportedValues", "type": "[MetadataSupportedValueDetail]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        type: Optional[str] = None,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        depends_on: Optional[List[str]] = None,
        applicable_scenarios: Optional[List[Union[str, "_models.Scenario"]]] = None,
        supported_values: Optional[List["_models.MetadataSupportedValueDetail"]] = None,
        **kwargs
    ):
        """
        :keyword id: The resource Id of the metadata entity.
        :paramtype id: str
        :keyword type: The type of the metadata entity.
        :paramtype type: str
        :keyword name: The name of the metadata entity.
        :paramtype name: str
        :keyword display_name: The display name.
        :paramtype display_name: str
        :keyword depends_on: The list of keys on which this entity depends on.
        :paramtype depends_on: list[str]
        :keyword applicable_scenarios: The list of scenarios applicable to this metadata entity.
        :paramtype applicable_scenarios: list[str or ~azure.mgmt.advisor.models.Scenario]
        :keyword supported_values: The list of supported values.
        :paramtype supported_values: list[~azure.mgmt.advisor.models.MetadataSupportedValueDetail]
        """
        super().__init__(**kwargs)
        self.id = id
        self.type = type
        self.name = name
        self.display_name = display_name
        self.depends_on = depends_on
        self.applicable_scenarios = applicable_scenarios
        self.supported_values = supported_values


class MetadataEntityListResult(_serialization.Model):
    """The list of metadata entities.

    :ivar value: The list of metadata entities.
    :vartype value: list[~azure.mgmt.advisor.models.MetadataEntity]
    :ivar next_link: The link used to get the next page of metadata.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[MetadataEntity]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.MetadataEntity"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: The list of metadata entities.
        :paramtype value: list[~azure.mgmt.advisor.models.MetadataEntity]
        :keyword next_link: The link used to get the next page of metadata.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class MetadataSupportedValueDetail(_serialization.Model):
    """The metadata supported value detail.

    :ivar id: The id.
    :vartype id: str
    :ivar display_name: The display name.
    :vartype display_name: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        display_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: The id.
        :paramtype id: str
        :keyword display_name: The display name.
        :paramtype display_name: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.display_name = display_name


class OperationDisplayInfo(_serialization.Model):
    """The operation supported by Advisor.

    :ivar description: The description of the operation.
    :vartype description: str
    :ivar operation: The action that users can perform, based on their permission level.
    :vartype operation: str
    :ivar provider: Service provider: Microsoft Advisor.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed.
    :vartype resource: str
    """

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        operation: Optional[str] = None,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: The description of the operation.
        :paramtype description: str
        :keyword operation: The action that users can perform, based on their permission level.
        :paramtype operation: str
        :keyword provider: Service provider: Microsoft Advisor.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed.
        :paramtype resource: str
        """
        super().__init__(**kwargs)
        self.description = description
        self.operation = operation
        self.provider = provider
        self.resource = resource


class OperationEntity(_serialization.Model):
    """The operation supported by Advisor.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: The operation supported by Advisor.
    :vartype display: ~azure.mgmt.advisor.models.OperationDisplayInfo
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplayInfo"},
    }

    def __init__(
        self, *, name: Optional[str] = None, display: Optional["_models.OperationDisplayInfo"] = None, **kwargs
    ):
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: The operation supported by Advisor.
        :paramtype display: ~azure.mgmt.advisor.models.OperationDisplayInfo
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display


class OperationEntityListResult(_serialization.Model):
    """The list of Advisor operations.

    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    :ivar value: The list of operations.
    :vartype value: list[~azure.mgmt.advisor.models.OperationEntity]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[OperationEntity]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.OperationEntity"]] = None, **kwargs
    ):
        """
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        :keyword value: The list of operations.
        :paramtype value: list[~azure.mgmt.advisor.models.OperationEntity]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ResourceMetadata(_serialization.Model):
    """Recommendation resource metadata.

    :ivar resource_id: Azure resource Id of the assessed resource.
    :vartype resource_id: str
    :ivar source: Source from which recommendation is generated.
    :vartype source: str
    :ivar action: The action to view resource.
    :vartype action: dict[str, JSON]
    :ivar singular: The singular user friendly name of resource type. eg: virtual machine.
    :vartype singular: str
    :ivar plural: The plural user friendly name of resource type. eg: virtual machines.
    :vartype plural: str
    """

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "source": {"key": "source", "type": "str"},
        "action": {"key": "action", "type": "{object}"},
        "singular": {"key": "singular", "type": "str"},
        "plural": {"key": "plural", "type": "str"},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        source: Optional[str] = None,
        action: Optional[Dict[str, JSON]] = None,
        singular: Optional[str] = None,
        plural: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword resource_id: Azure resource Id of the assessed resource.
        :paramtype resource_id: str
        :keyword source: Source from which recommendation is generated.
        :paramtype source: str
        :keyword action: The action to view resource.
        :paramtype action: dict[str, JSON]
        :keyword singular: The singular user friendly name of resource type. eg: virtual machine.
        :paramtype singular: str
        :keyword plural: The plural user friendly name of resource type. eg: virtual machines.
        :paramtype plural: str
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.source = source
        self.action = action
        self.singular = singular
        self.plural = plural


class ResourceRecommendationBase(Resource):  # pylint: disable=too-many-instance-attributes
    """Advisor Recommendation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar category: The category of the recommendation. Known values are: "HighAvailability",
     "Security", "Performance", "Cost", and "OperationalExcellence".
    :vartype category: str or ~azure.mgmt.advisor.models.Category
    :ivar impact: The business impact of the recommendation. Known values are: "High", "Medium",
     and "Low".
    :vartype impact: str or ~azure.mgmt.advisor.models.Impact
    :ivar impacted_field: The resource type identified by Advisor.
    :vartype impacted_field: str
    :ivar impacted_value: The resource identified by Advisor.
    :vartype impacted_value: str
    :ivar last_updated: The most recent time that Advisor checked the validity of the
     recommendation.
    :vartype last_updated: ~datetime.datetime
    :ivar metadata: The recommendation metadata.
    :vartype metadata: dict[str, JSON]
    :ivar recommendation_type_id: The recommendation-type GUID.
    :vartype recommendation_type_id: str
    :ivar short_description: A summary of the recommendation.
    :vartype short_description: ~azure.mgmt.advisor.models.ShortDescription
    :ivar suppression_ids: The list of snoozed and dismissed rules for the recommendation.
    :vartype suppression_ids: list[str]
    :ivar extended_properties: Extended properties.
    :vartype extended_properties: dict[str, str]
    :ivar resource_metadata: Metadata of resource that was assessed.
    :vartype resource_metadata: ~azure.mgmt.advisor.models.ResourceMetadata
    :ivar description: The detailed description of recommendation.
    :vartype description: str
    :ivar label: The label of recommendation.
    :vartype label: str
    :ivar learn_more_link: The link to learn more about recommendation and generation logic.
    :vartype learn_more_link: str
    :ivar potential_benefits: The potential benefit of implementing recommendation.
    :vartype potential_benefits: str
    :ivar actions: The list of recommended actions to implement recommendation.
    :vartype actions: list[dict[str, JSON]]
    :ivar remediation: The automated way to apply recommendation.
    :vartype remediation: dict[str, JSON]
    :ivar exposed_metadata_properties: The recommendation metadata properties exposed to customer
     to provide additional information.
    :vartype exposed_metadata_properties: dict[str, JSON]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "category": {"key": "properties.category", "type": "str"},
        "impact": {"key": "properties.impact", "type": "str"},
        "impacted_field": {"key": "properties.impactedField", "type": "str"},
        "impacted_value": {"key": "properties.impactedValue", "type": "str"},
        "last_updated": {"key": "properties.lastUpdated", "type": "iso-8601"},
        "metadata": {"key": "properties.metadata", "type": "{object}"},
        "recommendation_type_id": {"key": "properties.recommendationTypeId", "type": "str"},
        "short_description": {"key": "properties.shortDescription", "type": "ShortDescription"},
        "suppression_ids": {"key": "properties.suppressionIds", "type": "[str]"},
        "extended_properties": {"key": "properties.extendedProperties", "type": "{str}"},
        "resource_metadata": {"key": "properties.resourceMetadata", "type": "ResourceMetadata"},
        "description": {"key": "properties.description", "type": "str"},
        "label": {"key": "properties.label", "type": "str"},
        "learn_more_link": {"key": "properties.learnMoreLink", "type": "str"},
        "potential_benefits": {"key": "properties.potentialBenefits", "type": "str"},
        "actions": {"key": "properties.actions", "type": "[{object}]"},
        "remediation": {"key": "properties.remediation", "type": "{object}"},
        "exposed_metadata_properties": {"key": "properties.exposedMetadataProperties", "type": "{object}"},
    }

    def __init__(
        self,
        *,
        category: Optional[Union[str, "_models.Category"]] = None,
        impact: Optional[Union[str, "_models.Impact"]] = None,
        impacted_field: Optional[str] = None,
        impacted_value: Optional[str] = None,
        last_updated: Optional[datetime.datetime] = None,
        metadata: Optional[Dict[str, JSON]] = None,
        recommendation_type_id: Optional[str] = None,
        short_description: Optional["_models.ShortDescription"] = None,
        suppression_ids: Optional[List[str]] = None,
        extended_properties: Optional[Dict[str, str]] = None,
        resource_metadata: Optional["_models.ResourceMetadata"] = None,
        description: Optional[str] = None,
        label: Optional[str] = None,
        learn_more_link: Optional[str] = None,
        potential_benefits: Optional[str] = None,
        actions: Optional[List[Dict[str, JSON]]] = None,
        remediation: Optional[Dict[str, JSON]] = None,
        exposed_metadata_properties: Optional[Dict[str, JSON]] = None,
        **kwargs
    ):
        """
        :keyword category: The category of the recommendation. Known values are: "HighAvailability",
         "Security", "Performance", "Cost", and "OperationalExcellence".
        :paramtype category: str or ~azure.mgmt.advisor.models.Category
        :keyword impact: The business impact of the recommendation. Known values are: "High", "Medium",
         and "Low".
        :paramtype impact: str or ~azure.mgmt.advisor.models.Impact
        :keyword impacted_field: The resource type identified by Advisor.
        :paramtype impacted_field: str
        :keyword impacted_value: The resource identified by Advisor.
        :paramtype impacted_value: str
        :keyword last_updated: The most recent time that Advisor checked the validity of the
         recommendation.
        :paramtype last_updated: ~datetime.datetime
        :keyword metadata: The recommendation metadata.
        :paramtype metadata: dict[str, JSON]
        :keyword recommendation_type_id: The recommendation-type GUID.
        :paramtype recommendation_type_id: str
        :keyword short_description: A summary of the recommendation.
        :paramtype short_description: ~azure.mgmt.advisor.models.ShortDescription
        :keyword suppression_ids: The list of snoozed and dismissed rules for the recommendation.
        :paramtype suppression_ids: list[str]
        :keyword extended_properties: Extended properties.
        :paramtype extended_properties: dict[str, str]
        :keyword resource_metadata: Metadata of resource that was assessed.
        :paramtype resource_metadata: ~azure.mgmt.advisor.models.ResourceMetadata
        :keyword description: The detailed description of recommendation.
        :paramtype description: str
        :keyword label: The label of recommendation.
        :paramtype label: str
        :keyword learn_more_link: The link to learn more about recommendation and generation logic.
        :paramtype learn_more_link: str
        :keyword potential_benefits: The potential benefit of implementing recommendation.
        :paramtype potential_benefits: str
        :keyword actions: The list of recommended actions to implement recommendation.
        :paramtype actions: list[dict[str, JSON]]
        :keyword remediation: The automated way to apply recommendation.
        :paramtype remediation: dict[str, JSON]
        :keyword exposed_metadata_properties: The recommendation metadata properties exposed to
         customer to provide additional information.
        :paramtype exposed_metadata_properties: dict[str, JSON]
        """
        super().__init__(**kwargs)
        self.category = category
        self.impact = impact
        self.impacted_field = impacted_field
        self.impacted_value = impacted_value
        self.last_updated = last_updated
        self.metadata = metadata
        self.recommendation_type_id = recommendation_type_id
        self.short_description = short_description
        self.suppression_ids = suppression_ids
        self.extended_properties = extended_properties
        self.resource_metadata = resource_metadata
        self.description = description
        self.label = label
        self.learn_more_link = learn_more_link
        self.potential_benefits = potential_benefits
        self.actions = actions
        self.remediation = remediation
        self.exposed_metadata_properties = exposed_metadata_properties


class ResourceRecommendationBaseListResult(_serialization.Model):
    """The list of Advisor recommendations.

    :ivar next_link: The link used to get the next page of recommendations.
    :vartype next_link: str
    :ivar value: The list of recommendations.
    :vartype value: list[~azure.mgmt.advisor.models.ResourceRecommendationBase]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[ResourceRecommendationBase]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.ResourceRecommendationBase"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link used to get the next page of recommendations.
        :paramtype next_link: str
        :keyword value: The list of recommendations.
        :paramtype value: list[~azure.mgmt.advisor.models.ResourceRecommendationBase]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ShortDescription(_serialization.Model):
    """A summary of the recommendation.

    :ivar problem: The issue or opportunity identified by the recommendation and proposed solution.
    :vartype problem: str
    :ivar solution: The issue or opportunity identified by the recommendation and proposed
     solution.
    :vartype solution: str
    """

    _attribute_map = {
        "problem": {"key": "problem", "type": "str"},
        "solution": {"key": "solution", "type": "str"},
    }

    def __init__(self, *, problem: Optional[str] = None, solution: Optional[str] = None, **kwargs):
        """
        :keyword problem: The issue or opportunity identified by the recommendation and proposed
         solution.
        :paramtype problem: str
        :keyword solution: The issue or opportunity identified by the recommendation and proposed
         solution.
        :paramtype solution: str
        """
        super().__init__(**kwargs)
        self.problem = problem
        self.solution = solution


class SuppressionContract(Resource):
    """The details of the snoozed or dismissed rule; for example, the duration, name, and GUID associated with the rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar suppression_id: The GUID of the suppression.
    :vartype suppression_id: str
    :ivar ttl: The duration for which the suppression is valid.
    :vartype ttl: str
    :ivar expiration_time_stamp: Gets or sets the expiration time stamp.
    :vartype expiration_time_stamp: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "expiration_time_stamp": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "suppression_id": {"key": "properties.suppressionId", "type": "str"},
        "ttl": {"key": "properties.ttl", "type": "str"},
        "expiration_time_stamp": {"key": "properties.expirationTimeStamp", "type": "iso-8601"},
    }

    def __init__(self, *, suppression_id: Optional[str] = None, ttl: Optional[str] = None, **kwargs):
        """
        :keyword suppression_id: The GUID of the suppression.
        :paramtype suppression_id: str
        :keyword ttl: The duration for which the suppression is valid.
        :paramtype ttl: str
        """
        super().__init__(**kwargs)
        self.suppression_id = suppression_id
        self.ttl = ttl
        self.expiration_time_stamp = None


class SuppressionContractListResult(_serialization.Model):
    """The list of Advisor suppressions.

    :ivar next_link: The link used to get the next page of suppressions.
    :vartype next_link: str
    :ivar value: The list of suppressions.
    :vartype value: list[~azure.mgmt.advisor.models.SuppressionContract]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[SuppressionContract]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.SuppressionContract"]] = None, **kwargs
    ):
        """
        :keyword next_link: The link used to get the next page of suppressions.
        :paramtype next_link: str
        :keyword value: The list of suppressions.
        :paramtype value: list[~azure.mgmt.advisor.models.SuppressionContract]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value
