#include <stdlib.h>
#include <inttypes.h>
#include <stdio.h>

#include "profile.h"
#define size(x,y) ((uintptr_t) &y - (uintptr_t) &x)/sizeof(unsigned char)

int main(int argc, char *argv[])
{
  struct Profile prf __attribute__((aligned(16)));

  printf("Profile address: 0x%16.16x\n", &prf);
  printf("Identification : 0x%16.16x\t%lu\n", &prf.Identification, size(prf.Identification, prf.AC_Number));
  printf("AC_NUMBER      : 0x%16.16x\t%lu\n", &prf.AC_Number, size(prf.AC_Number ,prf.Date));
  printf("Date           : 0x%16.16x\t%lu\n", &prf.Date, size(prf.Date, prf.Description));
  printf("Description    : 0x%16.16x\t%lu\n", &prf.Description, size(prf.Description, prf.Alphabet_Mapping));
  printf("Mapping alpha  : 0x%16.16x\t%lu\n", &prf.Alphabet_Mapping, size(prf.Alphabet_Mapping, prf.Length));
  printf("Length         : 0x%16.16x\t%lu\n", &prf.Length, size(prf.Length, prf.Alphabet_Length));
  printf("Alpha Length   : 0x%16.16x\t%lu\n", &prf.Alphabet_Length, size(prf.Alphabet_Length, prf.Insertion));
  printf("Insertion      : 0x%16.16x\n", &prf.Insertion );
 // printf("Aligned length : 0x%16.16x\n", &prf.Aligned_Alphabet_Length);
  printf("Match          : 0x%16.16x\n", &prf.Match);
  printf("isCircular     : 0x%16.16x\t%lu\n", &prf.isCircular, size(prf.isCircular, prf.NormalizationData));
  printf("Normalization  : 0x%16.16x\t%lu\n", &prf.NormalizationData, size(prf.NormalizationData, prf.DisjointData));
  printf("Disjoint       : 0x%16.16x\t%lu\n", &prf.DisjointData, size(prf.DisjointData, prf.CutOffData));
  printf("Cutoff         : 0x%16.16x\n\n", &prf.CutOffData);

  printf("Insertions alphabet    : 0x%16.16x\n", &prf.Insertion.Alphabet);
  printf("Insertions boundaries  : 0x%16.16x\n", &(prf.Insertion.Boundaries));
  printf("Insertions transitions : 0x%16.16x\n", &(prf.Insertion.Transitions));
  printf("Insertions aligned L   : 0x%16.16x\n\n", &(prf.Insertion.AlignStep));
  printf("Match aligned L        : 0x%16.16x\n", &(prf.Match.AlignStep) );
  printf("Match alphabet         : 0x%16.16x\n", &(prf.Match.Alphabet) );
  return 0;
}