/*
 * Copyright (C) 2009 The Project Lombok Authors.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package lombok.core.runtimeDependencies;

import java.util.List;

/**
 * Implement and provide this interface to specify which transformations have a runtime dependency on
 * {@code lombok-runtime.jar}, as well as which files of your transformation must be in {@code lombok-runtime.jar}.
 */
public interface RuntimeDependencyInfo {
	/**
	 * @return A list of strings describing each lombok transformation that has a runtime dependency.
	 */
	public List<String> getRuntimeDependentsDescriptions();
	
	/**
	 * @return A list of files (findable via {@code yourClass.getResourceAsStream("/" + NAME)}) to include in
	 *     {@code lombok-runtime.jar}.
	 */
	public List<String> getRuntimeDependencies();
}
