/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.predictor;

import org.apache.pdfbox.pdmodel.graphics.predictor.Average;
import org.apache.pdfbox.pdmodel.graphics.predictor.None;
import org.apache.pdfbox.pdmodel.graphics.predictor.Paeth;
import org.apache.pdfbox.pdmodel.graphics.predictor.PredictorAlgorithm;
import org.apache.pdfbox.pdmodel.graphics.predictor.Sub;
import org.apache.pdfbox.pdmodel.graphics.predictor.Up;

public class Optimum
extends PredictorAlgorithm {
    PredictorAlgorithm[] filter = new PredictorAlgorithm[]{new None(), new Sub(), new Up(), new Average(), new Paeth()};

    public void checkBufsiz(byte[] filtered, byte[] raw) {
        if (filtered.length != (this.getWidth() * this.getBpp() + 1) * this.getHeight()) {
            throw new IllegalArgumentException("filtered.length != (width*bpp + 1) * height, " + filtered.length + " " + (this.getWidth() * this.getBpp() + 1) * this.getHeight() + "w,h,bpp=" + this.getWidth() + "," + this.getHeight() + "," + this.getBpp());
        }
        if (raw.length != this.getWidth() * this.getHeight() * this.getBpp()) {
            throw new IllegalArgumentException("raw.length != width * height * bpp, raw.length=" + raw.length + " w,h,bpp=" + this.getWidth() + "," + this.getHeight() + "," + this.getBpp());
        }
    }

    public void encodeLine(byte[] src, byte[] dest, int srcDy, int srcOffset, int destDy, int destOffset) {
        throw new UnsupportedOperationException("encodeLine");
    }

    public void decodeLine(byte[] src, byte[] dest, int srcDy, int srcOffset, int destDy, int destOffset) {
        throw new UnsupportedOperationException("decodeLine");
    }

    public void encode(byte[] src, byte[] dest) {
        this.checkBufsiz(dest, src);
        throw new UnsupportedOperationException("encode");
    }

    public void setBpp(int bpp) {
        super.setBpp(bpp);
        for (int i = 0; i < this.filter.length; ++i) {
            this.filter[i].setBpp(bpp);
        }
    }

    public void setHeight(int height) {
        super.setHeight(height);
        for (int i = 0; i < this.filter.length; ++i) {
            this.filter[i].setHeight(height);
        }
    }

    public void setWidth(int width) {
        super.setWidth(width);
        for (int i = 0; i < this.filter.length; ++i) {
            this.filter[i].setWidth(width);
        }
    }

    public void decode(byte[] src, byte[] dest) {
        this.checkBufsiz(src, dest);
        int bpl = this.getWidth() * this.getBpp();
        int srcDy = bpl + 1;
        for (int y = 0; y < this.getHeight(); ++y) {
            PredictorAlgorithm f = this.filter[src[y * srcDy]];
            int srcOffset = y * srcDy + 1;
            f.decodeLine(src, dest, srcDy, srcOffset, bpl, y * bpl);
        }
    }
}

