/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.ocrPlugins.mseOCR;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import net.sourceforge.javaocr.ocrPlugins.mseOCR.CharacterRange;
import net.sourceforge.javaocr.ocrPlugins.mseOCR.TrainingImage;
import net.sourceforge.javaocr.scanner.DocumentScanner;
import net.sourceforge.javaocr.scanner.DocumentScannerListenerAdaptor;
import net.sourceforge.javaocr.scanner.PixelImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrainingImageLoader
extends DocumentScannerListenerAdaptor {
    private int charValue = 0;
    private HashMap<Character, ArrayList<TrainingImage>> dest;
    private boolean debug = false;
    private DocumentScanner documentScanner = new DocumentScanner();
    private static final Logger LOG = Logger.getLogger(TrainingImageLoader.class.getName());

    public DocumentScanner getDocumentScanner() {
        return this.documentScanner;
    }

    public void load(Component component, String imageFilename, CharacterRange charRange, HashMap<Character, ArrayList<TrainingImage>> dest) throws IOException {
        ImageProducer imageProducer = (ImageProducer)new File(imageFilename).toURL().getContent();
        Image image = Toolkit.getDefaultToolkit().createImage(imageProducer);
        if (image == null) {
            throw new IOException("Cannot find training image file: " + imageFilename);
        }
        this.load(component, image, charRange, dest, imageFilename);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void load(Component component, Image image, CharacterRange charRange, HashMap<Character, ArrayList<TrainingImage>> dest, String imageFilename) throws IOException {
        MediaTracker mt = new MediaTracker(component);
        mt.addImage(image, 0);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        PixelImage pixelImage = new PixelImage(image);
        pixelImage.toGrayScale(true);
        pixelImage.filter();
        this.charValue = charRange.min;
        this.dest = dest;
        this.documentScanner.scan(pixelImage, this, 0, 0, 0, 0);
        if (this.charValue != charRange.max + 1) {
            throw new IOException("Expected to decode " + (charRange.max + 1 - charRange.min) + " characters but actually decoded " + (this.charValue - charRange.min) + " characters in training: " + imageFilename);
        }
    }

    @Override
    public void processChar(PixelImage pixelImage, int x1, int y1, int x2, int y2, int rowY1, int rowY2) {
        Character chr;
        ArrayList<TrainingImage> al;
        if (this.debug) {
            System.out.println("TrainingImageLoader.processChar: '" + (char)this.charValue + "' " + x1 + "," + y1 + "-" + x2 + "," + y2);
        }
        int w = x2 - x1;
        int h = y2 - y1;
        int[] pixels = new int[w * h];
        int y = y1;
        int destY = 0;
        while (y < y2) {
            System.arraycopy(pixelImage.pixels, y * pixelImage.width + x1, pixels, destY * w, w);
            ++y;
            ++destY;
        }
        if (this.debug) {
            int idx = 0;
            for (y = 0; y < h; ++y) {
                int x = 0;
                while (x < w) {
                    System.out.print(pixels[idx] > 0 ? (char)' ' : '*');
                    ++x;
                    ++idx;
                }
                System.out.println();
            }
            System.out.println();
        }
        if ((al = this.dest.get(chr = new Character((char)this.charValue))) == null) {
            al = new ArrayList();
            this.dest.put(chr, al);
        }
        al.add(new TrainingImage(pixels, w, h, y1 - rowY1, rowY2 - y2));
        ++this.charValue;
    }
}

