BEGIN {
  use strict; use warnings;
  my %missing = map {
    eval qq{ require $_ };
    $@ ? ($_=>1) : ()
  } qw( File::Glob constant experimental parent warnings );
  if(%missing)
  {
    print "Your Perl is missing core modules: @{[ sort keys %missing ]}\n";
    print "Ideally if you are using the system Perl you can install the appropriate\n";
    print "package which includes the core Perl modules.  On at least some versions\n";
    print "of Fedora, CentOS and RHEL, this is the `perl-core` package.\n";
    print "\n";
    print " % dnf install perl-core\n";
    print "   ~ or ~\n";
    print " % yum install perl-core\n";
    print "\n";
    print "If you really want to install dual-life modules from CPAN, then you can\n";
    print "use cpanm:\n";
    print "\n";
    print " % cpanm @{[ sort keys %missing ]}\n";
    print "\n";
    print "Note that some core modules are not available from CPAN.\n";
    exit;
  }
}
BEGIN {
  use strict; use warnings;
  unless(eval q{ use 5.020; 1}) {
    print "Perl 5.020 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v2.77.
use strict;
use warnings;
use 5.020;
use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT"           => "Documentation and tools for using Platypus with the V programming language",
  "AUTHOR"             => "Graham Ollis <plicease\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME"         => "FFI-Platypus-Lang-V",
  "LICENSE"          => "perl",
  "MIN_PERL_VERSION" => "5.020",
  "NAME"             => "FFI::Platypus::Lang::V",
  "PM"               => {
    "lib/FFI/Build/File/VMod.pm" => "\$(INST_LIB)/FFI/Build/File/VMod.pm",
    "lib/FFI/Platypus/Lang/V.pm" => "\$(INST_LIB)/FFI/Platypus/Lang/V.pm"
  },
  "PREREQ_PM" => {
    "FFI::Build"             => 0,
    "FFI::Build::File::Base" => 0,
    "FFI::Platypus"          => "2.10",
    "File::Which"            => 0,
    "File::chdir"            => 0,
    "Path::Tiny"             => 0,
    "PerlX::Maybe"           => "0.003",
    "stable"                 => 0,
    "true"                   => 0
  },
  "TEST_REQUIRES" => {
    "Capture::Tiny"            => 0,
    "Data::Section::Pluggable" => "0.04",
    "Test2::V0"                => "0.000121"
  },
  "VERSION" => "0.01",
  "test"    => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "Capture::Tiny"            => 0,
  "Data::Section::Pluggable" => "0.04",
  "FFI::Build"               => 0,
  "FFI::Build::File::Base"   => 0,
  "FFI::Platypus"            => "2.10",
  "File::Which"              => 0,
  "File::chdir"              => 0,
  "Path::Tiny"               => 0,
  "PerlX::Maybe"             => "0.003",
  "Test2::V0"                => "0.000121",
  "stable"                   => 0,
  "true"                     => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);